module CellularFluid.Grid.FD.FDSimpleStepper where

{-
   Simple diffusive fluid
   -}
import           RIO

import           CellularFluid.Grid.Types

-- | Main stepping function
step :: L -> DT -> Nu -> P -> AdjCells -> P
step w dt ν p adjs = p - divP * dt / α
  where
    α = 1e9 * ν -- magic
    divP = divP' adjs p / w

-- | Scaled divergence of P: w(∇·P)
divP' :: AdjCells -> P -> Double
divP' (Adj es cs) p = f es + f cs / (sqrt 2.0)
  where
    f = sum . fmap g
    g (FluidD p') =
      let !dp = p - p'
       in dp
    g _ = 0.0
