{-# LANGUAGE NoImplicitPrelude #-}
{-# LANGUAGE TemplateHaskell #-}
module Main (main) where

import Import
import Run
import RIO.Process
import Options.Applicative.Simple
import qualified Paths_cellularfluid

main :: IO ()
main = do
  (options, ()) <- simpleOptions
    $(simpleVersion Paths_cellularfluid.version)
    "Simulates fluid"
    "Description: TODO"
    (Options
       <$> switch ( long "verbose"
                 <> short 'v'
                 <> help "Verbose logging?"
                  )
       <*> strOption ( long "input"
                     <> short 'i'
                     <> help "Input file"
                     )
       <*> strOption ( long "output"
                     <> short 'o'
                     <> help "Output file"
                     )
       <*> option auto ( long "time"
                      <> help "Simultaion time"
                       )
    )
    empty
  lo <- logOptionsHandle stderr (optionsVerbose options)
  pc <- mkDefaultProcessContext
  withLogFunc lo $ \lf ->
    let app = App
          { appLogFunc = lf
          , appProcessContext = pc
          , appOptions = options
          }
     in runRIO app run
