import System.Environment
import Data.Maybe
import qualified Data.ByteString as B
import qualified Data.ByteString.Char8 as BC8
import qualified Data.ByteString.Search as BS
import Control.Parallel.Strategies
import Control.DeepSeq

solve :: BC8.ByteString  -> BC8.ByteString -> Maybe BC8.ByteString
solve pat text
  | check = Just text
  | otherwise = Nothing
  where check = not . null $ BS.indices pat text

printMaybe :: Maybe BC8.ByteString -> IO ()
printMaybe (Just x) = BC8.putStrLn x
printMaybe Nothing = return ()

main :: IO ()
main = do
  [pat, filename] <- getArgs
  contents <- B.readFile filename
  let as = BC8.lines contents
      len = length as `div` 4
      (a, bs) = splitAt len as
      (b, cs) = splitAt len bs
      (c, d) = splitAt len cs
      sol = runEval $ do
        a' <- rpar (force (map (solve (BC8.pack pat)) a))
        b' <- rpar (force (map (solve (BC8.pack pat)) b))
        c' <- rpar (force (map (solve (BC8.pack pat)) c))
        d' <- rpar (force (map (solve (BC8.pack pat)) d))
        _ <- rseq a'
        _ <- rseq b'
        _ <- rseq c'
        _ <- rseq d'
        return (a' ++ b' ++ c' ++ d')
        -- return (length a' + length b' + length c' + length d')
  mapM_ printMaybe (filter isJust sol)
  -- print sol
