import System.Environment
import Data.Maybe
import qualified Data.ByteString as B
import qualified Data.ByteString.Char8 as BC8
import qualified Data.ByteString.Search as BS
import System.Directory (doesDirectoryExist, getDirectoryContents)
import System.FilePath ((</>))
import Control.Monad(forM_, forever)

solve :: BC8.ByteString  -> BC8.ByteString -> Maybe BC8.ByteString
solve pat text
  | check == True = Just text
  | otherwise = Nothing
  where check = not . null $ BS.indices pat text

printMaybe :: Maybe BC8.ByteString -> IO ()
printMaybe (Just x) = BC8.putStrLn x
printMaybe Nothing = return ()

main :: IO ()
main = do
  [pat, filename] <- getArgs
  let bpat = BC8.pack pat

  grapFiles filename True bpat

grapFiles :: FilePath -> Bool -> BC8.ByteString -> IO ()
grapFiles fpath recursive pat = walkDir fpath recursive
  where
    fileFilter fname = head fname /= '.'
    walkDir :: FilePath -> Bool -> IO ()
    walkDir path recursive = do
        isDir <- doesDirectoryExist path
        if isDir
            then do
                names <- getDirectoryContents path
                let properNames = filter fileFilter names
                forM_ properNames $ \fname -> walkDir (path </> fname) recursive
            else grap path pat

grap :: FilePath -> BC8.ByteString -> IO ()
grap fpath pat = do
    contents <- B.readFile fpath
    let res = map (solve pat) $ BC8.lines contents
        linedRes = zip [1..] res
        finalRes = filter (isJust . snd) linedRes
    forM_ finalRes $ \(ln, txt) -> putStrLn $ fpath ++ ":" ++ show ln ++ ": " ++ BC8.unpack (fromJust txt)