{-# LANGUAGE LambdaCase #-}
{-# LANGUAGE PackageImports #-}
{-# LANGUAGE ScopedTypeVariables #-}

import System.Environment
import Data.Maybe
import qualified Data.ByteString as B
import qualified Data.ByteString.Char8 as BC8
import qualified Data.ByteString.Search as BS
import Control.Parallel.Strategies
import Control.DeepSeq
import qualified System.Posix.IO as PIO
import qualified "unix-bytestring" System.Posix.IO.ByteString as PIOB
import System.Posix.Types
import qualified System.Posix as P

solve :: BC8.ByteString  -> BC8.ByteString -> Maybe BC8.ByteString
solve pat text
  | check = Just text
  | otherwise = Nothing
  where check = not . null $ BS.indices pat text

printMaybe :: Maybe BC8.ByteString -> IO ()
printMaybe (Just x) = BC8.putStrLn x
printMaybe Nothing = return ()

getFileSize :: String -> IO FileOffset
getFileSize path = do
    stat <- P.getFileStatus path
    return (P.fileSize stat)

main :: IO ()
main = do
  [pat, filename] <- getArgs
  filesize <- getFileSize filename
  fd <- PIO.openFd filename PIO.ReadOnly (Just (CMode 0440)) PIO.defaultFileFlags

  let chunk_size_bt::ByteCount = fromIntegral (filesize `div` 4)
  let rm_bt::ByteCount = fromIntegral filesize - 3 * chunk_size_bt
  let chunk_size_off::FileOffset = filesize `div` 4
  ca <- PIOB.fdPread fd chunk_size_bt 0
  cb <- PIOB.fdPread fd chunk_size_bt chunk_size_off
  cc <- PIOB.fdPread fd chunk_size_bt (chunk_size_off * 2)
  cd <- PIOB.fdPread fd rm_bt (chunk_size_off * 3)

  let sol = runEval $ do
        a' <- rpar (force (map (solve (BC8.pack pat)) $ BC8.lines ca))
        b' <- rpar (force (map (solve (BC8.pack pat)) $ BC8.lines cb))
        c' <- rpar (force (map (solve (BC8.pack pat)) $ BC8.lines cc))
        d' <- rpar (force (map (solve (BC8.pack pat)) $ BC8.lines cd))
        _ <- rseq a'
        _ <- rseq b'
        _ <- rseq c'
        _ <- rseq d'
        return (a' ++ b' ++ c' ++ d')
        -- return (length a' + length b' + length c' + length d')
  mapM_ printMaybe (filter isJust sol)
  -- print sol
