import System.Environment
import Data.Maybe
import qualified Data.ByteString as B
import qualified Data.ByteString.Char8 as BC8
import qualified Data.ByteString.Search as BS
import Control.Parallel.Strategies hiding (parMap)

solve :: BC8.ByteString  -> BC8.ByteString -> Maybe BC8.ByteString
solve pat text
  | check = Just text
  | otherwise = Nothing
  where check = not . null $ BS.indices pat text

printMaybe :: Maybe BC8.ByteString -> IO ()
printMaybe (Just x) = BC8.putStrLn x
printMaybe Nothing = return ()

parMap :: (a -> b) -> [a] -> Eval [b]
parMap _ [] = return []
parMap f (a:as) = do b <- rpar (f a)
                     bs <- parMap f as
                     return (b:bs)

main :: IO ()
main = do
  [pat, filename] <- getArgs
  contents <- B.readFile filename
  let res = runEval (parMap (solve (BC8.pack pat)) $ BC8.lines contents)
  mapM_ printMaybe (filter isJust res)
  -- print $ length res
