# hipgrap

## Compile and Run
We have 6 separate implementations under src/:

SeqGrap.hs
Sequential version of the grep, read the entire file and run the BM algorithm line by line.

StaPar.hs
Static partitioning version, read the entire file as SeqGrap.hs, however, it splits the input into several chunks (we choose 4)
and run BM algorithm on each chunk in parallel.

DynPar.hs
Dynamic partitioning version, similar to StaPar.hs, it sparks a thread on every line instead of a chunk of input.

ParIO.hs
Parallel IO version, this one is similar to the StaPar.hs too. The new thing is that we add parallel support for the input,
we split the input file in many chunks, multiple threads will start at different offset for the input file.

Grap.hs
Multiple-file parallel version, it tries to solve the problem in another level of parallelism. Many files can be searched at same time.

SeqHipGrap.hs
Another version of SeqGrap that searches in the whole directory recursively if a directory is passed as the argument

Take SeqGrap as an example, to compile, run the following command:

```shell
stack ghc -- -O2 -threaded -rtsopts -eventlog SeqGrap.hs
```

To run:

```shell
time ./SeqGrap string_pat file +RTS -N1 -ls -s
```

Grap.hs and SeqHipGrap can take a directory as the second parameter since they can searching recursively in directory.


## Dependencies
- stm
- parallel
- directory
- filepath
- bytestring
- stringsearch
- unix
- deepseq
- unix-bytestring
