import Control.Parallel.Strategies
import System.Environment(getArgs)
import System.IO
import System.Exit(die)
import System.IO.Error(catchIOError, isUserError, isDoesNotExistError, ioeGetFileName, isPermissionError)

main :: IO ()
main = do
         [filename] <- getArgs
         h <- openFile filename ReadMode
         contents <- hGetContents h
         let list = inputToList contents
         putStr "Input: "
         print list
         printPartition $ threePartition list 4

      `catchIOError` \ e -> die $ case ioeGetFileName e of

       Just fn | isDoesNotExistError e -> fn ++ ": No such file"
               | isPermissionError e -> fn ++ ": Permission denied"
       _       | isUserError e -> "Usage: partition <filename>"
               | otherwise -> show e

inputToList :: String -> [Integer]
inputToList = map read . words

printPartition :: Show a => Maybe ([a],[a],[a]) -> IO ()
printPartition Nothing = do putStrLn "There is no possible partition"
printPartition (Just x) = do putStr "Possible partition: "
                             print x

threePartition :: Integral a => [a] -> Integer -> Maybe ([a],[a],[a])
threePartition list x | foldr (+) 0 list `mod` 3 > 0 = Nothing
                      | otherwise = threePartitionHelper x list ([],[],[])

threePartitionHelper :: Integral a => Integer -> [a] -> ([a], [a], [a]) -> Maybe ([a],[a],[a])
threePartitionHelper 0 s t = threePartitionNP s t
threePartitionHelper _ [] t = if check t then Just t
                            else Nothing
                            where check (a, b, c) = if x == y && y == z then True
                                                    else False
                                                    where x = foldr (+) 0 a
                                                          y = foldr (+) 0 b
                                                          z = foldr (+) 0 c
threePartitionHelper d (s:sx) (a, b, c) =  runEval $ do
                                            first <- rpar $ threePartitionHelper (d-1) sx (s:a, b, c)
                                            second <- rpar $ threePartitionHelper (d-1) sx (a, s:b, c)
                                            third <- rpar $ threePartitionHelper (d-1) sx (a, b, s:c)
                                            return $ output first second third 
                                           where output Nothing Nothing Nothing = Nothing
                                                 output (Just i) _ _ = Just i
                                                 output _ (Just j) _ = Just j
                                                 output _ _ (Just k) = Just k

threePartitionNP :: Integral a => [a] -> ([a], [a], [a]) -> Maybe ([a],[a],[a])
threePartitionNP [] t = if check t then Just t
                        else Nothing
                        where check (a, b, c) = if x == y && y == z then True
                                                else False
                                                where x = foldr (+) 0 a
                                                      y = foldr (+) 0 b
                                                      z = foldr (+) 0 c
threePartitionNP (s:sx) (a, b, c) = output first second third
                                    where output Nothing Nothing Nothing = Nothing
                                          output (Just i) _ _ = Just i
                                          output _ (Just j) _ = Just j
                                          output _ _ (Just k) = Just k
                                          first = threePartitionNP sx (s:a, b, c)
                                          second = threePartitionNP sx (a, s:b, c)
                                          third = threePartitionNP sx (a, b, s:c)