{-

Problem 1: Word Frequency Counter

Write a program that prints the 40 most common words and the number of
times they appear in the given text file.  Compile this into a
standalone executable that takes a single filename as a command-line
argument.  Print a usage message if the user does not supply exactly
one argument.

To find words, discard all non-alphabetic characters aside from
whitespace and treat what's left as lowercase.  E.g., treat "Stephen's
humor-challenged" as two words: "stephens" and "humorchallenged"

You may use any of the System or Data modules.  Ask permission from
the instructor on Piazza before you use any other modules.  You may
not use the Data.Text.WordCount module.

In my 32-line reference solution, I used Data.Map.fromListWith,
Data.List.sortBy, System.IO.readFile, System.Exit.die,
System.Environment.getArgs, and System.Environment.getProgName.

In addition to making your solution correct and readable, try to make
your solution go fast, but leave it single-threaded.  We will classify
solutions into three performance categories and assign 10% of the
score based on these categories:

1) Roughly the same as my reference solution (about 3s on the
   Shakespeare example);
2) Noticably faster than the reference solution
3) Noticably slower than the reference solution

E.g., on the Complete Works of Shakespeare

$ stack ghc -- --make -Wall -O wordFreq
$ ./wordFreq
Usage: wordFreq <filename>
$ wget http://www.gutenberg.org/files/100/100-0.txt
$ ./wordFreq 100-0.txt
30151 the
28385 and
21941 i
20910 to
18807 of
16126 a
14441 you
13182 my
12157 in
11779 that
9712 is
9068 not
8521 with
8265 me
8196 for
8178 it
7578 his
7369 be
7178 this
7077 your
6818 he
6753 but
6266 have
6177 as
5843 thou
5550 him
5455 so
5288 will
4752 what
4598 her
4359 thy
4206 all
4085 by
4075 no
3911 do
3845 shall
3802 if
3726 are
3551 we
3386 thee

-}

main :: IO ()
main = do
  putStrLn "Write your code here"
