#ifndef _USBMIDI_H
#define _USBMIDI_H

#include <libusb-1.0/libusb.h>

#define USB_HID_KEYBOARD_PROTOCOL 1
#define USB_MIDI_KEYBOARD_PROTOCOL 0

/* Modifier bits */
#define USB_LCTRL (1 << 0)
#define USB_LSHIFT (1 << 1)
#define USB_LALT (1 << 2)
#define USB_LGUI (1 << 3)
#define USB_RCTRL (1 << 4)
#define USB_RSHIFT (1 << 5)
#define USB_RALT (1 << 6)
#define USB_RGUI (1 << 7)

struct usb_midi_packet {
  uint8_t status_byte;
  uint8_t not_sure;
  uint8_t note;
  uint8_t attack;
  uint8_t other_data[60];
};

// struct usb_keyboard_packet {
//   uint8_t modifiers;
//   uint8_t reserved;
//   uint8_t keycode[6];
// };

/* Find and open a USB keyboard device.  Argument should point to
   space to store an endpoint address.  Returns NULL if no keyboard
   device was found. */
extern struct libusb_device_handle *openkeyboard(uint8_t *);

#endif
