#include <arpa/inet.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <unistd.h>

#include "note.h"
#include "usbmidi.h"
/* Update SERVER_HOST to be the IP address of
 * the chat server you are connecting to
 */
/* micro36.ee.columbia.edu */

#define BUFFER_SIZE 70000
#define MAX_MSG_LEN BUFFER_SIZE - 17

/*
 * References:
 *
 * http://beej.us/guide/bgnet/output/html/singlepage/bgnet.html
 * http://www.thegeekstuff.com/2011/12/c-socket-programming/
 *
 */

struct libusb_device_handle *keyboard;
uint8_t endpoint_address;

// char buf[BUFFER_SIZE];
// char keystate[BUFFER_SIZE];

int main() {

  int midi_top_fd;
  static const char filename[] = "/dev/midi_top";
  if ((midi_top_fd = open(filename, O_RDWR)) == -1) {
    fprintf(stderr, "could not open %s\n", filename);
    return -1;
  }

  /* initialize the driver program */
  note_init();

  /* Open the keyboard */
  if ((keyboard = openkeyboard(&endpoint_address)) == NULL) {

    fprintf(stderr, "Did not find a keyboard\n");
    // fbputs("Did not find a keyboard", 22, 19);
    exit(1);
  }

  // have to make our own packet...
  struct usb_midi_packet packet;
  int transferred;
  // char keystate[12];

  /* Look for and handle keypresses */
  // uint8_t data[64];

  int wave_1 = 0;
  int wave_2 = 0;

  for (;;) {
    int errcode = 0;
    memset(&packet, 0, sizeof(packet));
    errcode = libusb_bulk_transfer(keyboard, endpoint_address,
                                   (unsigned char *)&packet, sizeof(packet),
                                   &transferred, 1000);
    if (errcode != 0 ||
        (packet.status_byte != 9 && packet.status_byte != 11 &&
         packet.status_byte != 25 && packet.status_byte != 14)) {
      continue;
    }

    if (packet.status_byte == 25) {
      if (packet.note == 100 && packet.attack == 127) {
        printf("starting the send....\n");
        start_wave(midi_top_fd, 0);
        for (unsigned short i = 0; i < 48000; i++) {
          if (i < 24000)
            send_wave(midi_top_fd, 0x1388);
          else
            send_wave(midi_top_fd, 0xEC78);
        }
        printf("everything sent!..\n");
      }
      if (packet.note == 99 && packet.attack == 127) {
        wave_1++;
        printf("Wave_1 Number %d\n", wave_1);
      }
      if (packet.note == 98 && packet.attack == 127) {
        wave_1--;
        start_wave(midi_top_fd, 0);
        printf("Wave_1 Number %d\n", wave_1);
      }
      if (packet.note == 96 && packet.attack == 127) {
        wave_2++;
        printf("Wave_2 Number %d\n", wave_2);
      }
      if (packet.note == 97 && packet.attack == 127) {
        wave_2--;
        printf("Wave_2 Number %d\n", wave_2);
      }
    }

    if (packet.status_byte == 9) {
      printf("(NOTE, ATTACK): %d %d\n", packet.note, packet.attack);
      set_note(midi_top_fd, (unsigned short)packet.note,
               (unsigned short)packet.attack);
    }

    if (packet.status_byte == 11 && packet.note == 7) {
      printf("VOLUME(Value): %d\n", packet.attack);
    }
    if (packet.status_byte == 11 && packet.note == 1) {
      printf("MODULATION(Value): %d\n", packet.attack);
    }

    if (packet.status_byte == 14) {
      printf("PITCH WHEEL(VALUE): %d\n", packet.attack);
    }
  }

  return 0;
}
