
function y = sinwave(note, codec_freq, mag_bits, seconds)

lowest_freq = 1;
mag = 13100;
num_samples = int32( floor(codec_freq/lowest_freq) );

%disp("Amount of space OUT OF ~500 (KiloBytes):")
%disp((num_samples*mag_bits)/8192)

t_table = linspace(0, 2*pi, num_samples+1);
t_table(end) = [];

% HAVE to change to int32 if mag_bits > 16
if mag_bits <= 16
    sin_table = int16( mag * sin(t_table) );
else
    sin_table = int32( mag * sin(t_table) );
end


sample = 1;
sample_every =  floor(note/lowest_freq) ;

sin_freq = zeros(1,codec_freq*seconds*lowest_freq);
for i = 1:(num_samples*seconds*lowest_freq)
    sin_freq(i) = sin_table(sample);
    sample = mod( sample + sample_every, num_samples) + 1;
end

y = int16(sin_freq);

%t_freq = downsample(t_table,sample_every);
%sin_freq = downsample(sin_table,sample_every);


%
%figure;
%subplot(2,1,1)
%scatter(t_table,sin_table);
%subplot(2,1,2)
%scatter(t_table,sin_freq(1:num_samples));

%soundsc(sin_freq, codec_freq);

end
