%global sin_table

mag_bits    = 16;
codec_freq  = 44.1 * 1000;
seconds     = 2;
note = 440;

%Test here: https://www.szynalski.com/tone-generator/
sin_table = generate_sin_table(codec_freq, mag_bits);
saw_table = generate_saw_table(codec_freq, mag_bits);
triangle_table = generate_triangle_table(codec_freq, mag_bits);
square_table = generate_pulse_table(codec_freq, mag_bits, 50);

sin_out =           sample_wave(sin_table,      note, codec_freq, seconds);
saw_out =       sample_wave_saw(saw_table,      note, codec_freq, seconds);
triangle_out =      sample_wave(triangle_table, note, codec_freq, seconds);
pulse_out =    sample_wave_saw(square_table,   note, codec_freq, seconds);



%PLOT
%t = 0:(codec_freq*seconds-1);
plotnum = round(codec_freq*seconds/200);
t=1:plotnum;
figure;
subplot(4,1,1);
%scatter(t,sin_out);
scatter(t,sin_out(1:plotnum));
subplot(4,1,2)
scatter(t,saw_out(1:plotnum));
subplot(4,1,3)
scatter(t,triangle_out(1:plotnum));
subplot(4,1,4)
scatter(t,pulse_out(1:plotnum));


%PLAY SOUND
soundsc(double(sin_out), codec_freq);
pause(seconds+.1);
soundsc(double(saw_out), codec_freq);
pause(seconds+.1);
soundsc(double(triangle_out), codec_freq);
pause(seconds+.1);
soundsc(double(pulse_out), codec_freq);
