function triangle_table = generate_triangle_table(codec_freq, mag_bits)
                          %global sin_table
                          %codec_freq = 44100;
%mag_bits = 16;

mag = 2^(mag_bits-1)-1;
num_samples = int32( floor(codec_freq) );

disp("Size OUT OF ~500 (KiloBytes):")
disp((num_samples * mag_bits)/8192)

t_table = linspace(0, 2*pi, num_samples + 1);
t_table(end) = [];

%t_table = linspace(0, (2*pi)/4, num_samples);
triangle_table = int16( mag*sawtooth(t_table, 1/2) );

%int16(mag * )

%int16(linspace(-mag, mag, num_samples));
%t_table(end) = [];

% should change to int32 if mag_bits > 16
%saw_table =  int16(mag * sin(t_table));

%Write to file
fileID = fopen('tri_table','wb');
fprintf(fileID,"%.4x ", triangle_table);
fclose(fileID);

end
