% duty is scalar from 1 to 100, square is 50
function pulse_table = generate_pulse_table(codec_freq, mag_bits, duty)
                       mag = 2^(mag_bits-1)-1;
num_samples = int32( floor(codec_freq) );

disp("Size OUT OF ~500 (KiloBytes):")
disp((num_samples * mag_bits)/8192)

t_table = linspace(0, 2*pi, num_samples + 1);
t_table(end) = [];

%t_table = linspace(0, (2*pi)/4, num_samples);
pulse_table = int16( mag*square(t_table, duty) );


%Write to file
fileID = fopen('pulse_table','wb');
fprintf(fileID,"%.4x ", pulse_table);
fclose(fileID);

end
