#ifndef _MIDI_TOP_H
#define _MIDI_TOP_H

#include <linux/ioctl.h>

typedef struct {
  unsigned short note_info; // 16 bit thing
} midi_top_note_t;

typedef struct {
  midi_top_note_t note;
} midi_top_arg_t;

#define MIDI_TOP_MAGIC 'q'

/* ioctls and their arguments */
#define MIDI_TOP_WRITE_NOTE _IOW(MIDI_TOP_MAGIC, 1, midi_top_arg_t *)
#define MIDI_TOP_READ_NOTE _IOR(MIDI_TOP_MAGIC, 2, midi_top_arg_t *)
#define MIDI_TOP_START_WAVE _IOR(MIDI_TOP_MAGIC, 3, midi_top_arg_t *)
#define MIDI_TOP_SEND_WAVE _IOR(MIDI_TOP_MAGIC, 4, midi_top_arg_t *)

#endif
