module tb_wavetables();

logic clk;
logic rst;

logic write;     // set to true if linux sent us something
logic is_data;   // 0 is info, 1 is wave data
logic [15:0] wave_data;

logic [15:0] sample_address;
logic sample_ready;
logic sample_valid;

logic [6:0] mix_ratio;
logic [15:0] data_out;

//logic [15:0] sample_data0;
//logic [15:0] sample_data1;

wavetables w(.*);

//assign data_out = sample_data0;

initial begin
    rst = 1;
    clk = 0;
    #10 rst = 0;
end  

always begin
    #1 clk = ~clk;
end


logic [15:0]sample_counter;
logic [3:0] wave_counter;
logic [15:0] read_counter;

logic [15:0] numsent;


always_ff @(posedge clk) begin
	if(!rst) begin
		if(sample_counter < 16'd48000) begin
			sample_counter = sample_counter + 1;
			if (sample_counter == 1) begin
				write <= 1;
				is_data <= 0;
				if (wave_counter[0])
					wave_data <= 1;
				else 
					wave_data <= 0;
			end else begin
				write <= 1;
				is_data <= 1;
				wave_data <= numsent;
				numsent <= numsent + 1;
			end
		end else begin
			numsent <= 60;
			wave_counter = wave_counter + 1;
			sample_counter <= 0;
		end

		if(wave_counter > 1) begin
			if(!sample_valid) begin
				sample_ready <= 1;
				sample_address <= read_counter;
				if(read_counter < 47999)
					read_counter <= read_counter + 1;
				else 
					read_counter <= 0;

			end else begin
				sample_ready <= 0;
			end
		end
	end else begin
		mix_ratio <= 20;		
		numsent <= 0;
		sample_address <= 47932;
		read_counter <= 0;
		wave_counter <= 0;
		sample_counter <= 0;
		write <= 0;
	end
end


endmodule
