module mixer_tb (output logic [15:0] wave);

logic clk;
logic reset;

logic [15:0] wave1;
logic [15:0] wave2;

logic [6:0] mix_ratio;

logic [8:0] counter;

logic [15:0] wave_out;

//input to wave mixer
always_ff @(posedge clk) begin 
	if(reset) begin
		counter <= 0;
		mix_ratio <= 7'd63;
	end else begin
		counter <= counter + 1;
		wave1 <= counter;
		wave2 <= counter;
	end 
end


mixer dut(.reset, .wave1, .wave2, .mix_ratio, .wave_out(wave)); 

initial begin
    reset = 1;
    clk = 0;
    #10 reset = 0;
end

always begin
    #1 clk = !clk;
end

endmodule 
