// ==================================================================
// Copyright (c) 2013 by Terasic Technologies Inc.
// ==================================================================
//
// Modified 2019 by Stephen A. Edwards
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use in
//   synthesis for all Terasic Development Boards and Altera
//   Development Kits made by Terasic.  Other use of this code,
//   including the selling ,duplication, or modification of any
//   portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design
//   reference which illustrates how these types of functions can be
//   implemented.  It is the user's responsibility to verify their
//   design for consistency and functionality through the use of
//   formal verification methods.  Terasic provides no warranty
//   regarding the use or functionality of this code.
//
// ===============================================================
//           
//  Terasic Technologies Inc

//  9F., No.176, Sec.2, Gongdao 5th Rd, East Dist, Hsinchu City, 30070. Taiwan
//  
//  
//                     web: http://www.terasic.com/  
//                     email: support@terasic.com
module soc_system_top(

 ///////// AUD /////////
 input 	       AUD_ADCDAT,
 inout 	       AUD_ADCLRCK,
 inout 	       AUD_BCLK,
 output        AUD_DACDAT,
 inout 	       AUD_DACLRCK,
 output        AUD_XCK,

 ///////// CLOCK /////////
 input 	       CLOCK_50,
 
 ///////// KEY /////////
 input [3:0]   KEY,

 ///////// FPGA /////////
 output        FPGA_I2C_SCLK,
 inout 	       FPGA_I2C_SDAT
);

   logic [3:0] note;
   logic [2:0] octave = 3;
   logic [7:0] volume = 255;
   logic rdy_left;
   logic rdy_right;
   logic [15:0] sample;
   logic sample_valid;

   assign note = KEY[2:0];

   tonegen tg(.clk(CLOCK_50), .reset(~KEY[3]), .volume(volume), .note(note), .octave(octave), .left_chan_ready(rdy_left),
     .right_chan_ready(rdy_right), .sample_data(sample), .sample_valid(sample_valid));

   soc_system soc_system0(
     .clk_clk                      ( CLOCK_50 ),
     .reset_reset_n                ( 1'b1 ),

     .audio_0_avalon_left_channel_sink_data            (sample),
     .audio_0_avalon_left_channel_sink_valid           (sample_valid),
     .audio_0_avalon_left_channel_sink_ready           (rdy_left),
     .audio_0_avalon_right_channel_sink_data           (sample),
     .audio_0_avalon_right_channel_sink_valid          (sample_valid),
     .audio_0_avalon_right_channel_sink_ready          (rdy_right),
     .audio_0_external_interface_BCLK                  (AUD_BCLK),
     .audio_0_external_interface_DACDAT                (AUD_DACDAT),
     .audio_0_external_interface_DACLRCK               (AUD_DACLRCK),
     .audio_pll_0_audio_clk_clk                        (AUD_XCK),
     .audio_and_video_config_0_external_interface_SDAT (FPGA_I2C_SDAT),
     .audio_and_video_config_0_external_interface_SCLK (FPGA_I2C_SCLK)
  );
				          
endmodule
