module summer_tb (output logic [15:0] wave);

logic clk;
logic reset;

logic [15:0] note1;
logic [15:0] note2;
logic [15:0] note3;
logic [15:0] note4;
logic [15:0] note5;
logic [15:0] note6;
logic [15:0] note7;
logic [15:0] note8;
logic [15:0] note9;
logic [15:0] note10;


logic [3:0] valid_notes;

logic [8:0] counter;

//input to note mixer
always_ff @(posedge clk) begin 
	if(reset) begin
		counter <= 0;
		valid_notes <= 0;
	end else begin
		if (counter < 10) begin
			counter <= counter + 1;
			note1 <= 10;
			note2 <= 10;
			note3 <= 10;
			note4 <= 10;
			note5 <= 10;
			note6 <= 10;
			note7 <= 10;
			note8 <= 10;
			note9 <= 10;
			note10 <= 10;
		end else if (valid_notes < 10) begin
			counter <= 0;
			valid_notes = valid_notes + 1;
		end else begin
			reset <= 0;
		end
	end
end


summer dut(.reset, .note1, .note2, .note3, .note4, .note5, .note6, .note7, .note8, .note9, .note10, .valid_notes, .wave_out(wave)); 

initial begin
    reset = 1;
    clk = 0;
    #10 reset = 0;
end

always begin
    #1 clk = !clk;
end

endmodule 
