//`timescale 10ns / 1ns;

module tb_note_top (
    output logic left_out,
    output logic right_out
);

	logic clk;
	logic reset;
	//for wave table
	logic wave_address_ready;
	logic wave_sample_valid;
	logic signed [15:0] wave_sample;
	logic [15:0] wave_address;
	//from MIDI top
	logic note_data_valid;
	logic [15:0] note_data;
	logic [3:0] note_addr;
	//to audio codec	
	logic left_ready;
	logic right_ready;
	logic codec_sample_valid;
	logic signed [15:0] codec_sample_data;

	note_top nt(.audio_codec_ready(left_ready && right_ready), .*);

	audio_fifos af( // this is the audio codec
		.sample_left(codec_sample_data),
		.sample_right(codec_sample_data),
		.sample_left_valid(codec_sample_valid),
		.sample_right_valid(codec_sample_valid),
		.*
	);

	source src(.*); // this is the wavetable

	logic [12:0] clk_counter;
	logic [1:0] note_counter;
	//simulates midi top
	always_ff @(posedge clk) begin
		if (!reset) begin
			clk_counter <= clk_counter + 1;
			if (clk_counter < 10) begin
				note_addr <= clk_counter;
				note_data_valid <= 1;
			end else if(clk_counter == 10) begin
				case (note_counter)
					2'd0: note_data <= 16'b0000_0000_1_1111111;
					2'd1: note_data <= 16'b0000_0000_1_1111111;
					2'd2: note_data <= 16'b0000_0000_1_1111111;
					2'd3: note_data <= 16'b0000_0000_1_1111111;
				endcase
				note_data_valid <= 0;
				note_counter <= note_counter + 1;
			end
		end else begin 
			clk_counter <= 0;
			note_data <= 0;
			note_counter <= 0;
		end 
	end

	initial begin
		reset = 1;
		clk = 0;
		#10 reset = 0;
	end

	always begin
		#1 clk = !clk;
	end

endmodule

module source (
    input clk,
    input reset,
    output logic signed [15:0] wave_sample,
    output logic wave_sample_valid,
    input logic [15:0] wave_address,
    input wave_address_ready
);

	logic [2:0] count;

	always_ff @(posedge clk) begin
		if (reset) begin
		    count <= 0;
		    wave_sample <= 0;
		    wave_sample_valid <= 0;
		end else begin
		    if (wave_address_ready) begin
		        count <= (count == 3'd2) ? count : count + 3'd1;
				wave_sample <= (wave_address < 16'd24000) ? 16'd13100 : -16'd13100;
				if(count == 3'd2) begin
					wave_sample_valid <= 1;
				end
		    end else begin
		        count <= 0;
				wave_sample_valid <= 0;
			end
		end
	end

endmodule
