`timescale 10ns / 1ns;

module tb_note (
    output logic signed [29:0] sample_left,
    output logic signed [29:0] sample_right
);

logic clk;
logic rst;
logic [15:0] settings;

// to/from summer
logic signed [29:0] sample_out;
logic [15:0] amplitude;
logic valid_out;
logic ready_in;

// to/from arbiter
logic signed [15:0] sample_in;
logic valid_in;
logic [15:0] sample_address;
logic ready_out;

note n(.*);
source src(.*);
sink snk(.*);

assign sample_left = sample_out;
assign sample_right = sample_out;

initial begin
    rst = 1;
    clk = 0;
    settings = 16'h00ff;
    #10 rst = 0;
end  

always begin
    #1 clk = ~clk;
end
endmodule

// plays role of sample buffers
module source (
    input clk,
    input rst,
    output logic signed [15:0] sample_in,
    output logic valid_in,
    input logic [15:0] sample_address,
    input ready_out
);

logic [2:0] count;

always_ff @(posedge clk) begin
    if (rst) begin
        count <= 0;
        sample_in <= 0;
        valid_in <= 0;
    end else begin
        if (ready_out)
            count <= (count == 3'd4) ? count : count + 3'd1;
        else 
            count <= 0;
        valid_in = count == 3'd4;
        sample_in <= (sample_address > 16'd24000) ? 16'd255 : -16'd255;
    end
end
endmodule

// plays role of audio codec
module sink (
    input clk,
    input rst,
    output logic ready_in,
    input valid_out
);

logic [2:0] count;

always_ff @(posedge clk) begin
    if (rst) begin
        count <= 0;
        ready_in <= 0;
    end else begin
        if (valid_out)
            count <= 0;
        else 
            count <= (count == 3'd3) ? count : count + 3'd1;
        ready_in <= count == 3'd3;
    end
end
endmodule
