module arbiter_tb ();

logic clk;
logic reset;

logic get_next_sample;
logic notes_ready;

//for wave table
logic wave_address_ready;
logic wave_sample_valid;
logic [15:0] wave_sample;
logic [15:0] wave_address;

//for notes
logic [15:0] note_sample [9:0];
logic [15:0] note_address [9:0];
logic note_sample_valid [9:0];
logic note_address_ready [9:0];

integer i;
logic [2:0] runcount;

always_ff @(posedge clk) begin 
	if (reset) begin
		get_next_sample <= 0;
		wave_address_ready <= 0;
		notes_ready <= 0;
		runcount <= 1;

		for (i = 0; i < 10; i= i+1) begin
				note_sample_valid[i] <= 0;
		end

	end else begin
		if (notes_ready == 0) begin
			get_next_sample <= 1;
			for (i = 0; i < 10; i= i+1) begin
				note_address_ready[i] <= 1;
				note_address[i] <= i*runcount;
			end
			
			if(wave_address_ready) begin
				wave_sample <= wave_address;
				wave_sample_valid <= 1;
			end else begin
				wave_sample_valid <= 0;
			end
			
		end else begin
			runcount = runcount + 1;
			get_next_sample <= 0;
		end
	end
end


arbiter dut(.clk, .reset,
	//for note_top 
	.get_next_sample,
 	.notes_ready,
	
	//for wave table
	.wave_address_ready,
	.wave_sample_valid,
	.wave_sample,
	.wave_address,
	//for note modules
	.note_sample,
	.note_address,
	.note_sample_valid,
	.note_address_ready
); 

initial begin
    reset = 1;
    clk = 0;
    #10 reset = 0;
end

always begin
    #1 clk = !clk;
end

endmodule 
