module frac_mult (
		input reset,
		input logic signed [17:0] sum, 
		input logic [7:0] frac, 
		output logic signed [15:0] wave_out);

	//TODO test to make sure it works with negative numbers
	always_comb begin
		if(reset)
			wave_out = 0;
		else if (frac != 0)
			wave_out = frac[7] * (sum >> 1) + frac[6] * (sum >> 2) + frac[5] * (sum >> 3) + frac[4] * (sum >> 4) + frac[3] * (sum >> 5) + frac[2] * (sum >> 6) + frac[1] * (sum >> 7) + frac[0] * (sum >> 8);
		else
			wave_out = sum[15:0];
	end
endmodule



module summer (
		//input clk,
		input reset,
		input logic signed [15:0] notes_in [9:0],
		input logic [15:0] amplitudes [9:0],
		output logic signed [15:0] wave_out
	);

logic signed [17:0] sum;
logic [17:0] amp_sum;
logic [7:0] frac;

frac_mult fm (.*);

always_comb begin 
		amp_sum = amplitudes[9] + amplitudes[8] + amplitudes[7] + amplitudes[6] + amplitudes[5] + amplitudes[4] + amplitudes[3] + amplitudes[2] + amplitudes[1] + amplitudes[0];
		sum = notes_in[9] + notes_in[8] + notes_in[7] + notes_in[6] + notes_in[5] + notes_in[4] + notes_in[3] + notes_in[2] + notes_in[1] + notes_in[0];
		case (amp_sum[17:12])
			6'd0: frac = 8'h0;
			6'd1: frac = 8'hF0;
			6'd2: frac = 8'hE8;
			6'd3: frac = 8'hE0;
			6'd4: frac = 8'hDB;
			6'd5: frac = 8'hD6;
			6'd6: frac = 8'hCA;
			6'd7: frac = 8'hBE;
			6'd8: frac = 8'hB2;
			6'd9: frac = 8'hA9;
			6'd10: frac = 8'hA2;
			6'd11: frac = 8'h9C;
			6'd12: frac = 8'h96;
			6'd13: frac = 8'h90;
			6'd14: frac = 8'h8A;
			6'd15: frac = 8'h85;
			6'd16: frac = 8'h80;
			6'd17: frac = 8'h7C;
			6'd18: frac = 8'h78;
			6'd19: frac = 8'h74;
			6'd20: frac = 8'h70;
			6'd21: frac = 8'h6C;
			6'd22: frac = 8'h68;
			6'd23: frac = 8'h64;
			6'd24: frac = 8'h60;
			6'd25: frac = 8'h5D;
			6'd26: frac = 8'h5B;
			6'd27: frac = 8'h58;
			6'd28: frac = 8'h53;
			6'd29: frac = 8'h50;
			6'd30: frac = 8'h4E;
			6'd31: frac = 8'h4C;
			6'd32: frac = 8'h4A;
			6'd33: frac = 8'h48;
			6'd34: frac = 8'h46;
			6'd35: frac = 8'h44;
			6'd36: frac = 8'h43;
			6'd37: frac = 8'h42;
			6'd38: frac = 8'h41;
			6'd39: frac = 8'h40;
			default: frac = 8'h00;
		endcase
end

endmodule
