module note_top (
	input clk,
	input reset,
	//from wave table
	output logic wave_address_ready,
	input logic wave_sample_valid,
	input logic signed [15:0] wave_sample,
	output logic [15:0] wave_address,
	//from MIDI top
	input note_data_valid,
	input logic [15:0] note_data,
	input logic [3:0] note_addr,
	//to audio codec	
	input logic audio_codec_ready,
	output logic codec_sample_valid,
	output logic signed [15:0] codec_sample_data
);

logic get_next_sample;
logic arbiter_done;
//logic [9:0] push_reg; 
logic [15:0] note_address [9:0];
logic signed [15:0] note_sample [9:0];
logic [9:0] note_sample_valid;
logic signed [15:0] adjusted_sample [9:0];
logic [9:0] adjusted_sample_valid;
logic [9:0] note_address_ready;
logic notes_ready_in;
logic [15:0] note_settings [9:0];
logic [15:0] amplitudes [9:0];
 

//logic [3:0] num_active_notes;

arbiter note_arbiter (.clk(clk), .reset(reset), .get_next_sample(get_next_sample), .notes_ready(arbiter_done), .wave_address_ready(wave_address_ready), .wave_sample_valid(wave_sample_valid), .wave_sample(wave_sample), .wave_address(wave_address), .note_sample(note_sample), .note_address(note_address), .note_sample_valid(note_sample_valid), .note_address_ready(note_address_ready));

summer s (.reset(reset), .notes_in(adjusted_sample), .amplitudes(amplitudes), .wave_out(codec_sample_data));

note n0(.clk(clk), .rst(reset), .settings(note_settings[0]), .sample_out(adjusted_sample[0]), .valid_out(adjusted_sample_valid[0]), .ready_in(notes_ready_in), .sample_in(note_sample[0]), .valid_in(note_sample_valid[0]), 
.sample_address(note_address[0]), .ready_out(note_address_ready[0]), .amplitude(amplitudes[0]));
note n1(.clk(clk), .rst(reset), .settings(note_settings[1]), .sample_out(adjusted_sample[1]), .valid_out(adjusted_sample_valid[1]), .ready_in(notes_ready_in), .sample_in(note_sample[1]), .valid_in(note_sample_valid[1]), 
.sample_address(note_address[1]), .ready_out(note_address_ready[1]), .amplitude(amplitudes[1]));
note n2(.clk(clk), .rst(reset), .settings(note_settings[2]), .sample_out(adjusted_sample[2]), .valid_out(adjusted_sample_valid[2]), .ready_in(notes_ready_in), .sample_in(note_sample[2]), .valid_in(note_sample_valid[2]), 
.sample_address(note_address[2]), .ready_out(note_address_ready[2]), .amplitude(amplitudes[2]));
note n3(.clk(clk), .rst(reset), .settings(note_settings[3]), .sample_out(adjusted_sample[3]), .valid_out(adjusted_sample_valid[3]), .ready_in(notes_ready_in), .sample_in(note_sample[3]), .valid_in(note_sample_valid[3]), 
.sample_address(note_address[3]), .ready_out(note_address_ready[3]), .amplitude(amplitudes[3]));
note n4(.clk(clk), .rst(reset), .settings(note_settings[4]), .sample_out(adjusted_sample[4]), .valid_out(adjusted_sample_valid[4]), .ready_in(notes_ready_in), .sample_in(note_sample[4]), .valid_in(note_sample_valid[4]), 
.sample_address(note_address[4]), .ready_out(note_address_ready[4]), .amplitude(amplitudes[4]));
note n5(.clk(clk), .rst(reset), .settings(note_settings[5]), .sample_out(adjusted_sample[5]), .valid_out(adjusted_sample_valid[5]), .ready_in(notes_ready_in), .sample_in(note_sample[5]), .valid_in(note_sample_valid[5]), 
.sample_address(note_address[5]), .ready_out(note_address_ready[5]), .amplitude(amplitudes[5]));
note n6(.clk(clk), .rst(reset), .settings(note_settings[6]), .sample_out(adjusted_sample[6]), .valid_out(adjusted_sample_valid[6]), .ready_in(notes_ready_in), .sample_in(note_sample[6]), .valid_in(note_sample_valid[6]), 
.sample_address(note_address[6]), .ready_out(note_address_ready[6]), .amplitude(amplitudes[6]));
note n7(.clk(clk), .rst(reset), .settings(note_settings[7]), .sample_out(adjusted_sample[7]), .valid_out(adjusted_sample_valid[7]), .ready_in(notes_ready_in), .sample_in(note_sample[7]), .valid_in(note_sample_valid[7]), 
.sample_address(note_address[7]), .ready_out(note_address_ready[7]), .amplitude(amplitudes[7]));
note n8(.clk(clk), .rst(reset), .settings(note_settings[8]), .sample_out(adjusted_sample[8]), .valid_out(adjusted_sample_valid[8]), .ready_in(notes_ready_in), .sample_in(note_sample[8]), .valid_in(note_sample_valid[8]), 
.sample_address(note_address[8]), .ready_out(note_address_ready[8]), .amplitude(amplitudes[8]));
note n9(.clk(clk), .rst(reset), .settings(note_settings[9]), .sample_out(adjusted_sample[9]), .valid_out(adjusted_sample_valid[9]), .ready_in(notes_ready_in), .sample_in(note_sample[9]), .valid_in(note_sample_valid[9]), 
.sample_address(note_address[9]), .ready_out(note_address_ready[9]), .amplitude(amplitudes[9]));

enum integer {IDLE=0, ARBITER=1, NOTE=2, VALID=3} state;

always_ff @(posedge clk) begin 
	if (!reset) begin
		case(state) 
			IDLE: 	if(audio_codec_ready) begin 
						state <= ARBITER;
						codec_sample_valid <= 0; 
						get_next_sample <= 1;
						notes_ready_in <= 1;
					end else begin 
						codec_sample_valid <= 0; 
						get_next_sample <= 0;
						notes_ready_in <= 0;
					end
			ARBITER:if(arbiter_done) begin 
						state <= NOTE; 
						codec_sample_valid <= 0; 
						get_next_sample <= 0;
						notes_ready_in <= 1;
					end else begin
						codec_sample_valid <= 0; 
						get_next_sample <= 1;
						notes_ready_in <= 1;
					end
			NOTE: 	if(adjusted_sample_valid == 10'b1111111111) begin
						state <= VALID;
						codec_sample_valid <= 1; 
						get_next_sample <= 0;
						notes_ready_in <= 1;
					end else begin
						codec_sample_valid <= 0; 
						get_next_sample <= 0;
						notes_ready_in <= 1;
					end
			VALID: 	if(!audio_codec_ready) begin 
						state <= IDLE; 
						codec_sample_valid <= 0; 
						get_next_sample <= 0;
						notes_ready_in <= 0;
					end else begin
						codec_sample_valid <= 1; 
						get_next_sample <= 0;
						notes_ready_in <= 1;
					end
		endcase

		//sends data to notes
		if (note_data_valid) begin
			note_settings[note_addr] <= note_data;
		end

	end else begin
		get_next_sample <= 0; 
		codec_sample_valid <= 0;
		notes_ready_in <= 0;
		for(integer i = 0; i < 10; i = i+1) begin
			note_settings[i] <= 16'b0000_0000_0_0000000;
		end		
		state <= IDLE;
	end
end


endmodule
