module arbiter (
	input logic clk, 
	input logic reset, 
	//for note_top
	input logic get_next_sample,
 	output logic notes_ready,
	
	//for wave table
	output logic wave_address_ready,
	input logic wave_sample_valid,
	input logic signed [15:0] wave_sample,
	output logic [15:0] wave_address,
	//for note modules
	output logic signed [15:0] note_sample [9:0],
	input logic [15:0] note_address [9:0],
	output logic [9:0] note_sample_valid,
	input logic [9:0] note_address_ready 
);

logic [3:0] counter;
integer i;

always_ff @(posedge clk) begin
	
	if (!reset) begin
		if (get_next_sample && !notes_ready) begin
			if(counter < 4'd10 ) begin
				if (note_address_ready[counter]) begin
					wave_address <= note_address[counter];
					wave_address_ready <= 1;
				end
				if (wave_sample_valid && wave_address_ready) begin
					note_sample[counter] <= wave_sample;
					note_sample_valid[counter] <= 1;
					counter <= counter + 1;
					wave_address_ready <= 0;
				end
			end else begin 
				notes_ready <= 1;
				counter <= 0;
                note_sample_valid <= 10'd0;
			end
		end else if (!get_next_sample) begin
			notes_ready <= 0;
		end
	end else begin
		for (i = 0; i < 10; i= i+1) begin
			note_sample_valid[i] <= 0;
		end 

		counter <= 0;
		notes_ready <= 0;
		wave_address_ready <= 0;
	end
end

endmodule
