/*
* Avalon memory-mapped peripheral that generates VGA
*
* Stephen A. Edwards
* Columbia University
*/

module midi_top(input logic        clk,
		input logic 	   reset,
		input logic [15:0] writedata,
		input logic 	   write,
		input 		   chipselect,
		input logic [3:0]  address,

		input [3:0]	   KEY,
		
		input left_chan_ready,
		input right_chan_ready,
		output logic [15:0] sample_data,
		output logic sample_valid);


   logic [6:0] volume;
   logic status_bit;
   logic [3:0] note;
   logic [3:0] octave;


   tonegen tg(.clk(clk), .reset(~KEY[3]), .volume(volume), .note(note), .octave(octave), .left_chan_ready(left_chan_ready),
     .right_chan_ready(right_chan_ready), .sample_data(sample_data), .sample_valid(sample_valid));


   logic [15:0] addr;
   logic [15:0] din0, din1, din2;
   logic [15:0] dout0, dout1, dout2;
   logic we;
   //logic start_
   //logic [15:0]

   logic start;


   mem table0(.clock(clk), .address(addr), .data(din0),
		 .wren(we), .q(dout0));

   mem table1(.clock(clk), .address(addr), .data(din1),
		 .wren(we), .q(dout1));

   mem table2(.clock(clk), .address(addr), .data(din2),
		 .wren(we), .q(dout2));

   logic done;
   //assign done = ~(addr < 16'd48000);


   always_ff @(posedge clk) begin
   	if (reset) begin
		start <= 0;
		we   <= 0;
		octave <= 3;
	   	volume <= 255;
	   	note   <= KEY[2:0];
		we     <= 0;
		addr   <= 0;
		done   <= 0;
		
		//background_r <= 8'h0;
		//background_g <= 8'h0;
		//background_b <= 8'h80;
	end else if (chipselect && write) begin
		case (address)
	4'h0 : begin
		we  <= 0;
		volume     <= writedata[6:0];
		status_bit <= writedata[7];
		note       <= writedata[11:8];
		octave     <= writedata[15:12];
		end
	4'h1 : begin
		we  <= 0;
		volume     <= writedata[6:0];
		status_bit <= writedata[7];
		note       <= writedata[11:8];
		octave     <= writedata[15:12] + 2;
		end
	4'h2 : begin
		we  <= 0;
		start <= 1;
		done  <= 0;	
		addr  <= 0;
		end
	4'h3 : begin
		if ( (done == 1) | (addr > 16'd47998)) begin
			done <= 1;
			we <= 0;
		end
		else begin
			start <= 0;
			if (start == 1) begin
				we   <= 1;
				addr <= 0;
			end else if (addr == 16'd47998) begin
				we   <= 1;
				addr <= addr + 1;
				done <= 1;
			end else begin
				we   <= 1;
				addr <= addr + 1;		
			end
		
			din0  <= writedata;//6; //writedata; // addr + 1; 
			din1  <= writedata + 1; //7; //writedata + 1; addr + 1;
			din2  <= writedata + 2; //8; //writedata + 2; addr + 1; 
			end
		end
	default: begin
		we  <= 0;
		octave <= 3;
			volume <= 255;
			note   <= KEY[2:0];
		end
		endcase 
	end else begin
	we <= 0;
	if (done) begin
		addr <= 16'd4322;
		if (dout0 == 16'd0)
			note <= 0;
		else if (dout0 == 16'd4320)
			note <= 4;
		else if (dout0 == 16'd4321)
			note <= 5;
		else if (dout0 == 16'd4322 && dout1 == 16'd4323 && dout2 == 16'd4324)
			note <= 6;
		else if (dout0 == 16'd4323)
			note <= 7;
		else if (dout0 == 16'd4324)
			note <= 8;
		else
			note <= 9;
			octave <= 4;
			volume <= 255;
		end
	end
end

endmodule

module mem( input logic         clock,
	input logic  [15:0] address,
	input logic  [15:0] data,
	input logic         wren,
	output logic [15:0] q);

logic [15:0]  mem [47999:0];

always_ff @(posedge clock) begin
	if (wren) mem[address] <= data;
	q <= mem[address];
end

endmodule

