module tremolo (
	input clk,    // Clock
	input rst,
	input sample_in,
	output data_out
);

logic [9:0] clk_counter;
logic [9:0] aud_counter;

always_ff @(posedge clk) begin
	if(~rst) begin
		clk_counter <= 0;
		aud_counter <= 0;
	end else begin
		clk_counter <= clk_counter + 1;
		if(clk_counter == 0)
			aud_counter <= aud_counter + 1;
	end
end

always_comb	begin
	data_out = (sample_in >> 10) * aud_counter;
end

endmodule