module clipper (
	input rst,
	input en,
	input [15:0] sample_in,
	output [15:0] data_out
);

always_comb begin
	if (rst)
		data_out = 0;
	else if (en)
		case(sample_in[15:11]) 
			4'h0: data_out = sample_in << 2;
			4'h1: data_out = sample_in << 2;
			4'h2: data_out = sample_in << 1;
			4'h3: data_out = sample_in << 1;
			4'h4: data_out = 16'h7FFF;
			4'h5: data_out = 16'h7FFF;
			4'h6: data_out = 16'h7FFF;
			4'h7: data_out = 16'h7FFF;
			4'h8: data_out = 16'h8000;
			4'h9: data_out = 16'h8000;
			4'hA: data_out = 16'h8000;
			4'hB: data_out = 16'h8000;
			4'hC: data_out = sample_in << 1;
			4'hD: data_out = sample_in << 1;
			4'hE: data_out = sample_in << 2;
			4'hF: data_out = sample_in << 2;
		endcase
	else
		data_out = sample_in;
end

endmodule
