#ifndef _REFERENCE_H
#define _REFERENCE_H

typedef struct {
  int type;
  unsigned int data;
  unsigned int pointer;
  int marked;
} bram_entry_t;

typedef struct root_t {
  unsigned int pointer;
  int cycles;
  struct root_t *next;
} root_t;

typedef struct {
  unsigned int head;
  unsigned int tail;
  bram_entry_t *bram;
  root_t *roots;
} reference_arg_t;

void make_reference(reference_arg_t *ref, int base, int bound);

unsigned int write_reference(reference_arg_t *ref, unsigned int node, int cycles);

unsigned int read_reference(reference_arg_t *ref, unsigned int pointer);

void free_reference(reference_arg_t *ref);

int decrement_roots(reference_arg_t *ref);

void gc_reference(reference_arg_t *ref, int base, int bound);

void list_roots(unsigned int *roots, reference_arg_t *ref, int num_roots);

unsigned int get_root(reference_arg_t *ref, int key);

#endif
