#include "reference.h"
#include <stdlib.h>
#include <stdio.h>

void make_reference(reference_arg_t *ref, int base, int bound) {

  ref->head = base;
  ref->tail = bound-1;
  ref->bram = malloc((bound-base) * sizeof(bram_entry_t));
  ref->roots = NULL;
  
  for(int i = base; i < bound-1; i++) {
    ref->bram[i].type = 1;
    ref->bram[i].data = 0;
    ref->bram[i].pointer = i+1;
    ref->bram[i].marked = 2;
  }
  ref->bram[bound-1].type = 1;
  ref->bram[bound-1].marked = 2;
  ref->bram[bound-1].pointer = bound;
}

void free_reference(reference_arg_t *ref) {
  free(ref->bram);
  root_t *traverse = ref->roots;
  root_t *to_free;

  while (traverse != NULL) {
    to_free = traverse;
    traverse = traverse->next;
    free(to_free);
  }
}

unsigned int write_reference(reference_arg_t *ref, unsigned int node, int cycles){
  unsigned int t, d, p;
  unsigned int next, current;
  root_t *new_root;

  current = ref->head;
  next = ref->bram[ref->head].pointer;

  t = (node & 0x1);
  d = ((node >> 1) & 0xfff);
  p = ((node >> 13) & 0xfff);

  ref->bram[current].type = t;
  ref->bram[current].data = d;
  ref->bram[current].pointer = p;
  ref->bram[current].marked = 0;

  ref->head = next;

  new_root = malloc(sizeof(root_t));
  new_root->pointer = current;
  new_root->cycles = cycles;
  new_root->next = ref->roots;
  ref->roots = new_root;
  
  return current;
}

unsigned int read_reference(reference_arg_t *ref, unsigned int pointer){
  unsigned int t, d, p;
  unsigned int node;
  
  t = ref->bram[pointer].type;
  d = ref->bram[pointer].data;
  p = ref->bram[pointer].pointer;

  node = ((p & 0xfff) << 13) | ((d & 0xfff) << 1) | (t & 0x1);
  return node;
}

int decrement_roots(reference_arg_t *ref) {
  root_t *traverse = ref->roots;
  root_t *previous = NULL;
  int removed = 0;
  root_t *to_free;

  while (traverse != NULL) {
    traverse->cycles-=1;
    if (traverse->cycles == 0) {
      removed++;
      if(traverse == ref->roots) {
	to_free = ref->roots;
	ref->roots = ref->roots->next;
	traverse = traverse->next;
      	free(to_free);
      }else {
	to_free = traverse;
	previous->next = traverse->next;
	traverse = traverse->next;
      	free(to_free);
      }
    }else {
      previous = traverse;
      traverse = traverse->next;
    }
  }

  return removed;
}

void gc_reference(reference_arg_t *ref, int base, int bound) {
  root_t *traverse = ref->roots;
  unsigned int prev = -1;

  while (traverse != NULL) {
    int addr = traverse->pointer;
    bram_entry_t entry = ref->bram[addr];

    while (1) {
      if (entry.marked == 1)
	break;

      ref->bram[addr].marked = 1;

      if (entry.type == 0)
	break;
      
      addr = entry.pointer;
      entry = ref->bram[addr];

    }
    traverse = traverse->next;
  }

  for (int i = base; i < bound; i++) {
    if (ref->bram[i].marked == 0) {
      ref->bram[i].marked = 2;
      ref->bram[i].type = 0;
      ref->bram[i].data = 0;
      ref->bram[i].pointer = i;

      ref->bram[ref->tail].type = 1;
      ref->bram[ref->tail].pointer = i;

      ref->tail = i;
    } else if (ref->bram[i].marked == 1) {
      ref->bram[i].marked = 0;
    }
  }
}

void list_roots(unsigned int *roots, reference_arg_t *ref, int num_roots) {
  root_t *traverse;
  int i;
  
  traverse = ref->roots;
  i = 0;

  while (traverse != NULL) {
    roots[i] = traverse->pointer;
    traverse = traverse->next;
    i++;
  }

  while (i < num_roots) {
    roots[i] = -1;
    i++;
  }
}

unsigned int get_root(reference_arg_t *ref, int num){
  root_t *traverse = ref->roots;
  int i = 0;
  
  while (i < num) {
    i++;
    if (traverse->next == NULL)
      return -1;
    else
      traverse = traverse->next;
  }
  return traverse->pointer;
}
