#include "reference.h"
#include "GC_Memory.h"
#include <stdlib.h>
#include <stdio.h>
#include <sys/ioctl.h>

void init_memory(int gc_memory_fd, int base, int bound, int threshold, int num_roots) {

  gc_memory_arg_t vla;
    
  vla.value = base;
  if (ioctl(gc_memory_fd, GC_MEMORY_BASE, &vla)) {
    perror("ioctl(GC_MEMORY_BASE) failed");
    return;
  }
  
  vla.value = bound;
  if (ioctl(gc_memory_fd, GC_MEMORY_BOUND, &vla)) {
    perror("ioctl(GC_MEMORY_BOUND) failed");
    return;
  }
  
  vla.value = threshold;
  if (ioctl(gc_memory_fd, GC_MEMORY_THRESHOLD, &vla)) {
    perror("ioctl(GC_MEMORY_THRESHOLD) failed");
    return;
  }

  vla.value = num_roots;
  if (ioctl(gc_memory_fd, GC_MEMORY_NUM_ROOTS, &vla)) {
    perror("ioctl(GC_MEMORY_NUM_ROOTS) failed");
    return;
  }
  
}

void write_op(int gc_memory_fd, unsigned int *v) {
  gc_memory_arg_t vla;
  vla.value = *v;
  if (ioctl(gc_memory_fd, GC_MEMORY_WRITE_OP, &vla)) {
    perror("ioctl(GC_MEMORY_WRITE_OP) failed");
    return;
  }
}

void read_op(int gc_memory_fd, unsigned int *v) {
  gc_memory_arg_t vla;
  vla.value = *v;
  if (ioctl(gc_memory_fd, GC_MEMORY_READ_OP, &vla)) {
    perror("ioctl(GC_MEMORY_READ_OP) failed");
    return;
  }
}

void write_res(int gc_memory_fd, unsigned int *v) {
  gc_memory_arg_t vla;

  if (ioctl(gc_memory_fd, GC_MEMORY_WRITE_RES, &vla)) {
    perror("ioctl(GC_MEMORY_WRITE_RES) failed");
    return;
  }
  *v = vla.value;
}

void read_res(int gc_memory_fd, unsigned int *v) {
  gc_memory_arg_t vla;

  if (ioctl(gc_memory_fd, GC_MEMORY_READ_RES, &vla)) {
    perror("ioctl(GC_MEMORY_READ_RES) failed");
    return;
  }
  *v = vla.value;
}

void get_status(int gc_memory_fd, unsigned int *v) {
  gc_memory_arg_t vla;

  if (ioctl(gc_memory_fd, GC_MEMORY_STATUS, &vla)) {
    perror("ioctl(GC_MEMORY_STATUS) failed");
    return;
  }
  *v = vla.value;
}

void update_status(int gc_memory_fd, gc_memory_status_t *status) {
  unsigned int s;
  get_status(gc_memory_fd, &s);

  if ((s >> 0) & 0x1)
    status->read_rdy = 1;
  if ((s >> 1) & 0x1)
    status->write_rdy = 1;
  if ((s >> 2) & 0x1)
    status->read_res_rdy = 1;
  if ((s >> 3) & 0x1)
    status->write_res_rdy = 1;
  if ((s >> 4) & 0x1)
    status->start_gc = 1;
  if ((s >> 5) & 0x1)
    status->gc_done = 1;
  if ((s >> 6) & 0x1)
    status->root_rdy = 1;
}

void get_bram(int gc_memory_fd, int base, int bound, unsigned int *bram) {
  gc_memory_arg_t vla;
  unsigned int v;
  
  for (int i = base; i < bound; i++) {
    if (ioctl(gc_memory_fd, GC_MEMORY_READ_BRAM, &vla)) {
      perror("ioctl(GC_MEMORY_READ_BRAM) failed");
      return;
    }
    v = vla.value;
    bram[i] = v;
  }
}

void root_op(int gc_memory_fd, unsigned int *v) {
  gc_memory_arg_t vla;
  vla.value = *v;
  if (ioctl(gc_memory_fd, GC_MEMORY_ROOT, &vla)) {
    perror("ioctl(GC_MEMORY_ROOT) failed");
    return;
  }
}
