//`include "Types.sv"

module Write(
  input logic clk,
  input Node_t dat_d,
  output logic dat_r,
  input Res_t res_d,
  output logic res_r,
  input \Word#_t  init_d,
  output logic init_r,
  output Cmd_t cmd_out_dout,
  input logic cmd_out_rout,
  output Pointer_t ref_out_dout,
  input logic ref_out_rout,
  output Node_t nul_node_dout,
  input logic nul_node_rout
  );
  /* --define=INPUTS=((dat, 33, 8589934592, Node), (res, 34, 17179869184, Res), (init, 16, 65536, Word__023)) */
  /* --define=TAPS=() */
  /* --define=OUTPUTS=((cmd_out, 50, 1125899906842624, Cmd), (ref_out, 16, 65536, Pointer), (nul_node, 33, 8589934592, Node)) */
  /* TYPE_START
TYPE_END */
  /*  */
  /*  */

   parameter POINTER_BITS = 17;
   parameter NODE_BITS = 34;

   parameter POINTER_MSB = POINTER_BITS-1; //16;
   parameter WORD_MSB = POINTER_BITS-1; //16;
   parameter RES_MSB = NODE_BITS; //34;
   parameter NODE_MSB = NODE_BITS-1; //33;
   parameter NODE_PTR_LSB = POINTER_BITS+1; //18;
   parameter CMD_MSB = POINTER_BITS+NODE_BITS-1; //50;
   parameter NODE_WORD_MSB = POINTER_BITS; //17;

   Res_t ref_g_d;
  logic ref_g_r;
  Res_t res_in_d;
  logic res_in_r;
  Go_t ref_go_d;
  logic ref_go_r;
  Pointer_t ref_out_d;
  logic ref_out_r;
  Node_t al_node_d;
  logic al_node_r;
  Node_t al_node_choose_d;
  logic al_node_choose_r;
  Node_t al_node_pass_d;
  logic al_node_pass_r;
  Node_t nul_node_d;
  logic nul_node_r;
  Node_t val_node_d;
  logic val_node_r;
  \Word#_t  _0_d;
  logic _0_r;
  assign _0_r = 1'd1;
  Pointer_t al_ref_d;
  logic al_ref_r;
  \Word#_t  addr_d;
  logic addr_r;
  \Word#_t  init_a_d;
  logic init_a_r;
  \Word#_t  init_tok_d;
  logic init_tok_r;
  Go_t init_go_d;
  logic init_go_r;
  Tog_t choose_init_d;
  logic choose_init_r;
  \Word#_t  addr_o_d;
  logic addr_o_r;
  \Word#_t  init_addr_buf_d;
  logic init_addr_buf_r;
  \Word#_t  loop_addr_buf_d;
  logic loop_addr_buf_r;
  \Word#_t  init_addr_d;
  logic init_addr_r;
  \Word#_t  loop_addr_d;
  logic loop_addr_r;
  Go_t addr_go_d;
  logic addr_go_r;
  Tog_t choose_addr_d;
  logic choose_addr_r;
  Tog_t choose_d;
  logic choose_r;
  \Word#_t  addr_wr_buf_d;
  logic addr_wr_buf_r;
  \Word#_t  addr_rd_buf_d;
  logic addr_rd_buf_r;
  \Word#_t  addr_out_d;
  logic addr_out_r;
  \Word#_t  addr_wr_d;
  logic addr_wr_r;
  \Word#_t  addr_rd_d;
  logic addr_rd_r;
  Pointer_t ref_wait_d;
  logic ref_wait_r;
  Cmd_t cmd_wr_d;
  logic cmd_wr_r;
  Cmd_t cmd_rd_d;
  logic cmd_rd_r;
  Cmd_t cmd_out_d;
  logic cmd_out_r;
  S_t sel_d;
  logic sel_r;
  S_t sel_loop_d;
  logic sel_loop_r;
  S_t sel_res_d;
  logic sel_res_r;
  S_t sel_res_buf_d;
  logic sel_res_buf_r;
  S_t sel_out_d;
  logic sel_out_r;
  S_t sel_new_r_d;
  logic sel_new_r_r;
  S_t sel_new_d;
  logic sel_new_r;
  S_t sel_zero_d;
  logic sel_zero_r;
  S_t sel_zero_loop_d;
  logic sel_zero_loop_r;
  S_t sel_one_d;
  logic sel_one_r;
  S_t sel_one_loop_d;
  logic sel_one_loop_r;
  S_t sel_zero_out_d;
  logic sel_zero_out_r;
  S_t sel_zero_r_d;
  logic sel_zero_r_r;
  S_t sel_one_out_d;
  logic sel_one_out_r;
  S_t sel_one_r_d;
  logic sel_one_r_r;
  
  /* source (Ty Node) : > (dat,Node) */
  
  /* source (Ty Res) : > (res,Res) */
  
  /* source (Ty Word#) : > (init,Word#) */
  
  /* demux (Ty S,Ty Res) : (sel_res_buf,S) (res,Res) > [(ref_g,Res),
                                                   (res_in,Res)] */
  logic [1:0] res_onehotd;
  always_comb
    if ((sel_res_buf_d[0] && res_d[0]))
      unique case (sel_res_buf_d[1:1])
        1'd0: res_onehotd = 2'd1;
        1'd1: res_onehotd = 2'd2;
        default: res_onehotd = 2'bx;
      endcase
    else res_onehotd = 2'd0;
  assign ref_g_d = {res_d[RES_MSB:1], res_onehotd[0]};
  assign res_in_d = {res_d[RES_MSB:1], res_onehotd[1]};
  assign res_r = (| (res_onehotd & {res_in_r, ref_g_r}));
  assign sel_res_buf_r = res_r;
  
  /* togo (Ty Res) : (ref_g,Res) > (ref_go,Go) */
  assign ref_go_d = ref_g_d[0];
  assign ref_g_r = ref_go_r;
  
  /* mux (Ty Go,
     Ty Pointer) : (ref_go,Go) [(ref_wait,Pointer)] > (ref_out,Pointer) */
  assign ref_out_d = {ref_wait_d[POINTER_MSB:1],
                      (ref_go_d[0] && ref_wait_d[0])};
  assign ref_wait_r = (ref_out_r && (ref_go_d[0] && ref_wait_d[0]));
  assign ref_go_r = (ref_out_r && (ref_go_d[0] && ref_wait_d[0]));
  
  /* destruct (Ty Res,Dcon Data) : (res_in,Res) > [(al_node,Node)] */
  assign al_node_d = {res_in_d[RES_MSB:2], res_in_d[0]};
  assign res_in_r = al_node_r;
  
  /* fork (Ty Node) : (al_node,Node) > [(al_node_choose,Node),
                                   (al_node_pass,Node)] */
  logic [1:0] al_node_emitted;
  initial al_node_emitted = 2'd0;
  logic [1:0] al_node_done;
  assign al_node_choose_d = {al_node_d[NODE_MSB:1],
                             (al_node_d[0] && (! al_node_emitted[0]))};
  assign al_node_pass_d = {al_node_d[NODE_MSB:1],
                           (al_node_d[0] && (! al_node_emitted[1]))};
  assign al_node_done = (al_node_emitted | ({al_node_pass_d[0],
                                             al_node_choose_d[0]} & {al_node_pass_r,
                                                                     al_node_choose_r}));
  assign al_node_r = (& al_node_done);
  always_ff @(posedge clk)
    al_node_emitted <= (al_node_r ? 2'd0 :
                        al_node_done);
  
  /* demux (Ty Node,
       Ty Node) : (al_node_choose,Node) (al_node_pass,Node) > [(nul_node,Node),
                                                               (val_node,Node)] */
  logic [1:0] al_node_pass_onehotd;
  always_comb
    if ((al_node_choose_d[0] && al_node_pass_d[0]))
      unique case (al_node_choose_d[1:1])
        1'd0: al_node_pass_onehotd = 2'd1;
        1'd1: al_node_pass_onehotd = 2'd2;
        default: al_node_pass_onehotd = 2'bx;
      endcase
    else al_node_pass_onehotd = 2'd0;
  assign nul_node_d = {al_node_pass_d[NODE_MSB:1],
                       al_node_pass_onehotd[0]};
  assign val_node_d = {al_node_pass_d[NODE_MSB:1],
                       al_node_pass_onehotd[1]};
  assign al_node_pass_r = (| (al_node_pass_onehotd & {val_node_r,
                                                      nul_node_r}));
  assign al_node_choose_r = al_node_pass_r;
  
  /* destruct (Ty Node,Dcon Nd) : (val_node,Node) > [(_0,Word#),
                                                (al_ref,Pointer)] */
  logic [1:0] val_node_emitted;
  initial val_node_emitted = 2'd0;
  logic [1:0] val_node_done;
  assign _0_d = {val_node_d[NODE_WORD_MSB:2],
                 (val_node_d[0] && (! val_node_emitted[0]))};
  assign al_ref_d = {val_node_d[NODE_MSB:NODE_PTR_LSB],
                     (val_node_d[0] && (! val_node_emitted[1]))};
  assign val_node_done = (val_node_emitted | ({al_ref_d[0],
                                               _0_d[0]} & {al_ref_r, _0_r}));
  assign val_node_r = (& val_node_done);
  always_ff @(posedge clk)
    val_node_emitted <= (val_node_r ? 2'd0 :
                         val_node_done);
  
  /* destruct (Ty Pointer,Dcon P) : (al_ref,Pointer) > [(addr,Word#)] */
  assign addr_d = {al_ref_d[POINTER_MSB:1], al_ref_d[0]};
  assign al_ref_r = addr_r;
  
  /* fork (Ty Word#) : (init,Word#) > [(init_a,Word#),
                                      (init_tok,Word#)] */
  logic [1:0] init_emitted;
  initial init_emitted = 2'd0;
  logic [1:0] init_done;
  assign init_a_d = {init_d[WORD_MSB:1],
                     (init_d[0] && (! init_emitted[0]))};
  assign init_tok_d = {init_d[WORD_MSB:1],
                       (init_d[0] && (! init_emitted[1]))};
  assign init_done = (init_emitted | ({init_tok_d[0],
                                       init_a_d[0]} & {init_tok_r, init_a_r}));
  assign init_r = (& init_done);
  always_ff @(posedge clk)
    init_emitted <= (init_r ? 2'd0 :
                     init_done);
  
  /* togo (Ty Word#) : (init_tok,Word#) > (init_go,Go) */
  assign init_go_d = init_tok_d[0];
  assign init_tok_r = init_go_r;
  
  /* dcon (Ty Tog,Dcon One) : [(init_go,Go)] > (choose_init,Tog) */
  assign choose_init_d = One_dc((& {init_go_d[0]}), init_go_d);
  assign {init_go_r} = {1 {(choose_init_r && choose_init_d[0])}};
  
  /* mux (Ty Tog,Ty Word#) : (choose,Tog) [(addr,Word#),
                                        (init_a,Word#)] > (addr_o,Word#) */
  logic [WORD_MSB:0] addr_o_mux;
  logic [1:0] addr_o_onehot;
  always_comb
    unique case (choose_d[1:1])
      1'd0: {addr_o_onehot, addr_o_mux} = {2'd1, addr_d};
      1'd1: {addr_o_onehot, addr_o_mux} = {2'd2, init_a_d};
      default: {addr_o_onehot, addr_o_mux} = {2'bx, {{WORD_MSB{1'bx}}, 1'd0}};
    endcase
  assign addr_o_d = {addr_o_mux[WORD_MSB:1],
                     (addr_o_mux[0] && choose_d[0])};
  assign choose_r = (addr_o_d[0] && addr_o_r);
  assign {init_a_r, addr_r} = (choose_r ? addr_o_onehot :
                               2'd0);
  
  /* fork (Ty Word#) : (addr_o,Word#) > [(init_addr_buf,Word#),
                                        (loop_addr_buf,Word#)] */
  logic [1:0] addr_o_emitted;
  initial addr_o_emitted = 2'd0;
  logic [1:0] addr_o_done;
  assign init_addr_buf_d = {addr_o_d[WORD_MSB:1],
                            (addr_o_d[0] && (! addr_o_emitted[0]))};
  assign loop_addr_buf_d = {addr_o_d[WORD_MSB:1],
                            (addr_o_d[0] && (! addr_o_emitted[1]))};
  assign addr_o_done = (addr_o_emitted | ({loop_addr_buf_d[0],
                                           init_addr_buf_d[0]} & {loop_addr_buf_r,
                                                                  init_addr_buf_r}));
  assign addr_o_r = (& addr_o_done);
  always_ff @(posedge clk)
    addr_o_emitted <= (addr_o_r ? 2'd0 :
                       addr_o_done);
  
  /* buf (Ty Word#) : (init_addr_buf,Word#) > (init_addr,Word#) */
  \Word#_t  init_addr_buf_bufchan_d;
  logic init_addr_buf_bufchan_r;
  \Word#_t  init_addr_buf_buf;
  initial init_addr_buf_buf = {{WORD_MSB{1'bx}}, 1'd0};
  assign init_addr_buf_r = (! init_addr_buf_buf[0]);
  assign init_addr_buf_bufchan_d = (init_addr_buf_buf[0] ? init_addr_buf_buf :
                                    init_addr_buf_d);
  always_ff @(posedge clk)
    if ((init_addr_buf_bufchan_r && init_addr_buf_buf[0]))
      init_addr_buf_buf <= {{WORD_MSB{1'bx}}, 1'd0};
    else if (((! init_addr_buf_bufchan_r) && (! init_addr_buf_buf[0])))
      init_addr_buf_buf <= init_addr_buf_d;
  initial init_addr_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign init_addr_buf_bufchan_r = ((! init_addr_d[0]) || init_addr_r);
  always_ff @(posedge clk)
    if (init_addr_buf_bufchan_r)
      init_addr_d <= init_addr_buf_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((init_addr_d[0] && (! init_addr_r)))
      $display("%5t blocked: init_addr", $time);
  `endif
  
  /* buf (Ty Word#) : (loop_addr_buf,Word#) > (loop_addr,Word#) */
  \Word#_t  loop_addr_buf_bufchan_d;
  logic loop_addr_buf_bufchan_r;
  \Word#_t  loop_addr_buf_buf;
  initial loop_addr_buf_buf = {{WORD_MSB{1'bx}}, 1'd0};
  assign loop_addr_buf_r = (! loop_addr_buf_buf[0]);
  assign loop_addr_buf_bufchan_d = (loop_addr_buf_buf[0] ? loop_addr_buf_buf :
                                    loop_addr_buf_d);
  always_ff @(posedge clk)
    if ((loop_addr_buf_bufchan_r && loop_addr_buf_buf[0]))
      loop_addr_buf_buf <= {{WORD_MSB{1'bx}}, 1'd0};
    else if (((! loop_addr_buf_bufchan_r) && (! loop_addr_buf_buf[0])))
      loop_addr_buf_buf <= loop_addr_buf_d;
  initial loop_addr_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign loop_addr_buf_bufchan_r = ((! loop_addr_d[0]) || loop_addr_r);
  always_ff @(posedge clk)
    if (loop_addr_buf_bufchan_r)
      loop_addr_d <= loop_addr_buf_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((loop_addr_d[0] && (! loop_addr_r)))
      $display("%5t blocked: loop_addr", $time);
  `endif
  
  /* togo (Ty Word#) : (loop_addr,Word#) > (addr_go,Go) */
  assign addr_go_d = loop_addr_d[0];
  assign loop_addr_r = addr_go_r;
  
  /* dcon (Ty Tog,Dcon Zero) : [(addr_go,Go)] > (choose_addr,Tog) */
  assign choose_addr_d = Zero_dc((& {addr_go_d[0]}), addr_go_d);
  assign {addr_go_r} = {1 {(choose_addr_r && choose_addr_d[0])}};
  
  /* merge (Ty Tog) : [(choose_addr,Tog),
                  (choose_init,Tog)] > (choose,Tog) */
  logic [1:0] choose_selected;
  logic [1:0] choose_select;
  initial choose_select = 2'd0;
  always_comb
    begin
      choose_selected = 2'd0;
      if ((| choose_select)) choose_selected = choose_select;
      else
        if (choose_addr_d[0]) choose_selected[0] = 1'd1;
        else if (choose_init_d[0]) choose_selected[1] = 1'd1;
    end
  always_ff @(posedge clk)
    choose_select <= (choose_r ? 2'd0 :
                      choose_selected);
  always_comb
    if (choose_selected[0]) choose_d = choose_addr_d;
    else if (choose_selected[1]) choose_d = choose_init_d;
    else choose_d = {1'bx, 1'd0};
  assign {choose_init_r,
          choose_addr_r} = (choose_r ? choose_selected :
                            2'd0);
  
  /* fork (Ty Word#) : (init_addr,Word#) > [(addr_wr_buf,Word#),
                                           (addr_rd_buf,Word#),
                                           (addr_out,Word#)] */
  logic [2:0] init_addr_emitted;
  initial init_addr_emitted = 3'd0;
  logic [2:0] init_addr_done;
  assign addr_wr_buf_d = {init_addr_d[WORD_MSB:1],
                          (init_addr_d[0] && (! init_addr_emitted[0]))};
  assign addr_rd_buf_d = {init_addr_d[WORD_MSB:1],
                          (init_addr_d[0] && (! init_addr_emitted[1]))};
  assign addr_out_d = {init_addr_d[WORD_MSB:1],
                       (init_addr_d[0] && (! init_addr_emitted[2]))};
  assign init_addr_done = (init_addr_emitted | ({addr_out_d[0],
                                                 addr_rd_buf_d[0],
                                                 addr_wr_buf_d[0]} & {addr_out_r,
                                                                      addr_rd_buf_r,
                                                                      addr_wr_buf_r}));
  assign init_addr_r = (& init_addr_done);
  always_ff @(posedge clk)
    init_addr_emitted <= (init_addr_r ? 3'd0 :
                          init_addr_done);
  
  /* buf (Ty Word#) : (addr_wr_buf,Word#) > (addr_wr,Word#) */
  \Word#_t  addr_wr_buf_bufchan_d;
  logic addr_wr_buf_bufchan_r;
  \Word#_t  addr_wr_buf_buf;
  initial addr_wr_buf_buf = {{WORD_MSB{1'bx}}, 1'd0};
  assign addr_wr_buf_r = (! addr_wr_buf_buf[0]);
  assign addr_wr_buf_bufchan_d = (addr_wr_buf_buf[0] ? addr_wr_buf_buf :
                                  addr_wr_buf_d);
  always_ff @(posedge clk)
    if ((addr_wr_buf_bufchan_r && addr_wr_buf_buf[0]))
      addr_wr_buf_buf <= {{WORD_MSB{1'bx}}, 1'd0};
    else if (((! addr_wr_buf_bufchan_r) && (! addr_wr_buf_buf[0])))
      addr_wr_buf_buf <= addr_wr_buf_d;
  initial addr_wr_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign addr_wr_buf_bufchan_r = ((! addr_wr_d[0]) || addr_wr_r);
  always_ff @(posedge clk)
    if (addr_wr_buf_bufchan_r) addr_wr_d <= addr_wr_buf_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((addr_wr_d[0] && (! addr_wr_r)))
      $display("%5t blocked: addr_wr", $time);
  `endif
  
  /* buf (Ty Word#) : (addr_rd_buf,Word#) > (addr_rd,Word#) */
  \Word#_t  addr_rd_buf_bufchan_d;
  logic addr_rd_buf_bufchan_r;
  \Word#_t  addr_rd_buf_buf;
  initial addr_rd_buf_buf = {{WORD_MSB{1'bx}}, 1'd0};
  assign addr_rd_buf_r = (! addr_rd_buf_buf[0]);
  assign addr_rd_buf_bufchan_d = (addr_rd_buf_buf[0] ? addr_rd_buf_buf :
                                  addr_rd_buf_d);
  always_ff @(posedge clk)
    if ((addr_rd_buf_bufchan_r && addr_rd_buf_buf[0]))
      addr_rd_buf_buf <= {{WORD_MSB{1'bx}}, 1'd0};
    else if (((! addr_rd_buf_bufchan_r) && (! addr_rd_buf_buf[0])))
      addr_rd_buf_buf <= addr_rd_buf_d;
  initial addr_rd_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign addr_rd_buf_bufchan_r = ((! addr_rd_d[0]) || addr_rd_r);
  always_ff @(posedge clk)
    if (addr_rd_buf_bufchan_r) addr_rd_d <= addr_rd_buf_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((addr_rd_d[0] && (! addr_rd_r)))
      $display("%5t blocked: addr_rd", $time);
  `endif
  
  /* dcon (Ty Pointer,
      Dcon P) : [(addr_out,Word#)] > (ref_wait,Pointer) */
  assign ref_wait_d = P_dc((& {addr_out_d[0]}), addr_out_d);
  assign {addr_out_r} = {1 {(ref_wait_r && ref_wait_d[0])}};
  
  /* dcon (Ty Cmd,Dcon Write) : [(addr_wr,Word#),
                            (dat,Node)] > (cmd_wr,Cmd) */
  assign cmd_wr_d = Write_dc((& {addr_wr_d[0],
                                 dat_d[0]}), addr_wr_d, dat_d);
  assign {addr_wr_r, dat_r} = {2 {(cmd_wr_r && cmd_wr_d[0])}};
  
  /* dcon (Ty Cmd,Dcon Read) : [(addr_rd,Word#)] > (cmd_rd,Cmd) */
  assign cmd_rd_d = Read_dc((& {addr_rd_d[0]}), addr_rd_d);
  assign {addr_rd_r} = {1 {(cmd_rd_r && cmd_rd_d[0])}};
  
  /* mux (Ty S,Ty Cmd) : (sel,S) [(cmd_wr,Cmd),
                             (cmd_rd,Cmd)] > (cmd_out,Cmd) */
  logic [CMD_MSB:0] cmd_out_mux;
  logic [1:0] cmd_out_onehot;
  always_comb
    unique case (sel_d[1:1])
      1'd0: {cmd_out_onehot, cmd_out_mux} = {2'd1, cmd_wr_d};
      1'd1: {cmd_out_onehot, cmd_out_mux} = {2'd2, cmd_rd_d};
      default: {cmd_out_onehot, cmd_out_mux} = {2'bx, {{CMD_MSB{1'bx}}, 1'd0}};
    endcase
  assign cmd_out_d = {cmd_out_mux[CMD_MSB:1],
                      (cmd_out_mux[0] && sel_d[0])};
  assign sel_r = (cmd_out_d[0] && cmd_out_r);
  assign {cmd_rd_r, cmd_wr_r} = (sel_r ? cmd_out_onehot :
                                 2'd0);
  
  /* fork (Ty S) : (sel_out,S) > [(sel,S),(sel_loop,S),(sel_res,S)] */
  logic [2:0] sel_out_emitted;
  initial sel_out_emitted = 3'd0;
  logic [2:0] sel_out_done;
  assign sel_d = {sel_out_d[1:1],
                  (sel_out_d[0] && (! sel_out_emitted[0]))};
  assign sel_loop_d = {sel_out_d[1:1],
                       (sel_out_d[0] && (! sel_out_emitted[1]))};
  assign sel_res_d = {sel_out_d[1:1],
                      (sel_out_d[0] && (! sel_out_emitted[2]))};
  assign sel_out_done = (sel_out_emitted | ({sel_res_d[0],
                                             sel_loop_d[0],
                                             sel_d[0]} & {sel_res_r, sel_loop_r, sel_r}));
  assign sel_out_r = (& sel_out_done);
  always_ff @(posedge clk)
    sel_out_emitted <= (sel_out_r ? 3'd0 :
                        sel_out_done);
  
  /* buf (Ty S) : (sel_res,S) > (sel_res_buf,S) */
  S_t sel_res_bufchan_d;
  logic sel_res_bufchan_r;
  S_t sel_res_buf;
  initial sel_res_buf = {1'bx, 1'd0};
  assign sel_res_r = (! sel_res_buf[0]);
  assign sel_res_bufchan_d = (sel_res_buf[0] ? sel_res_buf :
                              sel_res_d);
  always_ff @(posedge clk)
    if ((sel_res_bufchan_r && sel_res_buf[0]))
      sel_res_buf <= {1'bx, 1'd0};
    else if (((! sel_res_bufchan_r) && (! sel_res_buf[0])))
      sel_res_buf <= sel_res_d;
  initial sel_res_buf_d = {1'bx, 1'd0};
  assign sel_res_bufchan_r = ((! sel_res_buf_d[0]) || sel_res_buf_r);
  always_ff @(posedge clk)
    if (sel_res_bufchan_r) sel_res_buf_d <= sel_res_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((sel_res_buf_d[0] && (! sel_res_buf_r)))
      $display("%5t blocked: sel_res_buf", $time);
  `endif
  
  /* initbuf (Ty S,Dcon O) : (sel_new_r,S) > (sel_out,S) */
  initial sel_out_d = O_dc(1'd1);
  assign sel_new_r_r = ((! sel_out_d[0]) || sel_out_r);
  always_ff @(posedge clk)
    if (sel_new_r_r) sel_out_d <= sel_new_r_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((sel_out_d[0] && (! sel_out_r)))
      $display("%5t blocked: sel_out", $time);
  `endif
  
  /* rbuf (Ty S) : (sel_new,S) > (sel_new_r,S) */
  S_t sel_new_buf;
  initial sel_new_buf = {1'bx, 1'd0};
  assign sel_new_r = (! sel_new_buf[0]);
  assign sel_new_r_d = (sel_new_buf[0] ? sel_new_buf :
                        sel_new_d);
  always_ff @(posedge clk)
    if ((sel_new_r_r && sel_new_buf[0])) sel_new_buf <= {1'bx, 1'd0};
    else if (((! sel_new_r_r) && (! sel_new_buf[0])))
      sel_new_buf <= sel_new_d;
  
  /* mux (Ty S,Ty S) : (sel_loop,S) [(sel_one,S),
                                (sel_zero,S)] > (sel_new,S) */
  logic [1:0] sel_new_mux;
  logic [1:0] sel_new_onehot;
  always_comb
    unique case (sel_loop_d[1:1])
      1'd0: {sel_new_onehot, sel_new_mux} = {2'd1, sel_one_d};
      1'd1: {sel_new_onehot, sel_new_mux} = {2'd2, sel_zero_d};
      default: {sel_new_onehot, sel_new_mux} = {2'bx, {1'bx, 1'd0}};
    endcase
  assign sel_new_d = {sel_new_mux[1:1],
                      (sel_new_mux[0] && sel_loop_d[0])};
  assign sel_loop_r = (sel_new_d[0] && sel_new_r);
  assign {sel_zero_r, sel_one_r} = (sel_loop_r ? sel_new_onehot :
                                    2'd0);
  
  /* fork (Ty S) : (sel_zero_out,S) > [(sel_zero,S),(sel_zero_loop,S)] */
  logic [1:0] sel_zero_out_emitted;
  initial sel_zero_out_emitted = 2'd0;
  logic [1:0] sel_zero_out_done;
  assign sel_zero_d = {sel_zero_out_d[1:1],
                       (sel_zero_out_d[0] && (! sel_zero_out_emitted[0]))};
  assign sel_zero_loop_d = {sel_zero_out_d[1:1],
                            (sel_zero_out_d[0] && (! sel_zero_out_emitted[1]))};
  assign sel_zero_out_done = (sel_zero_out_emitted | ({sel_zero_loop_d[0],
                                                       sel_zero_d[0]} & {sel_zero_loop_r,
                                                                         sel_zero_r}));
  assign sel_zero_out_r = (& sel_zero_out_done);
  always_ff @(posedge clk)
    sel_zero_out_emitted <= (sel_zero_out_r ? 2'd0 :
                             sel_zero_out_done);
  
  /* fork (Ty S) : (sel_one_out,S) > [(sel_one,S),(sel_one_loop,S)] */
  logic [1:0] sel_one_out_emitted;
  initial sel_one_out_emitted = 2'd0;
  logic [1:0] sel_one_out_done;
  assign sel_one_d = {sel_one_out_d[1:1],
                      (sel_one_out_d[0] && (! sel_one_out_emitted[0]))};
  assign sel_one_loop_d = {sel_one_out_d[1:1],
                           (sel_one_out_d[0] && (! sel_one_out_emitted[1]))};
  assign sel_one_out_done = (sel_one_out_emitted | ({sel_one_loop_d[0],
                                                     sel_one_d[0]} & {sel_one_loop_r, sel_one_r}));
  assign sel_one_out_r = (& sel_one_out_done);
  always_ff @(posedge clk)
    sel_one_out_emitted <= (sel_one_out_r ? 2'd0 :
                            sel_one_out_done);
  
  /* initbuf (Ty S,Dcon Z) : (sel_zero_r,S) > (sel_zero_out,S) */
  initial sel_zero_out_d = Z_dc(1'd1);
  assign sel_zero_r_r = ((! sel_zero_out_d[0]) || sel_zero_out_r);
  always_ff @(posedge clk)
    if (sel_zero_r_r) sel_zero_out_d <= sel_zero_r_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((sel_zero_out_d[0] && (! sel_zero_out_r)))
      $display("%5t blocked: sel_zero_out", $time);
  `endif
  
  /* rbuf (Ty S) : (sel_zero_loop,S) > (sel_zero_r,S) */
  S_t sel_zero_loop_buf;
  initial sel_zero_loop_buf = {1'bx, 1'd0};
  assign sel_zero_loop_r = (! sel_zero_loop_buf[0]);
  assign sel_zero_r_d = (sel_zero_loop_buf[0] ? sel_zero_loop_buf :
                         sel_zero_loop_d);
  always_ff @(posedge clk)
    if ((sel_zero_r_r && sel_zero_loop_buf[0]))
      sel_zero_loop_buf <= {1'bx, 1'd0};
    else if (((! sel_zero_r_r) && (! sel_zero_loop_buf[0])))
      sel_zero_loop_buf <= sel_zero_loop_d;
  
  /* initbuf (Ty S,Dcon O) : (sel_one_r,S) > (sel_one_out,S) */
  initial sel_one_out_d = O_dc(1'd1);
  assign sel_one_r_r = ((! sel_one_out_d[0]) || sel_one_out_r);
  always_ff @(posedge clk)
    if (sel_one_r_r) sel_one_out_d <= sel_one_r_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((sel_one_out_d[0] && (! sel_one_out_r)))
      $display("%5t blocked: sel_one_out", $time);
  `endif
  
  /* rbuf (Ty S) : (sel_one_loop,S) > (sel_one_r,S) */
  S_t sel_one_loop_buf;
  initial sel_one_loop_buf = {1'bx, 1'd0};
  assign sel_one_loop_r = (! sel_one_loop_buf[0]);
  assign sel_one_r_d = (sel_one_loop_buf[0] ? sel_one_loop_buf :
                        sel_one_loop_d);
  always_ff @(posedge clk)
    if ((sel_one_r_r && sel_one_loop_buf[0]))
      sel_one_loop_buf <= {1'bx, 1'd0};
    else if (((! sel_one_r_r) && (! sel_one_loop_buf[0])))
      sel_one_loop_buf <= sel_one_loop_d;
  
  /* sink (Ty Cmd) : (cmd_out,Cmd) > */
  assign {cmd_out_r, cmd_out_dout} = {cmd_out_rout, cmd_out_d};
  
  /* sink (Ty Pointer) : (ref_out,Pointer) > */
  assign {ref_out_r, ref_out_dout} = {ref_out_rout, ref_out_d};
  
  /* sink (Ty Node) : (nul_node,Node) > */
  assign {nul_node_r, nul_node_dout} = {nul_node_rout, nul_node_d};
  
  /* Lack-of-progress detector */
  `ifdef CHECK_PROGRESS
  logic [10:0] bufferedChannelValids;
  logic [10:0] bufferedChannelReadys;
  logic [10:0] last1BufferedChannelValids;
  logic [10:0] last1BufferedChannelReadys;
  logic [10:0] last2BufferedChannelValids;
  logic [10:0] last2BufferedChannelReadys;
  initial last1BufferedChannelValids = 11'd0;
  initial last1BufferedChannelReadys = 11'd0;
  initial last2BufferedChannelValids = 11'd1;
  initial last2BufferedChannelReadys = 11'd1;
  assign bufferedChannelValids = {init_addr_d[0],
                                  loop_addr_d[0],
                                  addr_wr_d[0],
                                  addr_rd_d[0],
                                  sel_res_buf_d[0],
                                  sel_out_d[0],
                                  sel_new_r_d[0],
                                  sel_zero_out_d[0],
                                  sel_zero_r_d[0],
                                  sel_one_out_d[0],
                                  sel_one_r_d[0]};
  assign bufferedChannelReadys = {init_addr_r,
                                  loop_addr_r,
                                  addr_wr_r,
                                  addr_rd_r,
                                  sel_res_buf_r,
                                  sel_out_r,
                                  sel_new_r_r,
                                  sel_zero_out_r,
                                  sel_zero_r_r,
                                  sel_one_out_r,
                                  sel_one_r_r};
  always_ff @(posedge clk)
    begin
      last1BufferedChannelValids <= bufferedChannelValids;
      last1BufferedChannelReadys <= bufferedChannelReadys;
      last2BufferedChannelValids <= last1BufferedChannelValids;
      last2BufferedChannelReadys <= last1BufferedChannelReadys;
      if (((((last2BufferedChannelValids == last1BufferedChannelValids) && (last1BufferedChannelValids == bufferedChannelValids)) && (last2BufferedChannelReadys == last1BufferedChannelReadys)) && (last1BufferedChannelReadys == bufferedChannelReadys)))
        begin
          $display("%6t no progress", $time);
          $display(" valids %b", last2BufferedChannelValids);
          $display(" readys %b", last2BufferedChannelReadys);
          $display(" valids %b", last1BufferedChannelValids);
          $display(" readys %b", last1BufferedChannelReadys);
          $display(" valids %b", bufferedChannelValids);
          $display(" readys %b", bufferedChannelReadys);
          if ((init_addr_d[0] && (! init_addr_r)))
            $display(" blocked init_addr");
          if ((loop_addr_d[0] && (! loop_addr_r)))
            $display(" blocked loop_addr");
          if ((addr_wr_d[0] && (! addr_wr_r))) $display(" blocked addr_wr");
          if ((addr_rd_d[0] && (! addr_rd_r))) $display(" blocked addr_rd");
          if ((sel_res_buf_d[0] && (! sel_res_buf_r)))
            $display(" blocked sel_res_buf");
          if ((sel_out_d[0] && (! sel_out_r))) $display(" blocked sel_out");
          if ((sel_new_r_d[0] && (! sel_new_r_r)))
            $display(" blocked sel_new_r");
          if ((sel_zero_out_d[0] && (! sel_zero_out_r)))
            $display(" blocked sel_zero_out");
          if ((sel_zero_r_d[0] && (! sel_zero_r_r)))
            $display(" blocked sel_zero_r");
          if ((sel_one_out_d[0] && (! sel_one_out_r)))
            $display(" blocked sel_one_out");
          if ((sel_one_r_d[0] && (! sel_one_r_r)))
            $display(" blocked sel_one_r");
          $finish();
        end
    end
  `endif
  /* Wake Node Reporting */
  `ifdef WAKE_REPORT
  /* wake ref_out:mux */
  /* wake addr_o:mux */
  /* wake init_addr:buf */
  /* wake loop_addr:buf */
  /* wake addr_wr:buf */
  /* wake addr_rd:buf */
  /* wake cmd_out:mux */
  /* wake sel_res_buf:buf */
  /* wake sel_out:initbuf */
  /* wake sel_new_r:rbuf */
  /* wake sel_new:mux */
  /* wake sel_zero_out:initbuf */
  /* wake sel_zero_r:rbuf */
  /* wake sel_one_out:initbuf */
  /* wake sel_one_r:rbuf */
  always_ff @(posedge clk)
    $display("wake %b", {ref_out_d[0],
                         addr_o_d[0],
                         (init_addr_d[0] || (init_addr_buf_d[0] || init_addr_buf_bufchan_d[0])),
                         (loop_addr_d[0] || (loop_addr_buf_d[0] || loop_addr_buf_bufchan_d[0])),
                         (addr_wr_d[0] || (addr_wr_buf_d[0] || addr_wr_buf_bufchan_d[0])),
                         (addr_rd_d[0] || (addr_rd_buf_d[0] || addr_rd_buf_bufchan_d[0])),
                         cmd_out_d[0],
                         (sel_res_buf_d[0] || (sel_res_d[0] || sel_res_bufchan_d[0])),
                         (sel_out_d[0] || sel_new_r_d[0]),
                         (sel_new_r_d[0] || sel_new_d[0]),
                         sel_new_d[0],
                         (sel_zero_out_d[0] || sel_zero_r_d[0]),
                         (sel_zero_r_d[0] || sel_zero_loop_d[0]),
                         (sel_one_out_d[0] || sel_one_r_d[0]),
                         (sel_one_r_d[0] || sel_one_loop_d[0])});
  `endif
endmodule
