typedef logic signed [4:0] \Int4#_t ;

typedef logic signed [8:0] \Int8#_t ;

typedef logic signed [16:0] \Int16#_t ;

typedef logic signed [12:0] \Int#_t ;

typedef logic [4:0] \Word4#_t ;

typedef logic [8:0] \Word8#_t ;

typedef logic [16:0] \Word16#_t ;

typedef logic [12:0] \Word#_t ;

typedef logic [3:0] C5_t;

function C5_t C1_5_dc (logic valid);
  begin
    C1_5_dc = 4'bx;
    C1_5_dc[0] = valid;
    C1_5_dc[3:1] = 3'd0;
  end
endfunction

function C5_t C2_5_dc (logic valid);
  begin
    C2_5_dc = 4'bx;
    C2_5_dc[0] = valid;
    C2_5_dc[3:1] = 3'd1;
  end
endfunction

function C5_t C3_5_dc (logic valid);
  begin
    C3_5_dc = 4'bx;
    C3_5_dc[0] = valid;
    C3_5_dc[3:1] = 3'd2;
  end
endfunction

function C5_t C4_5_dc (logic valid);
  begin
    C4_5_dc = 4'bx;
    C4_5_dc[0] = valid;
    C4_5_dc[3:1] = 3'd3;
  end
endfunction

function C5_t C5_5_dc (logic valid);
  begin
    C5_5_dc = 4'bx;
    C5_5_dc[0] = valid;
    C5_5_dc[3:1] = 3'd4;
  end
endfunction

typedef logic [1:0] C2_t;

function C2_t C1_2_dc (logic valid);
  begin
    C1_2_dc = 2'bx;
    C1_2_dc[0] = valid;
    C1_2_dc[1:1] = 1'd0;
  end
endfunction

function C2_t C2_2_dc (logic valid);
  begin
    C2_2_dc = 2'bx;
    C2_2_dc[0] = valid;
    C2_2_dc[1:1] = 1'd1;
  end
endfunction

typedef logic [2:0] C3_t;

function C3_t C1_3_dc (logic valid);
  begin
    C1_3_dc = 3'bx;
    C1_3_dc[0] = valid;
    C1_3_dc[2:1] = 2'd0;
  end
endfunction

function C3_t C2_3_dc (logic valid);
  begin
    C2_3_dc = 3'bx;
    C2_3_dc[0] = valid;
    C2_3_dc[2:1] = 2'd1;
  end
endfunction

function C3_t C3_3_dc (logic valid);
  begin
    C3_3_dc = 3'bx;
    C3_3_dc[0] = valid;
    C3_3_dc[2:1] = 2'd2;
  end
endfunction

typedef logic [0:0] Go_t;

function Go_t Go_dc (logic valid);
  begin
    Go_dc = 1'bx;
    Go_dc[0] = valid;
  end
endfunction

typedef logic [12:0] \Pointer_[]_Int_t ;

function \Pointer_[]_Int_t  \Pointer_[]_Int_dc  (logic valid, \Int#_t  z1);
  begin
    \Pointer_[]_Int_dc  = 13'bx;
    \Pointer_[]_Int_dc [0] = valid;
    \Pointer_[]_Int_dc [12:1] = z1[12:1];
  end
endfunction

typedef logic [24:0] \TupInt#___Pointer_[]_Int___Go_t ;

function \TupInt#___Pointer_[]_Int___Go_t  \TupInt#___Pointer_[]_Int___Go_dc  (logic valid, \Int#_t  z1, \Pointer_[]_Int_t  z2, Go_t z3);
  begin
    \TupInt#___Pointer_[]_Int___Go_dc  = 25'bx;
    \TupInt#___Pointer_[]_Int___Go_dc [0] = valid;
    \TupInt#___Pointer_[]_Int___Go_dc [12:1] = z1[12:1];
    \TupInt#___Pointer_[]_Int___Go_dc [24:13] = z2[12:1];
    ;
  end
endfunction

typedef logic [24:0] \TupPointer_[]_Int___Pointer_[]_Int___Go_t ;

function \TupPointer_[]_Int___Pointer_[]_Int___Go_t  \TupPointer_[]_Int___Pointer_[]_Int___Go_dc  (logic valid, \Pointer_[]_Int_t  z1, \Pointer_[]_Int_t  z2, Go_t z3);
  begin
    \TupPointer_[]_Int___Pointer_[]_Int___Go_dc  = 25'bx;
    \TupPointer_[]_Int___Pointer_[]_Int___Go_dc [0] = valid;
    \TupPointer_[]_Int___Pointer_[]_Int___Go_dc [12:1] = z1[12:1];
    \TupPointer_[]_Int___Pointer_[]_Int___Go_dc [24:13] = z2[12:1];
    ;
  end
endfunction

typedef logic [1:0] Bool_t;

function Bool_t False_dc (logic valid, Go_t z1);
  begin
    False_dc = 2'bx;
    False_dc[0] = valid;
    False_dc[1:1] = 1'd0;
    ;
  end
endfunction

function Bool_t True_dc (logic valid, Go_t z1);
  begin
    True_dc = 2'bx;
    True_dc[0] = valid;
    True_dc[1:1] = 1'd1;
    ;
  end
endfunction

typedef logic [1:0] TupGo___Bool_t;

function TupGo___Bool_t TupGo___Bool_dc (logic valid, Go_t z1, Bool_t z2);
  begin
    TupGo___Bool_dc = 2'bx;
    TupGo___Bool_dc[0] = valid;
    ;
    TupGo___Bool_dc[1:1] = z2[1:1];
  end
endfunction

typedef logic [12:0] Int_t;

function Int_t \I#_dc  (logic valid, \Int#_t  z1);
  begin
    \I#_dc  = 13'bx;
    \I#_dc [0] = valid;
    \I#_dc [12:1] = z1[12:1];
  end
endfunction

typedef logic [36:0] \TupInt___Int___Pointer_[]_Int___Go_t ;

function \TupInt___Int___Pointer_[]_Int___Go_t  \TupInt___Int___Pointer_[]_Int___Go_dc  (logic valid, Int_t z1, Int_t z2, \Pointer_[]_Int_t  z3, Go_t z4);
  begin
    \TupInt___Int___Pointer_[]_Int___Go_dc  = 37'bx;
    \TupInt___Int___Pointer_[]_Int___Go_dc [0] = valid;
    \TupInt___Int___Pointer_[]_Int___Go_dc [12:1] = z1[12:1];
    \TupInt___Int___Pointer_[]_Int___Go_dc [24:13] = z2[12:1];
    \TupInt___Int___Pointer_[]_Int___Go_dc [36:25] = z3[12:1];
    ;
  end
endfunction

typedef logic [12:0] Pointer_CTappend_Int_t;

function Pointer_CTappend_Int_t Pointer_CTappend_Int_dc (logic valid, \Int#_t  z1);
  begin
    Pointer_CTappend_Int_dc = 13'bx;
    Pointer_CTappend_Int_dc[0] = valid;
    Pointer_CTappend_Int_dc[12:1] = z1[12:1];
  end
endfunction

typedef logic [36:0] \TupPointer_[]_Int___Pointer_[]_Int___Pointer_CTappend_Int_t ;

function \TupPointer_[]_Int___Pointer_[]_Int___Pointer_CTappend_Int_t  \TupPointer_[]_Int___Pointer_[]_Int___Pointer_CTappend_Int_dc  (logic valid, \Pointer_[]_Int_t  z1, \Pointer_[]_Int_t  z2, Pointer_CTappend_Int_t z3);
  begin
    \TupPointer_[]_Int___Pointer_[]_Int___Pointer_CTappend_Int_dc  = 37'bx;
    \TupPointer_[]_Int___Pointer_[]_Int___Pointer_CTappend_Int_dc [0] = valid;
    \TupPointer_[]_Int___Pointer_[]_Int___Pointer_CTappend_Int_dc [12:1] = z1[12:1];
    \TupPointer_[]_Int___Pointer_[]_Int___Pointer_CTappend_Int_dc [24:13] = z2[12:1];
    \TupPointer_[]_Int___Pointer_[]_Int___Pointer_CTappend_Int_dc [36:25] = z3[12:1];
  end
endfunction

typedef logic [0:0] TupGo_t;

function TupGo_t TupGo_dc (logic valid, Go_t z1);
  begin
    TupGo_dc = 1'bx;
    TupGo_dc[0] = valid;
    ;
  end
endfunction

typedef logic [24:0] \TupInt#___Int#___Go_t ;

function \TupInt#___Int#___Go_t  \TupInt#___Int#___Go_dc  (logic valid, \Int#_t  z1, \Int#_t  z2, Go_t z3);
  begin
    \TupInt#___Int#___Go_dc  = 25'bx;
    \TupInt#___Int#___Go_dc [0] = valid;
    \TupInt#___Int#___Go_dc [12:1] = z1[12:1];
    \TupInt#___Int#___Go_dc [24:13] = z2[12:1];
    ;
  end
endfunction

typedef logic [24:0] \TupPointer_[]_Int___Pointer_CTappend_Int_t ;

function \TupPointer_[]_Int___Pointer_CTappend_Int_t  \TupPointer_[]_Int___Pointer_CTappend_Int_dc  (logic valid, \Pointer_[]_Int_t  z1, Pointer_CTappend_Int_t z2);
  begin
    \TupPointer_[]_Int___Pointer_CTappend_Int_dc  = 25'bx;
    \TupPointer_[]_Int___Pointer_CTappend_Int_dc [0] = valid;
    \TupPointer_[]_Int___Pointer_CTappend_Int_dc [12:1] = z1[12:1];
    \TupPointer_[]_Int___Pointer_CTappend_Int_dc [24:13] = z2[12:1];
  end
endfunction

typedef logic [1:0] MyBool_t;

function MyBool_t MyFalse_dc (logic valid, Go_t z1);
  begin
    MyFalse_dc = 2'bx;
    MyFalse_dc[0] = valid;
    MyFalse_dc[1:1] = 1'd0;
    ;
  end
endfunction

function MyBool_t MyTrue_dc (logic valid, Go_t z1);
  begin
    MyTrue_dc = 2'bx;
    MyTrue_dc[0] = valid;
    MyTrue_dc[1:1] = 1'd1;
    ;
  end
endfunction

typedef logic [25:0] CTappend_Int_t;

function CTappend_Int_t Lappend_Intsbos_dc (logic valid, Go_t z1);
  begin
    Lappend_Intsbos_dc = 26'bx;
    Lappend_Intsbos_dc[0] = valid;
    Lappend_Intsbos_dc[1:1] = 1'd0;
    ;
  end
endfunction

function CTappend_Int_t Lcall_append_Int0_dc (logic valid, Int_t z1, Pointer_CTappend_Int_t z2);
  begin
    Lcall_append_Int0_dc = 26'bx;
    Lcall_append_Int0_dc[0] = valid;
    Lcall_append_Int0_dc[1:1] = 1'd1;
    Lcall_append_Int0_dc[13:2] = z1[12:1];
    Lcall_append_Int0_dc[25:14] = z2[12:1];
  end
endfunction

typedef logic [25:0] \[]_Int_t ;

function \[]_Int_t  \[]_Int_dc  (logic valid, Go_t z1);
  begin
    \[]_Int_dc  = 26'bx;
    \[]_Int_dc [0] = valid;
    \[]_Int_dc [1:1] = 1'd0;
    ;
  end
endfunction

function \[]_Int_t  \:_Int_dc  (logic valid, Int_t z1, \Pointer_[]_Int_t  z2);
  begin
    \:_Int_dc  = 26'bx;
    \:_Int_dc [0] = valid;
    \:_Int_dc [1:1] = 1'd1;
    \:_Int_dc [13:2] = z1[12:1];
    \:_Int_dc [25:14] = z2[12:1];
  end
endfunction


typedef logic [1:0] Tog_t;

function Tog_t Zero_dc (logic valid, Go_t z1);
  begin
    Zero_dc = 2'bx;
    Zero_dc[0] = valid;
    Zero_dc[1:1] = 1'd0;
    ;
  end
endfunction

function Tog_t One_dc (logic valid, Go_t z1);
  begin
    One_dc = 2'bx;
    One_dc[0] = valid;
    One_dc[1:1] = 1'd1;
    ;
  end
endfunction

typedef logic [1:0] S_t;

function S_t Z_dc (logic valid);
  begin
    Z_dc = 2'bx;
    Z_dc[0] = valid;
    Z_dc[1:1] = 1'd0;
  end
endfunction

function S_t O_dc (logic valid);
  begin
    O_dc = 2'bx;
    O_dc[0] = valid;
    O_dc[1:1] = 1'd1;
  end
endfunction

typedef logic [1:0] Bool_mem_t;

function Bool_mem_t False_mem_dc (logic valid);
  begin
    False_mem_dc = 2'bx;
    False_mem_dc[0] = valid;
    False_mem_dc[1:1] = 1'd0;
  end
endfunction

function Bool_mem_t True_mem_dc (logic valid);
  begin
    True_mem_dc = 2'bx;
    True_mem_dc[0] = valid;
    True_mem_dc[1:1] = 1'd1;
  end
endfunction

typedef logic [2:0] Sel3_t;

function Sel3_t I30_dc (logic valid);
  begin
    I30_dc = 3'bx;
    I30_dc[0] = valid;
    I30_dc[2:1] = 2'd0;
  end
endfunction

function Sel3_t I31_dc (logic valid);
  begin
    I31_dc = 3'bx;
    I31_dc[0] = valid;
    I31_dc[2:1] = 2'd1;
  end
endfunction

function Sel3_t I32_dc (logic valid);
  begin
    I32_dc = 3'bx;
    I32_dc[0] = valid;
    I32_dc[2:1] = 2'd2;
  end
endfunction

typedef logic [1:0] Sel2_t;

function Sel2_t I20_dc (logic valid);
  begin
    I20_dc = 2'bx;
    I20_dc[0] = valid;
    I20_dc[1:1] = 1'd0;
  end
endfunction

function Sel2_t I21_dc (logic valid);
  begin
    I21_dc = 2'bx;
    I21_dc[0] = valid;
    I21_dc[1:1] = 1'd1;
  end
endfunction

typedef logic [2:0] Sel4_t;

function Sel4_t I40_dc (logic valid);
  begin
    I40_dc = 3'bx;
    I40_dc[0] = valid;
    I40_dc[2:1] = 2'd0;
  end
endfunction

function Sel4_t I41_dc (logic valid);
  begin
    I41_dc = 3'bx;
    I41_dc[0] = valid;
    I41_dc[2:1] = 2'd1;
  end
endfunction

function Sel4_t I42_dc (logic valid);
  begin
    I42_dc = 3'bx;
    I42_dc[0] = valid;
    I42_dc[2:1] = 2'd2;
  end
endfunction

function Sel4_t I43_dc (logic valid);
  begin
    I43_dc = 3'bx;
    I43_dc[0] = valid;
    I43_dc[2:1] = 2'd3;
  end
endfunction

typedef logic [12:0] Pointer_t;

function Pointer_t P_dc (logic valid, \Word#_t  z1);
  begin
    P_dc = 13'bx;
    P_dc[0] = valid;
    P_dc[12:1] = z1[12:1];
  end
endfunction

typedef logic [25:0] Node_t;

function Node_t Nul_dc (logic valid, Go_t z1);
  begin
    Nul_dc = 26'bx;
    Nul_dc[0] = valid;
    Nul_dc[1:1] = 1'd0;
    ;
  end
endfunction

function Node_t Nd_dc (logic valid, \Word#_t  z1, Pointer_t z2);
  begin
    Nd_dc = 26'bx;
    Nd_dc[0] = valid;
    Nd_dc[1:1] = 1'd1;
    Nd_dc[13:2] = z1[12:1];
    Nd_dc[25:14] = z2[12:1];
  end
endfunction

typedef logic [26:0] L3Node_t;

function L3Node_t L3Nul_dc (logic valid, Go_t z1);
  begin
    L3Nul_dc = 27'bx;
    L3Nul_dc[0] = valid;
    L3Nul_dc[2:1] = 2'd0;
    ;
  end
endfunction

function L3Node_t L3Nd1_dc (logic valid, \Word#_t  z1, Pointer_t z2);
  begin
    L3Nd1_dc = 27'bx;
    L3Nd1_dc[0] = valid;
    L3Nd1_dc[2:1] = 2'd1;
    L3Nd1_dc[14:3] = z1[12:1];
    L3Nd1_dc[26:15] = z2[12:1];
  end
endfunction

function L3Node_t L3Nd0_dc (logic valid, \Word#_t  z1, Pointer_t z2);
  begin
    L3Nd0_dc = 27'bx;
    L3Nd0_dc[0] = valid;
    L3Nd0_dc[2:1] = 2'd2;
    L3Nd0_dc[14:3] = z1[12:1];
    L3Nd0_dc[26:15] = z2[12:1];
  end
endfunction

typedef logic [13:0] Root_t;

function Root_t YesRef_dc (logic valid, Pointer_t z1);
  begin
    YesRef_dc = 14'bx;
    YesRef_dc[0] = valid;
    YesRef_dc[1:1] = 1'd0;
    YesRef_dc[13:2] = z1[12:1];
  end
endfunction

function Root_t NoRef_dc (logic valid);
  begin
    NoRef_dc = 14'bx;
    NoRef_dc[0] = valid;
    NoRef_dc[1:1] = 1'd1;
  end
endfunction

typedef logic [38:0] Cmd_t;

function Cmd_t Read_dc (logic valid, \Word#_t  z1);
  begin
    Read_dc = 39'bx;
    Read_dc[0] = valid;
    Read_dc[1:1] = 1'd0;
    Read_dc[13:2] = z1[12:1];
  end
endfunction

function Cmd_t Write_dc (logic valid, \Word#_t  z1, Node_t z2);
  begin
    Write_dc = 39'bx;
    Write_dc[0] = valid;
    Write_dc[1:1] = 1'd1;
    Write_dc[13:2] = z1[12:1];
    Write_dc[38:14] = z2[25:1];
  end
endfunction

typedef logic [26:0] Res_t;

function Res_t Data_dc (logic valid, Node_t z1);
  begin
    Data_dc = 27'bx;
    Data_dc[0] = valid;
    Data_dc[1:1] = 1'd0;
    Data_dc[26:2] = z1[25:1];
  end
endfunction

function Res_t Written_dc (logic valid);
  begin
    Written_dc = 27'bx;
    Written_dc[0] = valid;
    Written_dc[1:1] = 1'd1;
  end
endfunction

typedef logic [39:0] L3Cmd_t;

function L3Cmd_t L3Read_dc (logic valid, \Word#_t  z1);
  begin
    L3Read_dc = 40'bx;
    L3Read_dc[0] = valid;
    L3Read_dc[1:1] = 1'd0;
    L3Read_dc[13:2] = z1[12:1];
  end
endfunction

function L3Cmd_t L3Write_dc (logic valid, \Word#_t  z1, L3Node_t z2);
  begin
    L3Write_dc = 40'bx;
    L3Write_dc[0] = valid;
    L3Write_dc[1:1] = 1'd1;
    L3Write_dc[13:2] = z1[12:1];
    L3Write_dc[39:14] = z2[26:1];
  end
endfunction

typedef logic [27:0] L3Res_t;

function L3Res_t L3Data_dc (logic valid, L3Node_t z1);
  begin
    L3Data_dc = 28'bx;
    L3Data_dc[0] = valid;
    L3Data_dc[1:1] = 1'd0;
    L3Data_dc[27:2] = z1[26:1];
  end
endfunction

function L3Res_t L3Written_dc (logic valid);
  begin
    L3Written_dc = 28'bx;
    L3Written_dc[0] = valid;
    L3Written_dc[1:1] = 1'd1;
  end
endfunction

typedef logic [14:0] GC_Cmd_t;

function GC_Cmd_t Mark_dc (logic valid, Pointer_t z1);
  begin
    Mark_dc = 15'bx;
    Mark_dc[0] = valid;
    Mark_dc[2:1] = 2'd0;
    Mark_dc[14:3] = z1[12:1];
  end
endfunction

function GC_Cmd_t Sweep_dc (logic valid, Pointer_t z1);
  begin
    Sweep_dc = 15'bx;
    Sweep_dc[0] = valid;
    Sweep_dc[2:1] = 2'd1;
    Sweep_dc[14:3] = z1[12:1];
  end
endfunction

function GC_Cmd_t Freelist_dc (logic valid, Pointer_t z1);
  begin
    Freelist_dc = 15'bx;
    Freelist_dc[0] = valid;
    Freelist_dc[2:1] = 2'd2;
    Freelist_dc[14:3] = z1[12:1];
  end
endfunction

typedef logic [15:0] GC_Res_t;

function GC_Res_t Marked_dc (logic valid, Go_t z1);
  begin
    Marked_dc = 16'bx;
    Marked_dc[0] = valid;
    Marked_dc[3:1] = 3'd0;
    ;
  end
endfunction

function GC_Res_t NoChild_dc (logic valid, Go_t z1);
  begin
    NoChild_dc = 16'bx;
    NoChild_dc[0] = valid;
    NoChild_dc[3:1] = 3'd1;
    ;
  end
endfunction

function GC_Res_t OneChild_dc (logic valid, Pointer_t z1);
  begin
    OneChild_dc = 16'bx;
    OneChild_dc[0] = valid;
    OneChild_dc[3:1] = 3'd2;
    OneChild_dc[15:4] = z1[12:1];
  end
endfunction

function GC_Res_t Freed_dc (logic valid, Go_t z1);
  begin
    Freed_dc = 16'bx;
    Freed_dc[0] = valid;
    Freed_dc[3:1] = 3'd3;
    ;
  end
endfunction

function GC_Res_t Removed_dc (logic valid, Go_t z1);
  begin
    Removed_dc = 16'bx;
    Removed_dc[0] = valid;
    Removed_dc[3:1] = 3'd4;
    ;
  end
endfunction

function GC_Res_t AlreadyFree_dc (logic valid, Go_t z1);
  begin
    AlreadyFree_dc = 16'bx;
    AlreadyFree_dc[0] = valid;
    AlreadyFree_dc[3:1] = 3'd5;
    ;
  end
endfunction

typedef logic [2:0] Marked_t;

function Marked_t FL_dc (logic valid, Go_t z1);
  begin
    FL_dc = 3'bx;
    FL_dc[0] = valid;
    FL_dc[2:1] = 2'd0;
    ;
  end
endfunction

function Marked_t F_dc (logic valid, Go_t z1);
  begin
    F_dc = 3'bx;
    F_dc[0] = valid;
    F_dc[2:1] = 2'd1;
    ;
  end
endfunction

function Marked_t T_dc (logic valid, Go_t z1);
  begin
    T_dc = 3'bx;
    T_dc[0] = valid;
    T_dc[2:1] = 2'd2;
    ;
  end
endfunction

typedef logic [15:0] Map_Cmd_t;

function Map_Cmd_t MRead_dc (logic valid, \Word#_t  z1);
  begin
    MRead_dc = 16'bx;
    MRead_dc[0] = valid;
    MRead_dc[1:1] = 1'd0;
    MRead_dc[13:2] = z1[12:1];
  end
endfunction

function Map_Cmd_t MWrite_dc (logic valid, \Word#_t  z1, Marked_t z2);
  begin
    MWrite_dc = 16'bx;
    MWrite_dc[0] = valid;
    MWrite_dc[1:1] = 1'd1;
    MWrite_dc[13:2] = z1[12:1];
    MWrite_dc[15:14] = z2[2:1];
  end
endfunction

typedef logic [3:0] Map_Res_t;

function Map_Res_t MData_dc (logic valid, Marked_t z1);
  begin
    MData_dc = 4'bx;
    MData_dc[0] = valid;
    MData_dc[1:1] = 1'd0;
    MData_dc[3:2] = z1[2:1];
  end
endfunction

function Map_Res_t MWritten_dc (logic valid);
  begin
    MWritten_dc = 4'bx;
    MWritten_dc[0] = valid;
    MWritten_dc[1:1] = 1'd1;
  end
endfunction

typedef logic [12:0] ResetSweep_t;

function ResetSweep_t RS_dc (logic valid, \Word#_t  z1, Go_t z2);
  begin
    RS_dc = 13'bx;
    RS_dc[0] = valid;
    RS_dc[12:1] = z1[12:1];
    ;
  end
endfunction

typedef logic [2:0] Raise_Err_t;

function Raise_Err_t SC_dc (logic valid, Go_t z1);
  begin
    SC_dc = 3'bx;
    SC_dc[0] = valid;
    SC_dc[2:1] = 2'd0;
    ;
  end
endfunction

function Raise_Err_t GC_D_dc (logic valid, Go_t z1);
  begin
    GC_D_dc = 3'bx;
    GC_D_dc[0] = valid;
    GC_D_dc[2:1] = 2'd1;
    ;
  end
endfunction

function Raise_Err_t RC_dc (logic valid, Go_t z1);
  begin
    RC_dc = 3'bx;
    RC_dc[0] = valid;
    RC_dc[2:1] = 2'd2;
    ;
  end
endfunction

