module SweepCtrl(
  input logic clk,
  input \Word#_t  base_d,
  output logic base_r,
  input \Word#_t  bound_d,
  output logic bound_r,
  input Go_t start_d,
  output logic start_r,
  input GC_Res_t res_d,
  output logic res_r,
  output GC_Cmd_t cmd_dout,
  input logic cmd_rout,
  output Go_t end_sweep_dout,
  input logic end_sweep_rout,
  output Go_t freed_dout,
  input logic freed_rout,
  output Raise_Err_t sweep_error_dout,
  input logic sweep_error_rout
  );
  /* --define=INPUTS=((base, 16, 65536, Word__023), (bound, 16, 65536, Word__023), (start, 0, 1, Go), (res, 19, 524288, GC_Res)) */
  /* --define=TAPS=() */
  /* --define=OUTPUTS=((cmd, 18, 262144, GC_Cmd), (end_sweep, 0, 1, Go), (freed, 0, 1, Go), (sweep_error, 2, 3, Raise_Err)) */
  /* TYPE_START
TYPE_END */
  /*  */
  /*  */

   parameter POINTER_BITS = 17;
   parameter NODE_BITS = 34;

   parameter WORD_MSB = POINTER_BITS-1; //16;
   parameter GC_RES_MSB = POINTER_BITS+2; //19;

  \Word#_t  base0_d;
  logic base0_r;
  \Word#_t  base1_d;
  logic base1_r;
  \Word#_t  bound0_d;
  logic bound0_r;
  \Word#_t  bound1_d;
  logic bound1_r;
  \Word#_t  base_bound_d;
  logic base_bound_r;
  \Word#_t  bb_merge_d;
  logic bb_merge_r;
  \Word#_t  bb_gen_d;
  logic bb_gen_r;
  \Word#_t  bb_res_d;
  logic bb_res_r;
  \Word#_t  bb_keep_d;
  logic bb_keep_r;
  \Word#_t  bb_buf_d;
  logic bb_buf_r;
  \Word#_t  reset_d;
  logic reset_r;
  \Word#_t  reset_gate_d;
  logic reset_gate_r;
  \Word#_t  gen_update_d;
  logic gen_update_r;
  \Word#_t  count_d;
  logic count_r;
  \Word#_t  old_count_d;
  logic old_count_r;
  \Word#_t  count_rbuf_d;
  logic count_rbuf_r;
  \Word#_t  count_buf_d;
  logic count_buf_r;
  \Word#_t  count_eq_d;
  logic count_eq_r;
  \Word#_t  count_cmd_d;
  logic count_cmd_r;
  \Word#_t  bound_merge_d;
  logic bound_merge_r;
  \Word#_t  bound_use_d;
  logic bound_use_r;
  \Word#_t  bound_keep_d;
  logic bound_keep_r;
  \Word#_t  bound_buf_d;
  logic bound_buf_r;
  Bool_mem_t eq_bound_d;
  logic eq_bound_r;
  \Word#_t  gen_false_d;
  logic gen_false_r;
  \Word#_t  gen_true_d;
  logic gen_true_r;
  \Word#_t  gen_true_buf_d;
  logic gen_true_buf_r;
  \Word#_t  gen_one_d;
  logic gen_one_r;
  \Word#_t  gen_cmd_d;
  logic gen_cmd_r;
  Go_t one_go_d;
  logic one_go_r;
  Go_t one_buf_d;
  logic one_buf_r;
  \Word#_t  one_d;
  logic one_r;
  Pointer_t cmd_ref_d;
  logic cmd_ref_r;
  GC_Cmd_t cmd_d;
  logic cmd_r;
  ResetSweep_t reset_sweep_d;
  logic reset_sweep_r;
  Go_t reset_go_d;
  logic reset_go_r;
  \Word#_t  gen_sub_d;
  logic gen_sub_r;
  Go_t res_reset_d;
  logic res_reset_r;
  \Word#_t  res_gate_d;
  logic res_gate_r;
  \Word#_t  update_res_d;
  logic update_res_r;
  \Word#_t  res_in_d;
  logic res_in_r;
  Go_t res_go_d;
  logic res_go_r;
  \Word#_t  new_res_d;
  logic new_res_r;
  \Word#_t  old_res_d;
  logic old_res_r;
  \Word#_t  res_buf_d;
  logic res_buf_r;
  \Word#_t  res_keep_d;
  logic res_keep_r;
  \Word#_t  res_comp_d;
  logic res_comp_r;
  Bool_mem_t eq_zero_d;
  logic eq_zero_r;
  \Word#_t  zero_d;
  logic zero_r;
  Bool_mem_t zero_choose_d;
  logic zero_choose_r;
  Bool_mem_t zero_in_d;
  logic zero_in_r;
  Bool_mem_t zero_keep_d;
  logic zero_keep_r;
  Bool_mem_t zero_buf2_d;
  logic zero_buf2_r;
  Go_t zero_go_rbuf_d;
  logic zero_go_rbuf_r;
  Go_t zero_go_buf_d;
  logic zero_go_buf_r;
  Go_t zero_go_d;
  logic zero_go_r;
  Bool_mem_t _2_d;
  logic _2_r;
  assign _2_r = 1'd1;
  Bool_mem_t res_done_d;
  logic res_done_r;
  Bool_mem_t res_done_buf_d;
  logic res_done_buf_r;
  Go_t res_done_go_d;
  logic res_done_go_r;
  Go_t end_sweep_d;
  logic end_sweep_r;
  Go_t res_reset_go_d;
  logic res_reset_go_r;
  Go_t sweep_reset_go_d;
  logic sweep_reset_go_r;
  GC_Res_t res_count_d;
  logic res_count_r;
  GC_Res_t res_freed_d;
  logic res_freed_r;
  GC_Res_t res_choose_d;
  logic res_choose_r;
  GC_Res_t _1_d;
  logic _1_r;
  assign _1_r = 1'd1;
  GC_Res_t er2_d;
  logic er2_r;
  GC_Res_t er3_d;
  logic er3_r;
  GC_Res_t freed_go_d;
  logic freed_go_r;
  GC_Res_t er4_d;
  logic er4_r;
  GC_Res_t _0_d;
  logic _0_r;
  assign _0_r = 1'd1;
  Go_t freed_d;
  logic freed_r;
  Go_t er2_go_d;
  logic er2_go_r;
  Go_t er3_go_d;
  logic er3_go_r;
  Go_t er4_go_d;
  logic er4_go_r;
  Go_t all_errors_d;
  logic all_errors_r;
  Raise_Err_t sweep_error_d;
  logic sweep_error_r;
  
  /* source (Ty Word#) : > (base,Word#) */
  
  /* source (Ty Word#) : > (bound,Word#) */
  
  /* source (Ty Go) : > (start,Go) */
  
  /* source (Ty GC_Res) : > (res,GC_Res) */
  
  /* fork (Ty Word#) : (base,Word#) > [(base0,Word#),
                                      (base1,Word#)] */
  logic [1:0] base_emitted;
  initial base_emitted = 2'd0;
  logic [1:0] base_done;
  assign base0_d = {base_d[WORD_MSB:1],
                    (base_d[0] && (! base_emitted[0]))};
  assign base1_d = {base_d[WORD_MSB:1],
                    (base_d[0] && (! base_emitted[1]))};
  assign base_done = (base_emitted | ({base1_d[0],
                                       base0_d[0]} & {base1_r, base0_r}));
  assign base_r = (& base_done);
  always_ff @(posedge clk)
    base_emitted <= (base_r ? 2'd0 :
                     base_done);
  
  /* fork (Ty Word#) : (bound,Word#) > [(bound0,Word#),
                                       (bound1,Word#)] */
  logic [1:0] bound_emitted;
  initial bound_emitted = 2'd0;
  logic [1:0] bound_done;
  assign bound0_d = {bound_d[WORD_MSB:1],
                     (bound_d[0] && (! bound_emitted[0]))};
  assign bound1_d = {bound_d[WORD_MSB:1],
                     (bound_d[0] && (! bound_emitted[1]))};
  assign bound_done = (bound_emitted | ({bound1_d[0],
                                         bound0_d[0]} & {bound1_r, bound0_r}));
  assign bound_r = (& bound_done);
  always_ff @(posedge clk)
    bound_emitted <= (bound_r ? 2'd0 :
                      bound_done);
  
  /* op_sub (Ty Word#) : (base1,Word#) (bound1,Word#) > (base_bound,Word#) */
  assign base_bound_d = {(signed'(base1_d[WORD_MSB:1]) - signed'(bound1_d[WORD_MSB:1])),
                         (base1_d[0] && bound1_d[0])};
  assign {base1_r,
          bound1_r} = {2 {(base_bound_r && base_bound_d[0])}};
  
  /* merge (Ty Word#) : [(base_bound,Word#),
                      (bb_buf,Word#)] > (bb_merge,Word#) */
  logic [1:0] bb_merge_selected;
  logic [1:0] bb_merge_select;
  initial bb_merge_select = 2'd0;
  always_comb
    begin
      bb_merge_selected = 2'd0;
      if ((| bb_merge_select)) bb_merge_selected = bb_merge_select;
      else
        if (base_bound_d[0]) bb_merge_selected[0] = 1'd1;
        else if (bb_buf_d[0]) bb_merge_selected[1] = 1'd1;
    end
  always_ff @(posedge clk)
    bb_merge_select <= (bb_merge_r ? 2'd0 :
                        bb_merge_selected);
  always_comb
    if (bb_merge_selected[0]) bb_merge_d = base_bound_d;
    else if (bb_merge_selected[1]) bb_merge_d = bb_buf_d;
    else bb_merge_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign {bb_buf_r, base_bound_r} = (bb_merge_r ? bb_merge_selected :
                                     2'd0);
  
  /* fork (Ty Word#) : (bb_merge,Word#) > [(bb_gen,Word#),
                                          (bb_res,Word#),
                                          (bb_keep,Word#)] */
  logic [2:0] bb_merge_emitted;
  initial bb_merge_emitted = 3'd0;
  logic [2:0] bb_merge_done;
  assign bb_gen_d = {bb_merge_d[WORD_MSB:1],
                     (bb_merge_d[0] && (! bb_merge_emitted[0]))};
  assign bb_res_d = {bb_merge_d[WORD_MSB:1],
                     (bb_merge_d[0] && (! bb_merge_emitted[1]))};
  assign bb_keep_d = {bb_merge_d[WORD_MSB:1],
                      (bb_merge_d[0] && (! bb_merge_emitted[2]))};
  assign bb_merge_done = (bb_merge_emitted | ({bb_keep_d[0],
                                               bb_res_d[0],
                                               bb_gen_d[0]} & {bb_keep_r, bb_res_r, bb_gen_r}));
  assign bb_merge_r = (& bb_merge_done);
  always_ff @(posedge clk)
    bb_merge_emitted <= (bb_merge_r ? 3'd0 :
                         bb_merge_done);
  
  /* buf (Ty Word#) : (bb_keep,Word#) > (bb_buf,Word#) */
  \Word#_t  bb_keep_bufchan_d;
  logic bb_keep_bufchan_r;
  \Word#_t  bb_keep_buf;
  initial bb_keep_buf = {{WORD_MSB{1'bx}}, 1'd0};
  assign bb_keep_r = (! bb_keep_buf[0]);
  assign bb_keep_bufchan_d = (bb_keep_buf[0] ? bb_keep_buf :
                              bb_keep_d);
  always_ff @(posedge clk)
    if ((bb_keep_bufchan_r && bb_keep_buf[0]))
      bb_keep_buf <= {{WORD_MSB{1'bx}}, 1'd0};
    else if (((! bb_keep_bufchan_r) && (! bb_keep_buf[0])))
      bb_keep_buf <= bb_keep_d;
  initial bb_buf_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign bb_keep_bufchan_r = ((! bb_buf_d[0]) || bb_buf_r);
  always_ff @(posedge clk)
    if (bb_keep_bufchan_r) bb_buf_d <= bb_keep_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((bb_buf_d[0] && (! bb_buf_r)))
      $display("%5t blocked: bb_buf", $time);
  `endif
  
  /* merge (Ty Word#) : [(base0,Word#),
                      (gen_sub,Word#)] > (reset,Word#) */
  logic [1:0] reset_selected;
  logic [1:0] reset_select;
  initial reset_select = 2'd0;
  always_comb
    begin
      reset_selected = 2'd0;
      if ((| reset_select)) reset_selected = reset_select;
      else
        if (base0_d[0]) reset_selected[0] = 1'd1;
        else if (gen_sub_d[0]) reset_selected[1] = 1'd1;
    end
  always_ff @(posedge clk)
    reset_select <= (reset_r ? 2'd0 :
                     reset_selected);
  always_comb
    if (reset_selected[0]) reset_d = base0_d;
    else if (reset_selected[1]) reset_d = gen_sub_d;
    else reset_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign {gen_sub_r, base0_r} = (reset_r ? reset_selected :
                                 2'd0);
  
  /* mux (Ty Go,
     Ty Word#) : (start,Go) [(reset,Word#)] > (reset_gate,Word#) */
  assign reset_gate_d = {reset_d[WORD_MSB:1], (start_d[0] && reset_d[0])};
  assign reset_r = (reset_gate_r && (start_d[0] && reset_d[0]));
  assign start_r = (reset_gate_r && (start_d[0] && reset_d[0]));
  
  /* merge (Ty Word#) : [(reset_gate,Word#),
                      (one,Word#)] > (gen_update,Word#) */
  logic [1:0] gen_update_selected;
  logic [1:0] gen_update_select;
  initial gen_update_select = 2'd0;
  always_comb
    begin
      gen_update_selected = 2'd0;
      if ((| gen_update_select)) gen_update_selected = gen_update_select;
      else
        if (reset_gate_d[0]) gen_update_selected[0] = 1'd1;
        else if (one_d[0]) gen_update_selected[1] = 1'd1;
    end
  always_ff @(posedge clk)
    gen_update_select <= (gen_update_r ? 2'd0 :
                          gen_update_selected);
  always_comb
    if (gen_update_selected[0]) gen_update_d = reset_gate_d;
    else if (gen_update_selected[1]) gen_update_d = one_d;
    else gen_update_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign {one_r,
          reset_gate_r} = (gen_update_r ? gen_update_selected :
                           2'd0);
  
  /* op_add (Ty Word#) : (gen_update,Word#) (old_count,Word#) > (count,Word#) */
  assign count_d = {(signed'(gen_update_d[WORD_MSB:1]) + signed'(old_count_d[WORD_MSB:1])),
                    (gen_update_d[0] && old_count_d[0])};
  assign {gen_update_r, old_count_r} = {2 {(count_r && count_d[0])}};
  
  /* initibuf (Ty Word#,
          Lit 0) : (count_rbuf,Word#) > (old_count,Word#) */
  initial old_count_d = {{WORD_MSB{1'd0}}, 1'd1};
  assign count_rbuf_r = ((! old_count_d[0]) || old_count_r);
  always_ff @(posedge clk)
    if (count_rbuf_r) old_count_d <= count_rbuf_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((old_count_d[0] && (! old_count_r)))
      $display("%5t blocked: old_count", $time);
  `endif
  
  /* rbuf (Ty Word#) : (count_buf,Word#) > (count_rbuf,Word#) */
  \Word#_t  count_buf_buf;
  initial count_buf_buf = {{WORD_MSB{1'bx}}, 1'd0};
  assign count_buf_r = (! count_buf_buf[0]);
  assign count_rbuf_d = (count_buf_buf[0] ? count_buf_buf :
                         count_buf_d);
  always_ff @(posedge clk)
    if ((count_rbuf_r && count_buf_buf[0]))
      count_buf_buf <= {{WORD_MSB{1'bx}}, 1'd0};
    else if (((! count_rbuf_r) && (! count_buf_buf[0])))
      count_buf_buf <= count_buf_d;
  
  /* fork (Ty Word#) : (count,Word#) > [(count_buf,Word#),
                                       (count_eq,Word#),
                                       (count_cmd,Word#)] */
  logic [2:0] count_emitted;
  initial count_emitted = 3'd0;
  logic [2:0] count_done;
  assign count_buf_d = {count_d[WORD_MSB:1],
                        (count_d[0] && (! count_emitted[0]))};
  assign count_eq_d = {count_d[WORD_MSB:1],
                       (count_d[0] && (! count_emitted[1]))};
  assign count_cmd_d = {count_d[WORD_MSB:1],
                        (count_d[0] && (! count_emitted[2]))};
  assign count_done = (count_emitted | ({count_cmd_d[0],
                                         count_eq_d[0],
                                         count_buf_d[0]} & {count_cmd_r, count_eq_r, count_buf_r}));
  assign count_r = (& count_done);
  always_ff @(posedge clk)
    count_emitted <= (count_r ? 3'd0 :
                      count_done);
  
  /* merge (Ty Word#) : [(bound0,Word#),
                      (bound_buf,Word#)] > (bound_merge,Word#) */
  logic [1:0] bound_merge_selected;
  logic [1:0] bound_merge_select;
  initial bound_merge_select = 2'd0;
  always_comb
    begin
      bound_merge_selected = 2'd0;
      if ((| bound_merge_select))
        bound_merge_selected = bound_merge_select;
      else
        if (bound0_d[0]) bound_merge_selected[0] = 1'd1;
        else if (bound_buf_d[0]) bound_merge_selected[1] = 1'd1;
    end
  always_ff @(posedge clk)
    bound_merge_select <= (bound_merge_r ? 2'd0 :
                           bound_merge_selected);
  always_comb
    if (bound_merge_selected[0]) bound_merge_d = bound0_d;
    else if (bound_merge_selected[1]) bound_merge_d = bound_buf_d;
    else bound_merge_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign {bound_buf_r,
          bound0_r} = (bound_merge_r ? bound_merge_selected :
                       2'd0);
  
  /* fork (Ty Word#) : (bound_merge,Word#) > [(bound_use,Word#),
                                             (bound_keep,Word#)] */
  logic [1:0] bound_merge_emitted;
  initial bound_merge_emitted = 2'd0;
  logic [1:0] bound_merge_done;
  assign bound_use_d = {bound_merge_d[WORD_MSB:1],
                        (bound_merge_d[0] && (! bound_merge_emitted[0]))};
  assign bound_keep_d = {bound_merge_d[WORD_MSB:1],
                         (bound_merge_d[0] && (! bound_merge_emitted[1]))};
  assign bound_merge_done = (bound_merge_emitted | ({bound_keep_d[0],
                                                     bound_use_d[0]} & {bound_keep_r,
                                                                        bound_use_r}));
  assign bound_merge_r = (& bound_merge_done);
  always_ff @(posedge clk)
    bound_merge_emitted <= (bound_merge_r ? 2'd0 :
                            bound_merge_done);
  
  /* buf (Ty Word#) : (bound_keep,Word#) > (bound_buf,Word#) */
  \Word#_t  bound_keep_bufchan_d;
  logic bound_keep_bufchan_r;
  \Word#_t  bound_keep_buf;
  initial bound_keep_buf = {{WORD_MSB{1'bx}}, 1'd0};
  assign bound_keep_r = (! bound_keep_buf[0]);
  assign bound_keep_bufchan_d = (bound_keep_buf[0] ? bound_keep_buf :
                                 bound_keep_d);
  always_ff @(posedge clk)
    if ((bound_keep_bufchan_r && bound_keep_buf[0]))
      bound_keep_buf <= {{WORD_MSB{1'bx}}, 1'd0};
    else if (((! bound_keep_bufchan_r) && (! bound_keep_buf[0])))
      bound_keep_buf <= bound_keep_d;
  initial bound_buf_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign bound_keep_bufchan_r = ((! bound_buf_d[0]) || bound_buf_r);
  always_ff @(posedge clk)
    if (bound_keep_bufchan_r) bound_buf_d <= bound_keep_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((bound_buf_d[0] && (! bound_buf_r)))
      $display("%5t blocked: bound_buf", $time);
  `endif
  
  /* op_eq (Ty Word#) : (bound_use,Word#) (count_eq,Word#) > (eq_bound,Bool_mem) */
  assign eq_bound_d = {(signed'(bound_use_d[WORD_MSB:1]) == signed'(count_eq_d[WORD_MSB:1])),
                       (bound_use_d[0] && count_eq_d[0])};
  assign {bound_use_r,
          count_eq_r} = {2 {(eq_bound_r && eq_bound_d[0])}};
  
  /* demux (Ty Bool_mem,
       Ty Word#) : (eq_bound,Bool_mem) (count_cmd,Word#) > [(gen_false,Word#),
                                                            (gen_true,Word#)] */
  logic [1:0] count_cmd_onehotd;
  always_comb
    if ((eq_bound_d[0] && count_cmd_d[0]))
      unique case (eq_bound_d[1:1])
        1'd0: count_cmd_onehotd = 2'd1;
        1'd1: count_cmd_onehotd = 2'd2;
        default: count_cmd_onehotd = 2'bx;
      endcase
    else count_cmd_onehotd = 2'd0;
  assign gen_false_d = {count_cmd_d[WORD_MSB:1], count_cmd_onehotd[0]};
  assign gen_true_d = {count_cmd_d[WORD_MSB:1], count_cmd_onehotd[1]};
  assign count_cmd_r = (| (count_cmd_onehotd & {gen_true_r,
                                                gen_false_r}));
  assign eq_bound_r = count_cmd_r;
  
  /* buf (Ty Word#) : (gen_true,Word#) > (gen_true_buf,Word#) */
  \Word#_t  gen_true_bufchan_d;
  logic gen_true_bufchan_r;
  \Word#_t  gen_true_buf;
  initial gen_true_buf = {{WORD_MSB{1'bx}}, 1'd0};
  assign gen_true_r = (! gen_true_buf[0]);
  assign gen_true_bufchan_d = (gen_true_buf[0] ? gen_true_buf :
                               gen_true_d);
  always_ff @(posedge clk)
    if ((gen_true_bufchan_r && gen_true_buf[0]))
      gen_true_buf <= {{WORD_MSB{1'bx}}, 1'd0};
    else if (((! gen_true_bufchan_r) && (! gen_true_buf[0])))
      gen_true_buf <= gen_true_d;
  initial gen_true_buf_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign gen_true_bufchan_r = ((! gen_true_buf_d[0]) || gen_true_buf_r);
  always_ff @(posedge clk)
    if (gen_true_bufchan_r) gen_true_buf_d <= gen_true_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((gen_true_buf_d[0] && (! gen_true_buf_r)))
      $display("%5t blocked: gen_true_buf", $time);
  `endif
  
  /* fork (Ty Word#) : (gen_false,Word#) > [(gen_one,Word#),
                                           (gen_cmd,Word#)] */
  logic [1:0] gen_false_emitted;
  initial gen_false_emitted = 2'd0;
  logic [1:0] gen_false_done;
  assign gen_one_d = {gen_false_d[WORD_MSB:1],
                      (gen_false_d[0] && (! gen_false_emitted[0]))};
  assign gen_cmd_d = {gen_false_d[WORD_MSB:1],
                      (gen_false_d[0] && (! gen_false_emitted[1]))};
  assign gen_false_done = (gen_false_emitted | ({gen_cmd_d[0],
                                                 gen_one_d[0]} & {gen_cmd_r, gen_one_r}));
  assign gen_false_r = (& gen_false_done);
  always_ff @(posedge clk)
    gen_false_emitted <= (gen_false_r ? 2'd0 :
                          gen_false_done);
  
  /* togo (Ty Word#) : (gen_one,Word#) > (one_go,Go) */
  assign one_go_d = gen_one_d[0];
  assign gen_one_r = one_go_r;
  
  /* buf (Ty Go) : (one_go,Go) > (one_buf,Go) */
  Go_t one_go_bufchan_d;
  logic one_go_bufchan_r;
  Go_t one_go_buf;
  initial one_go_buf = 1'd0;
  assign one_go_r = (! one_go_buf[0]);
  assign one_go_bufchan_d = (one_go_buf[0] ? one_go_buf :
                             one_go_d);
  always_ff @(posedge clk)
    if ((one_go_bufchan_r && one_go_buf[0])) one_go_buf <= 1'd0;
    else if (((! one_go_bufchan_r) && (! one_go_buf[0])))
      one_go_buf <= one_go_d;
  initial one_buf_d = 1'd0;
  assign one_go_bufchan_r = ((! one_buf_d[0]) || one_buf_r);
  always_ff @(posedge clk)
    if (one_go_bufchan_r) one_buf_d <= one_go_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((one_buf_d[0] && (! one_buf_r)))
      $display("%5t blocked: one_buf", $time);
  `endif
  
  /* const (Ty Word#,Lit 1) : (one_buf,Go) > (one,Word#) */
  assign one_d = {{WORD_MSB-1{1'd0}}, 1'd1, one_buf_d[0]};
  assign one_buf_r = one_r;
  
  /* dcon (Ty Pointer,Dcon P) : [(gen_cmd,Word#)] > (cmd_ref,Pointer) */
  assign cmd_ref_d = P_dc((& {gen_cmd_d[0]}), gen_cmd_d);
  assign {gen_cmd_r} = {1 {(cmd_ref_r && cmd_ref_d[0])}};
  
  /* dcon (Ty GC_Cmd,Dcon Sweep) : [(cmd_ref,Pointer)] > (cmd,GC_Cmd) */
  assign cmd_d = Sweep_dc((& {cmd_ref_d[0]}), cmd_ref_d);
  assign {cmd_ref_r} = {1 {(cmd_r && cmd_d[0])}};
  
  /* dcon (Ty ResetSweep,Dcon RS) : [(gen_true_buf,Word#),
                                (sweep_reset_go,Go)] > (reset_sweep,ResetSweep) */
  assign reset_sweep_d = RS_dc((& {gen_true_buf_d[0],
                                   sweep_reset_go_d[0]}), gen_true_buf_d, sweep_reset_go_d);
  assign {gen_true_buf_r,
          sweep_reset_go_r} = {2 {(reset_sweep_r && reset_sweep_d[0])}};
  
  /* togo (Ty ResetSweep) : (reset_sweep,ResetSweep) > (reset_go,Go) */
  assign reset_go_d = reset_sweep_d[0];
  assign reset_sweep_r = reset_go_r;
  
  /* mux (Ty Go,
     Ty Word#) : (reset_go,Go) [(bb_gen,Word#)] > (gen_sub,Word#) */
  assign gen_sub_d = {bb_gen_d[WORD_MSB:1],
                      (reset_go_d[0] && bb_gen_d[0])};
  assign bb_gen_r = (gen_sub_r && (reset_go_d[0] && bb_gen_d[0]));
  assign reset_go_r = (gen_sub_r && (reset_go_d[0] && bb_gen_d[0]));
  
  /* initbuf (Ty Go,Dcon Go) : (res_reset_go,Go) > (res_reset,Go) */
  initial res_reset_d = Go_dc(1'd1);
  assign res_reset_go_r = ((! res_reset_d[0]) || res_reset_r);
  always_ff @(posedge clk)
    if (res_reset_go_r) res_reset_d <= res_reset_go_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((res_reset_d[0] && (! res_reset_r)))
      $display("%5t blocked: res_reset", $time);
  `endif
  
  /* mux (Ty Go,
     Ty Word#) : (res_reset,Go) [(bb_res,Word#)] > (res_gate,Word#) */
  assign res_gate_d = {bb_res_d[WORD_MSB:1],
                       (res_reset_d[0] && bb_res_d[0])};
  assign bb_res_r = (res_gate_r && (res_reset_d[0] && bb_res_d[0]));
  assign res_reset_r = (res_gate_r && (res_reset_d[0] && bb_res_d[0]));
  
  /* merge (Ty Word#) : [(res_gate,Word#),
                      (res_in,Word#)] > (update_res,Word#) */
  logic [1:0] update_res_selected;
  logic [1:0] update_res_select;
  initial update_res_select = 2'd0;
  always_comb
    begin
      update_res_selected = 2'd0;
      if ((| update_res_select)) update_res_selected = update_res_select;
      else
        if (res_gate_d[0]) update_res_selected[0] = 1'd1;
        else if (res_in_d[0]) update_res_selected[1] = 1'd1;
    end
  always_ff @(posedge clk)
    update_res_select <= (update_res_r ? 2'd0 :
                          update_res_selected);
  always_comb
    if (update_res_selected[0]) update_res_d = res_gate_d;
    else if (update_res_selected[1]) update_res_d = res_in_d;
    else update_res_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign {res_in_r,
          res_gate_r} = (update_res_r ? update_res_selected :
                         2'd0);
  
  /* const (Ty Word#,Lit 1) : (res_go,Go) > (res_in,Word#) */
  assign res_in_d = {{WORD_MSB-1{1'd0}}, 1'd1, res_go_d[0]};
  assign res_go_r = res_in_r;
  
  /* togo (Ty GC_Res) : (res_count,GC_Res) > (res_go,Go) */
  assign res_go_d = res_count_d[0];
  assign res_count_r = res_go_r;
  
  /* op_add (Ty Word#) : (update_res,Word#) (old_res,Word#) > (new_res,Word#) */
  assign new_res_d = {(signed'(update_res_d[WORD_MSB:1]) + signed'(old_res_d[WORD_MSB:1])),
                      (update_res_d[0] && old_res_d[0])};
  assign {update_res_r,
          old_res_r} = {2 {(new_res_r && new_res_d[0])}};
  
  /* initibuf (Ty Word#,Lit 0) : (res_buf,Word#) > (old_res,Word#) */
  initial old_res_d = {{WORD_MSB{1'd0}}, 1'd1};
  assign res_buf_r = ((! old_res_d[0]) || old_res_r);
  always_ff @(posedge clk)
    if (res_buf_r) old_res_d <= res_buf_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((old_res_d[0] && (! old_res_r)))
      $display("%5t blocked: old_res", $time);
  `endif
  
  /* rbuf (Ty Word#) : (res_keep,Word#) > (res_buf,Word#) */
  \Word#_t  res_keep_buf;
  initial res_keep_buf = {{WORD_MSB{1'bx}}, 1'd0};
  assign res_keep_r = (! res_keep_buf[0]);
  assign res_buf_d = (res_keep_buf[0] ? res_keep_buf :
                      res_keep_d);
  always_ff @(posedge clk)
    if ((res_buf_r && res_keep_buf[0])) res_keep_buf <= {{WORD_MSB{1'bx}}, 1'd0};
    else if (((! res_buf_r) && (! res_keep_buf[0])))
      res_keep_buf <= res_keep_d;
  
  /* fork (Ty Word#) : (new_res,Word#) > [(res_keep,Word#),
                                         (res_comp,Word#)] */
  logic [1:0] new_res_emitted;
  initial new_res_emitted = 2'd0;
  logic [1:0] new_res_done;
  assign res_keep_d = {new_res_d[WORD_MSB:1],
                       (new_res_d[0] && (! new_res_emitted[0]))};
  assign res_comp_d = {new_res_d[WORD_MSB:1],
                       (new_res_d[0] && (! new_res_emitted[1]))};
  assign new_res_done = (new_res_emitted | ({res_comp_d[0],
                                             res_keep_d[0]} & {res_comp_r, res_keep_r}));
  assign new_res_r = (& new_res_done);
  always_ff @(posedge clk)
    new_res_emitted <= (new_res_r ? 2'd0 :
                        new_res_done);
  
  /* op_eq (Ty Word#) : (res_comp,Word#) (zero,Word#) > (eq_zero,Bool_mem) */
  assign eq_zero_d = {(signed'(res_comp_d[WORD_MSB:1]) == signed'(zero_d[WORD_MSB:1])),
                      (res_comp_d[0] && zero_d[0])};
  assign {res_comp_r, zero_r} = {2 {(eq_zero_r && eq_zero_d[0])}};
  
  /* const (Ty Word#,Lit 0) : (zero_go,Go) > (zero,Word#) */
  assign zero_d = {{WORD_MSB{1'd0}}, zero_go_d[0]};
  assign zero_go_r = zero_r;
  
  /* fork (Ty Bool_mem) : (eq_zero,Bool_mem) > [(zero_choose,Bool_mem),
                                   (zero_in,Bool_mem),
                                   (zero_keep,Bool_mem)] */
  logic [2:0] eq_zero_emitted;
  initial eq_zero_emitted = 3'd0;
  logic [2:0] eq_zero_done;
  assign zero_choose_d = {eq_zero_d[1:1],
                          (eq_zero_d[0] && (! eq_zero_emitted[0]))};
  assign zero_in_d = {eq_zero_d[1:1],
                      (eq_zero_d[0] && (! eq_zero_emitted[1]))};
  assign zero_keep_d = {eq_zero_d[1:1],
                        (eq_zero_d[0] && (! eq_zero_emitted[2]))};
  assign eq_zero_done = (eq_zero_emitted | ({zero_keep_d[0],
                                             zero_in_d[0],
                                             zero_choose_d[0]} & {zero_keep_r,
                                                                  zero_in_r,
                                                                  zero_choose_r}));
  assign eq_zero_r = (& eq_zero_done);
  always_ff @(posedge clk)
    eq_zero_emitted <= (eq_zero_r ? 3'd0 :
                        eq_zero_done);
  
  /* buf (Ty Bool_mem) : (zero_keep,Bool_mem) > (zero_buf2,Bool_mem) */
  Bool_mem_t zero_keep_bufchan_d;
  logic zero_keep_bufchan_r;
  Bool_mem_t zero_keep_buf;
  initial zero_keep_buf = {1'bx, 1'd0};
  assign zero_keep_r = (! zero_keep_buf[0]);
  assign zero_keep_bufchan_d = (zero_keep_buf[0] ? zero_keep_buf :
                                zero_keep_d);
  always_ff @(posedge clk)
    if ((zero_keep_bufchan_r && zero_keep_buf[0]))
      zero_keep_buf <= {1'bx, 1'd0};
    else if (((! zero_keep_bufchan_r) && (! zero_keep_buf[0])))
      zero_keep_buf <= zero_keep_d;
  initial zero_buf2_d = {1'bx, 1'd0};
  assign zero_keep_bufchan_r = ((! zero_buf2_d[0]) || zero_buf2_r);
  always_ff @(posedge clk)
    if (zero_keep_bufchan_r) zero_buf2_d <= zero_keep_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((zero_buf2_d[0] && (! zero_buf2_r)))
      $display("%5t blocked: zero_buf2", $time);
  `endif
  
  /* togo (Ty Bool_mem) : (zero_buf2,Bool_mem) > (zero_go_rbuf,Go) */
  assign zero_go_rbuf_d = zero_buf2_d[0];
  assign zero_buf2_r = zero_go_rbuf_r;
  
  /* rbuf (Ty Go) : (zero_go_rbuf,Go) > (zero_go_buf,Go) */
  Go_t zero_go_rbuf_buf;
  initial zero_go_rbuf_buf = 1'd0;
  assign zero_go_rbuf_r = (! zero_go_rbuf_buf[0]);
  assign zero_go_buf_d = (zero_go_rbuf_buf[0] ? zero_go_rbuf_buf :
                          zero_go_rbuf_d);
  always_ff @(posedge clk)
    if ((zero_go_buf_r && zero_go_rbuf_buf[0]))
      zero_go_rbuf_buf <= 1'd0;
    else if (((! zero_go_buf_r) && (! zero_go_rbuf_buf[0])))
      zero_go_rbuf_buf <= zero_go_rbuf_d;
  
  /* initbuf (Ty Go,Dcon Go) : (zero_go_buf,Go) > (zero_go,Go) */
  initial zero_go_d = Go_dc(1'd1);
  assign zero_go_buf_r = ((! zero_go_d[0]) || zero_go_r);
  always_ff @(posedge clk)
    if (zero_go_buf_r) zero_go_d <= zero_go_buf_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((zero_go_d[0] && (! zero_go_r)))
      $display("%5t blocked: zero_go", $time);
  `endif
  
  /* demux (Ty Bool_mem,
       Ty Bool_mem) : (zero_choose,Bool_mem) (zero_in,Bool_mem) > [(_2,Bool_mem),
                                                       (res_done,Bool_mem)] */
  logic [1:0] zero_in_onehotd;
  always_comb
    if ((zero_choose_d[0] && zero_in_d[0]))
      unique case (zero_choose_d[1:1])
        1'd0: zero_in_onehotd = 2'd1;
        1'd1: zero_in_onehotd = 2'd2;
        default: zero_in_onehotd = 2'bx;
      endcase
    else zero_in_onehotd = 2'd0;
  assign _2_d = {zero_in_d[1:1], zero_in_onehotd[0]};
  assign res_done_d = {zero_in_d[1:1], zero_in_onehotd[1]};
  assign zero_in_r = (| (zero_in_onehotd & {res_done_r, _2_r}));
  assign zero_choose_r = zero_in_r;
  
  /* buf (Ty Bool_mem) : (res_done,Bool_mem) > (res_done_buf,Bool_mem) */
  Bool_mem_t res_done_bufchan_d;
  logic res_done_bufchan_r;
  Bool_mem_t res_done_buf;
  initial res_done_buf = {1'bx, 1'd0};
  assign res_done_r = (! res_done_buf[0]);
  assign res_done_bufchan_d = (res_done_buf[0] ? res_done_buf :
                               res_done_d);
  always_ff @(posedge clk)
    if ((res_done_bufchan_r && res_done_buf[0]))
      res_done_buf <= {1'bx, 1'd0};
    else if (((! res_done_bufchan_r) && (! res_done_buf[0])))
      res_done_buf <= res_done_d;
  initial res_done_buf_d = {1'bx, 1'd0};
  assign res_done_bufchan_r = ((! res_done_buf_d[0]) || res_done_buf_r);
  always_ff @(posedge clk)
    if (res_done_bufchan_r) res_done_buf_d <= res_done_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((res_done_buf_d[0] && (! res_done_buf_r)))
      $display("%5t blocked: res_done_buf", $time);
  `endif
  
  /* togo (Ty Bool_mem) : (res_done_buf,Bool_mem) > (res_done_go,Go) */
  assign res_done_go_d = res_done_buf_d[0];
  assign res_done_buf_r = res_done_go_r;
  
  /* fork (Ty Go) : (res_done_go,Go) > [(end_sweep,Go),
                                   (res_reset_go,Go),
                                   (sweep_reset_go,Go)] */
  logic [2:0] res_done_go_emitted;
  initial res_done_go_emitted = 3'd0;
  logic [2:0] res_done_go_done;
  assign end_sweep_d = (res_done_go_d[0] && (! res_done_go_emitted[0]));
  assign res_reset_go_d = (res_done_go_d[0] && (! res_done_go_emitted[1]));
  assign sweep_reset_go_d = (res_done_go_d[0] && (! res_done_go_emitted[2]));
  assign res_done_go_done = (res_done_go_emitted | ({sweep_reset_go_d[0],
                                                     res_reset_go_d[0],
                                                     end_sweep_d[0]} & {sweep_reset_go_r,
                                                                        res_reset_go_r,
                                                                        end_sweep_r}));
  assign res_done_go_r = (& res_done_go_done);
  always_ff @(posedge clk)
    res_done_go_emitted <= (res_done_go_r ? 3'd0 :
                            res_done_go_done);
  
  /* fork (Ty GC_Res) : (res,GC_Res) > [(res_count,GC_Res),
                                   (res_freed,GC_Res),
                                   (res_choose,GC_Res)] */
  logic [2:0] res_emitted;
  initial res_emitted = 3'd0;
  logic [2:0] res_done;
  assign res_count_d = {res_d[GC_RES_MSB:1],
                        (res_d[0] && (! res_emitted[0]))};
  assign res_freed_d = {res_d[GC_RES_MSB:1],
                        (res_d[0] && (! res_emitted[1]))};
  assign res_choose_d = {res_d[GC_RES_MSB:1],
                         (res_d[0] && (! res_emitted[2]))};
  assign res_done = (res_emitted | ({res_choose_d[0],
                                     res_freed_d[0],
                                     res_count_d[0]} & {res_choose_r, res_freed_r, res_count_r}));
  assign res_r = (& res_done);
  always_ff @(posedge clk)
    res_emitted <= (res_r ? 3'd0 :
                    res_done);
  
  /* demux (Ty GC_Res,
       Ty GC_Res) : (res_choose,GC_Res) (res_freed,GC_Res) > [(_1,GC_Res),
                                                              (er2,GC_Res),
                                                              (er3,GC_Res),
                                                              (freed_go,GC_Res),
                                                              (er4,GC_Res),
                                                              (_0,GC_Res)] */
  logic [5:0] res_freed_onehotd;
  always_comb
    if ((res_choose_d[0] && res_freed_d[0]))
      unique case (res_choose_d[3:1])
        3'd0: res_freed_onehotd = 6'd1;
        3'd1: res_freed_onehotd = 6'd2;
        3'd2: res_freed_onehotd = 6'd4;
        3'd3: res_freed_onehotd = 6'd8;
        3'd4: res_freed_onehotd = 6'd16;
        3'd5: res_freed_onehotd = 6'd32;
        default: res_freed_onehotd = 6'bx;
      endcase
    else res_freed_onehotd = 6'd0;
  assign _1_d = {res_freed_d[GC_RES_MSB:1], res_freed_onehotd[0]};
  assign er2_d = {res_freed_d[GC_RES_MSB:1], res_freed_onehotd[1]};
  assign er3_d = {res_freed_d[GC_RES_MSB:1], res_freed_onehotd[2]};
  assign freed_go_d = {res_freed_d[GC_RES_MSB:1], res_freed_onehotd[3]};
  assign er4_d = {res_freed_d[GC_RES_MSB:1], res_freed_onehotd[4]};
  assign _0_d = {res_freed_d[GC_RES_MSB:1], res_freed_onehotd[5]};
  assign res_freed_r = (| (res_freed_onehotd & {_0_r,
                                                er4_r,
                                                freed_go_r,
                                                er3_r,
                                                er2_r,
                                                _1_r}));
  assign res_choose_r = res_freed_r;
  
  /* togo (Ty GC_Res) : (freed_go,GC_Res) > (freed,Go) */
  assign freed_d = freed_go_d[0];
  assign freed_go_r = freed_r;
  
  /* togo (Ty GC_Res) : (er2,GC_Res) > (er2_go,Go) */
  assign er2_go_d = er2_d[0];
  assign er2_r = er2_go_r;
  
  /* togo (Ty GC_Res) : (er3,GC_Res) > (er3_go,Go) */
  assign er3_go_d = er3_d[0];
  assign er3_r = er3_go_r;
  
  /* togo (Ty GC_Res) : (er4,GC_Res) > (er4_go,Go) */
  assign er4_go_d = er4_d[0];
  assign er4_r = er4_go_r;
  
  /* merge (Ty Go) : [(er2_go,Go),
                 (er3_go,Go),
                 (er4_go,Go)] > (all_errors,Go) */
  logic [2:0] all_errors_selected;
  logic [2:0] all_errors_select;
  initial all_errors_select = 3'd0;
  always_comb
    begin
      all_errors_selected = 3'd0;
      if ((| all_errors_select)) all_errors_selected = all_errors_select;
      else
        if (er2_go_d[0]) all_errors_selected[0] = 1'd1;
        else if (er3_go_d[0]) all_errors_selected[1] = 1'd1;
        else if (er4_go_d[0]) all_errors_selected[2] = 1'd1;
    end
  always_ff @(posedge clk)
    all_errors_select <= (all_errors_r ? 3'd0 :
                          all_errors_selected);
  always_comb
    if (all_errors_selected[0]) all_errors_d = er2_go_d;
    else if (all_errors_selected[1]) all_errors_d = er3_go_d;
    else if (all_errors_selected[2]) all_errors_d = er4_go_d;
    else all_errors_d = 1'd0;
  assign {er4_go_r,
          er3_go_r,
          er2_go_r} = (all_errors_r ? all_errors_selected :
                       3'd0);
  
  /* dcon (Ty Raise_Err,
      Dcon SC) : [(all_errors,Go)] > (sweep_error,Raise_Err) */
  assign sweep_error_d = SC_dc((& {all_errors_d[0]}), all_errors_d);
  assign {all_errors_r} = {1 {(sweep_error_r && sweep_error_d[0])}};
  
  /* sink (Ty GC_Cmd) : (cmd,GC_Cmd) > */
  assign {cmd_r, cmd_dout} = {cmd_rout, cmd_d};
  
  /* sink (Ty Go) : (end_sweep,Go) > */
  assign {end_sweep_r, end_sweep_dout} = {end_sweep_rout,
                                          end_sweep_d};
  
  /* sink (Ty Go) : (freed,Go) > */
  assign {freed_r, freed_dout} = {freed_rout, freed_d};
  
  /* sink (Ty Raise_Err) : (sweep_error,Raise_Err) > */
  assign {sweep_error_r, sweep_error_dout} = {sweep_error_rout,
                                              sweep_error_d};
  
  /* Lack-of-progress detector */
  `ifdef CHECK_PROGRESS
  logic [12:0] bufferedChannelValids;
  logic [12:0] bufferedChannelReadys;
  logic [12:0] last1BufferedChannelValids;
  logic [12:0] last1BufferedChannelReadys;
  logic [12:0] last2BufferedChannelValids;
  logic [12:0] last2BufferedChannelReadys;
  initial last1BufferedChannelValids = 13'd0;
  initial last1BufferedChannelReadys = 13'd0;
  initial last2BufferedChannelValids = 13'd1;
  initial last2BufferedChannelReadys = 13'd1;
  assign bufferedChannelValids = {bb_buf_d[0],
                                  old_count_d[0],
                                  count_rbuf_d[0],
                                  bound_buf_d[0],
                                  gen_true_buf_d[0],
                                  one_buf_d[0],
                                  res_reset_d[0],
                                  old_res_d[0],
                                  res_buf_d[0],
                                  zero_buf2_d[0],
                                  zero_go_buf_d[0],
                                  zero_go_d[0],
                                  res_done_buf_d[0]};
  assign bufferedChannelReadys = {bb_buf_r,
                                  old_count_r,
                                  count_rbuf_r,
                                  bound_buf_r,
                                  gen_true_buf_r,
                                  one_buf_r,
                                  res_reset_r,
                                  old_res_r,
                                  res_buf_r,
                                  zero_buf2_r,
                                  zero_go_buf_r,
                                  zero_go_r,
                                  res_done_buf_r};
  always_ff @(posedge clk)
    begin
      last1BufferedChannelValids <= bufferedChannelValids;
      last1BufferedChannelReadys <= bufferedChannelReadys;
      last2BufferedChannelValids <= last1BufferedChannelValids;
      last2BufferedChannelReadys <= last1BufferedChannelReadys;
      if (((((last2BufferedChannelValids == last1BufferedChannelValids) && (last1BufferedChannelValids == bufferedChannelValids)) && (last2BufferedChannelReadys == last1BufferedChannelReadys)) && (last1BufferedChannelReadys == bufferedChannelReadys)))
        begin
          $display("%6t no progress", $time);
          $display(" valids %b", last2BufferedChannelValids);
          $display(" readys %b", last2BufferedChannelReadys);
          $display(" valids %b", last1BufferedChannelValids);
          $display(" readys %b", last1BufferedChannelReadys);
          $display(" valids %b", bufferedChannelValids);
          $display(" readys %b", bufferedChannelReadys);
          if ((bb_buf_d[0] && (! bb_buf_r))) $display(" blocked bb_buf");
          if ((old_count_d[0] && (! old_count_r)))
            $display(" blocked old_count");
          if ((count_rbuf_d[0] && (! count_rbuf_r)))
            $display(" blocked count_rbuf");
          if ((bound_buf_d[0] && (! bound_buf_r)))
            $display(" blocked bound_buf");
          if ((gen_true_buf_d[0] && (! gen_true_buf_r)))
            $display(" blocked gen_true_buf");
          if ((one_buf_d[0] && (! one_buf_r))) $display(" blocked one_buf");
          if ((res_reset_d[0] && (! res_reset_r)))
            $display(" blocked res_reset");
          if ((old_res_d[0] && (! old_res_r))) $display(" blocked old_res");
          if ((res_buf_d[0] && (! res_buf_r))) $display(" blocked res_buf");
          if ((zero_buf2_d[0] && (! zero_buf2_r)))
            $display(" blocked zero_buf2");
          if ((zero_go_buf_d[0] && (! zero_go_buf_r)))
            $display(" blocked zero_go_buf");
          if ((zero_go_d[0] && (! zero_go_r))) $display(" blocked zero_go");
          if ((res_done_buf_d[0] && (! res_done_buf_r)))
            $display(" blocked res_done_buf");
          $finish();
        end
    end
  `endif
  /* Wake Node Reporting */
  `ifdef WAKE_REPORT
  /* wake base_bound:sub */
  /* wake bb_buf:buf */
  /* wake reset_gate:mux */
  /* wake count:add */
  /* wake old_count:initibuf */
  /* wake count_rbuf:rbuf */
  /* wake bound_buf:buf */
  /* wake eq_bound:eq */
  /* wake gen_true_buf:buf */
  /* wake one_buf:buf */
  /* wake gen_sub:mux */
  /* wake res_reset:initbuf */
  /* wake res_gate:mux */
  /* wake new_res:add */
  /* wake old_res:initibuf */
  /* wake res_buf:rbuf */
  /* wake eq_zero:eq */
  /* wake zero_buf2:buf */
  /* wake zero_go_buf:rbuf */
  /* wake zero_go:initbuf */
  /* wake res_done_buf:buf */
  always_ff @(posedge clk)
    $display("wake %b", {base_bound_d[0],
                         (bb_buf_d[0] || (bb_keep_d[0] || bb_keep_bufchan_d[0])),
                         reset_gate_d[0],
                         count_d[0],
                         (old_count_d[0] || count_rbuf_d[0]),
                         (count_rbuf_d[0] || count_buf_d[0]),
                         (bound_buf_d[0] || (bound_keep_d[0] || bound_keep_bufchan_d[0])),
                         eq_bound_d[0],
                         (gen_true_buf_d[0] || (gen_true_d[0] || gen_true_bufchan_d[0])),
                         (one_buf_d[0] || (one_go_d[0] || one_go_bufchan_d[0])),
                         gen_sub_d[0],
                         (res_reset_d[0] || res_reset_go_d[0]),
                         res_gate_d[0],
                         new_res_d[0],
                         (old_res_d[0] || res_buf_d[0]),
                         (res_buf_d[0] || res_keep_d[0]),
                         eq_zero_d[0],
                         (zero_buf2_d[0] || (zero_keep_d[0] || zero_keep_bufchan_d[0])),
                         (zero_go_buf_d[0] || zero_go_rbuf_d[0]),
                         (zero_go_d[0] || zero_go_buf_d[0]),
                         (res_done_buf_d[0] || (res_done_d[0] || res_done_bufchan_d[0]))});
  `endif
endmodule
