module RootChase(
  input logic clk,
  input Pointer_t root_d,
  output logic root_r,
  input GC_Res_t res_d,
  output logic res_r,
  output Go_t done_out_dout,
  input logic done_out_rout,
  output GC_Cmd_t cmd_dout,
  input logic cmd_rout,
  output Raise_Err_t root_error_dout,
  input logic root_error_rout
  );
  /* --define=INPUTS=((root, 16, 65536, Pointer), (res, 19, 524288, GC_Res)) */
  /* --define=TAPS=() */
  /* --define=OUTPUTS=((done_out, 0, 1, Go), (cmd, 18, 262144, GC_Cmd), (root_error, 2, 3, Raise_Err)) */
  /* TYPE_START
TYPE_END */
  /*  */
  /*  */

   parameter POINTER_BITS = 17;
   parameter NODE_BITS = 34;

   parameter POINTER_MSB = POINTER_BITS-1; //16;
   parameter WORD_MSB = POINTER_BITS-1; //16;
   parameter GC_RES_MSB = POINTER_BITS+2; //19;
   
  GC_Res_t res_b_d;
  logic res_b_r;
  GC_Res_t res_choose_d;
  logic res_choose_r;
  GC_Res_t res_pass_d;
  logic res_pass_r;
  GC_Res_t marked_d;
  logic marked_r;
  GC_Res_t nochild_d;
  logic nochild_r;
  GC_Res_t onechild_d;
  logic onechild_r;
  GC_Res_t er0_d;
  logic er0_r;
  GC_Res_t er1_d;
  logic er1_r;
  GC_Res_t er2_d;
  logic er2_r;
  Go_t marked_go_d;
  logic marked_go_r;
  \Word#_t  marked_int_d;
  logic marked_int_r;
  Go_t nochild_go_d;
  logic nochild_go_r;
  \Word#_t  nochild_int_d;
  logic nochild_int_r;
  GC_Res_t onechild_cmd_d;
  logic onechild_cmd_r;
  GC_Res_t onechild_count_d;
  logic onechild_count_r;
  Go_t onechild_go_d;
  logic onechild_go_r;
  \Word#_t  onechild_int_d;
  logic onechild_int_r;
  Go_t new_root_buf_d;
  logic new_root_buf_r;
  Go_t new_root_rbuf_d;
  logic new_root_rbuf_r;
  Pointer_t new_root_go_d;
  logic new_root_go_r;
  Pointer_t root_count_d;
  logic root_count_r;
  Pointer_t root_ref_d;
  logic root_ref_r;
  Go_t root_go_d;
  logic root_go_r;
  \Word#_t  root_int_d;
  logic root_int_r;
  Pointer_t onechild_ref_d;
  logic onechild_ref_r;
  Pointer_t ref_d;
  logic ref_r;
  GC_Cmd_t cmd_d;
  logic cmd_r;
  \Word#_t  update_d;
  logic update_r;
  \Word#_t  new_count_d;
  logic new_count_r;
  \Word#_t  count_loop_d;
  logic count_loop_r;
  \Word#_t  count_use_d;
  logic count_use_r;
  \Word#_t  count_init_d;
  logic count_init_r;
  \Word#_t  count_buf_d;
  logic count_buf_r;
  \Word#_t  zero_init_d;
  logic zero_init_r;
  \Word#_t  zero_d;
  logic zero_r;
  \Word#_t  zero_loop_d;
  logic zero_loop_r;
  \Word#_t  zero_buf_d;
  logic zero_buf_r;
  \Word#_t  count_use_buf_d;
  logic count_use_buf_r;
  Tog_t count_eq_0_d;
  logic count_eq_0_r;
  Tog_t done_in_d;
  logic done_in_r;
  Tog_t done_choose_d;
  logic done_choose_r;
  Tog_t _0_d;
  logic _0_r;
  assign _0_r = 1'd1;
  Tog_t done_d;
  logic done_r;
  Go_t done_go_d;
  logic done_go_r;
  Go_t new_root_d;
  logic new_root_r;
  Go_t done_out_d;
  logic done_out_r;
  Go_t er0_go_d;
  logic er0_go_r;
  Go_t er1_go_d;
  logic er1_go_r;
  Go_t er2_go_d;
  logic er2_go_r;
  Go_t all_errors_d;
  logic all_errors_r;
  Raise_Err_t root_error_d;
  logic root_error_r;
  
  /* source (Ty Pointer) : > (root,Pointer) */
  
  /* source (Ty GC_Res) : > (res,GC_Res) */
  
  /* buf (Ty GC_Res) : (res,GC_Res) > (res_b,GC_Res) */
  GC_Res_t res_bufchan_d;
  logic res_bufchan_r;
  GC_Res_t res_buf;
  initial res_buf = {{GC_RES_MSB{1'bx}}, 1'd0};
  assign res_r = (! res_buf[0]);
  assign res_bufchan_d = (res_buf[0] ? res_buf :
                          res_d);
  always_ff @(posedge clk)
    if ((res_bufchan_r && res_buf[0])) res_buf <= {{GC_RES_MSB{1'bx}}, 1'd0};
    else if (((! res_bufchan_r) && (! res_buf[0]))) res_buf <= res_d;
  initial res_b_d = {{GC_RES_MSB{1'bx}}, 1'd0};
  assign res_bufchan_r = ((! res_b_d[0]) || res_b_r);
  always_ff @(posedge clk)
    if (res_bufchan_r) res_b_d <= res_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((res_b_d[0] && (! res_b_r)))
      $display("%5t blocked: res_b", $time);
  `endif
  
  /* fork (Ty GC_Res) : (res_b,GC_Res) > [(res_choose,GC_Res),
                                     (res_pass,GC_Res)] */
  logic [1:0] res_b_emitted;
  initial res_b_emitted = 2'd0;
  logic [1:0] res_b_done;
  assign res_choose_d = {res_b_d[GC_RES_MSB:1],
                         (res_b_d[0] && (! res_b_emitted[0]))};
  assign res_pass_d = {res_b_d[GC_RES_MSB:1],
                       (res_b_d[0] && (! res_b_emitted[1]))};
  assign res_b_done = (res_b_emitted | ({res_pass_d[0],
                                         res_choose_d[0]} & {res_pass_r, res_choose_r}));
  assign res_b_r = (& res_b_done);
  always_ff @(posedge clk)
    res_b_emitted <= (res_b_r ? 2'd0 :
                      res_b_done);
  
  /* demux (Ty GC_Res,
       Ty GC_Res) : (res_choose,GC_Res) (res_pass,GC_Res) > [(marked,GC_Res),
                                                             (nochild,GC_Res),
                                                             (onechild,GC_Res),
                                                             (er0,GC_Res),
                                                             (er1,GC_Res),
                                                             (er2,GC_Res)] */
  logic [5:0] res_pass_onehotd;
  always_comb
    if ((res_choose_d[0] && res_pass_d[0]))
      unique case (res_choose_d[3:1])
        3'd0: res_pass_onehotd = 6'd1;
        3'd1: res_pass_onehotd = 6'd2;
        3'd2: res_pass_onehotd = 6'd4;
        3'd3: res_pass_onehotd = 6'd8;
        3'd4: res_pass_onehotd = 6'd16;
        3'd5: res_pass_onehotd = 6'd32;
        default: res_pass_onehotd = 6'bx;
      endcase
    else res_pass_onehotd = 6'd0;
  assign marked_d = {res_pass_d[GC_RES_MSB:1], res_pass_onehotd[0]};
  assign nochild_d = {res_pass_d[GC_RES_MSB:1], res_pass_onehotd[1]};
  assign onechild_d = {res_pass_d[GC_RES_MSB:1], res_pass_onehotd[2]};
  assign er0_d = {res_pass_d[GC_RES_MSB:1], res_pass_onehotd[3]};
  assign er1_d = {res_pass_d[GC_RES_MSB:1], res_pass_onehotd[4]};
  assign er2_d = {res_pass_d[GC_RES_MSB:1], res_pass_onehotd[5]};
  assign res_pass_r = (| (res_pass_onehotd & {er2_r,
                                              er1_r,
                                              er0_r,
                                              onechild_r,
                                              nochild_r,
                                              marked_r}));
  assign res_choose_r = res_pass_r;
  
  /* togo (Ty GC_Res) : (marked,GC_Res) > (marked_go,Go) */
  assign marked_go_d = marked_d[0];
  assign marked_r = marked_go_r;
  
  /* const (Ty Word#,Lit -1) : (marked_go,Go) > (marked_int,Word#) */
  assign marked_int_d = {{WORD_MSB{1'd1}}, marked_go_d[0]};
  assign marked_go_r = marked_int_r;
  
  /* togo (Ty GC_Res) : (nochild,GC_Res) > (nochild_go,Go) */
  assign nochild_go_d = nochild_d[0];
  assign nochild_r = nochild_go_r;
  
  /* const (Ty Word#,Lit -1) : (nochild_go,Go) > (nochild_int,Word#) */
  assign nochild_int_d = {{WORD_MSB{1'd1}}, nochild_go_d[0]};
  assign nochild_go_r = nochild_int_r;
  
  /* fork (Ty GC_Res) : (onechild,GC_Res) > [(onechild_cmd,GC_Res),
                                        (onechild_count,GC_Res)] */
  logic [1:0] onechild_emitted;
  initial onechild_emitted = 2'd0;
  logic [1:0] onechild_done;
  assign onechild_cmd_d = {onechild_d[GC_RES_MSB:1],
                           (onechild_d[0] && (! onechild_emitted[0]))};
  assign onechild_count_d = {onechild_d[GC_RES_MSB:1],
                             (onechild_d[0] && (! onechild_emitted[1]))};
  assign onechild_done = (onechild_emitted | ({onechild_count_d[0],
                                               onechild_cmd_d[0]} & {onechild_count_r,
                                                                     onechild_cmd_r}));
  assign onechild_r = (& onechild_done);
  always_ff @(posedge clk)
    onechild_emitted <= (onechild_r ? 2'd0 :
                         onechild_done);
  
  /* togo (Ty GC_Res) : (onechild_count,GC_Res) > (onechild_go,Go) */
  assign onechild_go_d = onechild_count_d[0];
  assign onechild_count_r = onechild_go_r;
  
  /* const (Ty Word#,
       Lit 0) : (onechild_go,Go) > (onechild_int,Word#) */
  assign onechild_int_d = {{WORD_MSB{1'd0}}, onechild_go_d[0]};
  assign onechild_go_r = onechild_int_r;
  
  /* initbuf (Ty Go,Dcon Go) : (new_root,Go) > (new_root_buf,Go) */
  initial new_root_buf_d = Go_dc(1'd1);
  assign new_root_r = ((! new_root_buf_d[0]) || new_root_buf_r);
  always_ff @(posedge clk)
    if (new_root_r) new_root_buf_d <= new_root_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((new_root_buf_d[0] && (! new_root_buf_r)))
      $display("%5t blocked: new_root_buf", $time);
  `endif
  
  /* rbuf (Ty Go) : (new_root_buf,Go) > (new_root_rbuf,Go) */
  Go_t new_root_buf_buf;
  initial new_root_buf_buf = 1'd0;
  assign new_root_buf_r = (! new_root_buf_buf[0]);
  assign new_root_rbuf_d = (new_root_buf_buf[0] ? new_root_buf_buf :
                            new_root_buf_d);
  always_ff @(posedge clk)
    if ((new_root_rbuf_r && new_root_buf_buf[0]))
      new_root_buf_buf <= 1'd0;
    else if (((! new_root_rbuf_r) && (! new_root_buf_buf[0])))
      new_root_buf_buf <= new_root_buf_d;
  
  /* mux (Ty Go,
     Ty Pointer) : (new_root_rbuf,Go) [(root,Pointer)] > (new_root_go,Pointer) */
  assign new_root_go_d = {root_d[POINTER_MSB:1],
                          (new_root_rbuf_d[0] && root_d[0])};
  assign root_r = (new_root_go_r && (new_root_rbuf_d[0] && root_d[0]));
  assign new_root_rbuf_r = (new_root_go_r && (new_root_rbuf_d[0] && root_d[0]));
  
  /* fork (Ty Pointer) : (new_root_go,Pointer) > [(root_count,Pointer),
                                             (root_ref,Pointer)] */
  logic [1:0] new_root_go_emitted;
  initial new_root_go_emitted = 2'd0;
  logic [1:0] new_root_go_done;
  assign root_count_d = {new_root_go_d[POINTER_MSB:1],
                         (new_root_go_d[0] && (! new_root_go_emitted[0]))};
  assign root_ref_d = {new_root_go_d[POINTER_MSB:1],
                       (new_root_go_d[0] && (! new_root_go_emitted[1]))};
  assign new_root_go_done = (new_root_go_emitted | ({root_ref_d[0],
                                                     root_count_d[0]} & {root_ref_r,
                                                                         root_count_r}));
  assign new_root_go_r = (& new_root_go_done);
  always_ff @(posedge clk)
    new_root_go_emitted <= (new_root_go_r ? 2'd0 :
                            new_root_go_done);
  
  /* togo (Ty Pointer) : (root_count,Pointer) > (root_go,Go) */
  assign root_go_d = root_count_d[0];
  assign root_count_r = root_go_r;
  
  /* const (Ty Word#,Lit 1) : (root_go,Go) > (root_int,Word#) */
  assign root_int_d = {{WORD_MSB-1{1'd0}}, 1'd1, root_go_d[0]};
  assign root_go_r = root_int_r;
  
  /* destruct (Ty GC_Res,
          Dcon OneChild) : (onechild_cmd,GC_Res) > [(onechild_ref,Pointer)] */
  assign onechild_ref_d = {onechild_cmd_d[GC_RES_MSB:4], onechild_cmd_d[0]};
  assign onechild_cmd_r = onechild_ref_r;
  
  /* merge (Ty Pointer) : [(root_ref,Pointer),
                      (onechild_ref,Pointer)] > (ref,Pointer) */
  logic [1:0] ref_selected;
  logic [1:0] ref_select;
  initial ref_select = 2'd0;
  always_comb
    begin
      ref_selected = 2'd0;
      if ((| ref_select)) ref_selected = ref_select;
      else
        if (root_ref_d[0]) ref_selected[0] = 1'd1;
        else if (onechild_ref_d[0]) ref_selected[1] = 1'd1;
    end
  always_ff @(posedge clk)
    ref_select <= (ref_r ? 2'd0 :
                   ref_selected);
  always_comb
    if (ref_selected[0]) ref_d = root_ref_d;
    else if (ref_selected[1]) ref_d = onechild_ref_d;
    else ref_d = {{POINTER_MSB{1'bx}}, 1'd0};
  assign {onechild_ref_r, root_ref_r} = (ref_r ? ref_selected :
                                         2'd0);
  
  /* dcon (Ty GC_Cmd,Dcon Mark) : [(ref,Pointer)] > (cmd,GC_Cmd) */
  assign cmd_d = Mark_dc((& {ref_d[0]}), ref_d);
  assign {ref_r} = {1 {(cmd_r && cmd_d[0])}};
  
  /* merge (Ty Word#) : [(root_int,Word#),
                      (marked_int,Word#),
                      (nochild_int,Word#),
                      (onechild_int,Word#)] > (update,Word#) */
  logic [3:0] update_selected;
  logic [3:0] update_select;
  initial update_select = 4'd0;
  always_comb
    begin
      update_selected = 4'd0;
      if ((| update_select)) update_selected = update_select;
      else
        if (root_int_d[0]) update_selected[0] = 1'd1;
        else if (marked_int_d[0]) update_selected[1] = 1'd1;
        else if (nochild_int_d[0]) update_selected[2] = 1'd1;
        else if (onechild_int_d[0]) update_selected[3] = 1'd1;
    end
  always_ff @(posedge clk)
    update_select <= (update_r ? 4'd0 :
                      update_selected);
  always_comb
    if (update_selected[0]) update_d = root_int_d;
    else if (update_selected[1]) update_d = marked_int_d;
    else if (update_selected[2]) update_d = nochild_int_d;
    else if (update_selected[3]) update_d = onechild_int_d;
    else update_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign {onechild_int_r,
          nochild_int_r,
          marked_int_r,
          root_int_r} = (update_r ? update_selected :
                         4'd0);
  
  /* op_add (Ty Word#) : (update,Word#) (count_buf,Word#) > (new_count,Word#) */
  assign new_count_d = {(update_d[WORD_MSB:1] + count_buf_d[WORD_MSB:1]),
                        (update_d[0] && count_buf_d[0])};
  assign {update_r,
          count_buf_r} = {2 {(new_count_r && new_count_d[0])}};
  
  /* fork (Ty Word#) : (new_count,Word#) > [(count_loop,Word#),
                                           (count_use,Word#)] */
  logic [1:0] new_count_emitted;
  initial new_count_emitted = 2'd0;
  logic [1:0] new_count_done;
  assign count_loop_d = {new_count_d[WORD_MSB:1],
                         (new_count_d[0] && (! new_count_emitted[0]))};
  assign count_use_d = {new_count_d[WORD_MSB:1],
                        (new_count_d[0] && (! new_count_emitted[1]))};
  assign new_count_done = (new_count_emitted | ({count_use_d[0],
                                                 count_loop_d[0]} & {count_use_r, count_loop_r}));
  assign new_count_r = (& new_count_done);
  always_ff @(posedge clk)
    new_count_emitted <= (new_count_r ? 2'd0 :
                          new_count_done);
  
  /* initibuf (Ty Word#,
          Lit 0) : (count_loop,Word#) > (count_init,Word#) */
  initial count_init_d = {{WORD_MSB{1'd0}}, 1'd1};
  assign count_loop_r = ((! count_init_d[0]) || count_init_r);
  always_ff @(posedge clk)
    if (count_loop_r) count_init_d <= count_loop_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((count_init_d[0] && (! count_init_r)))
      $display("%5t blocked: count_init", $time);
  `endif
  
  /* rbuf (Ty Word#) : (count_init,Word#) > (count_buf,Word#) */
  \Word#_t  count_init_buf;
  initial count_init_buf = {{WORD_MSB{1'bx}}, 1'd0};
  assign count_init_r = (! count_init_buf[0]);
  assign count_buf_d = (count_init_buf[0] ? count_init_buf :
                        count_init_d);
  always_ff @(posedge clk)
    if ((count_buf_r && count_init_buf[0]))
      count_init_buf <= {{WORD_MSB{1'bx}}, 1'd0};
    else if (((! count_buf_r) && (! count_init_buf[0])))
      count_init_buf <= count_init_d;
  
  /* initibuf (Ty Word#,
          Lit 0) : (zero_buf,Word#) > (zero_init,Word#) */
  initial zero_init_d = {{WORD_MSB{1'd0}}, 1'd1};
  assign zero_buf_r = ((! zero_init_d[0]) || zero_init_r);
  always_ff @(posedge clk)
    if (zero_buf_r) zero_init_d <= zero_buf_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((zero_init_d[0] && (! zero_init_r)))
      $display("%5t blocked: zero_init", $time);
  `endif
  
  /* fork (Ty Word#) : (zero_init,Word#) > [(zero,Word#),
                                           (zero_loop,Word#)] */
  logic [1:0] zero_init_emitted;
  initial zero_init_emitted = 2'd0;
  logic [1:0] zero_init_done;
  assign zero_d = {zero_init_d[WORD_MSB:1],
                   (zero_init_d[0] && (! zero_init_emitted[0]))};
  assign zero_loop_d = {zero_init_d[WORD_MSB:1],
                        (zero_init_d[0] && (! zero_init_emitted[1]))};
  assign zero_init_done = (zero_init_emitted | ({zero_loop_d[0],
                                                 zero_d[0]} & {zero_loop_r, zero_r}));
  assign zero_init_r = (& zero_init_done);
  always_ff @(posedge clk)
    zero_init_emitted <= (zero_init_r ? 2'd0 :
                          zero_init_done);
  
  /* rbuf (Ty Word#) : (zero_loop,Word#) > (zero_buf,Word#) */
  \Word#_t  zero_loop_buf;
  initial zero_loop_buf = {{WORD_MSB{1'bx}}, 1'd0};
  assign zero_loop_r = (! zero_loop_buf[0]);
  assign zero_buf_d = (zero_loop_buf[0] ? zero_loop_buf :
                       zero_loop_d);
  always_ff @(posedge clk)
    if ((zero_buf_r && zero_loop_buf[0]))
      zero_loop_buf <= {{WORD_MSB{1'bx}}, 1'd0};
    else if (((! zero_buf_r) && (! zero_loop_buf[0])))
      zero_loop_buf <= zero_loop_d;
  
  /* buf (Ty Word#) : (count_use,Word#) > (count_use_buf,Word#) */
  \Word#_t  count_use_bufchan_d;
  logic count_use_bufchan_r;
  \Word#_t  count_use_buf;
  initial count_use_buf = {{WORD_MSB{1'bx}}, 1'd0};
  assign count_use_r = (! count_use_buf[0]);
  assign count_use_bufchan_d = (count_use_buf[0] ? count_use_buf :
                                count_use_d);
  always_ff @(posedge clk)
    if ((count_use_bufchan_r && count_use_buf[0]))
      count_use_buf <= {{WORD_MSB{1'bx}}, 1'd0};
    else if (((! count_use_bufchan_r) && (! count_use_buf[0])))
      count_use_buf <= count_use_d;
  initial count_use_buf_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign count_use_bufchan_r = ((! count_use_buf_d[0]) || count_use_buf_r);
  always_ff @(posedge clk)
    if (count_use_bufchan_r) count_use_buf_d <= count_use_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((count_use_buf_d[0] && (! count_use_buf_r)))
      $display("%5t blocked: count_use_buf", $time);
  `endif
  
  /* op_eq (Ty Word#) : (zero,Word#) (count_use_buf,Word#) > (count_eq_0,Tog) */
  assign count_eq_0_d = {(zero_d[WORD_MSB:1] == count_use_buf_d[WORD_MSB:1]),
                         (zero_d[0] && count_use_buf_d[0])};
  assign {zero_r,
          count_use_buf_r} = {2 {(count_eq_0_r && count_eq_0_d[0])}};
  
  /* fork (Ty Tog) : (count_eq_0,Tog) > [(done_in,Tog),
                                    (done_choose,Tog)] */
  logic [1:0] count_eq_0_emitted;
  initial count_eq_0_emitted = 2'd0;
  logic [1:0] count_eq_0_done;
  assign done_in_d = {count_eq_0_d[1:1],
                      (count_eq_0_d[0] && (! count_eq_0_emitted[0]))};
  assign done_choose_d = {count_eq_0_d[1:1],
                          (count_eq_0_d[0] && (! count_eq_0_emitted[1]))};
  assign count_eq_0_done = (count_eq_0_emitted | ({done_choose_d[0],
                                                   done_in_d[0]} & {done_choose_r, done_in_r}));
  assign count_eq_0_r = (& count_eq_0_done);
  always_ff @(posedge clk)
    count_eq_0_emitted <= (count_eq_0_r ? 2'd0 :
                           count_eq_0_done);
  
  /* demux (Ty Tog,
       Ty Tog) : (done_choose,Tog) (done_in,Tog) > [(_0,Tog),(done,Tog)] */
  logic [1:0] done_in_onehotd;
  always_comb
    if ((done_choose_d[0] && done_in_d[0]))
      unique case (done_choose_d[1:1])
        1'd0: done_in_onehotd = 2'd1;
        1'd1: done_in_onehotd = 2'd2;
        default: done_in_onehotd = 2'bx;
      endcase
    else done_in_onehotd = 2'd0;
  assign _0_d = {done_in_d[1:1], done_in_onehotd[0]};
  assign done_d = {done_in_d[1:1], done_in_onehotd[1]};
  assign done_in_r = (| (done_in_onehotd & {done_r, _0_r}));
  assign done_choose_r = done_in_r;
  
  /* togo (Ty Tog) : (done,Tog) > (done_go,Go) */
  assign done_go_d = done_d[0];
  assign done_r = done_go_r;
  
  /* fork (Ty Go) : (done_go,Go) > [(new_root,Go),(done_out,Go)] */
  logic [1:0] done_go_emitted;
  initial done_go_emitted = 2'd0;
  logic [1:0] done_go_done;
  assign new_root_d = (done_go_d[0] && (! done_go_emitted[0]));
  assign done_out_d = (done_go_d[0] && (! done_go_emitted[1]));
  assign done_go_done = (done_go_emitted | ({done_out_d[0],
                                             new_root_d[0]} & {done_out_r, new_root_r}));
  assign done_go_r = (& done_go_done);
  always_ff @(posedge clk)
    done_go_emitted <= (done_go_r ? 2'd0 :
                        done_go_done);
  
  /* togo (Ty GC_Res) : (er0,GC_Res) > (er0_go,Go) */
  assign er0_go_d = er0_d[0];
  assign er0_r = er0_go_r;
  
  /* togo (Ty GC_Res) : (er1,GC_Res) > (er1_go,Go) */
  assign er1_go_d = er1_d[0];
  assign er1_r = er1_go_r;
  
  /* togo (Ty GC_Res) : (er2,GC_Res) > (er2_go,Go) */
  assign er2_go_d = er2_d[0];
  assign er2_r = er2_go_r;
  
  /* merge (Ty Go) : [(er0_go,Go),
                 (er1_go,Go),
                 (er2_go,Go)] > (all_errors,Go) */
  logic [2:0] all_errors_selected;
  logic [2:0] all_errors_select;
  initial all_errors_select = 3'd0;
  always_comb
    begin
      all_errors_selected = 3'd0;
      if ((| all_errors_select)) all_errors_selected = all_errors_select;
      else
        if (er0_go_d[0]) all_errors_selected[0] = 1'd1;
        else if (er1_go_d[0]) all_errors_selected[1] = 1'd1;
        else if (er2_go_d[0]) all_errors_selected[2] = 1'd1;
    end
  always_ff @(posedge clk)
    all_errors_select <= (all_errors_r ? 3'd0 :
                          all_errors_selected);
  always_comb
    if (all_errors_selected[0]) all_errors_d = er0_go_d;
    else if (all_errors_selected[1]) all_errors_d = er1_go_d;
    else if (all_errors_selected[2]) all_errors_d = er2_go_d;
    else all_errors_d = 1'd0;
  assign {er2_go_r,
          er1_go_r,
          er0_go_r} = (all_errors_r ? all_errors_selected :
                       3'd0);
  
  /* dcon (Ty Raise_Err,
      Dcon RC) : [(all_errors,Go)] > (root_error,Raise_Err) */
  assign root_error_d = RC_dc((& {all_errors_d[0]}), all_errors_d);
  assign {all_errors_r} = {1 {(root_error_r && root_error_d[0])}};
  
  /* sink (Ty Go) : (done_out,Go) > */
  assign {done_out_r, done_out_dout} = {done_out_rout, done_out_d};
  
  /* sink (Ty GC_Cmd) : (cmd,GC_Cmd) > */
  assign {cmd_r, cmd_dout} = {cmd_rout, cmd_d};
  
  /* sink (Ty Raise_Err) : (root_error,Raise_Err) > */
  assign {root_error_r, root_error_dout} = {root_error_rout,
                                            root_error_d};
  
  /* Lack-of-progress detector */
  `ifdef CHECK_PROGRESS
  logic [7:0] bufferedChannelValids;
  logic [7:0] bufferedChannelReadys;
  logic [7:0] last1BufferedChannelValids;
  logic [7:0] last1BufferedChannelReadys;
  logic [7:0] last2BufferedChannelValids;
  logic [7:0] last2BufferedChannelReadys;
  initial last1BufferedChannelValids = 8'd0;
  initial last1BufferedChannelReadys = 8'd0;
  initial last2BufferedChannelValids = 8'd1;
  initial last2BufferedChannelReadys = 8'd1;
  assign bufferedChannelValids = {res_b_d[0],
                                  new_root_buf_d[0],
                                  new_root_rbuf_d[0],
                                  count_init_d[0],
                                  count_buf_d[0],
                                  zero_init_d[0],
                                  zero_buf_d[0],
                                  count_use_buf_d[0]};
  assign bufferedChannelReadys = {res_b_r,
                                  new_root_buf_r,
                                  new_root_rbuf_r,
                                  count_init_r,
                                  count_buf_r,
                                  zero_init_r,
                                  zero_buf_r,
                                  count_use_buf_r};
  always_ff @(posedge clk)
    begin
      last1BufferedChannelValids <= bufferedChannelValids;
      last1BufferedChannelReadys <= bufferedChannelReadys;
      last2BufferedChannelValids <= last1BufferedChannelValids;
      last2BufferedChannelReadys <= last1BufferedChannelReadys;
      if (((((last2BufferedChannelValids == last1BufferedChannelValids) && (last1BufferedChannelValids == bufferedChannelValids)) && (last2BufferedChannelReadys == last1BufferedChannelReadys)) && (last1BufferedChannelReadys == bufferedChannelReadys)))
        begin
          $display("%6t no progress", $time);
          $display(" valids %b", last2BufferedChannelValids);
          $display(" readys %b", last2BufferedChannelReadys);
          $display(" valids %b", last1BufferedChannelValids);
          $display(" readys %b", last1BufferedChannelReadys);
          $display(" valids %b", bufferedChannelValids);
          $display(" readys %b", bufferedChannelReadys);
          if ((res_b_d[0] && (! res_b_r))) $display(" blocked res_b");
          if ((new_root_buf_d[0] && (! new_root_buf_r)))
            $display(" blocked new_root_buf");
          if ((new_root_rbuf_d[0] && (! new_root_rbuf_r)))
            $display(" blocked new_root_rbuf");
          if ((count_init_d[0] && (! count_init_r)))
            $display(" blocked count_init");
          if ((count_buf_d[0] && (! count_buf_r)))
            $display(" blocked count_buf");
          if ((zero_init_d[0] && (! zero_init_r)))
            $display(" blocked zero_init");
          if ((zero_buf_d[0] && (! zero_buf_r)))
            $display(" blocked zero_buf");
          if ((count_use_buf_d[0] && (! count_use_buf_r)))
            $display(" blocked count_use_buf");
          $finish();
        end
    end
  `endif
  /* Wake Node Reporting */
  `ifdef WAKE_REPORT
  /* wake res_b:buf */
  /* wake new_root_buf:initbuf */
  /* wake new_root_rbuf:rbuf */
  /* wake new_root_go:mux */
  /* wake new_count:add */
  /* wake count_init:initibuf */
  /* wake count_buf:rbuf */
  /* wake zero_init:initibuf */
  /* wake zero_buf:rbuf */
  /* wake count_use_buf:buf */
  /* wake count_eq_0:eq */
  always_ff @(posedge clk)
    $display("wake %b", {(res_b_d[0] || (res_d[0] || res_bufchan_d[0])),
                         (new_root_buf_d[0] || new_root_d[0]),
                         (new_root_rbuf_d[0] || new_root_buf_d[0]),
                         new_root_go_d[0],
                         new_count_d[0],
                         (count_init_d[0] || count_loop_d[0]),
                         (count_buf_d[0] || count_init_d[0]),
                         (zero_init_d[0] || zero_buf_d[0]),
                         (zero_buf_d[0] || zero_loop_d[0]),
                         (count_use_buf_d[0] || (count_use_d[0] || count_use_bufchan_d[0])),
                         count_eq_0_d[0]});
  `endif
endmodule
