//`include "Types.sv"

module RefNodeMerge2(
  input logic clk,
  input Pointer_t cmd0_d,
  output logic cmd0_r,
  input Pointer_t cmd1_d,
  output logic cmd1_r,
  input Node_t res_in_d,
  output logic res_in_r,
  output Node_t res0_dout,
  input logic res0_rout,
  output Node_t res1_dout,
  input logic res1_rout,
  output Pointer_t cmd_out_dout,
  input logic cmd_out_rout
  );
  /* --define=INPUTS=((cmd0, 16, 65536, Pointer), (cmd1, 16, 65536, Pointer), (res_in, 33, 8589934592, Node)) */
  /* --define=TAPS=() */
  /* --define=OUTPUTS=((res0, 33, 8589934592, Node), (res1, 33, 8589934592, Node), (cmd_out, 16, 65536, Pointer)) */
  /* TYPE_START
TYPE_END */
  /*  */
  /*  */

   parameter POINTER_BITS = 17;
   parameter NODE_BITS = 34;

   parameter POINTER_MSB = POINTER_BITS-1; //16;
   parameter NODE_MSB = NODE_BITS-1; //33;
  
  Pointer_t in0_d;
  logic in0_r;
  Pointer_t in1_d;
  logic in1_r;
  Sel2_t s_d;
  logic s_r;
  Pointer_t cmd_out_d;
  logic cmd_out_r;
  Node_t res0_d;
  logic res0_r;
  Node_t res1_d;
  logic res1_r;
  
  /* source (Ty Pointer) : > (cmd0,Pointer) */
  
  /* source (Ty Pointer) : > (cmd1,Pointer) */
  
  /* source (Ty Node) : > (res_in,Node) */
  
  /* buf (Ty Pointer) : (cmd0,Pointer) > (in0,Pointer) */
  Pointer_t cmd0_bufchan_d;
  logic cmd0_bufchan_r;
  Pointer_t cmd0_buf;
  initial cmd0_buf = {{POINTER_MSB{1'bx}}, 1'd0};
  assign cmd0_r = (! cmd0_buf[0]);
  assign cmd0_bufchan_d = (cmd0_buf[0] ? cmd0_buf :
                           cmd0_d);
  always_ff @(posedge clk)
    if ((cmd0_bufchan_r && cmd0_buf[0])) cmd0_buf <= {{POINTER_MSB{1'bx}}, 1'd0};
    else if (((! cmd0_bufchan_r) && (! cmd0_buf[0])))
      cmd0_buf <= cmd0_d;
  initial in0_d = {{POINTER_MSB{1'bx}}, 1'd0};
  assign cmd0_bufchan_r = ((! in0_d[0]) || in0_r);
  always_ff @(posedge clk)
    if (cmd0_bufchan_r) in0_d <= cmd0_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((in0_d[0] && (! in0_r))) $display("%5t blocked: in0", $time);
  `endif
  
  /* buf (Ty Pointer) : (cmd1,Pointer) > (in1,Pointer) */
  Pointer_t cmd1_bufchan_d;
  logic cmd1_bufchan_r;
  Pointer_t cmd1_buf;
  initial cmd1_buf = {{POINTER_MSB{1'bx}}, 1'd0};
  assign cmd1_r = (! cmd1_buf[0]);
  assign cmd1_bufchan_d = (cmd1_buf[0] ? cmd1_buf :
                           cmd1_d);
  always_ff @(posedge clk)
    if ((cmd1_bufchan_r && cmd1_buf[0])) cmd1_buf <= {{POINTER_MSB{1'bx}}, 1'd0};
    else if (((! cmd1_bufchan_r) && (! cmd1_buf[0])))
      cmd1_buf <= cmd1_d;
  initial in1_d = {{POINTER_MSB{1'bx}}, 1'd0};
  assign cmd1_bufchan_r = ((! in1_d[0]) || in1_r);
  always_ff @(posedge clk)
    if (cmd1_bufchan_r) in1_d <= cmd1_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((in1_d[0] && (! in1_r))) $display("%5t blocked: in1", $time);
  `endif
  
  /* mergectrl (Ty Sel2,Ty Pointer) : [(in0,Pointer),
                                  (in1,Pointer)] > (s,Sel2) (cmd_out,Pointer) */
  logic [1:0] in0_select_d;
  assign in0_select_d = ((| in0_select_q) ? in0_select_q :
                         (in0_d[0] ? 2'd1 :
                          (in1_d[0] ? 2'd2 :
                           2'd0)));
  logic [1:0] in0_select_q;
  initial in0_select_q = 2'd0;
  always_ff @(posedge clk)
    in0_select_q <= (in0_done ? 2'd0 :
                     in0_select_d);
  logic [1:0] in0_emit_q;
  initial in0_emit_q = 2'd0;
  always_ff @(posedge clk)
    in0_emit_q <= (in0_done ? 2'd0 :
                   in0_emit_d);
  logic [1:0] in0_emit_d;
  assign in0_emit_d = (in0_emit_q | ({s_d[0], cmd_out_d[0]} & {s_r,
                                                               cmd_out_r}));
  logic in0_done;
  assign in0_done = (& in0_emit_d);
  assign {in1_r, in0_r} = (in0_done ? in0_select_d :
                           2'd0);
  assign cmd_out_d = ((in0_select_d[0] && (! in0_emit_q[0])) ? in0_d :
                      ((in0_select_d[1] && (! in0_emit_q[0])) ? in1_d :
                       {{POINTER_MSB{1'bx}}, 1'd0}));
  assign s_d = ((in0_select_d[0] && (! in0_emit_q[1])) ? I20_dc(1'd1) :
                ((in0_select_d[1] && (! in0_emit_q[1])) ? I21_dc(1'd1) :
                 {1'bx, 1'd0}));
  
  /* demux (Ty Sel2,Ty Node) : (s,Sel2) (res_in,Node) > [(res0,Node),
                                                    (res1,Node)] */
  logic [1:0] res_in_onehotd;
  always_comb
    if ((s_d[0] && res_in_d[0]))
      unique case (s_d[1:1])
        1'd0: res_in_onehotd = 2'd1;
        1'd1: res_in_onehotd = 2'd2;
        default: res_in_onehotd = 2'bx;
      endcase
    else res_in_onehotd = 2'd0;
  assign res0_d = {res_in_d[NODE_MSB:1], res_in_onehotd[0]};
  assign res1_d = {res_in_d[NODE_MSB:1], res_in_onehotd[1]};
  assign res_in_r = (| (res_in_onehotd & {res1_r, res0_r}));
  assign s_r = res_in_r;
  
  /* sink (Ty Node) : (res0,Node) > */
  assign {res0_r, res0_dout} = {res0_rout, res0_d};
  
  /* sink (Ty Node) : (res1,Node) > */
  assign {res1_r, res1_dout} = {res1_rout, res1_d};
  
  /* sink (Ty Pointer) : (cmd_out,Pointer) > */
  assign {cmd_out_r, cmd_out_dout} = {cmd_out_rout, cmd_out_d};
  
  /* Lack-of-progress detector */
  `ifdef CHECK_PROGRESS
  logic [1:0] bufferedChannelValids;
  logic [1:0] bufferedChannelReadys;
  logic [1:0] last1BufferedChannelValids;
  logic [1:0] last1BufferedChannelReadys;
  logic [1:0] last2BufferedChannelValids;
  logic [1:0] last2BufferedChannelReadys;
  initial last1BufferedChannelValids = 2'd0;
  initial last1BufferedChannelReadys = 2'd0;
  initial last2BufferedChannelValids = 2'd1;
  initial last2BufferedChannelReadys = 2'd1;
  assign bufferedChannelValids = {in0_d[0], in1_d[0]};
  assign bufferedChannelReadys = {in0_r, in1_r};
  always_ff @(posedge clk)
    begin
      last1BufferedChannelValids <= bufferedChannelValids;
      last1BufferedChannelReadys <= bufferedChannelReadys;
      last2BufferedChannelValids <= last1BufferedChannelValids;
      last2BufferedChannelReadys <= last1BufferedChannelReadys;
      if (((((last2BufferedChannelValids == last1BufferedChannelValids) && (last1BufferedChannelValids == bufferedChannelValids)) && (last2BufferedChannelReadys == last1BufferedChannelReadys)) && (last1BufferedChannelReadys == bufferedChannelReadys)))
        begin
          $display("%6t no progress", $time);
          $display(" valids %b", last2BufferedChannelValids);
          $display(" readys %b", last2BufferedChannelReadys);
          $display(" valids %b", last1BufferedChannelValids);
          $display(" readys %b", last1BufferedChannelReadys);
          $display(" valids %b", bufferedChannelValids);
          $display(" readys %b", bufferedChannelReadys);
          if ((in0_d[0] && (! in0_r))) $display(" blocked in0");
          if ((in1_d[0] && (! in1_r))) $display(" blocked in1");
          $finish();
        end
    end
  `endif
  /* Wake Node Reporting */
  `ifdef WAKE_REPORT
  /* wake in0:buf */
  /* wake in1:buf */
  always_ff @(posedge clk)
    $display("wake %b", {(in0_d[0] || (cmd0_d[0] || cmd0_bufchan_d[0])),
                         (in1_d[0] || (cmd1_d[0] || cmd1_bufchan_d[0]))});
  `endif
endmodule
