//`include "Types.sv"

module RefFork2(
  input logic clk,
  input Pointer_t input_d,
  output logic input_r,
  output Pointer_t output1_dout,
  input logic output1_rout,
  output Pointer_t output2_dout,
  input logic output2_rout
  );
  /* --define=INPUTS=((input, 16, 65536, Pointer)) */
  /* --define=TAPS=() */
  /* --define=OUTPUTS=((output1, 16, 65536, Pointer), (output2, 16, 65536, Pointer)) */
  /* TYPE_START
TYPE_END */
  /*  */
  /*  */

   parameter POINTER_BITS = 17;
   parameter NODE_BITS = 34;

   parameter POINTER_MSB = POINTER_BITS-1; //16;
   
  Pointer_t chan_d;
  logic chan_r;
  Pointer_t output1_d;
  logic output1_r;
  Pointer_t output2_d;
  logic output2_r;
  
  /* source (Ty Pointer) : > (input,Pointer) */
  
  /* buf (Ty Pointer) : (input,Pointer) > (chan,Pointer) */
  Pointer_t input_bufchan_d;
  logic input_bufchan_r;
  Pointer_t input_buf;
  initial input_buf = {{POINTER_MSB{1'bx}}, 1'd0};
  assign input_r = (! input_buf[0]);
  assign input_bufchan_d = (input_buf[0] ? input_buf :
                            input_d);
  always_ff @(posedge clk)
    if ((input_bufchan_r && input_buf[0])) input_buf <= {{POINTER_MSB{1'bx}}, 1'd0};
    else if (((! input_bufchan_r) && (! input_buf[0])))
      input_buf <= input_d;
  initial chan_d = {{POINTER_MSB{1'bx}}, 1'd0};
  assign input_bufchan_r = ((! chan_d[0]) || chan_r);
  always_ff @(posedge clk)
    if (input_bufchan_r) chan_d <= input_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((chan_d[0] && (! chan_r)))
      $display("%5t blocked: chan", $time);
  `endif
  
  /* fork (Ty Pointer) : (chan,Pointer) > [(output1,Pointer),
                                      (output2,Pointer)] */
  logic [1:0] chan_emitted;
  initial chan_emitted = 2'd0;
  logic [1:0] chan_done;
  assign output1_d = {chan_d[POINTER_MSB:1],
                      (chan_d[0] && (! chan_emitted[0]))};
  assign output2_d = {chan_d[POINTER_MSB:1],
                      (chan_d[0] && (! chan_emitted[1]))};
  assign chan_done = (chan_emitted | ({output2_d[0],
                                       output1_d[0]} & {output2_r, output1_r}));
  assign chan_r = (& chan_done);
  always_ff @(posedge clk)
    chan_emitted <= (chan_r ? 2'd0 :
                     chan_done);
  
  /* sink (Ty Pointer) : (output1,Pointer) > */
  assign {output1_r, output1_dout} = {output1_rout, output1_d};
  
  /* sink (Ty Pointer) : (output2,Pointer) > */
  assign {output2_r, output2_dout} = {output2_rout, output2_d};
  
  /* Wake Node Reporting */
  `ifdef WAKE_REPORT
  /* wake chan:buf */
  always_ff @(posedge clk)
    $display("wake %b", {(chan_d[0] || (input_d[0] || input_bufchan_d[0]))});
  `endif
endmodule
