//`include "Types.sv"

module Read(
  input logic clk,
  input \Word#_t  init_d,
  output logic init_r,
  input Pointer_t input_d,
  output logic input_r,
  input Res_t res_d,
  output logic res_r,
  output Node_t node_dout,
  input logic node_rout,
  output Cmd_t cmd_dout,
  input logic cmd_rout
  );
  /* --define=INPUTS=((init, 16, 65536, Word__023), (input, 16, 65536, Pointer), (res, 34, 17179869184, Res)) */
  /* --define=TAPS=() */
  /* --define=OUTPUTS=((node, 33, 8589934592, Node), (cmd, 50, 1125899906842624, Cmd)) */
  /* TYPE_START
TYPE_END */
  /*  */
  /*  */
   
   parameter POINTER_BITS = 17;
   parameter NODE_BITS = 34;

   parameter POINTER_MSB = POINTER_BITS-1; //16;
   parameter RES_MSB = NODE_BITS; //34;
   parameter NODE_MSB = NODE_BITS-1; //33;
  
   Go_t go_d;
  logic go_r;
  Go_t merge_out_d;
  logic merge_out_r;
  Go_t go_in_d;
  logic go_in_r;
  Go_t go_out_d;
  logic go_out_r;
  Go_t go_loop_d;
  logic go_loop_r;
  Go_t go_buf_d;
  logic go_buf_r;
  Pointer_t in_d;
  logic in_r;
  Node_t node_d;
  logic node_r;
  \Word#_t  addr_d;
  logic addr_r;
  Cmd_t cmd_d;
  logic cmd_r;
  Node_t out_d;
  logic out_r;
  
  /* source (Ty Word#) : > (init,Word#) */
  
  /* source (Ty Pointer) : > (input,Pointer) */
  
  /* togo (Ty Word#) : (init,Word#) > (go,Go) */
  assign go_d = init_d[0];
  assign init_r = go_r;
  
  /* merge (Ty Go) : [(go,Go),(go_buf,Go)] > (merge_out,Go) */
  logic [1:0] merge_out_selected;
  logic [1:0] merge_out_select;
  initial merge_out_select = 2'd0;
  always_comb
    begin
      merge_out_selected = 2'd0;
      if ((| merge_out_select)) merge_out_selected = merge_out_select;
      else
        if (go_d[0]) merge_out_selected[0] = 1'd1;
        else if (go_buf_d[0]) merge_out_selected[1] = 1'd1;
    end
  always_ff @(posedge clk)
    merge_out_select <= (merge_out_r ? 2'd0 :
                         merge_out_selected);
  always_comb
    if (merge_out_selected[0]) merge_out_d = go_d;
    else if (merge_out_selected[1]) merge_out_d = go_buf_d;
    else merge_out_d = 1'd0;
  assign {go_buf_r, go_r} = (merge_out_r ? merge_out_selected :
                             2'd0);
  
  /* fork (Ty Go) : (merge_out,Go) > [(go_in,Go),
                                 (go_out,Go),
                                 (go_loop,Go)] */
  logic [2:0] merge_out_emitted;
  initial merge_out_emitted = 3'd0;
  logic [2:0] merge_out_done;
  assign go_in_d = (merge_out_d[0] && (! merge_out_emitted[0]));
  assign go_out_d = (merge_out_d[0] && (! merge_out_emitted[1]));
  assign go_loop_d = (merge_out_d[0] && (! merge_out_emitted[2]));
  assign merge_out_done = (merge_out_emitted | ({go_loop_d[0],
                                                 go_out_d[0],
                                                 go_in_d[0]} & {go_loop_r, go_out_r, go_in_r}));
  assign merge_out_r = (& merge_out_done);
  always_ff @(posedge clk)
    merge_out_emitted <= (merge_out_r ? 3'd0 :
                          merge_out_done);
  
  /* buf (Ty Go) : (go_loop,Go) > (go_buf,Go) */
  Go_t go_loop_bufchan_d;
  logic go_loop_bufchan_r;
  Go_t go_loop_buf;
  initial go_loop_buf = 1'd0;
  assign go_loop_r = (! go_loop_buf[0]);
  assign go_loop_bufchan_d = (go_loop_buf[0] ? go_loop_buf :
                              go_loop_d);
  always_ff @(posedge clk)
    if ((go_loop_bufchan_r && go_loop_buf[0])) go_loop_buf <= 1'd0;
    else if (((! go_loop_bufchan_r) && (! go_loop_buf[0])))
      go_loop_buf <= go_loop_d;
  initial go_buf_d = 1'd0;
  assign go_loop_bufchan_r = ((! go_buf_d[0]) || go_buf_r);
  always_ff @(posedge clk)
    if (go_loop_bufchan_r) go_buf_d <= go_loop_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((go_buf_d[0] && (! go_buf_r)))
      $display("%5t blocked: go_buf", $time);
  `endif
  
  /* mux (Ty Go,
     Ty Pointer) : (go_in,Go) [(input,Pointer)] > (in,Pointer) */
  assign in_d = {input_d[POINTER_MSB:1], (go_in_d[0] && input_d[0])};
  assign input_r = (in_r && (go_in_d[0] && input_d[0]));
  assign go_in_r = (in_r && (go_in_d[0] && input_d[0]));
  
  /* mux (Ty Go,Ty Node) : (go_out,Go) [(out,Node)] > (node,Node) */
  assign node_d = {out_d[NODE_MSB:1], (go_out_d[0] && out_d[0])};
  assign out_r = (node_r && (go_out_d[0] && out_d[0]));
  assign go_out_r = (node_r && (go_out_d[0] && out_d[0]));
  
  /* destruct (Ty Pointer,Dcon P) : (in,Pointer) > [(addr,Word#)] */
  assign addr_d = {in_d[POINTER_MSB:1], in_d[0]};
  assign in_r = addr_r;
  
  /* dcon (Ty Cmd,Dcon Read) : [(addr,Word#)] > (cmd,Cmd) */
  assign cmd_d = Read_dc((& {addr_d[0]}), addr_d);
  assign {addr_r} = {1 {(cmd_r && cmd_d[0])}};
  
  /* source (Ty Res) : > (res,Res) */
  
  /* destruct (Ty Res,Dcon Data) : (res,Res) > [(out,Node)] */
  assign out_d = {res_d[RES_MSB:2], res_d[0]};
  assign res_r = out_r;
  
  /* sink (Ty Node) : (node,Node) > */
  assign {node_r, node_dout} = {node_rout, node_d};
  
  /* sink (Ty Cmd) : (cmd,Cmd) > */
  assign {cmd_r, cmd_dout} = {cmd_rout, cmd_d};
  
  /* Wake Node Reporting */
  `ifdef WAKE_REPORT
  /* wake go_buf:buf */
  /* wake in:mux */
  /* wake node:mux */
  always_ff @(posedge clk)
    $display("wake %b", {(go_buf_d[0] || (go_loop_d[0] || go_loop_bufchan_d[0])),
                         in_d[0],
                         node_d[0]});
  `endif
endmodule
