//`include "Types.sv"

module Memory(
		input logic 	    clk,
		input 		    Node_t dat_d,
		output logic 	    dat_r,
		output 		    Pointer_t ref_dout,
		input logic 	    ref_rout,
		input 		    Pointer_t rd_d,
		output logic 	    rd_r,
		output 		    Node_t rd_node_dout,
		input logic 	    rd_node_rout,
		input 		    Pointer_t free_d,
		output logic 	    free_r,
		input 		    \Word#_t init_start_d,
		output logic 	    init_start_r,
		input 		    \Word#_t init_end_d,
		output logic 	    init_end_r,
		output 		    Go_t free_ack_dout,
		input logic 	    free_ack_rout,
		output 		    Node_t error_mem_d,
		input logic 	    error_mem_r,
		//output logic [NODE_BITS-2:0] c0a_mem[2**(POINTER_BITS-1)-1:0]
		input logic [11:0]  bram_addr,
		output logic [24:0] bram_line
        	);

   parameter POINTER_BITS = 17;
   parameter NODE_BITS = 34;

   // parameter POINTER_MSB = 16;
   // parameter WORD_MSB = 16;
   // parameter NODE_MSB = 33;
   // parameter NODE_PTR_LSB = 18;
   // parameter NODE_WORD_MSB = 17;
   // parameter CMD_MSB = 50;
   // parameter CMD_NODE_LSB = 18;
   // parameter CMD_WORD_MSB = 17;
   // parameter RES_MSB = 34;
 
   Cmd_t cmd0_d;
   logic cmd0_r;
   Cmd_t cmd1_d;
   logic cmd1_r;
   Cmd_t cmd2_d;
   logic cmd2_r;
   Res_t res0_d;
   logic res0_r;
   Res_t res1_d;
   logic res1_r;
   Res_t res2_d;
   logic res2_r;

   Cmd_t bram_cmd_d;
   logic bram_cmd_r;
   Res_t bram_res_d;
   logic bram_res_r;

   \Word#_t init_done_d;
   logic init_done_r;
   \Word#_t st_alloc_d;
   logic st_alloc_r;
   \Word#_t st_read_d;
   logic st_read_r;
   \Word#_t end_freelist_d;
   logic end_freelist_r;

   Cmd_t initCmd_d;
   logic initCmd_r;
   Res_t initRes_dout;   
   logic initRes_rout;
   
   assign initRes_rout = 1'b1;

   WordFork2 #(.POINTER_BITS(POINTER_BITS),
	       .NODE_BITS(NODE_BITS)) start(.clk(clk),
				    .input_d(init_done_d),
				    .input_r(init_done_r),
				    .output1_dout(st_alloc_d),
				    .output1_rout(st_alloc_r),
				    .output2_dout(st_read_d),
				    .output2_rout(st_read_r)
				    );
   
   Init_Bram #(.POINTER_BITS(POINTER_BITS),
	       .NODE_BITS(NODE_BITS)) init(
				       .clk(clk),
				       .start_d(init_start_d),
				       .start_r(init_start_r),
				       .end_d(init_end_d),
				       .end_r(init_end_r),
				       .to_free_dout(end_freelist_d),
				       .to_free_rout(end_freelist_r),
				       .true_dout(init_done_d),
				       .true_rout(init_done_r),
				       .cmd_dout(initCmd_d),
				       .cmd_rout(initCmd_r)
				       );

   Write #(.POINTER_BITS(POINTER_BITS),
	   .NODE_BITS(NODE_BITS)) alloc(
				    .clk(clk),
				    .dat_d(dat_d), 
				    .dat_r(dat_r),
				    .res_d(res0_d),
				    .res_r(res0_r),
				    .cmd_out_dout(cmd0_d),
				    .cmd_out_rout(cmd0_r),
				    .ref_out_dout(ref_dout),
				    .ref_out_rout(ref_rout),
				    .nul_node_dout(error_mem_d),
				    .nul_node_rout(error_mem_r),
				    .init_d(st_alloc_d),
				    .init_r(st_alloc_r)
				    );

   Read #(.POINTER_BITS(POINTER_BITS),
	  .NODE_BITS(NODE_BITS)) read(
				  .clk(clk),
				  .init_d(st_read_d),
				  .init_r(st_read_r),
				  .input_d(rd_d),
				  .input_r(rd_r),
				  .res_d(res1_d),
				  .res_r(res1_r),
				  .node_dout(rd_node_dout),
				  .node_rout(rd_node_rout),
				  .cmd_dout(cmd1_d),
				  .cmd_rout(cmd1_r)
				  );

   Free #(.POINTER_BITS(POINTER_BITS),
	  .NODE_BITS(NODE_BITS)) free(
				      .clk(clk),
				  .init_d(end_freelist_d),
				  .init_r(end_freelist_r),
				  .input_d(free_d),
				  .input_r(free_r),
				  .cmd_out_dout(cmd2_d),
				  .cmd_out_rout(cmd2_r),
				  .res_in_d(res2_d),
				  .res_in_r(res2_r),
				  .free_ack_dout(free_ack_dout),
				  .free_ack_rout(free_ack_rout)
				  );

   BramMerge4 #(.POINTER_BITS(POINTER_BITS),
		.NODE_BITS(NODE_BITS)) merge(
					 .clk(clk),
					 .cmd0_d(cmd0_d),
					 .cmd0_r(cmd0_r),
					 .cmd1_d(initCmd_d),
					 .cmd1_r(initCmd_r),
					 .cmd2_d(cmd1_d),
					 .cmd2_r(cmd1_r),
					 .cmd3_d(cmd2_d),
					 .cmd3_r(cmd2_r),
					 .res_in_d(bram_res_d),
					 .res_in_r(bram_res_r),
					 .res0_dout(res0_d),
					 .res0_rout(res0_r),
 					 .res1_dout(initRes_dout),
					 .res1_rout(initRes_rout),
					 .res2_dout(res1_d),
					 .res2_rout(res1_r),
					 .res3_dout(res2_d),
					 .res3_rout(res2_r),
					 .cmd_out_dout(bram_cmd_d),
					 .cmd_out_rout(bram_cmd_r)
					 );

   Bram #(.POINTER_BITS(POINTER_BITS),
	  .NODE_BITS(NODE_BITS)) bram(
				      .clk(clk),
				      .input_d(bram_cmd_d),
				      .input_r(bram_cmd_r),
				      .output_dout(bram_res_d),
				      .output_rout(bram_res_r),
				      //.c0a_mem(c0a_mem)
				      .bram_addr(bram_addr),
				      .bram_line(bram_line)
				      );
   
   
endmodule // toplevel

   
