module MarkCtrl(
  input logic clk,
  input \Word#_t  num_roots_d,
  output logic num_roots_r,
  input Root_t input_d,
  output logic input_r,
  input Go_t start_mark_d,
  output logic start_mark_r,
  input Go_t add_done_d,
  output logic add_done_r,
  output Pointer_t chase_ref_dout,
  input logic chase_ref_rout,
  output Go_t end_mark_dout,
  input logic end_mark_rout
  );
  /* --define=INPUTS=((num_roots, 16, 65536, Word__023), (input, 17, 131072, Root), (start_mark, 0, 1, Go), (add_done, 0, 1, Go)) */
  /* --define=TAPS=() */
  /* --define=OUTPUTS=((chase_ref, 16, 65536, Pointer), (end_mark, 0, 1, Go)) */
  /* TYPE_START
TYPE_END */
  /*  */
  /*  */

   parameter POINTER_BITS = 17;
   parameter NODE_BITS = 34;

   parameter WORD_MSB = POINTER_BITS-1; //16;
   parameter ROOT_MSB = POINTER_BITS; //17;
   
  Go_t pass_go_d;
  logic pass_go_r;
  Go_t init_start_d;
  logic init_start_r;
  Go_t root_gate_d;
  logic root_gate_r;
  Root_t root_in_d;
  logic root_in_r;
  Root_t root_pass_d;
  logic root_pass_r;
  Root_t root_choose_d;
  logic root_choose_r;
  Root_t yes_ref_d;
  logic yes_ref_r;
  Root_t no_ref_d;
  logic no_ref_r;
  Go_t no_go_d;
  logic no_go_r;
  \Word#_t  no_chase_d;
  logic no_chase_r;
  Pointer_t chase_ref_d;
  logic chase_ref_r;
  \Word#_t  chase_done_d;
  logic chase_done_r;
  \Word#_t  update_count_d;
  logic update_count_r;
  \Word#_t  root_count_d;
  logic root_count_r;
  \Word#_t  root_use_d;
  logic root_use_r;
  \Word#_t  root_loop_d;
  logic root_loop_r;
  \Word#_t  root_init_d;
  logic root_init_r;
  \Word#_t  root_buf_d;
  logic root_buf_r;
  \Word#_t  num_in_d;
  logic num_in_r;
  \Word#_t  num_comp_d;
  logic num_comp_r;
  \Word#_t  num_reset_d;
  logic num_reset_r;
  \Word#_t  num_merge_out_d;
  logic num_merge_out_r;
  \Word#_t  num_comp_use_d;
  logic num_comp_use_r;
  \Word#_t  num_comp_loop_d;
  logic num_comp_loop_r;
  \Word#_t  num_comp_buf_d;
  logic num_comp_buf_r;
  Tog_t done_roots_d;
  logic done_roots_r;
  Tog_t done_roots_pass_d;
  logic done_roots_pass_r;
  Tog_t done_roots_choose_d;
  logic done_roots_choose_r;
  Tog_t count_neq_d;
  logic count_neq_r;
  Tog_t count_eq_d;
  logic count_eq_r;
  Go_t end_mark_d;
  logic end_mark_r;
  \Word#_t  reset_merge_out_d;
  logic reset_merge_out_r;
  \Word#_t  reset_pass_d;
  logic reset_pass_r;
  \Word#_t  reset_loop_d;
  logic reset_loop_r;
  \Word#_t  reset_use_d;
  logic reset_use_r;
  \Word#_t  reset_buf_d;
  logic reset_buf_r;
  \Word#_t  zero_init_d;
  logic zero_init_r;
  \Word#_t  zero_d;
  logic zero_r;
  \Word#_t  zero_loop_d;
  logic zero_loop_r;
  \Word#_t  zero_buf_d;
  logic zero_buf_r;
  \Word#_t  reset_d;
  logic reset_r;
  \Word#_t  reset_num_d;
  logic reset_num_r;
  
  /* source (Ty Word#) : > (num_roots,Word#) */
  
  /* source (Ty Root) : > (input,Root) */
  
  /* source (Ty Go) : > (start_mark,Go) */
  
  /* togo (Ty Tog) : (count_neq,Tog) > (pass_go,Go) */
  assign pass_go_d = count_neq_d[0];
  assign count_neq_r = pass_go_r;
  
  /* initbuf (Ty Go,Dcon Go) : (pass_go,Go) > (init_start,Go) */
  initial init_start_d = Go_dc(1'd1);
  assign pass_go_r = ((! init_start_d[0]) || init_start_r);
  always_ff @(posedge clk)
    if (pass_go_r) init_start_d <= pass_go_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((init_start_d[0] && (! init_start_r)))
      $display("%5t blocked: init_start", $time);
  `endif
  
  /* rbuf (Ty Go) : (init_start,Go) > (root_gate,Go) */
  Go_t init_start_buf;
  initial init_start_buf = 1'd0;
  assign init_start_r = (! init_start_buf[0]);
  assign root_gate_d = (init_start_buf[0] ? init_start_buf :
                        init_start_d);
  always_ff @(posedge clk)
    if ((root_gate_r && init_start_buf[0])) init_start_buf <= 1'd0;
    else if (((! root_gate_r) && (! init_start_buf[0])))
      init_start_buf <= init_start_d;
  
  /* mux (Ty Go,
     Ty Root) : (root_gate,Go) [(input,Root)] > (root_in,Root) */
  assign root_in_d = {input_d[ROOT_MSB:1], (root_gate_d[0] && input_d[0])};
  assign input_r = (root_in_r && (root_gate_d[0] && input_d[0]));
  assign root_gate_r = (root_in_r && (root_gate_d[0] && input_d[0]));
  
  /* fork (Ty Root) : (root_in,Root) > [(root_pass,Root),
                                   (root_choose,Root)] */
  logic [1:0] root_in_emitted;
  initial root_in_emitted = 2'd0;
  logic [1:0] root_in_done;
  assign root_pass_d = {root_in_d[ROOT_MSB:1],
                        (root_in_d[0] && (! root_in_emitted[0]))};
  assign root_choose_d = {root_in_d[ROOT_MSB:1],
                          (root_in_d[0] && (! root_in_emitted[1]))};
  assign root_in_done = (root_in_emitted | ({root_choose_d[0],
                                             root_pass_d[0]} & {root_choose_r, root_pass_r}));
  assign root_in_r = (& root_in_done);
  always_ff @(posedge clk)
    root_in_emitted <= (root_in_r ? 2'd0 :
                        root_in_done);
  
  /* demux (Ty Root,
       Ty Root) : (root_choose,Root) (root_pass,Root) > [(yes_ref,Root),
                                                         (no_ref,Root)] */
  logic [1:0] root_pass_onehotd;
  always_comb
    if ((root_choose_d[0] && root_pass_d[0]))
      unique case (root_choose_d[1:1])
        1'd0: root_pass_onehotd = 2'd1;
        1'd1: root_pass_onehotd = 2'd2;
        default: root_pass_onehotd = 2'bx;
      endcase
    else root_pass_onehotd = 2'd0;
  assign yes_ref_d = {root_pass_d[ROOT_MSB:1], root_pass_onehotd[0]};
  assign no_ref_d = {root_pass_d[ROOT_MSB:1], root_pass_onehotd[1]};
  assign root_pass_r = (| (root_pass_onehotd & {no_ref_r,
                                                yes_ref_r}));
  assign root_choose_r = root_pass_r;
  
  /* togo (Ty Root) : (no_ref,Root) > (no_go,Go) */
  assign no_go_d = no_ref_d[0];
  assign no_ref_r = no_go_r;
  
  /* const (Ty Word#,Lit 1) : (no_go,Go) > (no_chase,Word#) */
  assign no_chase_d = {{WORD_MSB-1{1'b0}}, 1'd1, no_go_d[0]};
  assign no_go_r = no_chase_r;
  
  /* destruct (Ty Root,
          Dcon YesRef) : (yes_ref,Root) > [(chase_ref,Pointer)] */
  assign chase_ref_d = {yes_ref_d[ROOT_MSB:2], yes_ref_d[0]};
  assign yes_ref_r = chase_ref_r;
  
  /* sink (Ty Pointer) : (chase_ref,Pointer) > */
  assign {chase_ref_r, chase_ref_dout} = {chase_ref_rout,
                                          chase_ref_d};
  
  /* source (Ty Go) : > (add_done,Go) */
  
  /* const (Ty Word#,Lit 1) : (add_done,Go) > (chase_done,Word#) */
  assign chase_done_d = {{WORD_MSB-1{1'd0}}, 1'd1, add_done_d[0]};
  assign add_done_r = chase_done_r;
  
  /* merge (Ty Word#) : [(no_chase,Word#),
                      (chase_done,Word#),
                      (reset_num,Word#)] > (update_count,Word#) */
  logic [2:0] update_count_selected;
  logic [2:0] update_count_select;
  initial update_count_select = 3'd0;
  always_comb
    begin
      update_count_selected = 3'd0;
      if ((| update_count_select))
        update_count_selected = update_count_select;
      else
        if (no_chase_d[0]) update_count_selected[0] = 1'd1;
        else if (chase_done_d[0]) update_count_selected[1] = 1'd1;
        else if (reset_num_d[0]) update_count_selected[2] = 1'd1;
    end
  always_ff @(posedge clk)
    update_count_select <= (update_count_r ? 3'd0 :
                            update_count_selected);
  always_comb
    if (update_count_selected[0]) update_count_d = no_chase_d;
    else if (update_count_selected[1]) update_count_d = chase_done_d;
    else if (update_count_selected[2]) update_count_d = reset_num_d;
    else update_count_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign {reset_num_r,
          chase_done_r,
          no_chase_r} = (update_count_r ? update_count_selected :
                         3'd0);
  
  /* op_add (Ty Word#) : (update_count,Word#) (root_buf,Word#) > (root_count,Word#) */
  assign root_count_d = {(update_count_d[WORD_MSB:1] + root_buf_d[WORD_MSB:1]),
                         (update_count_d[0] && root_buf_d[0])};
  assign {update_count_r,
          root_buf_r} = {2 {(root_count_r && root_count_d[0])}};
  
  /* fork (Ty Word#) : (root_count,Word#) > [(root_use,Word#),
                                            (root_loop,Word#)] */
  logic [1:0] root_count_emitted;
  initial root_count_emitted = 2'd0;
  logic [1:0] root_count_done;
  assign root_use_d = {root_count_d[WORD_MSB:1],
                       (root_count_d[0] && (! root_count_emitted[0]))};
  assign root_loop_d = {root_count_d[WORD_MSB:1],
                        (root_count_d[0] && (! root_count_emitted[1]))};
  assign root_count_done = (root_count_emitted | ({root_loop_d[0],
                                                   root_use_d[0]} & {root_loop_r, root_use_r}));
  assign root_count_r = (& root_count_done);
  always_ff @(posedge clk)
    root_count_emitted <= (root_count_r ? 2'd0 :
                           root_count_done);
  
  /* initibuf (Ty Word#,
          Lit 0) : (root_loop,Word#) > (root_init,Word#) */
  initial root_init_d = {{WORD_MSB{1'd0}}, 1'd1};
  assign root_loop_r = ((! root_init_d[0]) || root_init_r);
  always_ff @(posedge clk)
    if (root_loop_r) root_init_d <= root_loop_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((root_init_d[0] && (! root_init_r)))
      $display("%5t blocked: root_init", $time);
  `endif
  
  /* rbuf (Ty Word#) : (root_init,Word#) > (root_buf,Word#) */
  \Word#_t  root_init_buf;
  initial root_init_buf = {{WORD_MSB{1'bx}}, 1'd0};
  assign root_init_r = (! root_init_buf[0]);
  assign root_buf_d = (root_init_buf[0] ? root_init_buf :
                       root_init_d);
  always_ff @(posedge clk)
    if ((root_buf_r && root_init_buf[0]))
      root_init_buf <= {{WORD_MSB{1'bx}}, 1'd0};
    else if (((! root_buf_r) && (! root_init_buf[0])))
      root_init_buf <= root_init_d;
  
  /* buf (Ty Word#) : (num_roots,Word#) > (num_in,Word#) */
  \Word#_t  num_roots_bufchan_d;
  logic num_roots_bufchan_r;
  \Word#_t  num_roots_buf;
  initial num_roots_buf = {{WORD_MSB{1'bx}}, 1'd0};
  assign num_roots_r = (! num_roots_buf[0]);
  assign num_roots_bufchan_d = (num_roots_buf[0] ? num_roots_buf :
                                num_roots_d);
  always_ff @(posedge clk)
    if ((num_roots_bufchan_r && num_roots_buf[0]))
      num_roots_buf <= {{WORD_MSB{1'bx}}, 1'd0};
    else if (((! num_roots_bufchan_r) && (! num_roots_buf[0])))
      num_roots_buf <= num_roots_d;
  initial num_in_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign num_roots_bufchan_r = ((! num_in_d[0]) || num_in_r);
  always_ff @(posedge clk)
    if (num_roots_bufchan_r) num_in_d <= num_roots_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((num_in_d[0] && (! num_in_r)))
      $display("%5t blocked: num_in", $time);
  `endif
  
  /* fork (Ty Word#) : (num_in,Word#) > [(num_comp,Word#),
                                        (num_reset,Word#)] */
  logic [1:0] num_in_emitted;
  initial num_in_emitted = 2'd0;
  logic [1:0] num_in_done;
  assign num_comp_d = {num_in_d[WORD_MSB:1],
                       (num_in_d[0] && (! num_in_emitted[0]))};
  assign num_reset_d = {num_in_d[WORD_MSB:1],
                        (num_in_d[0] && (! num_in_emitted[1]))};
  assign num_in_done = (num_in_emitted | ({num_reset_d[0],
                                           num_comp_d[0]} & {num_reset_r, num_comp_r}));
  assign num_in_r = (& num_in_done);
  always_ff @(posedge clk)
    num_in_emitted <= (num_in_r ? 2'd0 :
                       num_in_done);
  
  /* merge (Ty Word#) : [(num_comp,Word#),
                      (num_comp_buf,Word#)] > (num_merge_out,Word#) */
  logic [1:0] num_merge_out_selected;
  logic [1:0] num_merge_out_select;
  initial num_merge_out_select = 2'd0;
  always_comb
    begin
      num_merge_out_selected = 2'd0;
      if ((| num_merge_out_select))
        num_merge_out_selected = num_merge_out_select;
      else
        if (num_comp_d[0]) num_merge_out_selected[0] = 1'd1;
        else if (num_comp_buf_d[0]) num_merge_out_selected[1] = 1'd1;
    end
  always_ff @(posedge clk)
    num_merge_out_select <= (num_merge_out_r ? 2'd0 :
                             num_merge_out_selected);
  always_comb
    if (num_merge_out_selected[0]) num_merge_out_d = num_comp_d;
    else if (num_merge_out_selected[1])
      num_merge_out_d = num_comp_buf_d;
    else num_merge_out_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign {num_comp_buf_r,
          num_comp_r} = (num_merge_out_r ? num_merge_out_selected :
                         2'd0);
  
  /* fork (Ty Word#) : (num_merge_out,Word#) > [(num_comp_use,Word#),
                                               (num_comp_loop,Word#)] */
  logic [1:0] num_merge_out_emitted;
  initial num_merge_out_emitted = 2'd0;
  logic [1:0] num_merge_out_done;
  assign num_comp_use_d = {num_merge_out_d[WORD_MSB:1],
                           (num_merge_out_d[0] && (! num_merge_out_emitted[0]))};
  assign num_comp_loop_d = {num_merge_out_d[WORD_MSB:1],
                            (num_merge_out_d[0] && (! num_merge_out_emitted[1]))};
  assign num_merge_out_done = (num_merge_out_emitted | ({num_comp_loop_d[0],
                                                         num_comp_use_d[0]} & {num_comp_loop_r,
                                                                               num_comp_use_r}));
  assign num_merge_out_r = (& num_merge_out_done);
  always_ff @(posedge clk)
    num_merge_out_emitted <= (num_merge_out_r ? 2'd0 :
                              num_merge_out_done);
  
  /* buf (Ty Word#) : (num_comp_loop,Word#) > (num_comp_buf,Word#) */
  \Word#_t  num_comp_loop_bufchan_d;
  logic num_comp_loop_bufchan_r;
  \Word#_t  num_comp_loop_buf;
  initial num_comp_loop_buf = {{WORD_MSB{1'bx}}, 1'd0};
  assign num_comp_loop_r = (! num_comp_loop_buf[0]);
  assign num_comp_loop_bufchan_d = (num_comp_loop_buf[0] ? num_comp_loop_buf :
                                    num_comp_loop_d);
  always_ff @(posedge clk)
    if ((num_comp_loop_bufchan_r && num_comp_loop_buf[0]))
      num_comp_loop_buf <= {{WORD_MSB{1'bx}}, 1'd0};
    else if (((! num_comp_loop_bufchan_r) && (! num_comp_loop_buf[0])))
      num_comp_loop_buf <= num_comp_loop_d;
  initial num_comp_buf_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign num_comp_loop_bufchan_r = ((! num_comp_buf_d[0]) || num_comp_buf_r);
  always_ff @(posedge clk)
    if (num_comp_loop_bufchan_r)
      num_comp_buf_d <= num_comp_loop_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((num_comp_buf_d[0] && (! num_comp_buf_r)))
      $display("%5t blocked: num_comp_buf", $time);
  `endif
  
  /* op_eq (Ty Word#) : (num_comp_use,Word#) (root_use,Word#) > (done_roots,Tog) */
  assign done_roots_d = {(num_comp_use_d[WORD_MSB:1] == root_use_d[WORD_MSB:1]),
                         (num_comp_use_d[0] && root_use_d[0])};
  assign {num_comp_use_r,
          root_use_r} = {2 {(done_roots_r && done_roots_d[0])}};
  
  /* fork (Ty Tog) : (done_roots,Tog) > [(done_roots_pass,Tog),
                                    (done_roots_choose,Tog)] */
  logic [1:0] done_roots_emitted;
  initial done_roots_emitted = 2'd0;
  logic [1:0] done_roots_done;
  assign done_roots_pass_d = {done_roots_d[1:1],
                              (done_roots_d[0] && (! done_roots_emitted[0]))};
  assign done_roots_choose_d = {done_roots_d[1:1],
                                (done_roots_d[0] && (! done_roots_emitted[1]))};
  assign done_roots_done = (done_roots_emitted | ({done_roots_choose_d[0],
                                                   done_roots_pass_d[0]} & {done_roots_choose_r,
                                                                            done_roots_pass_r}));
  assign done_roots_r = (& done_roots_done);
  always_ff @(posedge clk)
    done_roots_emitted <= (done_roots_r ? 2'd0 :
                           done_roots_done);
  
  /* demux (Ty Tog,
       Ty Tog) : (done_roots_choose,Tog) (done_roots_pass,Tog) > [(count_neq,Tog),
                                                                  (count_eq,Tog)] */
  logic [1:0] done_roots_pass_onehotd;
  always_comb
    if ((done_roots_choose_d[0] && done_roots_pass_d[0]))
      unique case (done_roots_choose_d[1:1])
        1'd0: done_roots_pass_onehotd = 2'd1;
        1'd1: done_roots_pass_onehotd = 2'd2;
        default: done_roots_pass_onehotd = 2'bx;
      endcase
    else done_roots_pass_onehotd = 2'd0;
  assign count_neq_d = {done_roots_pass_d[1:1],
                        done_roots_pass_onehotd[0]};
  assign count_eq_d = {done_roots_pass_d[1:1],
                       done_roots_pass_onehotd[1]};
  assign done_roots_pass_r = (| (done_roots_pass_onehotd & {count_eq_r,
                                                            count_neq_r}));
  assign done_roots_choose_r = done_roots_pass_r;
  
  /* togo (Ty Tog) : (count_eq,Tog) > (end_mark,Go) */
  assign end_mark_d = count_eq_d[0];
  assign count_eq_r = end_mark_r;
  
  /* merge (Ty Word#) : [(num_reset,Word#),
                      (reset_buf,Word#)] > (reset_merge_out,Word#) */
  logic [1:0] reset_merge_out_selected;
  logic [1:0] reset_merge_out_select;
  initial reset_merge_out_select = 2'd0;
  always_comb
    begin
      reset_merge_out_selected = 2'd0;
      if ((| reset_merge_out_select))
        reset_merge_out_selected = reset_merge_out_select;
      else
        if (num_reset_d[0]) reset_merge_out_selected[0] = 1'd1;
        else if (reset_buf_d[0]) reset_merge_out_selected[1] = 1'd1;
    end
  always_ff @(posedge clk)
    reset_merge_out_select <= (reset_merge_out_r ? 2'd0 :
                               reset_merge_out_selected);
  always_comb
    if (reset_merge_out_selected[0]) reset_merge_out_d = num_reset_d;
    else if (reset_merge_out_selected[1])
      reset_merge_out_d = reset_buf_d;
    else reset_merge_out_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign {reset_buf_r,
          num_reset_r} = (reset_merge_out_r ? reset_merge_out_selected :
                          2'd0);
  
  /* mux (Ty Go,
     Ty Word#) : (start_mark,Go) [(reset_merge_out,Word#)] > (reset_pass,Word#) */
  assign reset_pass_d = {reset_merge_out_d[WORD_MSB:1],
                         (start_mark_d[0] && reset_merge_out_d[0])};
  assign reset_merge_out_r = (reset_pass_r && (start_mark_d[0] && reset_merge_out_d[0]));
  assign start_mark_r = (reset_pass_r && (start_mark_d[0] && reset_merge_out_d[0]));
  
  /* fork (Ty Word#) : (reset_pass,Word#) > [(reset_loop,Word#),
                                            (reset_use,Word#)] */
  logic [1:0] reset_pass_emitted;
  initial reset_pass_emitted = 2'd0;
  logic [1:0] reset_pass_done;
  assign reset_loop_d = {reset_pass_d[WORD_MSB:1],
                         (reset_pass_d[0] && (! reset_pass_emitted[0]))};
  assign reset_use_d = {reset_pass_d[WORD_MSB:1],
                        (reset_pass_d[0] && (! reset_pass_emitted[1]))};
  assign reset_pass_done = (reset_pass_emitted | ({reset_use_d[0],
                                                   reset_loop_d[0]} & {reset_use_r, reset_loop_r}));
  assign reset_pass_r = (& reset_pass_done);
  always_ff @(posedge clk)
    reset_pass_emitted <= (reset_pass_r ? 2'd0 :
                           reset_pass_done);
  
  /* buf (Ty Word#) : (reset_loop,Word#) > (reset_buf,Word#) */
  \Word#_t  reset_loop_bufchan_d;
  logic reset_loop_bufchan_r;
  \Word#_t  reset_loop_buf;
  initial reset_loop_buf = {{WORD_MSB{1'bx}}, 1'd0};
  assign reset_loop_r = (! reset_loop_buf[0]);
  assign reset_loop_bufchan_d = (reset_loop_buf[0] ? reset_loop_buf :
                                 reset_loop_d);
  always_ff @(posedge clk)
    if ((reset_loop_bufchan_r && reset_loop_buf[0]))
      reset_loop_buf <= {{WORD_MSB{1'bx}}, 1'd0};
    else if (((! reset_loop_bufchan_r) && (! reset_loop_buf[0])))
      reset_loop_buf <= reset_loop_d;
  initial reset_buf_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign reset_loop_bufchan_r = ((! reset_buf_d[0]) || reset_buf_r);
  always_ff @(posedge clk)
    if (reset_loop_bufchan_r) reset_buf_d <= reset_loop_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((reset_buf_d[0] && (! reset_buf_r)))
      $display("%5t blocked: reset_buf", $time);
  `endif
  
  /* initibuf (Ty Word#,
          Lit 0) : (zero_buf,Word#) > (zero_init,Word#) */
   initial zero_init_d = {{WORD_MSB{1'd0}}, 1'd1};
  assign zero_buf_r = ((! zero_init_d[0]) || zero_init_r);
  always_ff @(posedge clk)
    if (zero_buf_r) zero_init_d <= zero_buf_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((zero_init_d[0] && (! zero_init_r)))
      $display("%5t blocked: zero_init", $time);
  `endif
  
  /* fork (Ty Word#) : (zero_init,Word#) > [(zero,Word#),
                                           (zero_loop,Word#)] */
  logic [1:0] zero_init_emitted;
  initial zero_init_emitted = 2'd0;
  logic [1:0] zero_init_done;
  assign zero_d = {zero_init_d[WORD_MSB:1],
                   (zero_init_d[0] && (! zero_init_emitted[0]))};
  assign zero_loop_d = {zero_init_d[WORD_MSB:1],
                        (zero_init_d[0] && (! zero_init_emitted[1]))};
  assign zero_init_done = (zero_init_emitted | ({zero_loop_d[0],
                                                 zero_d[0]} & {zero_loop_r, zero_r}));
  assign zero_init_r = (& zero_init_done);
  always_ff @(posedge clk)
    zero_init_emitted <= (zero_init_r ? 2'd0 :
                          zero_init_done);
  
  /* rbuf (Ty Word#) : (zero_loop,Word#) > (zero_buf,Word#) */
  \Word#_t  zero_loop_buf;
  initial zero_loop_buf = {{WORD_MSB{1'bx}}, 1'd0};
  assign zero_loop_r = (! zero_loop_buf[0]);
  assign zero_buf_d = (zero_loop_buf[0] ? zero_loop_buf :
                       zero_loop_d);
  always_ff @(posedge clk)
    if ((zero_buf_r && zero_loop_buf[0]))
      zero_loop_buf <= {{WORD_MSB{1'bx}}, 1'd0};
    else if (((! zero_buf_r) && (! zero_loop_buf[0])))
      zero_loop_buf <= zero_loop_d;
  
  /* op_sub (Ty Word#) : (zero,Word#) (reset_use,Word#) > (reset,Word#) */
  assign reset_d = {(zero_d[WORD_MSB:1] - reset_use_d[WORD_MSB:1]),
                    (zero_d[0] && reset_use_d[0])};
  assign {zero_r, reset_use_r} = {2 {(reset_r && reset_d[0])}};
  
  /* buf (Ty Word#) : (reset,Word#) > (reset_num,Word#) */
  \Word#_t  reset_bufchan_d;
  logic reset_bufchan_r;
  \Word#_t  reset_buf;
  initial reset_buf = {{WORD_MSB{1'bx}}, 1'd0};
  assign reset_r = (! reset_buf[0]);
  assign reset_bufchan_d = (reset_buf[0] ? reset_buf :
                            reset_d);
  always_ff @(posedge clk)
    if ((reset_bufchan_r && reset_buf[0])) reset_buf <= {{WORD_MSB{1'bx}}, 1'd0};
    else if (((! reset_bufchan_r) && (! reset_buf[0])))
      reset_buf <= reset_d;
  initial reset_num_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign reset_bufchan_r = ((! reset_num_d[0]) || reset_num_r);
  always_ff @(posedge clk)
    if (reset_bufchan_r) reset_num_d <= reset_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((reset_num_d[0] && (! reset_num_r)))
      $display("%5t blocked: reset_num", $time);
  `endif
  
  /* sink (Ty Go) : (end_mark,Go) > */
  assign {end_mark_r, end_mark_dout} = {end_mark_rout, end_mark_d};
  
  /* Lack-of-progress detector */
  `ifdef CHECK_PROGRESS
  logic [9:0] bufferedChannelValids;
  logic [9:0] bufferedChannelReadys;
  logic [9:0] last1BufferedChannelValids;
  logic [9:0] last1BufferedChannelReadys;
  logic [9:0] last2BufferedChannelValids;
  logic [9:0] last2BufferedChannelReadys;
  initial last1BufferedChannelValids = 10'd0;
  initial last1BufferedChannelReadys = 10'd0;
  initial last2BufferedChannelValids = 10'd1;
  initial last2BufferedChannelReadys = 10'd1;
  assign bufferedChannelValids = {init_start_d[0],
                                  root_gate_d[0],
                                  root_init_d[0],
                                  root_buf_d[0],
                                  num_in_d[0],
                                  num_comp_buf_d[0],
                                  reset_buf_d[0],
                                  zero_init_d[0],
                                  zero_buf_d[0],
                                  reset_num_d[0]};
  assign bufferedChannelReadys = {init_start_r,
                                  root_gate_r,
                                  root_init_r,
                                  root_buf_r,
                                  num_in_r,
                                  num_comp_buf_r,
                                  reset_buf_r,
                                  zero_init_r,
                                  zero_buf_r,
                                  reset_num_r};
  always_ff @(posedge clk)
    begin
      last1BufferedChannelValids <= bufferedChannelValids;
      last1BufferedChannelReadys <= bufferedChannelReadys;
      last2BufferedChannelValids <= last1BufferedChannelValids;
      last2BufferedChannelReadys <= last1BufferedChannelReadys;
      if (((((last2BufferedChannelValids == last1BufferedChannelValids) && (last1BufferedChannelValids == bufferedChannelValids)) && (last2BufferedChannelReadys == last1BufferedChannelReadys)) && (last1BufferedChannelReadys == bufferedChannelReadys)))
        begin
          $display("%6t no progress", $time);
          $display(" valids %b", last2BufferedChannelValids);
          $display(" readys %b", last2BufferedChannelReadys);
          $display(" valids %b", last1BufferedChannelValids);
          $display(" readys %b", last1BufferedChannelReadys);
          $display(" valids %b", bufferedChannelValids);
          $display(" readys %b", bufferedChannelReadys);
          if ((init_start_d[0] && (! init_start_r)))
            $display(" blocked init_start");
          if ((root_gate_d[0] && (! root_gate_r)))
            $display(" blocked root_gate");
          if ((root_init_d[0] && (! root_init_r)))
            $display(" blocked root_init");
          if ((root_buf_d[0] && (! root_buf_r)))
            $display(" blocked root_buf");
          if ((num_in_d[0] && (! num_in_r))) $display(" blocked num_in");
          if ((num_comp_buf_d[0] && (! num_comp_buf_r)))
            $display(" blocked num_comp_buf");
          if ((reset_buf_d[0] && (! reset_buf_r)))
            $display(" blocked reset_buf");
          if ((zero_init_d[0] && (! zero_init_r)))
            $display(" blocked zero_init");
          if ((zero_buf_d[0] && (! zero_buf_r)))
            $display(" blocked zero_buf");
          if ((reset_num_d[0] && (! reset_num_r)))
            $display(" blocked reset_num");
          $finish();
        end
    end
  `endif
  /* Wake Node Reporting */
  `ifdef WAKE_REPORT
  /* wake init_start:initbuf */
  /* wake root_gate:rbuf */
  /* wake root_in:mux */
  /* wake root_count:add */
  /* wake root_init:initibuf */
  /* wake root_buf:rbuf */
  /* wake num_in:buf */
  /* wake num_comp_buf:buf */
  /* wake done_roots:eq */
  /* wake reset_pass:mux */
  /* wake reset_buf:buf */
  /* wake zero_init:initibuf */
  /* wake zero_buf:rbuf */
  /* wake reset:sub */
  /* wake reset_num:buf */
  always_ff @(posedge clk)
    $display("wake %b", {(init_start_d[0] || pass_go_d[0]),
                         (root_gate_d[0] || init_start_d[0]),
                         root_in_d[0],
                         root_count_d[0],
                         (root_init_d[0] || root_loop_d[0]),
                         (root_buf_d[0] || root_init_d[0]),
                         (num_in_d[0] || (num_roots_d[0] || num_roots_bufchan_d[0])),
                         (num_comp_buf_d[0] || (num_comp_loop_d[0] || num_comp_loop_bufchan_d[0])),
                         done_roots_d[0],
                         reset_pass_d[0],
                         (reset_buf_d[0] || (reset_loop_d[0] || reset_loop_bufchan_d[0])),
                         (zero_init_d[0] || zero_buf_d[0]),
                         (zero_buf_d[0] || zero_loop_d[0]),
                         reset_d[0],
                         (reset_num_d[0] || (reset_d[0] || reset_bufchan_d[0]))});
  `endif
endmodule
