module ListCtrl(
  input logic clk,
  input Go_t freed_d,
  output logic freed_r,
  input GC_Res_t removed_d,
  output logic removed_r,
  input Pointer_t alloc_d,
  output logic alloc_r,
  input Go_t gc_d,
  output logic gc_r,
  input \Word#_t  base_d,
  output logic base_r,
  input \Word#_t  bound_d,
  output logic bound_r,
  input \Word#_t  threshold_d,
  output logic threshold_r,
  output Go_t do_gc_dout,
  input logic do_gc_rout,
  output GC_Cmd_t cmd_dout,
  input logic cmd_rout
  );
  /* --define=INPUTS=((freed, 0, 1, Go), (removed, 19, 524288, GC_Res), (alloc, 16, 65536, Pointer), (gc, 0, 1, Go), (base, 16, 65536, Word__023), (bound, 16, 65536, Word__023), (threshold, 16, 65536, Word__023)) */
  /* --define=TAPS=() */
  /* --define=OUTPUTS=((do_gc, 0, 1, Go), (cmd, 18, 262144, GC_Cmd)) */
  /* TYPE_START
TYPE_END */
  /*  */
  /*  */

   parameter POINTER_BITS = 17;
   parameter NODE_BITS = 34;

   parameter WORD_MSB = POINTER_BITS-1; //16;
   
  \Word#_t  init_d;
  logic init_r;
  \Word#_t  init_use_d;
  logic init_use_r;
  \Word#_t  init_mux_d;
  logic init_mux_r;
  Go_t minus_go_use_d;
  logic minus_go_use_r;
  Go_t minus_go_mux_d;
  logic minus_go_mux_r;
  Go_t freed_use_d;
  logic freed_use_r;
  Go_t freed_mux_d;
  logic freed_mux_r;
  \Word#_t  add_one_d;
  logic add_one_r;
  Go_t minus_go_d;
  logic minus_go_r;
  \Word#_t  minus_one_d;
  logic minus_one_r;
  \Word#_t  update_count_d;
  logic update_count_r;
  \Word#_t  new_count_d;
  logic new_count_r;
  \Word#_t  count_d;
  logic count_r;
  \Word#_t  count_rbuf_d;
  logic count_rbuf_r;
  \Word#_t  count_loop_d;
  logic count_loop_r;
  \Word#_t  count_use_d;
  logic count_use_r;
  Go_t init_go_d;
  logic init_go_r;
  Tog_t tog0_d;
  logic tog0_r;
  Tog_t tog1_d;
  logic tog1_r;
  Tog_t tog2_d;
  logic tog2_r;
  Tog_t keep_d;
  logic keep_r;
  Bool_mem_t _1_d;
  logic _1_r;
  assign _1_r = 1'd1;
  Bool_mem_t pass_d;
  logic pass_r;
  Bool_mem_t at_threshold_d;
  logic at_threshold_r;
  \Word#_t  threshold_init_d;
  logic threshold_init_r;
  \Word#_t  threshold_merge_d;
  logic threshold_merge_r;
  \Word#_t  threshold_use_d;
  logic threshold_use_r;
  \Word#_t  threshold_loop_d;
  logic threshold_loop_r;
  \Word#_t  threshold_buf_d;
  logic threshold_buf_r;
  Bool_mem_t thresh_pass_d;
  logic thresh_pass_r;
  Bool_mem_t thresh_choose_d;
  logic thresh_choose_r;
  Bool_mem_t _0_d;
  logic _0_r;
  assign _0_r = 1'd1;
  Bool_mem_t need_gc_d;
  logic need_gc_r;
  Go_t internal_gc_d;
  logic internal_gc_r;
  Go_t do_gc_d;
  logic do_gc_r;
  GC_Cmd_t cmd_d;
  logic cmd_r;
  
  /* source (Ty Go) : > (freed,Go) */
  
  /* source (Ty GC_Res) : > (removed,GC_Res) */
  
  /* source (Ty Pointer) : > (alloc,Pointer) */
  
  /* source (Ty Go) : > (gc,Go) */
  
  /* source (Ty Word#) : > (base,Word#) */
  
  /* source (Ty Word#) : > (bound,Word#) */
  
  /* source (Ty Word#) : > (threshold,Word#) */
  
  /* op_sub (Ty Word#) : (bound,Word#) (base,Word#) > (init,Word#) */
  assign init_d = {(bound_d[WORD_MSB:1] - base_d[WORD_MSB:1]),
                   (bound_d[0] && base_d[0])};
  assign {bound_r, base_r} = {2 {(init_r && init_d[0])}};
  
  /* fork (Ty Word#) : (init,Word#) > [(init_use,Word#),
                                      (init_mux,Word#)] */
  logic [1:0] init_emitted;
  initial init_emitted = 2'd0;
  logic [1:0] init_done;
  assign init_use_d = {init_d[WORD_MSB:1],
                       (init_d[0] && (! init_emitted[0]))};
  assign init_mux_d = {init_d[WORD_MSB:1],
                       (init_d[0] && (! init_emitted[1]))};
  assign init_done = (init_emitted | ({init_mux_d[0],
                                       init_use_d[0]} & {init_mux_r, init_use_r}));
  assign init_r = (& init_done);
  always_ff @(posedge clk)
    init_emitted <= (init_r ? 2'd0 :
                     init_done);
  
  /* fork (Ty Go) : (minus_go,Go) > [(minus_go_use,Go),
                                (minus_go_mux,Go)] */
  logic [1:0] minus_go_emitted;
  initial minus_go_emitted = 2'd0;
  logic [1:0] minus_go_done;
  assign minus_go_use_d = (minus_go_d[0] && (! minus_go_emitted[0]));
  assign minus_go_mux_d = (minus_go_d[0] && (! minus_go_emitted[1]));
  assign minus_go_done = (minus_go_emitted | ({minus_go_mux_d[0],
                                               minus_go_use_d[0]} & {minus_go_mux_r,
                                                                     minus_go_use_r}));
  assign minus_go_r = (& minus_go_done);
  always_ff @(posedge clk)
    minus_go_emitted <= (minus_go_r ? 2'd0 :
                         minus_go_done);
  
  /* fork (Ty Go) : (freed,Go) > [(freed_use,Go),(freed_mux,Go)] */
  logic [1:0] freed_emitted;
  initial freed_emitted = 2'd0;
  logic [1:0] freed_done;
  assign freed_use_d = (freed_d[0] && (! freed_emitted[0]));
  assign freed_mux_d = (freed_d[0] && (! freed_emitted[1]));
  assign freed_done = (freed_emitted | ({freed_mux_d[0],
                                         freed_use_d[0]} & {freed_mux_r, freed_use_r}));
  assign freed_r = (& freed_done);
  always_ff @(posedge clk)
    freed_emitted <= (freed_r ? 2'd0 :
                      freed_done);
  
  /* const (Ty Word#,Lit 1) : (freed_use,Go) > (add_one,Word#) */
  assign add_one_d = {{WORD_MSB-1{1'd0}}, 1'd1, freed_use_d[0]};
  assign freed_use_r = add_one_r;
  
  /* togo (Ty GC_Res) : (removed,GC_Res) > (minus_go,Go) */
  assign minus_go_d = removed_d[0];
  assign removed_r = minus_go_r;
  
  /* const (Ty Word#,Lit -1) : (minus_go_use,Go) > (minus_one,Word#) */
  assign minus_one_d = {{WORD_MSB{1'd1}}, minus_go_use_d[0]};
  assign minus_go_use_r = minus_one_r;
  
  /* merge (Ty Word#) : [(init_use,Word#),
                      (add_one,Word#),
                      (minus_one,Word#)] > (update_count,Word#) */
  logic [2:0] update_count_selected;
  logic [2:0] update_count_select;
  initial update_count_select = 3'd0;
  always_comb
    begin
      update_count_selected = 3'd0;
      if ((| update_count_select))
        update_count_selected = update_count_select;
      else
        if (init_use_d[0]) update_count_selected[0] = 1'd1;
        else if (add_one_d[0]) update_count_selected[1] = 1'd1;
        else if (minus_one_d[0]) update_count_selected[2] = 1'd1;
    end
  always_ff @(posedge clk)
    update_count_select <= (update_count_r ? 3'd0 :
                            update_count_selected);
  always_comb
    if (update_count_selected[0]) update_count_d = init_use_d;
    else if (update_count_selected[1]) update_count_d = add_one_d;
    else if (update_count_selected[2]) update_count_d = minus_one_d;
    else update_count_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign {minus_one_r,
          add_one_r,
          init_use_r} = (update_count_r ? update_count_selected :
                         3'd0);
  
  /* op_add (Ty Word#) : (update_count,Word#) (count,Word#) > (new_count,Word#) */
  assign new_count_d = {(update_count_d[WORD_MSB:1] + count_d[WORD_MSB:1]),
                        (update_count_d[0] && count_d[0])};
  assign {update_count_r,
          count_r} = {2 {(new_count_r && new_count_d[0])}};
  
  /* initibuf (Ty Word#,
          Lit 0) : (count_rbuf,Word#) > (count,Word#) */
  initial count_d = {{WORD_MSB{1'd0}}, 1'd1};
  assign count_rbuf_r = ((! count_d[0]) || count_r);
  always_ff @(posedge clk)
    if (count_rbuf_r) count_d <= count_rbuf_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((count_d[0] && (! count_r)))
      $display("%5t blocked: count", $time);
  `endif
  
  /* rbuf (Ty Word#) : (count_loop,Word#) > (count_rbuf,Word#) */
  \Word#_t  count_loop_buf;
  initial count_loop_buf = {{WORD_MSB{1'bx}}, 1'd0};
  assign count_loop_r = (! count_loop_buf[0]);
  assign count_rbuf_d = (count_loop_buf[0] ? count_loop_buf :
                         count_loop_d);
  always_ff @(posedge clk)
    if ((count_rbuf_r && count_loop_buf[0]))
      count_loop_buf <= {{WORD_MSB{1'bx}}, 1'd0};
    else if (((! count_rbuf_r) && (! count_loop_buf[0])))
      count_loop_buf <= count_loop_d;
  
  /* fork (Ty Word#) : (new_count,Word#) > [(count_loop,Word#),
                                           (count_use,Word#)] */
  logic [1:0] new_count_emitted;
  initial new_count_emitted = 2'd0;
  logic [1:0] new_count_done;
  assign count_loop_d = {new_count_d[WORD_MSB:1],
                         (new_count_d[0] && (! new_count_emitted[0]))};
  assign count_use_d = {new_count_d[WORD_MSB:1],
                        (new_count_d[0] && (! new_count_emitted[1]))};
  assign new_count_done = (new_count_emitted | ({count_use_d[0],
                                                 count_loop_d[0]} & {count_use_r, count_loop_r}));
  assign new_count_r = (& new_count_done);
  always_ff @(posedge clk)
    new_count_emitted <= (new_count_r ? 2'd0 :
                          new_count_done);
  
  /* togo (Ty Word#) : (init_mux,Word#) > (init_go,Go) */
  assign init_go_d = init_mux_d[0];
  assign init_mux_r = init_go_r;
  
  /* dcon (Ty Tog,Dcon Zero) : [(init_go,Go)] > (tog0,Tog) */
  assign tog0_d = Zero_dc((& {init_go_d[0]}), init_go_d);
  assign {init_go_r} = {1 {(tog0_r && tog0_d[0])}};
  
  /* dcon (Ty Tog,Dcon Zero) : [(freed_mux,Go)] > (tog1,Tog) */
  assign tog1_d = Zero_dc((& {freed_mux_d[0]}), freed_mux_d);
  assign {freed_mux_r} = {1 {(tog1_r && tog1_d[0])}};
  
  /* dcon (Ty Tog,Dcon One) : [(minus_go_mux,Go)] > (tog2,Tog) */
  assign tog2_d = One_dc((& {minus_go_mux_d[0]}), minus_go_mux_d);
  assign {minus_go_mux_r} = {1 {(tog2_r && tog2_d[0])}};
  
  /* merge (Ty Tog) : [(tog0,Tog),(tog1,Tog),(tog2,Tog)] > (keep,Tog) */
  logic [2:0] keep_selected;
  logic [2:0] keep_select;
  initial keep_select = 3'd0;
  always_comb
    begin
      keep_selected = 3'd0;
      if ((| keep_select)) keep_selected = keep_select;
      else
        if (tog0_d[0]) keep_selected[0] = 1'd1;
        else if (tog1_d[0]) keep_selected[1] = 1'd1;
        else if (tog2_d[0]) keep_selected[2] = 1'd1;
    end
  always_ff @(posedge clk)
    keep_select <= (keep_r ? 3'd0 :
                    keep_selected);
  always_comb
    if (keep_selected[0]) keep_d = tog0_d;
    else if (keep_selected[1]) keep_d = tog1_d;
    else if (keep_selected[2]) keep_d = tog2_d;
    else keep_d = {1'bx, 1'd0};
  assign {tog2_r, tog1_r, tog0_r} = (keep_r ? keep_selected :
                                     3'd0);
  
  /* demux (Ty Tog,
       Ty Bool_mem) : (keep,Tog) (at_threshold,Bool_mem) > [(_1,Bool_mem),(pass,Bool_mem)] */
  logic [1:0] at_threshold_onehotd;
  always_comb
    if ((keep_d[0] && at_threshold_d[0]))
      unique case (keep_d[1:1])
        1'd0: at_threshold_onehotd = 2'd1;
        1'd1: at_threshold_onehotd = 2'd2;
        default: at_threshold_onehotd = 2'bx;
      endcase
    else at_threshold_onehotd = 2'd0;
  assign _1_d = {at_threshold_d[1:1], at_threshold_onehotd[0]};
  assign pass_d = {at_threshold_d[1:1], at_threshold_onehotd[1]};
  assign at_threshold_r = (| (at_threshold_onehotd & {pass_r,
                                                      _1_r}));
  assign keep_r = at_threshold_r;
  
  /* op_lteq (Ty Word#) : (count_use,Word#) (threshold_use,Word#) > (at_threshold,Bool_mem) */
  assign at_threshold_d = {(count_use_d[WORD_MSB:1] <= threshold_use_d[WORD_MSB:1]),
                           (count_use_d[0] && threshold_use_d[0])};
  assign {count_use_r,
          threshold_use_r} = {2 {(at_threshold_r && at_threshold_d[0])}};
  
  /* buf (Ty Word#) : (threshold,Word#) > (threshold_init,Word#) */
  \Word#_t  threshold_bufchan_d;
  logic threshold_bufchan_r;
  \Word#_t  threshold_buf;
  initial threshold_buf = {{WORD_MSB{1'bx}}, 1'd0};
  assign threshold_r = (! threshold_buf[0]);
  assign threshold_bufchan_d = (threshold_buf[0] ? threshold_buf :
                                threshold_d);
  always_ff @(posedge clk)
    if ((threshold_bufchan_r && threshold_buf[0]))
      threshold_buf <= {{WORD_MSB{1'bx}}, 1'd0};
    else if (((! threshold_bufchan_r) && (! threshold_buf[0])))
      threshold_buf <= threshold_d;
  initial threshold_init_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign threshold_bufchan_r = ((! threshold_init_d[0]) || threshold_init_r);
  always_ff @(posedge clk)
    if (threshold_bufchan_r) threshold_init_d <= threshold_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((threshold_init_d[0] && (! threshold_init_r)))
      $display("%5t blocked: threshold_init", $time);
  `endif
  
  /* merge (Ty Word#) : [(threshold_init,Word#),
                      (threshold_buf,Word#)] > (threshold_merge,Word#) */
  logic [1:0] threshold_merge_selected;
  logic [1:0] threshold_merge_select;
  initial threshold_merge_select = 2'd0;
  always_comb
    begin
      threshold_merge_selected = 2'd0;
      if ((| threshold_merge_select))
        threshold_merge_selected = threshold_merge_select;
      else
        if (threshold_init_d[0]) threshold_merge_selected[0] = 1'd1;
        else if (threshold_buf_d[0]) threshold_merge_selected[1] = 1'd1;
    end
  always_ff @(posedge clk)
    threshold_merge_select <= (threshold_merge_r ? 2'd0 :
                               threshold_merge_selected);
  always_comb
    if (threshold_merge_selected[0])
      threshold_merge_d = threshold_init_d;
    else if (threshold_merge_selected[1])
      threshold_merge_d = threshold_buf_d;
    else threshold_merge_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign {threshold_buf_r,
          threshold_init_r} = (threshold_merge_r ? threshold_merge_selected :
                               2'd0);
  
  /* fork (Ty Word#) : (threshold_merge,Word#) > [(threshold_use,Word#),
                                                 (threshold_loop,Word#)] */
  logic [1:0] threshold_merge_emitted;
  initial threshold_merge_emitted = 2'd0;
  logic [1:0] threshold_merge_done;
  assign threshold_use_d = {threshold_merge_d[WORD_MSB:1],
                            (threshold_merge_d[0] && (! threshold_merge_emitted[0]))};
  assign threshold_loop_d = {threshold_merge_d[WORD_MSB:1],
                             (threshold_merge_d[0] && (! threshold_merge_emitted[1]))};
  assign threshold_merge_done = (threshold_merge_emitted | ({threshold_loop_d[0],
                                                             threshold_use_d[0]} & {threshold_loop_r,
                                                                                    threshold_use_r}));
  assign threshold_merge_r = (& threshold_merge_done);
  always_ff @(posedge clk)
    threshold_merge_emitted <= (threshold_merge_r ? 2'd0 :
                                threshold_merge_done);
  
  /* buf (Ty Word#) : (threshold_loop,Word#) > (threshold_buf,Word#) */
  \Word#_t  threshold_loop_bufchan_d;
  logic threshold_loop_bufchan_r;
  \Word#_t  threshold_loop_buf;
  initial threshold_loop_buf = {{WORD_MSB{1'bx}}, 1'd0};
  assign threshold_loop_r = (! threshold_loop_buf[0]);
  assign threshold_loop_bufchan_d = (threshold_loop_buf[0] ? threshold_loop_buf :
                                     threshold_loop_d);
  always_ff @(posedge clk)
    if ((threshold_loop_bufchan_r && threshold_loop_buf[0]))
      threshold_loop_buf <= {{WORD_MSB{1'bx}}, 1'd0};
    else if (((! threshold_loop_bufchan_r) && (! threshold_loop_buf[0])))
      threshold_loop_buf <= threshold_loop_d;
  initial threshold_buf_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign threshold_loop_bufchan_r = ((! threshold_buf_d[0]) || threshold_buf_r);
  always_ff @(posedge clk)
    if (threshold_loop_bufchan_r)
      threshold_buf_d <= threshold_loop_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((threshold_buf_d[0] && (! threshold_buf_r)))
      $display("%5t blocked: threshold_buf", $time);
  `endif
  
  /* fork (Ty Bool_mem) : (pass,Bool_mem) > [(thresh_pass,Bool_mem),
                                (thresh_choose,Bool_mem)] */
  logic [1:0] pass_emitted;
  initial pass_emitted = 2'd0;
  logic [1:0] pass_done;
  assign thresh_pass_d = {pass_d[1:1],
                          (pass_d[0] && (! pass_emitted[0]))};
  assign thresh_choose_d = {pass_d[1:1],
                            (pass_d[0] && (! pass_emitted[1]))};
  assign pass_done = (pass_emitted | ({thresh_choose_d[0],
                                       thresh_pass_d[0]} & {thresh_choose_r, thresh_pass_r}));
  assign pass_r = (& pass_done);
  always_ff @(posedge clk)
    pass_emitted <= (pass_r ? 2'd0 :
                     pass_done);
  
  /* demux (Ty Bool_mem,
       Ty Bool_mem) : (thresh_choose,Bool_mem) (thresh_pass,Bool_mem) > [(_0,Bool_mem),
                                                             (need_gc,Bool_mem)] */
  logic [1:0] thresh_pass_onehotd;
  always_comb
    if ((thresh_choose_d[0] && thresh_pass_d[0]))
      unique case (thresh_choose_d[1:1])
        1'd0: thresh_pass_onehotd = 2'd1;
        1'd1: thresh_pass_onehotd = 2'd2;
        default: thresh_pass_onehotd = 2'bx;
      endcase
    else thresh_pass_onehotd = 2'd0;
  assign _0_d = {thresh_pass_d[1:1], thresh_pass_onehotd[0]};
  assign need_gc_d = {thresh_pass_d[1:1], thresh_pass_onehotd[1]};
  assign thresh_pass_r = (| (thresh_pass_onehotd & {need_gc_r,
                                                    _0_r}));
  assign thresh_choose_r = thresh_pass_r;
  
  /* togo (Ty Bool_mem) : (need_gc,Bool_mem) > (internal_gc,Go) */
  assign internal_gc_d = need_gc_d[0];
  assign need_gc_r = internal_gc_r;
  
  /* merge (Ty Go) : [(internal_gc,Go),(gc,Go)] > (do_gc,Go) */
  logic [1:0] do_gc_selected;
  logic [1:0] do_gc_select;
  initial do_gc_select = 2'd0;
  always_comb
    begin
      do_gc_selected = 2'd0;
      if ((| do_gc_select)) do_gc_selected = do_gc_select;
      else
        if (internal_gc_d[0]) do_gc_selected[0] = 1'd1;
        else if (gc_d[0]) do_gc_selected[1] = 1'd1;
    end
  always_ff @(posedge clk)
    do_gc_select <= (do_gc_r ? 2'd0 :
                     do_gc_selected);
  always_comb
    if (do_gc_selected[0]) do_gc_d = internal_gc_d;
    else if (do_gc_selected[1]) do_gc_d = gc_d;
    else do_gc_d = 1'd0;
  assign {gc_r, internal_gc_r} = (do_gc_r ? do_gc_selected :
                                  2'd0);
  
  /* dcon (Ty GC_Cmd,Dcon Freelist) : [(alloc,Pointer)] > (cmd,GC_Cmd) */
  assign cmd_d = Freelist_dc((& {alloc_d[0]}), alloc_d);
  assign {alloc_r} = {1 {(cmd_r && cmd_d[0])}};
  
  /* sink (Ty Go) : (do_gc,Go) > */
  assign {do_gc_r, do_gc_dout} = {do_gc_rout, do_gc_d};
  
  /* sink (Ty GC_Cmd) : (cmd,GC_Cmd) > */
  assign {cmd_r, cmd_dout} = {cmd_rout, cmd_d};
  
  /* Lack-of-progress detector */
  `ifdef CHECK_PROGRESS
  logic [3:0] bufferedChannelValids;
  logic [3:0] bufferedChannelReadys;
  logic [3:0] last1BufferedChannelValids;
  logic [3:0] last1BufferedChannelReadys;
  logic [3:0] last2BufferedChannelValids;
  logic [3:0] last2BufferedChannelReadys;
  initial last1BufferedChannelValids = 4'd0;
  initial last1BufferedChannelReadys = 4'd0;
  initial last2BufferedChannelValids = 4'd1;
  initial last2BufferedChannelReadys = 4'd1;
  assign bufferedChannelValids = {count_d[0],
                                  count_rbuf_d[0],
                                  threshold_init_d[0],
                                  threshold_buf_d[0]};
  assign bufferedChannelReadys = {count_r,
                                  count_rbuf_r,
                                  threshold_init_r,
                                  threshold_buf_r};
  always_ff @(posedge clk)
    begin
      last1BufferedChannelValids <= bufferedChannelValids;
      last1BufferedChannelReadys <= bufferedChannelReadys;
      last2BufferedChannelValids <= last1BufferedChannelValids;
      last2BufferedChannelReadys <= last1BufferedChannelReadys;
      if (((((last2BufferedChannelValids == last1BufferedChannelValids) && (last1BufferedChannelValids == bufferedChannelValids)) && (last2BufferedChannelReadys == last1BufferedChannelReadys)) && (last1BufferedChannelReadys == bufferedChannelReadys)))
        begin
          $display("%6t no progress", $time);
          $display(" valids %b", last2BufferedChannelValids);
          $display(" readys %b", last2BufferedChannelReadys);
          $display(" valids %b", last1BufferedChannelValids);
          $display(" readys %b", last1BufferedChannelReadys);
          $display(" valids %b", bufferedChannelValids);
          $display(" readys %b", bufferedChannelReadys);
          if ((count_d[0] && (! count_r))) $display(" blocked count");
          if ((count_rbuf_d[0] && (! count_rbuf_r)))
            $display(" blocked count_rbuf");
          if ((threshold_init_d[0] && (! threshold_init_r)))
            $display(" blocked threshold_init");
          if ((threshold_buf_d[0] && (! threshold_buf_r)))
            $display(" blocked threshold_buf");
          $finish();
        end
    end
  `endif
  /* Wake Node Reporting */
  `ifdef WAKE_REPORT
  /* wake init:sub */
  /* wake new_count:add */
  /* wake count:initibuf */
  /* wake count_rbuf:rbuf */
  /* wake at_threshold:lteq */
  /* wake threshold_init:buf */
  /* wake threshold_buf:buf */
  always_ff @(posedge clk)
    $display("wake %b", {init_d[0],
                         new_count_d[0],
                         (count_d[0] || count_rbuf_d[0]),
                         (count_rbuf_d[0] || count_loop_d[0]),
                         at_threshold_d[0],
                         (threshold_init_d[0] || (threshold_d[0] || threshold_bufchan_d[0])),
                         (threshold_buf_d[0] || (threshold_loop_d[0] || threshold_loop_bufchan_d[0]))});
  `endif
endmodule
