//`include "Types.sv"

module Init_Bram(
  input logic clk,
  input \Word#_t  start_d,
  output logic start_r,
  input \Word#_t  end_d,
  output logic end_r,
  output \Word#_t  to_free_dout,
  input logic to_free_rout,
  output \Word#_t  true_dout,
  input logic true_rout,
  output Cmd_t cmd_dout,
  input logic cmd_rout
  );
  /* --define=INPUTS=((start, 16, 65536, Word__023), (end, 16, 65536, Word__023)) */
  /* --define=TAPS=() */
  /* --define=OUTPUTS=((to_free, 16, 65536, Word__023), (true, 16, 65536, Word__023), (cmd, 50, 1125899906842624, Cmd)) */
  /* TYPE_START
TYPE_END */
  /*  */
  /*  */

   parameter POINTER_BITS = 17;
   parameter NODE_BITS = 34;

   parameter WORD_MSB = POINTER_BITS-1; //16;
   parameter CMD_MSB = POINTER_BITS+NODE_BITS-1; //50;

  Bool_mem_t comp_init_d;
  logic comp_init_r;
  Bool_mem_t comp0_rbuf_d;
  logic comp0_rbuf_r;
  \Word#_t  save_d;
  logic save_r;
  \Word#_t  use_d;
  logic use_r;
  \Word#_t  save_buf_d;
  logic save_buf_r;
  Bool_mem_t st_d;
  logic st_r;
  Bool_mem_t en_d;
  logic en_r;
  \Word#_t  start_out_d;
  logic start_out_r;
  \Word#_t  false_buf_d;
  logic false_buf_r;
  \Word#_t  end_save_d;
  logic end_save_r;
  \Word#_t  end_use_d;
  logic end_use_r;
  \Word#_t  end_out_d;
  logic end_out_r;
  \Word#_t  add_d;
  logic add_r;
  \Word#_t  c0_d;
  logic c0_r;
  \Word#_t  cmd_addr_d;
  logic cmd_addr_r;
  \Word#_t  end_loop_d;
  logic end_loop_r;
  \Word#_t  c1_d;
  logic c1_r;
  \Word#_t  loop_out_d;
  logic loop_out_r;
  Bool_mem_t comp_out_d;
  logic comp_out_r;
  Bool_mem_t comp_out_buf_d;
  logic comp_out_buf_r;
  Bool_mem_t comp0_d;
  logic comp0_r;
  Bool_mem_t comp1_d;
  logic comp1_r;
  Bool_mem_t comp2_d;
  logic comp2_r;
  \Word#_t  add_out_d;
  logic add_out_r;
  Go_t go1_buf_d;
  logic go1_buf_r;
  \Word#_t  one_d;
  logic one_r;
  Go_t go1_d;
  logic go1_r;
  \Word#_t  add_go_d;
  logic add_go_r;
  \Word#_t  add_one_d;
  logic add_one_r;
  \Word#_t  add_go_init_d;
  logic add_go_init_r;
  \Word#_t  tf_d;
  logic tf_r;
  \Word#_t  tf_buf_d;
  logic tf_buf_r;
  \Word#_t  false_out_d;
  logic false_out_r;
  \Word#_t  true_out_d;
  logic true_out_r;
  \Word#_t  zero_d;
  logic zero_r;
  Go_t go0_d;
  logic go0_r;
  Go_t go0_buf_d;
  logic go0_buf_r;
  Go_t go0_rbuf_d;
  logic go0_rbuf_r;
  \Word#_t  false_cmd_d;
  logic false_cmd_r;
  \Word#_t  false_d;
  logic false_r;
  \Word#_t  false_out_buf_d;
  logic false_out_buf_r;
  Pointer_t ref_d;
  logic ref_r;
  Node_t node_d;
  logic node_r;
  Cmd_t cmd_out_d;
  logic cmd_out_r;
  \Word#_t  cmd_addr_buf_d;
  logic cmd_addr_buf_r;
  Cmd_t cmd_d;
  logic cmd_r;
  Cmd_t cmd_loop_d;
  logic cmd_loop_r;
  \Word#_t  true_d;
  logic true_r;
  \Word#_t  true_go_d;
  logic true_go_r;
  \Word#_t  to_free_d;
  logic to_free_r;
  Go_t end_go_d;
  logic end_go_r;
  
  /* source (Ty Word#) : > (start,Word#) */
  
  /* source (Ty Word#) : > (end,Word#) */
  
  /* initbuf (Ty Bool_mem,Dcon True_mem) : (comp0_rbuf,Bool_mem) > (comp_init,Bool_mem) */
  initial comp_init_d = True_mem_dc(1'd1);
  assign comp0_rbuf_r = ((! comp_init_d[0]) || comp_init_r);
  always_ff @(posedge clk)
    if (comp0_rbuf_r) comp_init_d <= comp0_rbuf_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((comp_init_d[0] && (! comp_init_r)))
      $display("%5t blocked: comp_init", $time);
  `endif
  
  /* rbuf (Ty Bool_mem) : (comp0,Bool_mem) > (comp0_rbuf,Bool_mem) */
  Bool_mem_t comp0_buf;
  initial comp0_buf = {1'bx, 1'd0};
  assign comp0_r = (! comp0_buf[0]);
  assign comp0_rbuf_d = (comp0_buf[0] ? comp0_buf :
                         comp0_d);
  always_ff @(posedge clk)
    if ((comp0_rbuf_r && comp0_buf[0])) comp0_buf <= {1'bx, 1'd0};
    else if (((! comp0_rbuf_r) && (! comp0_buf[0])))
      comp0_buf <= comp0_d;
  
  /* fork (Ty Word#) : (start,Word#) > [(save,Word#),
                                       (use,Word#)] */
  logic [1:0] start_emitted;
  initial start_emitted = 2'd0;
  logic [1:0] start_done;
  assign save_d = {start_d[WORD_MSB:1],
                   (start_d[0] && (! start_emitted[0]))};
  assign use_d = {start_d[WORD_MSB:1],
                  (start_d[0] && (! start_emitted[1]))};
  assign start_done = (start_emitted | ({use_d[0],
                                         save_d[0]} & {use_r, save_r}));
  assign start_r = (& start_done);
  always_ff @(posedge clk)
    start_emitted <= (start_r ? 2'd0 :
                      start_done);
  
  /* buf (Ty Word#) : (save,Word#) > (save_buf,Word#) */
  \Word#_t  save_bufchan_d;
  logic save_bufchan_r;
  \Word#_t  save_buf;
  initial save_buf = {{WORD_MSB{1'bx}}, 1'd0};
  assign save_r = (! save_buf[0]);
  assign save_bufchan_d = (save_buf[0] ? save_buf :
                           save_d);
  always_ff @(posedge clk)
    if ((save_bufchan_r && save_buf[0])) save_buf <= {{WORD_MSB{1'bx}}, 1'd0};
    else if (((! save_bufchan_r) && (! save_buf[0])))
      save_buf <= save_d;
  initial save_buf_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign save_bufchan_r = ((! save_buf_d[0]) || save_buf_r);
  always_ff @(posedge clk)
    if (save_bufchan_r) save_buf_d <= save_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((save_buf_d[0] && (! save_buf_r)))
      $display("%5t blocked: save_buf", $time);
  `endif
  
  /* fork (Ty Bool_mem) : (comp_init,Bool_mem) > [(st,Bool_mem),(en,Bool_mem)] */
  logic [1:0] comp_init_emitted;
  initial comp_init_emitted = 2'd0;
  logic [1:0] comp_init_done;
  assign st_d = {comp_init_d[1:1],
                 (comp_init_d[0] && (! comp_init_emitted[0]))};
  assign en_d = {comp_init_d[1:1],
                 (comp_init_d[0] && (! comp_init_emitted[1]))};
  assign comp_init_done = (comp_init_emitted | ({en_d[0],
                                                 st_d[0]} & {en_r, st_r}));
  assign comp_init_r = (& comp_init_done);
  always_ff @(posedge clk)
    comp_init_emitted <= (comp_init_r ? 2'd0 :
                          comp_init_done);
  
  /* mux (Ty Bool_mem,Ty Word#) : (st,Bool_mem) [(false_buf,Word#),
                                      (use,Word#)] > (start_out,Word#) */
  logic [WORD_MSB:0] start_out_mux;
  logic [1:0] start_out_onehot;
  always_comb
    unique case (st_d[1:1])
      1'd0: {start_out_onehot, start_out_mux} = {2'd1, false_buf_d};
      1'd1: {start_out_onehot, start_out_mux} = {2'd2, use_d};
      default: {start_out_onehot, start_out_mux} = {2'bx, {{WORD_MSB{1'bx}}, 1'd0}};
    endcase
  assign start_out_d = {start_out_mux[WORD_MSB:1],
                        (start_out_mux[0] && st_d[0])};
  assign st_r = (start_out_d[0] && start_out_r);
  assign {use_r, false_buf_r} = (st_r ? start_out_onehot :
                                 2'd0);
  
  /* buf (Ty Word#) : (false,Word#) > (false_buf,Word#) */
  \Word#_t  false_bufchan_d;
  logic false_bufchan_r;
  \Word#_t  false_buf;
  initial false_buf = {{WORD_MSB{1'bx}}, 1'd0};
  assign false_r = (! false_buf[0]);
  assign false_bufchan_d = (false_buf[0] ? false_buf :
                            false_d);
  always_ff @(posedge clk)
    if ((false_bufchan_r && false_buf[0])) false_buf <= {{WORD_MSB{1'bx}}, 1'd0};
    else if (((! false_bufchan_r) && (! false_buf[0])))
      false_buf <= false_d;
  initial false_buf_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign false_bufchan_r = ((! false_buf_d[0]) || false_buf_r);
  always_ff @(posedge clk)
    if (false_bufchan_r) false_buf_d <= false_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((false_buf_d[0] && (! false_buf_r)))
      $display("%5t blocked: false_buf", $time);
  `endif
  
  /* fork (Ty Word#) : (end,Word#) > [(end_save,Word#),
                                     (end_use,Word#)] */
  logic [1:0] end_emitted;
  initial end_emitted = 2'd0;
  logic [1:0] end_done;
  assign end_save_d = {end_d[WORD_MSB:1],
                       (end_d[0] && (! end_emitted[0]))};
  assign end_use_d = {end_d[WORD_MSB:1], (end_d[0] && (! end_emitted[1]))};
  assign end_done = (end_emitted | ({end_use_d[0],
                                     end_save_d[0]} & {end_use_r, end_save_r}));
  assign end_r = (& end_done);
  always_ff @(posedge clk)
    end_emitted <= (end_r ? 2'd0 :
                    end_done);
  
  /* mux (Ty Bool_mem,Ty Word#) : (en,Bool_mem) [(loop_out,Word#),
                                      (end_use,Word#)] > (end_out,Word#) */
  logic [WORD_MSB:0] end_out_mux;
  logic [1:0] end_out_onehot;
  always_comb
    unique case (en_d[1:1])
      1'd0: {end_out_onehot, end_out_mux} = {2'd1, loop_out_d};
      1'd1: {end_out_onehot, end_out_mux} = {2'd2, end_use_d};
      default: {end_out_onehot, end_out_mux} = {2'bx, {{WORD_MSB{1'bx}}, 1'd0}};
    endcase
  assign end_out_d = {end_out_mux[WORD_MSB:1],
                      (end_out_mux[0] && en_d[0])};
  assign en_r = (end_out_d[0] && end_out_r);
  assign {end_use_r, loop_out_r} = (en_r ? end_out_onehot :
                                    2'd0);
  
  /* fork (Ty Word#) : (start_out,Word#) > [(add,Word#),
                                           (c0,Word#),
                                           (cmd_addr,Word#)] */
  logic [2:0] start_out_emitted;
  initial start_out_emitted = 3'd0;
  logic [2:0] start_out_done;
  assign add_d = {start_out_d[WORD_MSB:1],
                  (start_out_d[0] && (! start_out_emitted[0]))};
  assign c0_d = {start_out_d[WORD_MSB:1],
                 (start_out_d[0] && (! start_out_emitted[1]))};
  assign cmd_addr_d = {start_out_d[WORD_MSB:1],
                       (start_out_d[0] && (! start_out_emitted[2]))};
  assign start_out_done = (start_out_emitted | ({cmd_addr_d[0],
                                                 c0_d[0],
                                                 add_d[0]} & {cmd_addr_r, c0_r, add_r}));
  assign start_out_r = (& start_out_done);
  always_ff @(posedge clk)
    start_out_emitted <= (start_out_r ? 3'd0 :
                          start_out_done);
  
  /* fork (Ty Word#) : (end_out,Word#) > [(end_loop,Word#),
                                         (c1,Word#)] */
  logic [1:0] end_out_emitted;
  initial end_out_emitted = 2'd0;
  logic [1:0] end_out_done;
  assign end_loop_d = {end_out_d[WORD_MSB:1],
                       (end_out_d[0] && (! end_out_emitted[0]))};
  assign c1_d = {end_out_d[WORD_MSB:1],
                 (end_out_d[0] && (! end_out_emitted[1]))};
  assign end_out_done = (end_out_emitted | ({c1_d[0],
                                             end_loop_d[0]} & {c1_r, end_loop_r}));
  assign end_out_r = (& end_out_done);
  always_ff @(posedge clk)
    end_out_emitted <= (end_out_r ? 2'd0 :
                        end_out_done);
  
  /* buf (Ty Word#) : (end_loop,Word#) > (loop_out,Word#) */
  \Word#_t  end_loop_bufchan_d;
  logic end_loop_bufchan_r;
  \Word#_t  end_loop_buf;
  initial end_loop_buf = {{WORD_MSB{1'bx}}, 1'd0};
  assign end_loop_r = (! end_loop_buf[0]);
  assign end_loop_bufchan_d = (end_loop_buf[0] ? end_loop_buf :
                               end_loop_d);
  always_ff @(posedge clk)
    if ((end_loop_bufchan_r && end_loop_buf[0]))
      end_loop_buf <= {{WORD_MSB{1'bx}}, 1'd0};
    else if (((! end_loop_bufchan_r) && (! end_loop_buf[0])))
      end_loop_buf <= end_loop_d;
  initial loop_out_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign end_loop_bufchan_r = ((! loop_out_d[0]) || loop_out_r);
  always_ff @(posedge clk)
    if (end_loop_bufchan_r) loop_out_d <= end_loop_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((loop_out_d[0] && (! loop_out_r)))
      $display("%5t blocked: loop_out", $time);
  `endif
  
  /* op_eq (Ty Word#) : (c0,Word#) (c1,Word#) > (comp_out,Bool_mem) */
  assign comp_out_d = {(c0_d[WORD_MSB:1] == c1_d[WORD_MSB:1]),
                       (c0_d[0] && c1_d[0])};
  assign {c0_r, c1_r} = {2 {(comp_out_r && comp_out_d[0])}};
  
  /* buf (Ty Bool_mem) : (comp_out,Bool_mem) > (comp_out_buf,Bool_mem) */
  Bool_mem_t comp_out_bufchan_d;
  logic comp_out_bufchan_r;
  Bool_mem_t comp_out_buf;
  initial comp_out_buf = {1'bx, 1'd0};
  assign comp_out_r = (! comp_out_buf[0]);
  assign comp_out_bufchan_d = (comp_out_buf[0] ? comp_out_buf :
                               comp_out_d);
  always_ff @(posedge clk)
    if ((comp_out_bufchan_r && comp_out_buf[0]))
      comp_out_buf <= {1'bx, 1'd0};
    else if (((! comp_out_bufchan_r) && (! comp_out_buf[0])))
      comp_out_buf <= comp_out_d;
  initial comp_out_buf_d = {1'bx, 1'd0};
  assign comp_out_bufchan_r = ((! comp_out_buf_d[0]) || comp_out_buf_r);
  always_ff @(posedge clk)
    if (comp_out_bufchan_r) comp_out_buf_d <= comp_out_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((comp_out_buf_d[0] && (! comp_out_buf_r)))
      $display("%5t blocked: comp_out_buf", $time);
  `endif
  
  /* fork (Ty Bool_mem) : (comp_out_buf,Bool_mem) > [(comp0,Bool_mem),
                                        (comp1,Bool_mem),
                                        (comp2,Bool_mem)] */
  logic [2:0] comp_out_buf_emitted;
  initial comp_out_buf_emitted = 3'd0;
  logic [2:0] comp_out_buf_done;
  assign comp0_d = {comp_out_buf_d[1:1],
                    (comp_out_buf_d[0] && (! comp_out_buf_emitted[0]))};
  assign comp1_d = {comp_out_buf_d[1:1],
                    (comp_out_buf_d[0] && (! comp_out_buf_emitted[1]))};
  assign comp2_d = {comp_out_buf_d[1:1],
                    (comp_out_buf_d[0] && (! comp_out_buf_emitted[2]))};
  assign comp_out_buf_done = (comp_out_buf_emitted | ({comp2_d[0],
                                                       comp1_d[0],
                                                       comp0_d[0]} & {comp2_r, comp1_r, comp0_r}));
  assign comp_out_buf_r = (& comp_out_buf_done);
  always_ff @(posedge clk)
    comp_out_buf_emitted <= (comp_out_buf_r ? 3'd0 :
                             comp_out_buf_done);
  
  /* op_add (Ty Word#) : (add,Word#) (one,Word#) > (add_out,Word#) */
  assign add_out_d = {(add_d[WORD_MSB:1] + one_d[WORD_MSB:1]),
                      (add_d[0] && one_d[0])};
  assign {add_r, one_r} = {2 {(add_out_r && add_out_d[0])}};
  
  /* buf (Ty Go) : (go1,Go) > (go1_buf,Go) */
  Go_t go1_bufchan_d;
  logic go1_bufchan_r;
  Go_t go1_buf;
  initial go1_buf = 1'd0;
  assign go1_r = (! go1_buf[0]);
  assign go1_bufchan_d = (go1_buf[0] ? go1_buf :
                          go1_d);
  always_ff @(posedge clk)
    if ((go1_bufchan_r && go1_buf[0])) go1_buf <= 1'd0;
    else if (((! go1_bufchan_r) && (! go1_buf[0]))) go1_buf <= go1_d;
  initial go1_buf_d = 1'd0;
  assign go1_bufchan_r = ((! go1_buf_d[0]) || go1_buf_r);
  always_ff @(posedge clk)
    if (go1_bufchan_r) go1_buf_d <= go1_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((go1_buf_d[0] && (! go1_buf_r)))
      $display("%5t blocked: go1_buf", $time);
  `endif
  
  /* const (Ty Word#,Lit 1) : (go1_buf,Go) > (one,Word#) */
  assign one_d = {{WORD_MSB-1{1'b0}}, 1'd1, go1_buf_d[0]};
  assign go1_buf_r = one_r;
  
  /* togo (Ty Word#) : (add_go_init,Word#) > (go1,Go) */
  assign go1_d = add_go_init_d[0];
  assign add_go_init_r = go1_r;
  
  /* fork (Ty Word#) : (add_out,Word#) > [(add_go,Word#),
                                         (add_one,Word#)] */
  logic [1:0] add_out_emitted;
  initial add_out_emitted = 2'd0;
  logic [1:0] add_out_done;
  assign add_go_d = {add_out_d[WORD_MSB:1],
                     (add_out_d[0] && (! add_out_emitted[0]))};
  assign add_one_d = {add_out_d[WORD_MSB:1],
                      (add_out_d[0] && (! add_out_emitted[1]))};
  assign add_out_done = (add_out_emitted | ({add_one_d[0],
                                             add_go_d[0]} & {add_one_r, add_go_r}));
  assign add_out_r = (& add_out_done);
  always_ff @(posedge clk)
    add_out_emitted <= (add_out_r ? 2'd0 :
                        add_out_done);
  
  /* initibuf (Ty Word#,
          Lit 1) : (add_go,Word#) > (add_go_init,Word#) */
  initial add_go_init_d = {{WORD_MSB-1{1'b0}}, 1'd1, 1'd1};
  assign add_go_r = ((! add_go_init_d[0]) || add_go_init_r);
  always_ff @(posedge clk)
    if (add_go_r) add_go_init_d <= add_go_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((add_go_init_d[0] && (! add_go_init_r)))
      $display("%5t blocked: add_go_init", $time);
  `endif
  
  /* mux (Ty Bool_mem,Ty Word#) : (comp1,Bool_mem) [(add_one,Word#),
                                         (save_buf,Word#)] > (tf,Word#) */
  logic [WORD_MSB:0] tf_mux;
  logic [1:0] tf_onehot;
  always_comb
    unique case (comp1_d[1:1])
      1'd0: {tf_onehot, tf_mux} = {2'd1, add_one_d};
      1'd1: {tf_onehot, tf_mux} = {2'd2, save_buf_d};
      default: {tf_onehot, tf_mux} = {2'bx, {{WORD_MSB{1'bx}}, 1'd0}};
    endcase
  assign tf_d = {tf_mux[WORD_MSB:1], (tf_mux[0] && comp1_d[0])};
  assign comp1_r = (tf_d[0] && tf_r);
  assign {save_buf_r, add_one_r} = (comp1_r ? tf_onehot :
                                    2'd0);
  
  /* buf (Ty Word#) : (tf,Word#) > (tf_buf,Word#) */
  \Word#_t  tf_bufchan_d;
  logic tf_bufchan_r;
  \Word#_t  tf_buf;
  initial tf_buf = {{WORD_MSB{1'bx}}, 1'd0};
  assign tf_r = (! tf_buf[0]);
  assign tf_bufchan_d = (tf_buf[0] ? tf_buf :
                         tf_d);
  always_ff @(posedge clk)
    if ((tf_bufchan_r && tf_buf[0])) tf_buf <= {{WORD_MSB{1'bx}}, 1'd0};
    else if (((! tf_bufchan_r) && (! tf_buf[0]))) tf_buf <= tf_d;
  initial tf_buf_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign tf_bufchan_r = ((! tf_buf_d[0]) || tf_buf_r);
  always_ff @(posedge clk)
    if (tf_bufchan_r) tf_buf_d <= tf_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((tf_buf_d[0] && (! tf_buf_r)))
      $display("%5t blocked: tf_buf", $time);
  `endif
  
  /* demux (Ty Bool_mem,
       Ty Word#) : (comp2,Bool_mem) (tf_buf,Word#) > [(false_out,Word#),
                                                      (true_out,Word#)] */
  logic [1:0] tf_buf_onehotd;
  always_comb
    if ((comp2_d[0] && tf_buf_d[0]))
      unique case (comp2_d[1:1])
        1'd0: tf_buf_onehotd = 2'd1;
        1'd1: tf_buf_onehotd = 2'd2;
        default: tf_buf_onehotd = 2'bx;
      endcase
    else tf_buf_onehotd = 2'd0;
  assign false_out_d = {tf_buf_d[WORD_MSB:1], tf_buf_onehotd[0]};
  assign true_out_d = {tf_buf_d[WORD_MSB:1], tf_buf_onehotd[1]};
  assign tf_buf_r = (| (tf_buf_onehotd & {true_out_r, false_out_r}));
  assign comp2_r = tf_buf_r;
  
  /* const (Ty Word#,Lit 0) : (go0_rbuf,Go) > (zero,Word#) */
  assign zero_d = {{WORD_MSB{1'd0}}, go0_rbuf_d[0]};
  assign go0_rbuf_r = zero_r;
  
  /* togo (Ty Cmd) : (cmd_loop,Cmd) > (go0,Go) */
  assign go0_d = cmd_loop_d[0];
  assign cmd_loop_r = go0_r;
  
  /* initbuf (Ty Go,Dcon Go) : (go0,Go) > (go0_buf,Go) */
  initial go0_buf_d = Go_dc(1'd1);
  assign go0_r = ((! go0_buf_d[0]) || go0_buf_r);
  always_ff @(posedge clk)
    if (go0_r) go0_buf_d <= go0_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((go0_buf_d[0] && (! go0_buf_r)))
      $display("%5t blocked: go0_buf", $time);
  `endif
  
  /* rbuf (Ty Go) : (go0_buf,Go) > (go0_rbuf,Go) */
  Go_t go0_buf_buf;
  initial go0_buf_buf = 1'd0;
  assign go0_buf_r = (! go0_buf_buf[0]);
  assign go0_rbuf_d = (go0_buf_buf[0] ? go0_buf_buf :
                       go0_buf_d);
  always_ff @(posedge clk)
    if ((go0_rbuf_r && go0_buf_buf[0])) go0_buf_buf <= 1'd0;
    else if (((! go0_rbuf_r) && (! go0_buf_buf[0])))
      go0_buf_buf <= go0_buf_d;
  
  /* fork (Ty Word#) : (false_out_buf,Word#) > [(false_cmd,Word#),
                                               (false,Word#)] */
  logic [1:0] false_out_buf_emitted;
  initial false_out_buf_emitted = 2'd0;
  logic [1:0] false_out_buf_done;
  assign false_cmd_d = {false_out_buf_d[WORD_MSB:1],
                        (false_out_buf_d[0] && (! false_out_buf_emitted[0]))};
  assign false_d = {false_out_buf_d[WORD_MSB:1],
                    (false_out_buf_d[0] && (! false_out_buf_emitted[1]))};
  assign false_out_buf_done = (false_out_buf_emitted | ({false_d[0],
                                                         false_cmd_d[0]} & {false_r, false_cmd_r}));
  assign false_out_buf_r = (& false_out_buf_done);
  always_ff @(posedge clk)
    false_out_buf_emitted <= (false_out_buf_r ? 2'd0 :
                              false_out_buf_done);
  
  /* buf (Ty Word#) : (false_out,Word#) > (false_out_buf,Word#) */
  \Word#_t  false_out_bufchan_d;
  logic false_out_bufchan_r;
  \Word#_t  false_out_buf;
  initial false_out_buf = {{WORD_MSB{1'bx}}, 1'd0};
  assign false_out_r = (! false_out_buf[0]);
  assign false_out_bufchan_d = (false_out_buf[0] ? false_out_buf :
                                false_out_d);
  always_ff @(posedge clk)
    if ((false_out_bufchan_r && false_out_buf[0]))
      false_out_buf <= {{WORD_MSB{1'bx}}, 1'd0};
    else if (((! false_out_bufchan_r) && (! false_out_buf[0])))
      false_out_buf <= false_out_d;
  initial false_out_buf_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign false_out_bufchan_r = ((! false_out_buf_d[0]) || false_out_buf_r);
  always_ff @(posedge clk)
    if (false_out_bufchan_r) false_out_buf_d <= false_out_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((false_out_buf_d[0] && (! false_out_buf_r)))
      $display("%5t blocked: false_out_buf", $time);
  `endif
  
  /* dcon (Ty Pointer,Dcon P) : [(false_cmd,Word#)] > (ref,Pointer) */
  assign ref_d = P_dc((& {false_cmd_d[0]}), false_cmd_d);
  assign {false_cmd_r} = {1 {(ref_r && ref_d[0])}};
  
  /* dcon (Ty Node,Dcon Nd) : [(zero,Word#),
                          (ref,Pointer)] > (node,Node) */
  assign node_d = Nd_dc((& {zero_d[0], ref_d[0]}), zero_d, ref_d);
  assign {zero_r, ref_r} = {2 {(node_r && node_d[0])}};
  
  /* dcon (Ty Cmd,Dcon Write) : [(cmd_addr_buf,Word#),
                            (node,Node)] > (cmd_out,Cmd) */
  assign cmd_out_d = Write_dc((& {cmd_addr_buf_d[0],
                                  node_d[0]}), cmd_addr_buf_d, node_d);
  assign {cmd_addr_buf_r,
          node_r} = {2 {(cmd_out_r && cmd_out_d[0])}};
  
  /* buf (Ty Word#) : (cmd_addr,Word#) > (cmd_addr_buf,Word#) */
  \Word#_t  cmd_addr_bufchan_d;
  logic cmd_addr_bufchan_r;
  \Word#_t  cmd_addr_buf;
  initial cmd_addr_buf = {{WORD_MSB{1'bx}}, 1'd0};
  assign cmd_addr_r = (! cmd_addr_buf[0]);
  assign cmd_addr_bufchan_d = (cmd_addr_buf[0] ? cmd_addr_buf :
                               cmd_addr_d);
  always_ff @(posedge clk)
    if ((cmd_addr_bufchan_r && cmd_addr_buf[0]))
      cmd_addr_buf <= {{WORD_MSB{1'bx}}, 1'd0};
    else if (((! cmd_addr_bufchan_r) && (! cmd_addr_buf[0])))
      cmd_addr_buf <= cmd_addr_d;
  initial cmd_addr_buf_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign cmd_addr_bufchan_r = ((! cmd_addr_buf_d[0]) || cmd_addr_buf_r);
  always_ff @(posedge clk)
    if (cmd_addr_bufchan_r) cmd_addr_buf_d <= cmd_addr_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((cmd_addr_buf_d[0] && (! cmd_addr_buf_r)))
      $display("%5t blocked: cmd_addr_buf", $time);
  `endif
  
  /* fork (Ty Cmd) : (cmd_out,Cmd) > [(cmd,Cmd),(cmd_loop,Cmd)] */
  logic [1:0] cmd_out_emitted;
  initial cmd_out_emitted = 2'd0;
  logic [1:0] cmd_out_done;
  assign cmd_d = {cmd_out_d[CMD_MSB:1],
                  (cmd_out_d[0] && (! cmd_out_emitted[0]))};
  assign cmd_loop_d = {cmd_out_d[CMD_MSB:1],
                       (cmd_out_d[0] && (! cmd_out_emitted[1]))};
  assign cmd_out_done = (cmd_out_emitted | ({cmd_loop_d[0],
                                             cmd_d[0]} & {cmd_loop_r, cmd_r}));
  assign cmd_out_r = (& cmd_out_done);
  always_ff @(posedge clk)
    cmd_out_emitted <= (cmd_out_r ? 2'd0 :
                        cmd_out_done);
  
  /* fork (Ty Word#) : (true_out,Word#) > [(true,Word#),
                                          (true_go,Word#)] */
  logic [1:0] true_out_emitted;
  initial true_out_emitted = 2'd0;
  logic [1:0] true_out_done;
  assign true_d = {true_out_d[WORD_MSB:1],
                   (true_out_d[0] && (! true_out_emitted[0]))};
  assign true_go_d = {true_out_d[WORD_MSB:1],
                      (true_out_d[0] && (! true_out_emitted[1]))};
  assign true_out_done = (true_out_emitted | ({true_go_d[0],
                                               true_d[0]} & {true_go_r, true_r}));
  assign true_out_r = (& true_out_done);
  always_ff @(posedge clk)
    true_out_emitted <= (true_out_r ? 2'd0 :
                         true_out_done);
  
  /* mux (Ty Go,
     Ty Word#) : (end_go,Go) [(end_save,Word#)] > (to_free,Word#) */
  assign to_free_d = {end_save_d[WORD_MSB:1],
                      (end_go_d[0] && end_save_d[0])};
  assign end_save_r = (to_free_r && (end_go_d[0] && end_save_d[0]));
  assign end_go_r = (to_free_r && (end_go_d[0] && end_save_d[0]));
  
  /* togo (Ty Word#) : (true_go,Word#) > (end_go,Go) */
  assign end_go_d = true_go_d[0];
  assign true_go_r = end_go_r;
  
  /* sink (Ty Word#) : (to_free,Word#) > */
  assign {to_free_r, to_free_dout} = {to_free_rout, to_free_d};
  
  /* sink (Ty Word#) : (true,Word#) > */
  assign {true_r, true_dout} = {true_rout, true_d};
  
  /* sink (Ty Cmd) : (cmd,Cmd) > */
  assign {cmd_r, cmd_dout} = {cmd_rout, cmd_d};
  
  /* Lack-of-progress detector */
  `ifdef CHECK_PROGRESS
  logic [12:0] bufferedChannelValids;
  logic [12:0] bufferedChannelReadys;
  logic [12:0] last1BufferedChannelValids;
  logic [12:0] last1BufferedChannelReadys;
  logic [12:0] last2BufferedChannelValids;
  logic [12:0] last2BufferedChannelReadys;
  initial last1BufferedChannelValids = 13'd0;
  initial last1BufferedChannelReadys = 13'd0;
  initial last2BufferedChannelValids = 13'd1;
  initial last2BufferedChannelReadys = 13'd1;
  assign bufferedChannelValids = {comp_init_d[0],
                                  comp0_rbuf_d[0],
                                  save_buf_d[0],
                                  false_buf_d[0],
                                  loop_out_d[0],
                                  comp_out_buf_d[0],
                                  go1_buf_d[0],
                                  add_go_init_d[0],
                                  tf_buf_d[0],
                                  go0_buf_d[0],
                                  go0_rbuf_d[0],
                                  false_out_buf_d[0],
                                  cmd_addr_buf_d[0]};
  assign bufferedChannelReadys = {comp_init_r,
                                  comp0_rbuf_r,
                                  save_buf_r,
                                  false_buf_r,
                                  loop_out_r,
                                  comp_out_buf_r,
                                  go1_buf_r,
                                  add_go_init_r,
                                  tf_buf_r,
                                  go0_buf_r,
                                  go0_rbuf_r,
                                  false_out_buf_r,
                                  cmd_addr_buf_r};
  always_ff @(posedge clk)
    begin
      last1BufferedChannelValids <= bufferedChannelValids;
      last1BufferedChannelReadys <= bufferedChannelReadys;
      last2BufferedChannelValids <= last1BufferedChannelValids;
      last2BufferedChannelReadys <= last1BufferedChannelReadys;
      if (((((last2BufferedChannelValids == last1BufferedChannelValids) && (last1BufferedChannelValids == bufferedChannelValids)) && (last2BufferedChannelReadys == last1BufferedChannelReadys)) && (last1BufferedChannelReadys == bufferedChannelReadys)))
        begin
          $display("%6t no progress", $time);
          $display(" valids %b", last2BufferedChannelValids);
          $display(" readys %b", last2BufferedChannelReadys);
          $display(" valids %b", last1BufferedChannelValids);
          $display(" readys %b", last1BufferedChannelReadys);
          $display(" valids %b", bufferedChannelValids);
          $display(" readys %b", bufferedChannelReadys);
          if ((comp_init_d[0] && (! comp_init_r)))
            $display(" blocked comp_init");
          if ((comp0_rbuf_d[0] && (! comp0_rbuf_r)))
            $display(" blocked comp0_rbuf");
          if ((save_buf_d[0] && (! save_buf_r)))
            $display(" blocked save_buf");
          if ((false_buf_d[0] && (! false_buf_r)))
            $display(" blocked false_buf");
          if ((loop_out_d[0] && (! loop_out_r)))
            $display(" blocked loop_out");
          if ((comp_out_buf_d[0] && (! comp_out_buf_r)))
            $display(" blocked comp_out_buf");
          if ((go1_buf_d[0] && (! go1_buf_r))) $display(" blocked go1_buf");
          if ((add_go_init_d[0] && (! add_go_init_r)))
            $display(" blocked add_go_init");
          if ((tf_buf_d[0] && (! tf_buf_r))) $display(" blocked tf_buf");
          if ((go0_buf_d[0] && (! go0_buf_r))) $display(" blocked go0_buf");
          if ((go0_rbuf_d[0] && (! go0_rbuf_r)))
            $display(" blocked go0_rbuf");
          if ((false_out_buf_d[0] && (! false_out_buf_r)))
            $display(" blocked false_out_buf");
          if ((cmd_addr_buf_d[0] && (! cmd_addr_buf_r)))
            $display(" blocked cmd_addr_buf");
          $finish();
        end
    end
  `endif
  /* Wake Node Reporting */
  `ifdef WAKE_REPORT
  /* wake comp_init:initbuf */
  /* wake comp0_rbuf:rbuf */
  /* wake save_buf:buf */
  /* wake start_out:mux */
  /* wake false_buf:buf */
  /* wake end_out:mux */
  /* wake loop_out:buf */
  /* wake comp_out:eq */
  /* wake comp_out_buf:buf */
  /* wake add_out:add */
  /* wake go1_buf:buf */
  /* wake add_go_init:initibuf */
  /* wake tf:mux */
  /* wake tf_buf:buf */
  /* wake go0_buf:initbuf */
  /* wake go0_rbuf:rbuf */
  /* wake false_out_buf:buf */
  /* wake cmd_addr_buf:buf */
  /* wake to_free:mux */
  always_ff @(posedge clk)
    $display("wake %b", {(comp_init_d[0] || comp0_rbuf_d[0]),
                         (comp0_rbuf_d[0] || comp0_d[0]),
                         (save_buf_d[0] || (save_d[0] || save_bufchan_d[0])),
                         start_out_d[0],
                         (false_buf_d[0] || (false_d[0] || false_bufchan_d[0])),
                         end_out_d[0],
                         (loop_out_d[0] || (end_loop_d[0] || end_loop_bufchan_d[0])),
                         comp_out_d[0],
                         (comp_out_buf_d[0] || (comp_out_d[0] || comp_out_bufchan_d[0])),
                         add_out_d[0],
                         (go1_buf_d[0] || (go1_d[0] || go1_bufchan_d[0])),
                         (add_go_init_d[0] || add_go_d[0]),
                         tf_d[0],
                         (tf_buf_d[0] || (tf_d[0] || tf_bufchan_d[0])),
                         (go0_buf_d[0] || go0_d[0]),
                         (go0_rbuf_d[0] || go0_buf_d[0]),
                         (false_out_buf_d[0] || (false_out_d[0] || false_out_bufchan_d[0])),
                         (cmd_addr_buf_d[0] || (cmd_addr_d[0] || cmd_addr_bufchan_d[0])),
                         to_free_d[0]});
  `endif
endmodule
