//`include "Types.sv"

module Garbage_Collection(input logic clk,
			  input        \Word#_t num_roots_d,
			  output logic num_roots_r,
			  input        Root_t root_d,
			  output logic root_r,
			  input        \Word#_t base_d,
			  output logic base_r,
			  input        \Word#_t bound_d,
			  output logic bound_r,
			  output       Go_t done_dout,
			  input logic  done_rout,
			  input        Node_t node_d,
			  output logic node_r,
			  input        Go_t ack_d,
			  output logic ack_r,
			  output       Pointer_t read_dout,
			  input logic  read_rout,
			  output       Pointer_t free_dout,
			  input logic  free_rout,
			  input        Pointer_t alloc_d,
			  output logic alloc_r,
			  input        Go_t force_gc_d,
			  output logic force_gc_r,
			  output       Go_t start_gc_dout,
			  input logic  start_gc_rout,
			  output       Raise_Err_t gc_error_dout,
			  input logic  gc_error_rout,
			  input        \Word#_t threshold_d,
			  output logic threshold_r
		       );
   
   // parameter WORD_MSB = 16;
   // parameter POINTER_MSB = 16;
   // parameter NODE_MSB = 33;
   // parameter NODE_PTR_LSB = 18;
   // parameter NODE_WORD_MSB = 17;
   // parameter ROOT_MSB = 17;
   // parameter GC_CMD_MSB = 18;
   // parameter GC_RES_MSB = 19;
   // parameter MAP_CMD_MSB = 19;
   // parameter MAP_CMD_MK_LSB = 18;
   // parameter MAP_CMD_WORD_MSB = 17;

   parameter POINTER_BITS = 17;
   parameter NODE_BITS = 34;
   
   GC_Cmd_t gc_cmd_d;
   logic 			    gc_cmd_r;
   GC_Res_t gc_res_d;
   logic 			    gc_res_r;
   Raise_Err_t dpath_error_dout;
   logic 			    dpath_error_rout;
   Raise_Err_t root_error_dout;
   logic 			    root_error_rout;
   Raise_Err_t sweep_error_dout;
   logic 			    sweep_error_rout;
   
   GC_Control #(.POINTER_BITS(POINTER_BITS),
		.NODE_BITS(NODE_BITS)) control_path(.clk(clk),
						    .num_roots_d(num_roots_d),
						    .num_roots_r(num_roots_r),
						    .root_d(root_d),
						    .root_r(root_r),
						    .base_d(base_d),
						    .base_r(base_r),
						    .bound_d(bound_d),
						    .bound_r(bound_r),
						    .gc_res_d(gc_res_d),
						    .gc_res_r(gc_res_r),
						    .gc_cmd_dout(gc_cmd_d),
						    .gc_cmd_rout(gc_cmd_r),
						    .done_dout(done_dout),
						    .done_rout(done_rout),
						    .alloc_d(alloc_d),
						    .alloc_r(alloc_r),
						    .force_gc_d(force_gc_d),
						    .force_gc_r(force_gc_r),
						    .start_gc_dout(start_gc_dout),
						    .start_gc_rout(start_gc_rout),
						    .root_error_dout(root_error_dout),
						    .root_error_rout(root_error_rout),
						    .sweep_error_dout(sweep_error_dout),
						    .sweep_error_rout(sweep_error_rout),
						    .threshold_d(threshold_d),
						    .threshold_r(threshold_r)
						    );
   
   
   GC_Data #(.POINTER_BITS(POINTER_BITS),
	     .NODE_BITS(NODE_BITS)) data_path(.clk(clk),
					    .cmd_d(gc_cmd_d),
					    .cmd_r(gc_cmd_r),
					    .node_d(node_d),
					    .node_r(node_r),
					    .ack_d(ack_d),
					    .ack_r(ack_r),
					    .read_dout(read_dout),
					    .read_rout(read_rout),
					    .free_dout(free_dout),
					    .free_rout(free_rout),
					    .res_dout(gc_res_d),
					    .res_rout(gc_res_r),
					    .dpath_error_dout(dpath_error_dout),
					    .dpath_error_rout(dpath_error_rout)
					    );

   ErrorMerge3 merge_errors(.clk(clk),
			    .in0_d(sweep_error_dout),
			    .in0_r(sweep_error_rout),
			    .in1_d(root_error_dout),
			    .in1_r(root_error_rout),
			    .in2_d(dpath_error_dout),
			    .in2_r(dpath_error_rout),
			    .out_dout(gc_error_dout),
			    .out_rout(gc_error_rout)
			    );
   

endmodule 

