#ifndef _GC_MEMORY_H
#define _GC_MEMORY_H

#include <linux/ioctl.h>
#include <stdbool.h>

typedef struct {
  int read_rdy, write_rdy, read_res_rdy, write_res_rdy, start_gc, gc_done, root_rdy;
} gc_memory_status_t;

typedef struct {
  gc_memory_status_t status;
  unsigned int value;
} gc_memory_arg_t;

#define GC_MEMORY_MAGIC 'q'

/* ioctls and their arguments */
#define GC_MEMORY_STATUS    _IOR(GC_MEMORY_MAGIC, 1, gc_memory_arg_t *)
#define GC_MEMORY_NUM_ROOTS _IOW(GC_MEMORY_MAGIC, 2, gc_memory_arg_t *)
#define GC_MEMORY_BASE      _IOW(GC_MEMORY_MAGIC, 3, gc_memory_arg_t *)
#define GC_MEMORY_BOUND     _IOW(GC_MEMORY_MAGIC, 4, gc_memory_arg_t *)
#define GC_MEMORY_THRESHOLD _IOW(GC_MEMORY_MAGIC, 5, gc_memory_arg_t *)
#define GC_MEMORY_READ_OP   _IOW(GC_MEMORY_MAGIC, 6, gc_memory_arg_t *)
#define GC_MEMORY_READ_RES  _IOR(GC_MEMORY_MAGIC, 7, gc_memory_arg_t *)
#define GC_MEMORY_WRITE_OP  _IOW(GC_MEMORY_MAGIC, 8, gc_memory_arg_t *)
#define GC_MEMORY_WRITE_RES _IOR(GC_MEMORY_MAGIC, 9, gc_memory_arg_t *)
#define GC_MEMORY_ROOT      _IOW(GC_MEMORY_MAGIC, 10, gc_memory_arg_t *)
  //#define GC_MEMORY_TEST      _IOR(GC_MEMORY_MAGIC, 11, gc_memory_arg_t *)
#define GC_MEMORY_READ_BRAM _IOR(GC_MEMORY_MAGIC, 11, gc_memory_arg_t *)
  
#endif
