module GC_Data(
  input logic clk,
  input GC_Cmd_t cmd_d,
  output logic cmd_r,
  input Node_t node_d,
  output logic node_r,
  input Go_t ack_d,
  output logic ack_r,
  output Pointer_t read_dout,
  input logic read_rout,
  output Pointer_t free_dout,
  input logic free_rout,
  output GC_Res_t res_dout,
  input logic res_rout,
  output Raise_Err_t dpath_error_dout,
  input logic dpath_error_rout
  );
  /* --define=INPUTS=((cmd, 18, 262144, GC_Cmd), (node, 33, 8589934592, Node), (ack, 0, 1, Go)) */
  /* --define=TAPS=() */
  /* --define=OUTPUTS=((read, 16, 65536, Pointer), (free, 16, 65536, Pointer), (res, 19, 524288, GC_Res), (dpath_error, 2, 3, Raise_Err)) */
  /* TYPE_START
TYPE_END */
  /*  */
  /*  */

   parameter POINTER_BITS = 17;
   parameter NODE_BITS = 34;
   
   parameter POINTER_MSB = POINTER_BITS-1; //16;
   parameter GC_CMD_MSB = POINTER_BITS+1; //18;
   parameter GC_RES_MSB = POINTER_BITS+2;
   parameter NODE_MSB = NODE_BITS-1; //33;
   parameter NODE_PTR_LSB = POINTER_BITS+1; //18;
   parameter NODE_WORD_MSB = POINTER_BITS; //17;
   parameter MAP_CMD_MSB = POINTER_BITS+2; //19;
   parameter MAP_CMD_MK_LSB = POINTER_BITS+1; //18;
   parameter MAP_CMD_WORD_MSB = POINTER_BITS; //17;
   
  Go_t ack_buf_d;
  logic ack_buf_r;
  Go_t pass_next_d;
  logic pass_next_r;
  Go_t pass_next_buf_d;
  logic pass_next_buf_r;
  GC_Cmd_t next_cmd_d;
  logic next_cmd_r;
  GC_Cmd_t mux0_d;
  logic mux0_r;
  GC_Cmd_t use_cmd_d;
  logic use_cmd_r;
  GC_Cmd_t mk_cmd_d;
  logic mk_cmd_r;
  GC_Cmd_t sp_cmd_d;
  logic sp_cmd_r;
  GC_Cmd_t fl_cmd_d;
  logic fl_cmd_r;
  GC_Cmd_t mux_fl_d;
  logic mux_fl_r;
  GC_Cmd_t use_fl_d;
  logic use_fl_r;
  GC_Cmd_t mux_mk_d;
  logic mux_mk_r;
  GC_Cmd_t use_mk_d;
  logic use_mk_r;
  GC_Cmd_t mux_sp_d;
  logic mux_sp_r;
  GC_Cmd_t use_sp_d;
  logic use_sp_r;
  Pointer_t mk_ref_d;
  logic mk_ref_r;
  Pointer_t sp_ref_d;
  logic sp_ref_r;
  Pointer_t fl_ref_d;
  logic fl_ref_r;
  Pointer_t ref_d;
  logic ref_r;
  GC_Cmd_t ms_cmd_d;
  logic ms_cmd_r;
  Pointer_t ref_buf_d;
  logic ref_buf_r;
  Pointer_t read_ref_d;
  logic read_ref_r;
  Pointer_t pass_ref_d;
  logic pass_ref_r;
  Pointer_t pass_ref_buf_d;
  logic pass_ref_buf_r;
  \Word#_t  addr_d;
  logic addr_r;
  Map_Cmd_t read_map_d;
  logic read_map_r;
  Map_Cmd_t map_cmd_d;
  logic map_cmd_r;
  Map_Cmd_t map_cmd_buf_d;
  logic map_cmd_buf_r;
  Map_Res_t map_res_d;
  logic map_res_r;
  Map_Res_t res_choose_d;
  logic res_choose_r;
  Map_Res_t res_use_d;
  logic res_use_r;
  Map_Res_t dat_d;
  logic dat_r;
  Map_Res_t written_d;
  logic written_r;
  Map_Res_t written_next_d;
  logic written_next_r;
  Map_Res_t written_out_d;
  logic written_out_r;
  Marked_t marked_d;
  logic marked_r;
  Marked_t marked_buf_d;
  logic marked_buf_r;
  Marked_t m0_d;
  logic m0_r;
  Marked_t m1_d;
  logic m1_r;
  Pointer_t marked_fl_d;
  logic marked_fl_r;
  Pointer_t marked_false_d;
  logic marked_false_r;
  Pointer_t marked_true_d;
  logic marked_true_r;
  Pointer_t marked_fl_buf_d;
  logic marked_fl_buf_r;
  Pointer_t marked_false_buf_d;
  logic marked_false_buf_r;
  Pointer_t marked_true_buf_d;
  logic marked_true_buf_r;
  GC_Cmd_t _2_d;
  logic _2_r;
  assign _2_r = 1'd1;
  GC_Cmd_t mux_false_d;
  logic mux_false_r;
  GC_Cmd_t mux_true_d;
  logic mux_true_r;
  Pointer_t false_out_d;
  logic false_out_r;
  Pointer_t false_next_d;
  logic false_next_r;
  GC_Cmd_t mux_false_0_d;
  logic mux_false_0_r;
  GC_Cmd_t mux_false_1_d;
  logic mux_false_1_r;
  Pointer_t read_d;
  logic read_r;
  Pointer_t free_d;
  logic free_r;
  Pointer_t er1_d;
  logic er1_r;
  Pointer_t false_mark_d;
  logic false_mark_r;
  Pointer_t false_sweep_d;
  logic false_sweep_r;
  Pointer_t er2_d;
  logic er2_r;
  Pointer_t true_out_d;
  logic true_out_r;
  Pointer_t true_next_d;
  logic true_next_r;
  Pointer_t true_mark_d;
  logic true_mark_r;
  Pointer_t true_sweep_d;
  logic true_sweep_r;
  Pointer_t er3_d;
  logic er3_r;
  Pointer_t false_mark_ref_d;
  logic false_mark_ref_r;
  Pointer_t write_true_d;
  logic write_true_r;
  Pointer_t mk_rm_d;
  logic mk_rm_r;
  Pointer_t false_sweep_ref_d;
  logic false_sweep_ref_r;
  Pointer_t false_sweep_write_d;
  logic false_sweep_write_r;
  Pointer_t f_sp_rm_d;
  logic f_sp_rm_r;
  Pointer_t true_ref_d;
  logic true_ref_r;
  Pointer_t write_false_d;
  logic write_false_r;
  Pointer_t t_sp_rm_d;
  logic t_sp_rm_r;
  Pointer_t fl_write_ref_d;
  logic fl_write_ref_r;
  Pointer_t fl_write_false_d;
  logic fl_write_false_r;
  Pointer_t write_ref_d;
  logic write_ref_r;
  \Word#_t  write_addr_d;
  logic write_addr_r;
  Map_Cmd_t write_map_d;
  logic write_map_r;
  Go_t false_0_go_d;
  logic false_0_go_r;
  Marked_t mark_f0_d;
  logic mark_f0_r;
  Go_t freelist_go_d;
  logic freelist_go_r;
  Marked_t mark_fl_d;
  logic mark_fl_r;
  Go_t true_go_d;
  logic true_go_r;
  Marked_t mark_t_d;
  logic mark_t_r;
  Go_t false_1_go_d;
  logic false_1_go_r;
  Marked_t mark_f1_d;
  logic mark_f1_r;
  Marked_t write_val_d;
  logic write_val_r;
  Pointer_t marked_fl_next_d;
  logic marked_fl_next_r;
  Pointer_t marked_fl_out_d;
  logic marked_fl_out_r;
  Go_t next0_d;
  logic next0_r;
  Go_t next1_d;
  logic next1_r;
  Go_t next2_d;
  logic next2_r;
  Go_t pass_next_rbuf_d;
  logic pass_next_rbuf_r;
  Go_t marked_go_d;
  logic marked_go_r;
  GC_Res_t res_marked_d;
  logic res_marked_r;
  GC_Res_t res_freed_d;
  logic res_freed_r;
  Node_t node_buf_d;
  logic node_buf_r;
  Node_t node_choose_d;
  logic node_choose_r;
  Node_t node_pass_d;
  logic node_pass_r;
  Node_t null_node_d;
  logic null_node_r;
  Node_t val_node_d;
  logic val_node_r;
  Go_t nochild_go_d;
  logic nochild_go_r;
  \Word#_t  _1_d;
  logic _1_r;
  assign _1_r = 1'd1;
  Pointer_t val_d;
  logic val_r;
  GC_Res_t res_nochild_d;
  logic res_nochild_r;
  GC_Res_t res_child_d;
  logic res_child_r;
  Go_t alreadyfree_go_d;
  logic alreadyfree_go_r;
  GC_Res_t res_alreadyfree_d;
  logic res_alreadyfree_r;
  Go_t fl_bl_d;
  logic fl_bl_r;
  Go_t f_sp_bl_d;
  logic f_sp_bl_r;
  Go_t t_sp_bl_d;
  logic t_sp_bl_r;
  Go_t mk_bl_d;
  logic mk_bl_r;
  Tog_t fl_tg_d;
  logic fl_tg_r;
  Tog_t f_sp_tg_d;
  logic f_sp_tg_r;
  Tog_t t_sp_tg_d;
  logic t_sp_tg_r;
  Tog_t mk_tg_d;
  logic mk_tg_r;
  Tog_t rm_choose_d;
  logic rm_choose_r;
  Map_Res_t _0_d;
  logic _0_r;
  assign _0_r = 1'd1;
  Map_Res_t rm_ack_d;
  logic rm_ack_r;
  Go_t removed_go_d;
  logic removed_go_r;
  GC_Res_t res_removed_d;
  logic res_removed_r;
  GC_Res_t res_d;
  logic res_r;
  Go_t er1_go_d;
  logic er1_go_r;
  Go_t er2_go_d;
  logic er2_go_r;
  Go_t er3_go_d;
  logic er3_go_r;
  Go_t all_errors_d;
  logic all_errors_r;
  Raise_Err_t dpath_error_d;
  logic dpath_error_r;
  
  /* source (Ty GC_Cmd) : > (cmd,GC_Cmd) */
  
  /* source (Ty Node) : > (node,Node) */
  
  /* source (Ty Go) : > (ack,Go) */
  
  /* buf (Ty Go) : (ack,Go) > (ack_buf,Go) */
  Go_t ack_bufchan_d;
  logic ack_bufchan_r;
  Go_t ack_buf;
  initial ack_buf = 1'd0;
  assign ack_r = (! ack_buf[0]);
  assign ack_bufchan_d = (ack_buf[0] ? ack_buf :
                          ack_d);
  always_ff @(posedge clk)
    if ((ack_bufchan_r && ack_buf[0])) ack_buf <= 1'd0;
    else if (((! ack_bufchan_r) && (! ack_buf[0]))) ack_buf <= ack_d;
  initial ack_buf_d = 1'd0;
  assign ack_bufchan_r = ((! ack_buf_d[0]) || ack_buf_r);
  always_ff @(posedge clk)
    if (ack_bufchan_r) ack_buf_d <= ack_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((ack_buf_d[0] && (! ack_buf_r)))
      $display("%5t blocked: ack_buf", $time);
  `endif
  
  /* initbuf (Ty Go,Dcon Go) : (pass_next_buf,Go) > (pass_next,Go) */
  initial pass_next_d = Go_dc(1'd1);
  assign pass_next_buf_r = ((! pass_next_d[0]) || pass_next_r);
  always_ff @(posedge clk)
    if (pass_next_buf_r) pass_next_d <= pass_next_buf_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((pass_next_d[0] && (! pass_next_r)))
      $display("%5t blocked: pass_next", $time);
  `endif
  
  /* rbuf (Ty Go) : (pass_next_rbuf,Go) > (pass_next_buf,Go) */
  Go_t pass_next_rbuf_buf;
  initial pass_next_rbuf_buf = 1'd0;
  assign pass_next_rbuf_r = (! pass_next_rbuf_buf[0]);
  assign pass_next_buf_d = (pass_next_rbuf_buf[0] ? pass_next_rbuf_buf :
                            pass_next_rbuf_d);
  always_ff @(posedge clk)
    if ((pass_next_buf_r && pass_next_rbuf_buf[0]))
      pass_next_rbuf_buf <= 1'd0;
    else if (((! pass_next_buf_r) && (! pass_next_rbuf_buf[0])))
      pass_next_rbuf_buf <= pass_next_rbuf_d;
  
  /* mux (Ty Go,
     Ty GC_Cmd) : (pass_next,Go) [(cmd,GC_Cmd)] > (next_cmd,GC_Cmd) */
  assign next_cmd_d = {cmd_d[GC_CMD_MSB:1], (pass_next_d[0] && cmd_d[0])};
  assign cmd_r = (next_cmd_r && (pass_next_d[0] && cmd_d[0]));
  assign pass_next_r = (next_cmd_r && (pass_next_d[0] && cmd_d[0]));
  
  /* fork (Ty GC_Cmd) : (next_cmd,GC_Cmd) > [(mux0,GC_Cmd),
                                        (use_cmd,GC_Cmd)] */
  logic [1:0] next_cmd_emitted;
  initial next_cmd_emitted = 2'd0;
  logic [1:0] next_cmd_done;
  assign mux0_d = {next_cmd_d[GC_CMD_MSB:1],
                   (next_cmd_d[0] && (! next_cmd_emitted[0]))};
  assign use_cmd_d = {next_cmd_d[GC_CMD_MSB:1],
                      (next_cmd_d[0] && (! next_cmd_emitted[1]))};
  assign next_cmd_done = (next_cmd_emitted | ({use_cmd_d[0],
                                               mux0_d[0]} & {use_cmd_r, mux0_r}));
  assign next_cmd_r = (& next_cmd_done);
  always_ff @(posedge clk)
    next_cmd_emitted <= (next_cmd_r ? 2'd0 :
                         next_cmd_done);
  
  /* demux (Ty GC_Cmd,
       Ty GC_Cmd) : (mux0,GC_Cmd) (use_cmd,GC_Cmd) > [(mk_cmd,GC_Cmd),
                                                      (sp_cmd,GC_Cmd),
                                                      (fl_cmd,GC_Cmd)] */
  logic [2:0] use_cmd_onehotd;
  always_comb
    if ((mux0_d[0] && use_cmd_d[0]))
      unique case (mux0_d[2:1])
        2'd0: use_cmd_onehotd = 3'd1;
        2'd1: use_cmd_onehotd = 3'd2;
        2'd2: use_cmd_onehotd = 3'd4;
        default: use_cmd_onehotd = 3'bx;
      endcase
    else use_cmd_onehotd = 3'd0;
  assign mk_cmd_d = {use_cmd_d[GC_CMD_MSB:1], use_cmd_onehotd[0]};
  assign sp_cmd_d = {use_cmd_d[GC_CMD_MSB:1], use_cmd_onehotd[1]};
  assign fl_cmd_d = {use_cmd_d[GC_CMD_MSB:1], use_cmd_onehotd[2]};
  assign use_cmd_r = (| (use_cmd_onehotd & {fl_cmd_r,
                                            sp_cmd_r,
                                            mk_cmd_r}));
  assign mux0_r = use_cmd_r;
  
  /* fork (Ty GC_Cmd) : (fl_cmd,GC_Cmd) > [(mux_fl,GC_Cmd),
                                      (use_fl,GC_Cmd)] */
  logic [1:0] fl_cmd_emitted;
  initial fl_cmd_emitted = 2'd0;
  logic [1:0] fl_cmd_done;
  assign mux_fl_d = {fl_cmd_d[GC_CMD_MSB:1],
                     (fl_cmd_d[0] && (! fl_cmd_emitted[0]))};
  assign use_fl_d = {fl_cmd_d[GC_CMD_MSB:1],
                     (fl_cmd_d[0] && (! fl_cmd_emitted[1]))};
  assign fl_cmd_done = (fl_cmd_emitted | ({use_fl_d[0],
                                           mux_fl_d[0]} & {use_fl_r, mux_fl_r}));
  assign fl_cmd_r = (& fl_cmd_done);
  always_ff @(posedge clk)
    fl_cmd_emitted <= (fl_cmd_r ? 2'd0 :
                       fl_cmd_done);
  
  /* fork (Ty GC_Cmd) : (mk_cmd,GC_Cmd) > [(mux_mk,GC_Cmd),
                                      (use_mk,GC_Cmd)] */
  logic [1:0] mk_cmd_emitted;
  initial mk_cmd_emitted = 2'd0;
  logic [1:0] mk_cmd_done;
  assign mux_mk_d = {mk_cmd_d[GC_CMD_MSB:1],
                     (mk_cmd_d[0] && (! mk_cmd_emitted[0]))};
  assign use_mk_d = {mk_cmd_d[GC_CMD_MSB:1],
                     (mk_cmd_d[0] && (! mk_cmd_emitted[1]))};
  assign mk_cmd_done = (mk_cmd_emitted | ({use_mk_d[0],
                                           mux_mk_d[0]} & {use_mk_r, mux_mk_r}));
  assign mk_cmd_r = (& mk_cmd_done);
  always_ff @(posedge clk)
    mk_cmd_emitted <= (mk_cmd_r ? 2'd0 :
                       mk_cmd_done);
  
  /* fork (Ty GC_Cmd) : (sp_cmd,GC_Cmd) > [(mux_sp,GC_Cmd),
                                      (use_sp,GC_Cmd)] */
  logic [1:0] sp_cmd_emitted;
  initial sp_cmd_emitted = 2'd0;
  logic [1:0] sp_cmd_done;
  assign mux_sp_d = {sp_cmd_d[GC_CMD_MSB:1],
                     (sp_cmd_d[0] && (! sp_cmd_emitted[0]))};
  assign use_sp_d = {sp_cmd_d[GC_CMD_MSB:1],
                     (sp_cmd_d[0] && (! sp_cmd_emitted[1]))};
  assign sp_cmd_done = (sp_cmd_emitted | ({use_sp_d[0],
                                           mux_sp_d[0]} & {use_sp_r, mux_sp_r}));
  assign sp_cmd_r = (& sp_cmd_done);
  always_ff @(posedge clk)
    sp_cmd_emitted <= (sp_cmd_r ? 2'd0 :
                       sp_cmd_done);
  
  /* destruct (Ty GC_Cmd,
          Dcon Mark) : (use_mk,GC_Cmd) > [(mk_ref,Pointer)] */
  assign mk_ref_d = {use_mk_d[GC_CMD_MSB:3], use_mk_d[0]};
  assign use_mk_r = mk_ref_r;
  
  /* destruct (Ty GC_Cmd,
          Dcon Sweep) : (use_sp,GC_Cmd) > [(sp_ref,Pointer)] */
  assign sp_ref_d = {use_sp_d[GC_CMD_MSB:3], use_sp_d[0]};
  assign use_sp_r = sp_ref_r;
  
  /* destruct (Ty GC_Cmd,
          Dcon Freelist) : (use_fl,GC_Cmd) > [(fl_ref,Pointer)] */
  assign fl_ref_d = {use_fl_d[GC_CMD_MSB:3], use_fl_d[0]};
  assign use_fl_r = fl_ref_r;
  
  /* merge (Ty Pointer) : [(mk_ref,Pointer),
                      (sp_ref,Pointer)] > (ref,Pointer) */
  logic [1:0] ref_selected;
  logic [1:0] ref_select;
  initial ref_select = 2'd0;
  always_comb
    begin
      ref_selected = 2'd0;
      if ((| ref_select)) ref_selected = ref_select;
      else
        if (mk_ref_d[0]) ref_selected[0] = 1'd1;
        else if (sp_ref_d[0]) ref_selected[1] = 1'd1;
    end
  always_ff @(posedge clk)
    ref_select <= (ref_r ? 2'd0 :
                   ref_selected);
  always_comb
    if (ref_selected[0]) ref_d = mk_ref_d;
    else if (ref_selected[1]) ref_d = sp_ref_d;
    else ref_d = {{POINTER_MSB{1'bx}}, 1'd0};
  assign {sp_ref_r, mk_ref_r} = (ref_r ? ref_selected :
                                 2'd0);
  
  /* merge (Ty GC_Cmd) : [(mux_mk,GC_Cmd),
                     (mux_sp,GC_Cmd)] > (ms_cmd,GC_Cmd) */
  logic [1:0] ms_cmd_selected;
  logic [1:0] ms_cmd_select;
  initial ms_cmd_select = 2'd0;
  always_comb
    begin
      ms_cmd_selected = 2'd0;
      if ((| ms_cmd_select)) ms_cmd_selected = ms_cmd_select;
      else
        if (mux_mk_d[0]) ms_cmd_selected[0] = 1'd1;
        else if (mux_sp_d[0]) ms_cmd_selected[1] = 1'd1;
    end
  always_ff @(posedge clk)
    ms_cmd_select <= (ms_cmd_r ? 2'd0 :
                      ms_cmd_selected);
  always_comb
    if (ms_cmd_selected[0]) ms_cmd_d = mux_mk_d;
    else if (ms_cmd_selected[1]) ms_cmd_d = mux_sp_d;
    else ms_cmd_d = {{GC_CMD_MSB{1'bx}}, 1'd0};
  assign {mux_sp_r, mux_mk_r} = (ms_cmd_r ? ms_cmd_selected :
                                 2'd0);
  
  /* buf (Ty Pointer) : (ref,Pointer) > (ref_buf,Pointer) */
  Pointer_t ref_bufchan_d;
  logic ref_bufchan_r;
  Pointer_t ref_buf;
  initial ref_buf = {{POINTER_MSB{1'bx}}, 1'd0};
  assign ref_r = (! ref_buf[0]);
  assign ref_bufchan_d = (ref_buf[0] ? ref_buf :
                          ref_d);
  always_ff @(posedge clk)
    if ((ref_bufchan_r && ref_buf[0])) ref_buf <= {{POINTER_MSB{1'bx}}, 1'd0};
    else if (((! ref_bufchan_r) && (! ref_buf[0]))) ref_buf <= ref_d;
  initial ref_buf_d = {{POINTER_MSB{1'bx}}, 1'd0};
  assign ref_bufchan_r = ((! ref_buf_d[0]) || ref_buf_r);
  always_ff @(posedge clk)
    if (ref_bufchan_r) ref_buf_d <= ref_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((ref_buf_d[0] && (! ref_buf_r)))
      $display("%5t blocked: ref_buf", $time);
  `endif
  
  /* fork (Ty Pointer) : (ref_buf,Pointer) > [(read_ref,Pointer),
                                         (pass_ref,Pointer)] */
  logic [1:0] ref_buf_emitted;
  initial ref_buf_emitted = 2'd0;
  logic [1:0] ref_buf_done;
  assign read_ref_d = {ref_buf_d[POINTER_MSB:1],
                       (ref_buf_d[0] && (! ref_buf_emitted[0]))};
  assign pass_ref_d = {ref_buf_d[POINTER_MSB:1],
                       (ref_buf_d[0] && (! ref_buf_emitted[1]))};
  assign ref_buf_done = (ref_buf_emitted | ({pass_ref_d[0],
                                             read_ref_d[0]} & {pass_ref_r, read_ref_r}));
  assign ref_buf_r = (& ref_buf_done);
  always_ff @(posedge clk)
    ref_buf_emitted <= (ref_buf_r ? 2'd0 :
                        ref_buf_done);
  
  /* buf (Ty Pointer) : (pass_ref,Pointer) > (pass_ref_buf,Pointer) */
  Pointer_t pass_ref_bufchan_d;
  logic pass_ref_bufchan_r;
  Pointer_t pass_ref_buf;
  initial pass_ref_buf = {{POINTER_MSB{1'bx}}, 1'd0};
  assign pass_ref_r = (! pass_ref_buf[0]);
  assign pass_ref_bufchan_d = (pass_ref_buf[0] ? pass_ref_buf :
                               pass_ref_d);
  always_ff @(posedge clk)
    if ((pass_ref_bufchan_r && pass_ref_buf[0]))
      pass_ref_buf <= {{POINTER_MSB{1'bx}}, 1'd0};
    else if (((! pass_ref_bufchan_r) && (! pass_ref_buf[0])))
      pass_ref_buf <= pass_ref_d;
  initial pass_ref_buf_d = {{POINTER_MSB{1'bx}}, 1'd0};
  assign pass_ref_bufchan_r = ((! pass_ref_buf_d[0]) || pass_ref_buf_r);
  always_ff @(posedge clk)
    if (pass_ref_bufchan_r) pass_ref_buf_d <= pass_ref_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((pass_ref_buf_d[0] && (! pass_ref_buf_r)))
      $display("%5t blocked: pass_ref_buf", $time);
  `endif
  
  /* destruct (Ty Pointer,
          Dcon P) : (read_ref,Pointer) > [(addr,Word#)] */
  assign addr_d = {read_ref_d[POINTER_MSB:1], read_ref_d[0]};
  assign read_ref_r = addr_r;
  
  /* dcon (Ty Map_Cmd,
      Dcon MRead) : [(addr,Word#)] > (read_map,Map_Cmd) */
  assign read_map_d = MRead_dc((& {addr_d[0]}), addr_d);
  assign {addr_r} = {1 {(read_map_r && read_map_d[0])}};
  
  /* merge (Ty Map_Cmd) : [(read_map,Map_Cmd),
                      (write_map,Map_Cmd)] > (map_cmd,Map_Cmd) */
  logic [1:0] map_cmd_selected;
  logic [1:0] map_cmd_select;
  initial map_cmd_select = 2'd0;
  always_comb
    begin
      map_cmd_selected = 2'd0;
      if ((| map_cmd_select)) map_cmd_selected = map_cmd_select;
      else
        if (read_map_d[0]) map_cmd_selected[0] = 1'd1;
        else if (write_map_d[0]) map_cmd_selected[1] = 1'd1;
    end
  always_ff @(posedge clk)
    map_cmd_select <= (map_cmd_r ? 2'd0 :
                       map_cmd_selected);
  always_comb
    if (map_cmd_selected[0]) map_cmd_d = read_map_d;
    else if (map_cmd_selected[1]) map_cmd_d = write_map_d;
    else map_cmd_d = {{MAP_CMD_MSB{1'bx}}, 1'd0};
  assign {write_map_r, read_map_r} = (map_cmd_r ? map_cmd_selected :
                                      2'd0);
  
  /* buf (Ty Map_Cmd) : (map_cmd,Map_Cmd) > (map_cmd_buf,Map_Cmd) */
  Map_Cmd_t map_cmd_bufchan_d;
  logic map_cmd_bufchan_r;
  Map_Cmd_t map_cmd_buf;
  initial map_cmd_buf = {{MAP_CMD_MSB{1'bx}}, 1'd0};
  assign map_cmd_r = (! map_cmd_buf[0]);
  assign map_cmd_bufchan_d = (map_cmd_buf[0] ? map_cmd_buf :
                              map_cmd_d);
  always_ff @(posedge clk)
    if ((map_cmd_bufchan_r && map_cmd_buf[0]))
      map_cmd_buf <= {{MAP_CMD_MSB{1'bx}}, 1'd0};
    else if (((! map_cmd_bufchan_r) && (! map_cmd_buf[0])))
      map_cmd_buf <= map_cmd_d;
  initial map_cmd_buf_d = {{MAP_CMD_MSB{1'bx}}, 1'd0};
  assign map_cmd_bufchan_r = ((! map_cmd_buf_d[0]) || map_cmd_buf_r);
  always_ff @(posedge clk)
    if (map_cmd_bufchan_r) map_cmd_buf_d <= map_cmd_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((map_cmd_buf_d[0] && (! map_cmd_buf_r)))
      $display("%5t blocked: map_cmd_buf", $time);
  `endif
  
  /* bram (Ty Map_Cmd,
      Ty Map_Res) : (map_cmd_buf,Map_Cmd) > (map_res,Map_Res) */
  logic [1:0] map_cmd_buf_mem[2**POINTER_MSB-1:0];
  logic [POINTER_MSB-1:0] map_cmd_buf_address;
  logic [1:0] map_cmd_buf_din;
  logic [1:0] map_res_q;
  logic map_res_valid;
  logic map_cmd_buf_we;
  logic map_res_we;
  assign map_cmd_buf_din = map_cmd_buf_d[MAP_CMD_MSB:MAP_CMD_MK_LSB];
  assign map_cmd_buf_address = map_cmd_buf_d[MAP_CMD_WORD_MSB:2];
  assign map_cmd_buf_we = (map_cmd_buf_d[1:1] && map_cmd_buf_d[0]);
  always_ff @(posedge clk)
    if (map_cmd_buf_r)
      begin
        map_res_we <= map_cmd_buf_we;
        map_res_valid <= map_cmd_buf_d[0];
        if (map_cmd_buf_we)
          begin
            map_cmd_buf_mem[map_cmd_buf_address] <= map_cmd_buf_din;
            map_res_q <= map_cmd_buf_din;
          end
        else map_res_q <= map_cmd_buf_mem[map_cmd_buf_address];
      end
  assign map_res_d = {map_res_q, map_res_we, map_res_valid};
  assign map_cmd_buf_r = ((! map_res_valid) || map_res_r);
  
  /* fork (Ty Map_Res) : (map_res,Map_Res) > [(res_choose,Map_Res),
                                         (res_use,Map_Res)] */
  logic [1:0] map_res_emitted;
  initial map_res_emitted = 2'd0;
  logic [1:0] map_res_done;
  assign res_choose_d = {map_res_d[3:1],
                         (map_res_d[0] && (! map_res_emitted[0]))};
  assign res_use_d = {map_res_d[3:1],
                      (map_res_d[0] && (! map_res_emitted[1]))};
  assign map_res_done = (map_res_emitted | ({res_use_d[0],
                                             res_choose_d[0]} & {res_use_r, res_choose_r}));
  assign map_res_r = (& map_res_done);
  always_ff @(posedge clk)
    map_res_emitted <= (map_res_r ? 2'd0 :
                        map_res_done);
  
  /* demux (Ty Map_Res,
       Ty Map_Res) : (res_choose,Map_Res) (res_use,Map_Res) > [(dat,Map_Res),
                                                               (written,Map_Res)] */
  logic [1:0] res_use_onehotd;
  always_comb
    if ((res_choose_d[0] && res_use_d[0]))
      unique case (res_choose_d[1:1])
        1'd0: res_use_onehotd = 2'd1;
        1'd1: res_use_onehotd = 2'd2;
        default: res_use_onehotd = 2'bx;
      endcase
    else res_use_onehotd = 2'd0;
  assign dat_d = {res_use_d[3:1], res_use_onehotd[0]};
  assign written_d = {res_use_d[3:1], res_use_onehotd[1]};
  assign res_use_r = (| (res_use_onehotd & {written_r, dat_r}));
  assign res_choose_r = res_use_r;
  
  /* fork (Ty Map_Res) : (written,Map_Res) > [(written_next,Map_Res),
                                         (written_out,Map_Res)] */
  logic [1:0] written_emitted;
  initial written_emitted = 2'd0;
  logic [1:0] written_done;
  assign written_next_d = {written_d[3:1],
                           (written_d[0] && (! written_emitted[0]))};
  assign written_out_d = {written_d[3:1],
                          (written_d[0] && (! written_emitted[1]))};
  assign written_done = (written_emitted | ({written_out_d[0],
                                             written_next_d[0]} & {written_out_r, written_next_r}));
  assign written_r = (& written_done);
  always_ff @(posedge clk)
    written_emitted <= (written_r ? 2'd0 :
                        written_done);
  
  /* destruct (Ty Map_Res,
          Dcon MData) : (dat,Map_Res) > [(marked,Marked)] */
  assign marked_d = {dat_d[3:2], dat_d[0]};
  assign dat_r = marked_r;
  
  /* buf (Ty Marked) : (marked,Marked) > (marked_buf,Marked) */
  Marked_t marked_bufchan_d;
  logic marked_bufchan_r;
  Marked_t marked_buf;
  initial marked_buf = {2'bx, 1'd0};
  assign marked_r = (! marked_buf[0]);
  assign marked_bufchan_d = (marked_buf[0] ? marked_buf :
                             marked_d);
  always_ff @(posedge clk)
    if ((marked_bufchan_r && marked_buf[0]))
      marked_buf <= {2'bx, 1'd0};
    else if (((! marked_bufchan_r) && (! marked_buf[0])))
      marked_buf <= marked_d;
  initial marked_buf_d = {2'bx, 1'd0};
  assign marked_bufchan_r = ((! marked_buf_d[0]) || marked_buf_r);
  always_ff @(posedge clk)
    if (marked_bufchan_r) marked_buf_d <= marked_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((marked_buf_d[0] && (! marked_buf_r)))
      $display("%5t blocked: marked_buf", $time);
  `endif
  
  /* fork (Ty Marked) : (marked_buf,Marked) > [(m0,Marked),(m1,Marked)] */
  logic [1:0] marked_buf_emitted;
  initial marked_buf_emitted = 2'd0;
  logic [1:0] marked_buf_done;
  assign m0_d = {marked_buf_d[2:1],
                 (marked_buf_d[0] && (! marked_buf_emitted[0]))};
  assign m1_d = {marked_buf_d[2:1],
                 (marked_buf_d[0] && (! marked_buf_emitted[1]))};
  assign marked_buf_done = (marked_buf_emitted | ({m1_d[0],
                                                   m0_d[0]} & {m1_r, m0_r}));
  assign marked_buf_r = (& marked_buf_done);
  always_ff @(posedge clk)
    marked_buf_emitted <= (marked_buf_r ? 2'd0 :
                           marked_buf_done);
  
  /* demux (Ty Marked,
       Ty Pointer) : (m0,Marked) (pass_ref_buf,Pointer) > [(marked_fl,Pointer),
                                                           (marked_false,Pointer),
                                                           (marked_true,Pointer)] */
  logic [2:0] pass_ref_buf_onehotd;
  always_comb
    if ((m0_d[0] && pass_ref_buf_d[0]))
      unique case (m0_d[2:1])
        2'd0: pass_ref_buf_onehotd = 3'd1;
        2'd1: pass_ref_buf_onehotd = 3'd2;
        2'd2: pass_ref_buf_onehotd = 3'd4;
        default: pass_ref_buf_onehotd = 3'bx;
      endcase
    else pass_ref_buf_onehotd = 3'd0;
  assign marked_fl_d = {pass_ref_buf_d[POINTER_MSB:1],
                        pass_ref_buf_onehotd[0]};
  assign marked_false_d = {pass_ref_buf_d[POINTER_MSB:1],
                           pass_ref_buf_onehotd[1]};
  assign marked_true_d = {pass_ref_buf_d[POINTER_MSB:1],
                          pass_ref_buf_onehotd[2]};
  assign pass_ref_buf_r = (| (pass_ref_buf_onehotd & {marked_true_r,
                                                      marked_false_r,
                                                      marked_fl_r}));
  assign m0_r = pass_ref_buf_r;
  
  /* buf (Ty Pointer) : (marked_fl,Pointer) > (marked_fl_buf,Pointer) */
  Pointer_t marked_fl_bufchan_d;
  logic marked_fl_bufchan_r;
  Pointer_t marked_fl_buf;
  initial marked_fl_buf = {{POINTER_MSB{1'bx}}, 1'd0};
  assign marked_fl_r = (! marked_fl_buf[0]);
  assign marked_fl_bufchan_d = (marked_fl_buf[0] ? marked_fl_buf :
                                marked_fl_d);
  always_ff @(posedge clk)
    if ((marked_fl_bufchan_r && marked_fl_buf[0]))
      marked_fl_buf <= {{POINTER_MSB{1'bx}}, 1'd0};
    else if (((! marked_fl_bufchan_r) && (! marked_fl_buf[0])))
      marked_fl_buf <= marked_fl_d;
  initial marked_fl_buf_d = {{POINTER_MSB{1'bx}}, 1'd0};
  assign marked_fl_bufchan_r = ((! marked_fl_buf_d[0]) || marked_fl_buf_r);
  always_ff @(posedge clk)
    if (marked_fl_bufchan_r) marked_fl_buf_d <= marked_fl_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((marked_fl_buf_d[0] && (! marked_fl_buf_r)))
      $display("%5t blocked: marked_fl_buf", $time);
  `endif
  
  /* buf (Ty Pointer) : (marked_false,Pointer) > (marked_false_buf,Pointer) */
  Pointer_t marked_false_bufchan_d;
  logic marked_false_bufchan_r;
  Pointer_t marked_false_buf;
  initial marked_false_buf = {{POINTER_MSB{1'bx}}, 1'd0};
  assign marked_false_r = (! marked_false_buf[0]);
  assign marked_false_bufchan_d = (marked_false_buf[0] ? marked_false_buf :
                                   marked_false_d);
  always_ff @(posedge clk)
    if ((marked_false_bufchan_r && marked_false_buf[0]))
      marked_false_buf <= {{POINTER_MSB{1'bx}}, 1'd0};
    else if (((! marked_false_bufchan_r) && (! marked_false_buf[0])))
      marked_false_buf <= marked_false_d;
  initial marked_false_buf_d = {{POINTER_MSB{1'bx}}, 1'd0};
  assign marked_false_bufchan_r = ((! marked_false_buf_d[0]) || marked_false_buf_r);
  always_ff @(posedge clk)
    if (marked_false_bufchan_r)
      marked_false_buf_d <= marked_false_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((marked_false_buf_d[0] && (! marked_false_buf_r)))
      $display("%5t blocked: marked_false_buf", $time);
  `endif
  
  /* buf (Ty Pointer) : (marked_true,Pointer) > (marked_true_buf,Pointer) */
  Pointer_t marked_true_bufchan_d;
  logic marked_true_bufchan_r;
  Pointer_t marked_true_buf;
  initial marked_true_buf = {{POINTER_MSB{1'bx}}, 1'd0};
  assign marked_true_r = (! marked_true_buf[0]);
  assign marked_true_bufchan_d = (marked_true_buf[0] ? marked_true_buf :
                                  marked_true_d);
  always_ff @(posedge clk)
    if ((marked_true_bufchan_r && marked_true_buf[0]))
      marked_true_buf <= {{POINTER_MSB{1'bx}}, 1'd0};
    else if (((! marked_true_bufchan_r) && (! marked_true_buf[0])))
      marked_true_buf <= marked_true_d;
  initial marked_true_buf_d = {{POINTER_MSB{1'bx}}, 1'd0};
  assign marked_true_bufchan_r = ((! marked_true_buf_d[0]) || marked_true_buf_r);
  always_ff @(posedge clk)
    if (marked_true_bufchan_r)
      marked_true_buf_d <= marked_true_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((marked_true_buf_d[0] && (! marked_true_buf_r)))
      $display("%5t blocked: marked_true_buf", $time);
  `endif
  
  /* demux (Ty Marked,
       Ty GC_Cmd) : (m1,Marked) (ms_cmd,GC_Cmd) > [(_2,GC_Cmd),
                                                   (mux_false,GC_Cmd),
                                                   (mux_true,GC_Cmd)] */
  logic [2:0] ms_cmd_onehotd;
  always_comb
    if ((m1_d[0] && ms_cmd_d[0]))
      unique case (m1_d[2:1])
        2'd0: ms_cmd_onehotd = 3'd1;
        2'd1: ms_cmd_onehotd = 3'd2;
        2'd2: ms_cmd_onehotd = 3'd4;
        default: ms_cmd_onehotd = 3'bx;
      endcase
    else ms_cmd_onehotd = 3'd0;
  assign _2_d = {ms_cmd_d[GC_CMD_MSB:1], ms_cmd_onehotd[0]};
  assign mux_false_d = {ms_cmd_d[GC_CMD_MSB:1], ms_cmd_onehotd[1]};
  assign mux_true_d = {ms_cmd_d[GC_CMD_MSB:1], ms_cmd_onehotd[2]};
  assign ms_cmd_r = (| (ms_cmd_onehotd & {mux_true_r,
                                          mux_false_r,
                                          _2_r}));
  assign m1_r = ms_cmd_r;
  
  /* fork (Ty Pointer) : (marked_false_buf,Pointer) > [(false_out,Pointer),
                                                  (false_next,Pointer)] */
  logic [1:0] marked_false_buf_emitted;
  initial marked_false_buf_emitted = 2'd0;
  logic [1:0] marked_false_buf_done;
  assign false_out_d = {marked_false_buf_d[POINTER_MSB:1],
                        (marked_false_buf_d[0] && (! marked_false_buf_emitted[0]))};
  assign false_next_d = {marked_false_buf_d[POINTER_MSB:1],
                         (marked_false_buf_d[0] && (! marked_false_buf_emitted[1]))};
  assign marked_false_buf_done = (marked_false_buf_emitted | ({false_next_d[0],
                                                               false_out_d[0]} & {false_next_r,
                                                                                  false_out_r}));
  assign marked_false_buf_r = (& marked_false_buf_done);
  always_ff @(posedge clk)
    marked_false_buf_emitted <= (marked_false_buf_r ? 2'd0 :
                                 marked_false_buf_done);
  
  /* fork (Ty GC_Cmd) : (mux_false,GC_Cmd) > [(mux_false_0,GC_Cmd),
                                         (mux_false_1,GC_Cmd)] */
  logic [1:0] mux_false_emitted;
  initial mux_false_emitted = 2'd0;
  logic [1:0] mux_false_done;
  assign mux_false_0_d = {mux_false_d[GC_CMD_MSB:1],
                          (mux_false_d[0] && (! mux_false_emitted[0]))};
  assign mux_false_1_d = {mux_false_d[GC_CMD_MSB:1],
                          (mux_false_d[0] && (! mux_false_emitted[1]))};
  assign mux_false_done = (mux_false_emitted | ({mux_false_1_d[0],
                                                 mux_false_0_d[0]} & {mux_false_1_r,
                                                                      mux_false_0_r}));
  assign mux_false_r = (& mux_false_done);
  always_ff @(posedge clk)
    mux_false_emitted <= (mux_false_r ? 2'd0 :
                          mux_false_done);
  
  /* demux (Ty GC_Cmd,
       Ty Pointer) : (mux_false_0,GC_Cmd) (false_out,Pointer) > [(read,Pointer),
                                                                 (free,Pointer),
                                                                 (er1,Pointer)] */
  logic [2:0] false_out_onehotd;
  always_comb
    if ((mux_false_0_d[0] && false_out_d[0]))
      unique case (mux_false_0_d[2:1])
        2'd0: false_out_onehotd = 3'd1;
        2'd1: false_out_onehotd = 3'd2;
        2'd2: false_out_onehotd = 3'd4;
        default: false_out_onehotd = 3'bx;
      endcase
    else false_out_onehotd = 3'd0;
  assign read_d = {false_out_d[POINTER_MSB:1], false_out_onehotd[0]};
  assign free_d = {false_out_d[POINTER_MSB:1], false_out_onehotd[1]};
  assign er1_d = {false_out_d[POINTER_MSB:1], false_out_onehotd[2]};
  assign false_out_r = (| (false_out_onehotd & {er1_r,
                                                free_r,
                                                read_r}));
  assign mux_false_0_r = false_out_r;
  
  /* demux (Ty GC_Cmd,
       Ty Pointer) : (mux_false_1,GC_Cmd) (false_next,Pointer) > [(false_mark,Pointer),
                                                                  (false_sweep,Pointer),
                                                                  (er2,Pointer)] */
  logic [2:0] false_next_onehotd;
  always_comb
    if ((mux_false_1_d[0] && false_next_d[0]))
      unique case (mux_false_1_d[2:1])
        2'd0: false_next_onehotd = 3'd1;
        2'd1: false_next_onehotd = 3'd2;
        2'd2: false_next_onehotd = 3'd4;
        default: false_next_onehotd = 3'bx;
      endcase
    else false_next_onehotd = 3'd0;
  assign false_mark_d = {false_next_d[POINTER_MSB:1], false_next_onehotd[0]};
  assign false_sweep_d = {false_next_d[POINTER_MSB:1], false_next_onehotd[1]};
  assign er2_d = {false_next_d[POINTER_MSB:1], false_next_onehotd[2]};
  assign false_next_r = (| (false_next_onehotd & {er2_r,
                                                  false_sweep_r,
                                                  false_mark_r}));
  assign mux_false_1_r = false_next_r;
  
  /* fork (Ty Pointer) : (marked_true_buf,Pointer) > [(true_out,Pointer),
                                                 (true_next,Pointer)] */
  logic [1:0] marked_true_buf_emitted;
  initial marked_true_buf_emitted = 2'd0;
  logic [1:0] marked_true_buf_done;
  assign true_out_d = {marked_true_buf_d[POINTER_MSB:1],
                       (marked_true_buf_d[0] && (! marked_true_buf_emitted[0]))};
  assign true_next_d = {marked_true_buf_d[POINTER_MSB:1],
                        (marked_true_buf_d[0] && (! marked_true_buf_emitted[1]))};
  assign marked_true_buf_done = (marked_true_buf_emitted | ({true_next_d[0],
                                                             true_out_d[0]} & {true_next_r,
                                                                               true_out_r}));
  assign marked_true_buf_r = (& marked_true_buf_done);
  always_ff @(posedge clk)
    marked_true_buf_emitted <= (marked_true_buf_r ? 2'd0 :
                                marked_true_buf_done);
  
  /* demux (Ty GC_Cmd,
       Ty Pointer) : (mux_true,GC_Cmd) (true_next,Pointer) > [(true_mark,Pointer),
                                                              (true_sweep,Pointer),
                                                              (er3,Pointer)] */
  logic [2:0] true_next_onehotd;
  always_comb
    if ((mux_true_d[0] && true_next_d[0]))
      unique case (mux_true_d[2:1])
        2'd0: true_next_onehotd = 3'd1;
        2'd1: true_next_onehotd = 3'd2;
        2'd2: true_next_onehotd = 3'd4;
        default: true_next_onehotd = 3'bx;
      endcase
    else true_next_onehotd = 3'd0;
  assign true_mark_d = {true_next_d[POINTER_MSB:1], true_next_onehotd[0]};
  assign true_sweep_d = {true_next_d[POINTER_MSB:1], true_next_onehotd[1]};
  assign er3_d = {true_next_d[POINTER_MSB:1], true_next_onehotd[2]};
  assign true_next_r = (| (true_next_onehotd & {er3_r,
                                                true_sweep_r,
                                                true_mark_r}));
  assign mux_true_r = true_next_r;
  
  /* fork (Ty Pointer) : (false_mark,Pointer) > [(false_mark_ref,Pointer),
                                            (write_true,Pointer),
                                            (mk_rm,Pointer)] */
  logic [2:0] false_mark_emitted;
  initial false_mark_emitted = 3'd0;
  logic [2:0] false_mark_done;
  assign false_mark_ref_d = {false_mark_d[POINTER_MSB:1],
                             (false_mark_d[0] && (! false_mark_emitted[0]))};
  assign write_true_d = {false_mark_d[POINTER_MSB:1],
                         (false_mark_d[0] && (! false_mark_emitted[1]))};
  assign mk_rm_d = {false_mark_d[POINTER_MSB:1],
                    (false_mark_d[0] && (! false_mark_emitted[2]))};
  assign false_mark_done = (false_mark_emitted | ({mk_rm_d[0],
                                                   write_true_d[0],
                                                   false_mark_ref_d[0]} & {mk_rm_r,
                                                                           write_true_r,
                                                                           false_mark_ref_r}));
  assign false_mark_r = (& false_mark_done);
  always_ff @(posedge clk)
    false_mark_emitted <= (false_mark_r ? 3'd0 :
                           false_mark_done);
  
  /* fork (Ty Pointer) : (false_sweep,Pointer) > [(false_sweep_ref,Pointer),
                                             (false_sweep_write,Pointer),
                                             (f_sp_rm,Pointer)] */
  logic [2:0] false_sweep_emitted;
  initial false_sweep_emitted = 3'd0;
  logic [2:0] false_sweep_done;
  assign false_sweep_ref_d = {false_sweep_d[POINTER_MSB:1],
                              (false_sweep_d[0] && (! false_sweep_emitted[0]))};
  assign false_sweep_write_d = {false_sweep_d[POINTER_MSB:1],
                                (false_sweep_d[0] && (! false_sweep_emitted[1]))};
  assign f_sp_rm_d = {false_sweep_d[POINTER_MSB:1],
                      (false_sweep_d[0] && (! false_sweep_emitted[2]))};
  assign false_sweep_done = (false_sweep_emitted | ({f_sp_rm_d[0],
                                                     false_sweep_write_d[0],
                                                     false_sweep_ref_d[0]} & {f_sp_rm_r,
                                                                              false_sweep_write_r,
                                                                              false_sweep_ref_r}));
  assign false_sweep_r = (& false_sweep_done);
  always_ff @(posedge clk)
    false_sweep_emitted <= (false_sweep_r ? 3'd0 :
                            false_sweep_done);
  
  /* fork (Ty Pointer) : (true_sweep,Pointer) > [(true_ref,Pointer),
                                            (write_false,Pointer),
                                            (t_sp_rm,Pointer)] */
  logic [2:0] true_sweep_emitted;
  initial true_sweep_emitted = 3'd0;
  logic [2:0] true_sweep_done;
  assign true_ref_d = {true_sweep_d[POINTER_MSB:1],
                       (true_sweep_d[0] && (! true_sweep_emitted[0]))};
  assign write_false_d = {true_sweep_d[POINTER_MSB:1],
                          (true_sweep_d[0] && (! true_sweep_emitted[1]))};
  assign t_sp_rm_d = {true_sweep_d[POINTER_MSB:1],
                      (true_sweep_d[0] && (! true_sweep_emitted[2]))};
  assign true_sweep_done = (true_sweep_emitted | ({t_sp_rm_d[0],
                                                   write_false_d[0],
                                                   true_ref_d[0]} & {t_sp_rm_r,
                                                                     write_false_r,
                                                                     true_ref_r}));
  assign true_sweep_r = (& true_sweep_done);
  always_ff @(posedge clk)
    true_sweep_emitted <= (true_sweep_r ? 3'd0 :
                           true_sweep_done);
  
  /* fork (Ty Pointer) : (fl_ref,Pointer) > [(fl_write_ref,Pointer),
                                        (fl_write_false,Pointer)] */
  logic [1:0] fl_ref_emitted;
  initial fl_ref_emitted = 2'd0;
  logic [1:0] fl_ref_done;
  assign fl_write_ref_d = {fl_ref_d[POINTER_MSB:1],
                           (fl_ref_d[0] && (! fl_ref_emitted[0]))};
  assign fl_write_false_d = {fl_ref_d[POINTER_MSB:1],
                             (fl_ref_d[0] && (! fl_ref_emitted[1]))};
  assign fl_ref_done = (fl_ref_emitted | ({fl_write_false_d[0],
                                           fl_write_ref_d[0]} & {fl_write_false_r,
                                                                 fl_write_ref_r}));
  assign fl_ref_r = (& fl_ref_done);
  always_ff @(posedge clk)
    fl_ref_emitted <= (fl_ref_r ? 2'd0 :
                       fl_ref_done);
  
  /* merge (Ty Pointer) : [(false_mark_ref,Pointer),
                      (false_sweep_ref,Pointer),
                      (true_ref,Pointer),
                      (fl_write_ref,Pointer)] > (write_ref,Pointer) */
  logic [3:0] write_ref_selected;
  logic [3:0] write_ref_select;
  initial write_ref_select = 4'd0;
  always_comb
    begin
      write_ref_selected = 4'd0;
      if ((| write_ref_select)) write_ref_selected = write_ref_select;
      else
        if (false_mark_ref_d[0]) write_ref_selected[0] = 1'd1;
        else if (false_sweep_ref_d[0]) write_ref_selected[1] = 1'd1;
        else if (true_ref_d[0]) write_ref_selected[2] = 1'd1;
        else if (fl_write_ref_d[0]) write_ref_selected[3] = 1'd1;
    end
  always_ff @(posedge clk)
    write_ref_select <= (write_ref_r ? 4'd0 :
                         write_ref_selected);
  always_comb
    if (write_ref_selected[0]) write_ref_d = false_mark_ref_d;
    else if (write_ref_selected[1]) write_ref_d = false_sweep_ref_d;
    else if (write_ref_selected[2]) write_ref_d = true_ref_d;
    else if (write_ref_selected[3]) write_ref_d = fl_write_ref_d;
    else write_ref_d = {{POINTER_MSB{1'bx}}, 1'd0};
  assign {fl_write_ref_r,
          true_ref_r,
          false_sweep_ref_r,
          false_mark_ref_r} = (write_ref_r ? write_ref_selected :
                               4'd0);
  
  /* destruct (Ty Pointer,
          Dcon P) : (write_ref,Pointer) > [(write_addr,Word#)] */
  assign write_addr_d = {write_ref_d[POINTER_MSB:1], write_ref_d[0]};
  assign write_ref_r = write_addr_r;
  
  /* dcon (Ty Map_Cmd,Dcon MWrite) : [(write_addr,Word#),
                                 (write_val,Marked)] > (write_map,Map_Cmd) */
  assign write_map_d = MWrite_dc((& {write_addr_d[0],
                                     write_val_d[0]}), write_addr_d, write_val_d);
  assign {write_addr_r,
          write_val_r} = {2 {(write_map_r && write_map_d[0])}};
  
  /* togo (Ty Pointer) : (fl_write_false,Pointer) > (false_0_go,Go) */
  assign false_0_go_d = fl_write_false_d[0];
  assign fl_write_false_r = false_0_go_r;
  
  /* dcon (Ty Marked,Dcon F) : [(false_0_go,Go)] > (mark_f0,Marked) */
  assign mark_f0_d = F_dc((& {false_0_go_d[0]}), false_0_go_d);
  assign {false_0_go_r} = {1 {(mark_f0_r && mark_f0_d[0])}};
  
  /* togo (Ty Pointer) : (false_sweep_write,Pointer) > (freelist_go,Go) */
  assign freelist_go_d = false_sweep_write_d[0];
  assign false_sweep_write_r = freelist_go_r;
  
  /* dcon (Ty Marked,Dcon FL) : [(freelist_go,Go)] > (mark_fl,Marked) */
  assign mark_fl_d = FL_dc((& {freelist_go_d[0]}), freelist_go_d);
  assign {freelist_go_r} = {1 {(mark_fl_r && mark_fl_d[0])}};
  
  /* togo (Ty Pointer) : (write_true,Pointer) > (true_go,Go) */
  assign true_go_d = write_true_d[0];
  assign write_true_r = true_go_r;
  
  /* dcon (Ty Marked,Dcon T) : [(true_go,Go)] > (mark_t,Marked) */
  assign mark_t_d = T_dc((& {true_go_d[0]}), true_go_d);
  assign {true_go_r} = {1 {(mark_t_r && mark_t_d[0])}};
  
  /* togo (Ty Pointer) : (write_false,Pointer) > (false_1_go,Go) */
  assign false_1_go_d = write_false_d[0];
  assign write_false_r = false_1_go_r;
  
  /* dcon (Ty Marked,Dcon F) : [(false_1_go,Go)] > (mark_f1,Marked) */
  assign mark_f1_d = F_dc((& {false_1_go_d[0]}), false_1_go_d);
  assign {false_1_go_r} = {1 {(mark_f1_r && mark_f1_d[0])}};
  
  /* merge (Ty Marked) : [(mark_f0,Marked),
                     (mark_f1,Marked),
                     (mark_t,Marked),
                     (mark_fl,Marked)] > (write_val,Marked) */
  logic [3:0] write_val_selected;
  logic [3:0] write_val_select;
  initial write_val_select = 4'd0;
  always_comb
    begin
      write_val_selected = 4'd0;
      if ((| write_val_select)) write_val_selected = write_val_select;
      else
        if (mark_f0_d[0]) write_val_selected[0] = 1'd1;
        else if (mark_f1_d[0]) write_val_selected[1] = 1'd1;
        else if (mark_t_d[0]) write_val_selected[2] = 1'd1;
        else if (mark_fl_d[0]) write_val_selected[3] = 1'd1;
    end
  always_ff @(posedge clk)
    write_val_select <= (write_val_r ? 4'd0 :
                         write_val_selected);
  always_comb
    if (write_val_selected[0]) write_val_d = mark_f0_d;
    else if (write_val_selected[1]) write_val_d = mark_f1_d;
    else if (write_val_selected[2]) write_val_d = mark_t_d;
    else if (write_val_selected[3]) write_val_d = mark_fl_d;
    else write_val_d = {2'bx, 1'd0};
  assign {mark_fl_r,
          mark_t_r,
          mark_f1_r,
          mark_f0_r} = (write_val_r ? write_val_selected :
                        4'd0);
  
  /* fork (Ty Pointer) : (marked_fl_buf,Pointer) > [(marked_fl_next,Pointer),
                                               (marked_fl_out,Pointer)] */
  logic [1:0] marked_fl_buf_emitted;
  initial marked_fl_buf_emitted = 2'd0;
  logic [1:0] marked_fl_buf_done;
  assign marked_fl_next_d = {marked_fl_buf_d[POINTER_MSB:1],
                             (marked_fl_buf_d[0] && (! marked_fl_buf_emitted[0]))};
  assign marked_fl_out_d = {marked_fl_buf_d[POINTER_MSB:1],
                            (marked_fl_buf_d[0] && (! marked_fl_buf_emitted[1]))};
  assign marked_fl_buf_done = (marked_fl_buf_emitted | ({marked_fl_out_d[0],
                                                         marked_fl_next_d[0]} & {marked_fl_out_r,
                                                                                 marked_fl_next_r}));
  assign marked_fl_buf_r = (& marked_fl_buf_done);
  always_ff @(posedge clk)
    marked_fl_buf_emitted <= (marked_fl_buf_r ? 2'd0 :
                              marked_fl_buf_done);
  
  /* togo (Ty Pointer) : (true_mark,Pointer) > (next0,Go) */
  assign next0_d = true_mark_d[0];
  assign true_mark_r = next0_r;
  
  /* togo (Ty Map_Res) : (written_next,Map_Res) > (next1,Go) */
  assign next1_d = written_next_d[0];
  assign written_next_r = next1_r;
  
  /* togo (Ty Pointer) : (marked_fl_next,Pointer) > (next2,Go) */
  assign next2_d = marked_fl_next_d[0];
  assign marked_fl_next_r = next2_r;
  
  /* merge (Ty Go) : [(next0,Go),
                 (next1,Go),
                 (next2,Go)] > (pass_next_rbuf,Go) */
  logic [2:0] pass_next_rbuf_selected;
  logic [2:0] pass_next_rbuf_select;
  initial pass_next_rbuf_select = 3'd0;
  always_comb
    begin
      pass_next_rbuf_selected = 3'd0;
      if ((| pass_next_rbuf_select))
        pass_next_rbuf_selected = pass_next_rbuf_select;
      else
        if (next0_d[0]) pass_next_rbuf_selected[0] = 1'd1;
        else if (next1_d[0]) pass_next_rbuf_selected[1] = 1'd1;
        else if (next2_d[0]) pass_next_rbuf_selected[2] = 1'd1;
    end
  always_ff @(posedge clk)
    pass_next_rbuf_select <= (pass_next_rbuf_r ? 3'd0 :
                              pass_next_rbuf_selected);
  always_comb
    if (pass_next_rbuf_selected[0]) pass_next_rbuf_d = next0_d;
    else if (pass_next_rbuf_selected[1]) pass_next_rbuf_d = next1_d;
    else if (pass_next_rbuf_selected[2]) pass_next_rbuf_d = next2_d;
    else pass_next_rbuf_d = 1'd0;
  assign {next2_r,
          next1_r,
          next0_r} = (pass_next_rbuf_r ? pass_next_rbuf_selected :
                      3'd0);
  
  /* togo (Ty Pointer) : (true_out,Pointer) > (marked_go,Go) */
  assign marked_go_d = true_out_d[0];
  assign true_out_r = marked_go_r;
  
  /* dcon (Ty GC_Res,
      Dcon Marked) : [(marked_go,Go)] > (res_marked,GC_Res) */
  assign res_marked_d = Marked_dc((& {marked_go_d[0]}), marked_go_d);
  assign {marked_go_r} = {1 {(res_marked_r && res_marked_d[0])}};
  
  /* dcon (Ty GC_Res,Dcon Freed) : [(ack_buf,Go)] > (res_freed,GC_Res) */
  assign res_freed_d = Freed_dc((& {ack_buf_d[0]}), ack_buf_d);
  assign {ack_buf_r} = {1 {(res_freed_r && res_freed_d[0])}};
  
  /* buf (Ty Node) : (node,Node) > (node_buf,Node) */
  Node_t node_bufchan_d;
  logic node_bufchan_r;
  Node_t node_buf;
  initial node_buf = {{NODE_MSB{1'bx}}, 1'd0};
  assign node_r = (! node_buf[0]);
  assign node_bufchan_d = (node_buf[0] ? node_buf :
                           node_d);
  always_ff @(posedge clk)
    if ((node_bufchan_r && node_buf[0])) node_buf <= {{NODE_MSB{1'bx}}, 1'd0};
    else if (((! node_bufchan_r) && (! node_buf[0])))
      node_buf <= node_d;
  initial node_buf_d = {{NODE_MSB{1'bx}}, 1'd0};
  assign node_bufchan_r = ((! node_buf_d[0]) || node_buf_r);
  always_ff @(posedge clk)
    if (node_bufchan_r) node_buf_d <= node_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((node_buf_d[0] && (! node_buf_r)))
      $display("%5t blocked: node_buf", $time);
  `endif
  
  /* fork (Ty Node) : (node_buf,Node) > [(node_choose,Node),
                                    (node_pass,Node)] */
  logic [1:0] node_buf_emitted;
  initial node_buf_emitted = 2'd0;
  logic [1:0] node_buf_done;
  assign node_choose_d = {node_buf_d[NODE_MSB:1],
                          (node_buf_d[0] && (! node_buf_emitted[0]))};
  assign node_pass_d = {node_buf_d[NODE_MSB:1],
                        (node_buf_d[0] && (! node_buf_emitted[1]))};
  assign node_buf_done = (node_buf_emitted | ({node_pass_d[0],
                                               node_choose_d[0]} & {node_pass_r, node_choose_r}));
  assign node_buf_r = (& node_buf_done);
  always_ff @(posedge clk)
    node_buf_emitted <= (node_buf_r ? 2'd0 :
                         node_buf_done);
  
  /* demux (Ty Node,
       Ty Node) : (node_choose,Node) (node_pass,Node) > [(null_node,Node),
                                                         (val_node,Node)] */
  logic [1:0] node_pass_onehotd;
  always_comb
    if ((node_choose_d[0] && node_pass_d[0]))
      unique case (node_choose_d[1:1])
        1'd0: node_pass_onehotd = 2'd1;
        1'd1: node_pass_onehotd = 2'd2;
        default: node_pass_onehotd = 2'bx;
      endcase
    else node_pass_onehotd = 2'd0;
  assign null_node_d = {node_pass_d[NODE_MSB:1], node_pass_onehotd[0]};
  assign val_node_d = {node_pass_d[NODE_MSB:1], node_pass_onehotd[1]};
  assign node_pass_r = (| (node_pass_onehotd & {val_node_r,
                                                null_node_r}));
  assign node_choose_r = node_pass_r;
  
  /* destruct (Ty Node,Dcon Nul) : (null_node,Node) > [(nochild_go,Go)] */
  assign nochild_go_d = null_node_d[0];
  assign null_node_r = nochild_go_r;
  
  /* destruct (Ty Node,Dcon Nd) : (val_node,Node) > [(_1,Word#),
                                                (val,Pointer)] */
  logic [1:0] val_node_emitted;
  initial val_node_emitted = 2'd0;
  logic [1:0] val_node_done;
  assign _1_d = {val_node_d[NODE_WORD_MSB:2],
                 (val_node_d[0] && (! val_node_emitted[0]))};
  assign val_d = {val_node_d[NODE_MSB:NODE_PTR_LSB],
                  (val_node_d[0] && (! val_node_emitted[1]))};
  assign val_node_done = (val_node_emitted | ({val_d[0],
                                               _1_d[0]} & {val_r, _1_r}));
  assign val_node_r = (& val_node_done);
  always_ff @(posedge clk)
    val_node_emitted <= (val_node_r ? 2'd0 :
                         val_node_done);
  
  /* dcon (Ty GC_Res,
      Dcon NoChild) : [(nochild_go,Go)] > (res_nochild,GC_Res) */
  assign res_nochild_d = NoChild_dc((& {nochild_go_d[0]}), nochild_go_d);
  assign {nochild_go_r} = {1 {(res_nochild_r && res_nochild_d[0])}};
  
  /* dcon (Ty GC_Res,
      Dcon OneChild) : [(val,Pointer)] > (res_child,GC_Res) */
  assign res_child_d = OneChild_dc((& {val_d[0]}), val_d);
  assign {val_r} = {1 {(res_child_r && res_child_d[0])}};
  
  /* togo (Ty Pointer) : (marked_fl_out,Pointer) > (alreadyfree_go,Go) */
  assign alreadyfree_go_d = marked_fl_out_d[0];
  assign marked_fl_out_r = alreadyfree_go_r;
  
  /* dcon (Ty GC_Res,
      Dcon AlreadyFree) : [(alreadyfree_go,Go)] > (res_alreadyfree,GC_Res) */
  assign res_alreadyfree_d = AlreadyFree_dc((& {alreadyfree_go_d[0]}), alreadyfree_go_d);
  assign {alreadyfree_go_r} = {1 {(res_alreadyfree_r && res_alreadyfree_d[0])}};
  
  /* togo (Ty GC_Cmd) : (mux_fl,GC_Cmd) > (fl_bl,Go) */
  assign fl_bl_d = mux_fl_d[0];
  assign mux_fl_r = fl_bl_r;
  
  /* togo (Ty Pointer) : (f_sp_rm,Pointer) > (f_sp_bl,Go) */
  assign f_sp_bl_d = f_sp_rm_d[0];
  assign f_sp_rm_r = f_sp_bl_r;
  
  /* togo (Ty Pointer) : (t_sp_rm,Pointer) > (t_sp_bl,Go) */
  assign t_sp_bl_d = t_sp_rm_d[0];
  assign t_sp_rm_r = t_sp_bl_r;
  
  /* togo (Ty Pointer) : (mk_rm,Pointer) > (mk_bl,Go) */
  assign mk_bl_d = mk_rm_d[0];
  assign mk_rm_r = mk_bl_r;
  
  /* dcon (Ty Tog,Dcon One) : [(fl_bl,Go)] > (fl_tg,Tog) */
  assign fl_tg_d = One_dc((& {fl_bl_d[0]}), fl_bl_d);
  assign {fl_bl_r} = {1 {(fl_tg_r && fl_tg_d[0])}};
  
  /* dcon (Ty Tog,Dcon Zero) : [(f_sp_bl,Go)] > (f_sp_tg,Tog) */
  assign f_sp_tg_d = Zero_dc((& {f_sp_bl_d[0]}), f_sp_bl_d);
  assign {f_sp_bl_r} = {1 {(f_sp_tg_r && f_sp_tg_d[0])}};
  
  /* dcon (Ty Tog,Dcon Zero) : [(t_sp_bl,Go)] > (t_sp_tg,Tog) */
  assign t_sp_tg_d = Zero_dc((& {t_sp_bl_d[0]}), t_sp_bl_d);
  assign {t_sp_bl_r} = {1 {(t_sp_tg_r && t_sp_tg_d[0])}};
  
  /* dcon (Ty Tog,Dcon Zero) : [(mk_bl,Go)] > (mk_tg,Tog) */
  assign mk_tg_d = Zero_dc((& {mk_bl_d[0]}), mk_bl_d);
  assign {mk_bl_r} = {1 {(mk_tg_r && mk_tg_d[0])}};
  
  /* merge (Ty Tog) : [(fl_tg,Tog),
                  (f_sp_tg,Tog),
                  (t_sp_tg,Tog),
                  (mk_tg,Tog)] > (rm_choose,Tog) */
  logic [3:0] rm_choose_selected;
  logic [3:0] rm_choose_select;
  initial rm_choose_select = 4'd0;
  always_comb
    begin
      rm_choose_selected = 4'd0;
      if ((| rm_choose_select)) rm_choose_selected = rm_choose_select;
      else
        if (fl_tg_d[0]) rm_choose_selected[0] = 1'd1;
        else if (f_sp_tg_d[0]) rm_choose_selected[1] = 1'd1;
        else if (t_sp_tg_d[0]) rm_choose_selected[2] = 1'd1;
        else if (mk_tg_d[0]) rm_choose_selected[3] = 1'd1;
    end
  always_ff @(posedge clk)
    rm_choose_select <= (rm_choose_r ? 4'd0 :
                         rm_choose_selected);
  always_comb
    if (rm_choose_selected[0]) rm_choose_d = fl_tg_d;
    else if (rm_choose_selected[1]) rm_choose_d = f_sp_tg_d;
    else if (rm_choose_selected[2]) rm_choose_d = t_sp_tg_d;
    else if (rm_choose_selected[3]) rm_choose_d = mk_tg_d;
    else rm_choose_d = {1'bx, 1'd0};
  assign {mk_tg_r,
          t_sp_tg_r,
          f_sp_tg_r,
          fl_tg_r} = (rm_choose_r ? rm_choose_selected :
                      4'd0);
  
  /* demux (Ty Tog,
       Ty Map_Res) : (rm_choose,Tog) (written_out,Map_Res) > [(_0,Map_Res),
                                                              (rm_ack,Map_Res)] */
  logic [1:0] written_out_onehotd;
  always_comb
    if ((rm_choose_d[0] && written_out_d[0]))
      unique case (rm_choose_d[1:1])
        1'd0: written_out_onehotd = 2'd1;
        1'd1: written_out_onehotd = 2'd2;
        default: written_out_onehotd = 2'bx;
      endcase
    else written_out_onehotd = 2'd0;
  assign _0_d = {written_out_d[3:1], written_out_onehotd[0]};
  assign rm_ack_d = {written_out_d[3:1], written_out_onehotd[1]};
  assign written_out_r = (| (written_out_onehotd & {rm_ack_r,
                                                    _0_r}));
  assign rm_choose_r = written_out_r;
  
  /* togo (Ty Map_Res) : (rm_ack,Map_Res) > (removed_go,Go) */
  assign removed_go_d = rm_ack_d[0];
  assign rm_ack_r = removed_go_r;
  
  /* dcon (Ty GC_Res,
      Dcon Removed) : [(removed_go,Go)] > (res_removed,GC_Res) */
  assign res_removed_d = Removed_dc((& {removed_go_d[0]}), removed_go_d);
  assign {removed_go_r} = {1 {(res_removed_r && res_removed_d[0])}};
  
  /* merge (Ty GC_Res) : [(res_marked,GC_Res),
                     (res_freed,GC_Res),
                     (res_nochild,GC_Res),
                     (res_child,GC_Res),
                     (res_alreadyfree,GC_Res),
                     (res_removed,GC_Res)] > (res,GC_Res) */
  logic [5:0] res_selected;
  logic [5:0] res_select;
  initial res_select = 6'd0;
  always_comb
    begin
      res_selected = 6'd0;
      if ((| res_select)) res_selected = res_select;
      else
        if (res_marked_d[0]) res_selected[0] = 1'd1;
        else if (res_freed_d[0]) res_selected[1] = 1'd1;
        else if (res_nochild_d[0]) res_selected[2] = 1'd1;
        else if (res_child_d[0]) res_selected[3] = 1'd1;
        else if (res_alreadyfree_d[0]) res_selected[4] = 1'd1;
        else if (res_removed_d[0]) res_selected[5] = 1'd1;
    end
  always_ff @(posedge clk)
    res_select <= (res_r ? 6'd0 :
                   res_selected);
  always_comb
    if (res_selected[0]) res_d = res_marked_d;
    else if (res_selected[1]) res_d = res_freed_d;
    else if (res_selected[2]) res_d = res_nochild_d;
    else if (res_selected[3]) res_d = res_child_d;
    else if (res_selected[4]) res_d = res_alreadyfree_d;
    else if (res_selected[5]) res_d = res_removed_d;
    else res_d = {{GC_RES_MSB{1'bx}}, 1'd0};
  assign {res_removed_r,
          res_alreadyfree_r,
          res_child_r,
          res_nochild_r,
          res_freed_r,
          res_marked_r} = (res_r ? res_selected :
                           6'd0);
  
  /* togo (Ty Pointer) : (er1,Pointer) > (er1_go,Go) */
  assign er1_go_d = er1_d[0];
  assign er1_r = er1_go_r;
  
  /* togo (Ty Pointer) : (er2,Pointer) > (er2_go,Go) */
  assign er2_go_d = er2_d[0];
  assign er2_r = er2_go_r;
  
  /* togo (Ty Pointer) : (er3,Pointer) > (er3_go,Go) */
  assign er3_go_d = er3_d[0];
  assign er3_r = er3_go_r;
  
  /* merge (Ty Go) : [(er1_go,Go),
                 (er2_go,Go),
                 (er3_go,Go)] > (all_errors,Go) */
  logic [2:0] all_errors_selected;
  logic [2:0] all_errors_select;
  initial all_errors_select = 3'd0;
  always_comb
    begin
      all_errors_selected = 3'd0;
      if ((| all_errors_select)) all_errors_selected = all_errors_select;
      else
        if (er1_go_d[0]) all_errors_selected[0] = 1'd1;
        else if (er2_go_d[0]) all_errors_selected[1] = 1'd1;
        else if (er3_go_d[0]) all_errors_selected[2] = 1'd1;
    end
  always_ff @(posedge clk)
    all_errors_select <= (all_errors_r ? 3'd0 :
                          all_errors_selected);
  always_comb
    if (all_errors_selected[0]) all_errors_d = er1_go_d;
    else if (all_errors_selected[1]) all_errors_d = er2_go_d;
    else if (all_errors_selected[2]) all_errors_d = er3_go_d;
    else all_errors_d = 1'd0;
  assign {er3_go_r,
          er2_go_r,
          er1_go_r} = (all_errors_r ? all_errors_selected :
                       3'd0);
  
  /* dcon (Ty Raise_Err,
      Dcon GC_D) : [(all_errors,Go)] > (dpath_error,Raise_Err) */
  assign dpath_error_d = GC_D_dc((& {all_errors_d[0]}), all_errors_d);
  assign {all_errors_r} = {1 {(dpath_error_r && dpath_error_d[0])}};
  
  /* sink (Ty Pointer) : (read,Pointer) > */
  assign {read_r, read_dout} = {read_rout, read_d};
  
  /* sink (Ty Pointer) : (free,Pointer) > */
  assign {free_r, free_dout} = {free_rout, free_d};
  
  /* sink (Ty GC_Res) : (res,GC_Res) > */
  assign {res_r, res_dout} = {res_rout, res_d};
  
  /* sink (Ty Raise_Err) : (dpath_error,Raise_Err) > */
  assign {dpath_error_r, dpath_error_dout} = {dpath_error_rout,
                                              dpath_error_d};
  
  /* Lack-of-progress detector */
  `ifdef CHECK_PROGRESS
  logic [10:0] bufferedChannelValids;
  logic [10:0] bufferedChannelReadys;
  logic [10:0] last1BufferedChannelValids;
  logic [10:0] last1BufferedChannelReadys;
  logic [10:0] last2BufferedChannelValids;
  logic [10:0] last2BufferedChannelReadys;
  initial last1BufferedChannelValids = 11'd0;
  initial last1BufferedChannelReadys = 11'd0;
  initial last2BufferedChannelValids = 11'd1;
  initial last2BufferedChannelReadys = 11'd1;
  assign bufferedChannelValids = {ack_buf_d[0],
                                  pass_next_d[0],
                                  pass_next_buf_d[0],
                                  ref_buf_d[0],
                                  pass_ref_buf_d[0],
                                  map_cmd_buf_d[0],
                                  marked_buf_d[0],
                                  marked_fl_buf_d[0],
                                  marked_false_buf_d[0],
                                  marked_true_buf_d[0],
                                  node_buf_d[0]};
  assign bufferedChannelReadys = {ack_buf_r,
                                  pass_next_r,
                                  pass_next_buf_r,
                                  ref_buf_r,
                                  pass_ref_buf_r,
                                  map_cmd_buf_r,
                                  marked_buf_r,
                                  marked_fl_buf_r,
                                  marked_false_buf_r,
                                  marked_true_buf_r,
                                  node_buf_r};
  always_ff @(posedge clk)
    begin
      last1BufferedChannelValids <= bufferedChannelValids;
      last1BufferedChannelReadys <= bufferedChannelReadys;
      last2BufferedChannelValids <= last1BufferedChannelValids;
      last2BufferedChannelReadys <= last1BufferedChannelReadys;
      if (((((last2BufferedChannelValids == last1BufferedChannelValids) && (last1BufferedChannelValids == bufferedChannelValids)) && (last2BufferedChannelReadys == last1BufferedChannelReadys)) && (last1BufferedChannelReadys == bufferedChannelReadys)))
        begin
          $display("%6t no progress", $time);
          $display(" valids %b", last2BufferedChannelValids);
          $display(" readys %b", last2BufferedChannelReadys);
          $display(" valids %b", last1BufferedChannelValids);
          $display(" readys %b", last1BufferedChannelReadys);
          $display(" valids %b", bufferedChannelValids);
          $display(" readys %b", bufferedChannelReadys);
          if ((ack_buf_d[0] && (! ack_buf_r))) $display(" blocked ack_buf");
          if ((pass_next_d[0] && (! pass_next_r)))
            $display(" blocked pass_next");
          if ((pass_next_buf_d[0] && (! pass_next_buf_r)))
            $display(" blocked pass_next_buf");
          if ((ref_buf_d[0] && (! ref_buf_r))) $display(" blocked ref_buf");
          if ((pass_ref_buf_d[0] && (! pass_ref_buf_r)))
            $display(" blocked pass_ref_buf");
          if ((map_cmd_buf_d[0] && (! map_cmd_buf_r)))
            $display(" blocked map_cmd_buf");
          if ((marked_buf_d[0] && (! marked_buf_r)))
            $display(" blocked marked_buf");
          if ((marked_fl_buf_d[0] && (! marked_fl_buf_r)))
            $display(" blocked marked_fl_buf");
          if ((marked_false_buf_d[0] && (! marked_false_buf_r)))
            $display(" blocked marked_false_buf");
          if ((marked_true_buf_d[0] && (! marked_true_buf_r)))
            $display(" blocked marked_true_buf");
          if ((node_buf_d[0] && (! node_buf_r)))
            $display(" blocked node_buf");
          $finish();
        end
    end
  `endif
  /* Wake Node Reporting */
  `ifdef WAKE_REPORT
  /* wake ack_buf:buf */
  /* wake pass_next:initbuf */
  /* wake pass_next_buf:rbuf */
  /* wake next_cmd:mux */
  /* wake ref_buf:buf */
  /* wake pass_ref_buf:buf */
  /* wake map_cmd_buf:buf */
  /* wake marked_buf:buf */
  /* wake marked_fl_buf:buf */
  /* wake marked_false_buf:buf */
  /* wake marked_true_buf:buf */
  /* wake node_buf:buf */
  always_ff @(posedge clk)
    $display("wake %b", {(ack_buf_d[0] || (ack_d[0] || ack_bufchan_d[0])),
                         (pass_next_d[0] || pass_next_buf_d[0]),
                         (pass_next_buf_d[0] || pass_next_rbuf_d[0]),
                         next_cmd_d[0],
                         (ref_buf_d[0] || (ref_d[0] || ref_bufchan_d[0])),
                         (pass_ref_buf_d[0] || (pass_ref_d[0] || pass_ref_bufchan_d[0])),
                         (map_cmd_buf_d[0] || (map_cmd_d[0] || map_cmd_bufchan_d[0])),
                         (marked_buf_d[0] || (marked_d[0] || marked_bufchan_d[0])),
                         (marked_fl_buf_d[0] || (marked_fl_d[0] || marked_fl_bufchan_d[0])),
                         (marked_false_buf_d[0] || (marked_false_d[0] || marked_false_bufchan_d[0])),
                         (marked_true_buf_d[0] || (marked_true_d[0] || marked_true_bufchan_d[0])),
                         (node_buf_d[0] || (node_d[0] || node_bufchan_d[0]))});
  `endif
endmodule
