//`include "Types.sv"

module GC_Control(input logic clk,
		  input        \Word#_t num_roots_d,
		  output logic num_roots_r,
		  input        Root_t root_d,
		  output logic root_r,
		  input        \Word#_t base_d,
		  output logic base_r,
		  input        \Word#_t bound_d,
		  output logic bound_r,
		  input        GC_Res_t gc_res_d,
		  output       gc_res_r,
		  output       GC_Cmd_t gc_cmd_dout,
		  input logic  gc_cmd_rout,
		  output       Go_t done_dout,
		  input logic  done_rout,
		  input        Pointer_t alloc_d,
		  output logic alloc_r,
		  input        Go_t force_gc_d,
		  output logic force_gc_r,
		  output       Go_t start_gc_dout,
		  input logic  start_gc_rout,
		  output       Raise_Err_t root_error_dout,
		  input logic  root_error_rout,
		  output       Raise_Err_t sweep_error_dout,
		  input logic  sweep_error_rout,
		  input        \Word#_t threshold_d,
		  output logic threshold_r
		  );


   parameter POINTER_BITS = 17;
   parameter NODE_BITS = 34;

   // parameter WORD_MSB = 16;
   // parameter POINTER_MSB = 16;
   // parameter ROOT_MSB = 17;
   // parameter GC_CMD_MSB = 18;
   // parameter GC_RES_MSB = 19;
   
   Go_t sweep_done_d;
   logic 		       sweep_done_r;
   Go_t mark_start_d;
   logic 		       mark_start_r;
   Go_t mark_done_d;
   logic 		       mark_done_r;
   Pointer_t chase_ref_d;
   logic 		       chase_ref_r;
   Go_t chase_done_d;
   logic 		       chase_done_r;
   GC_Cmd_t mark_cmd_d;
   logic 		       mark_cmd_r;
   GC_Res_t mark_res_d;
   logic 		       mark_res_r;
   GC_Cmd_t sweep_cmd_d;
   logic 		       sweep_cmd_r;
   GC_Res_t sweep_res_d;
   logic 		       sweep_res_r;
   GC_Cmd_t list_cmd_d;
   logic 		       list_cmd_r;
   GC_Res_t list_res_d;
   logic 		       list_res_r;
   Go_t freed_d;
   logic 		       freed_r;
   \Word#_t sweep_base_d;
   logic 		       sweep_base_r;
   \Word#_t sweep_bound_d;
   logic 		       sweep_bound_r;
   \Word#_t list_base_d;
   logic 		       list_base_r;
   \Word#_t list_bound_d;
   logic 		       list_bound_r;
   
   MarkCtrl #(.POINTER_BITS(POINTER_BITS),
	      .NODE_BITS(NODE_BITS)) markCtrl(.clk(clk),
					    .num_roots_d(num_roots_d),
					    .num_roots_r(num_roots_r),
					    .input_d(root_d),
					    .input_r(root_r),
					    .start_mark_d(mark_start_d),
					    .start_mark_r(mark_start_r),
					    .add_done_d(chase_done_d),
					    .add_done_r(chase_done_r),
					    .chase_ref_dout(chase_ref_d),
					    .chase_ref_rout(chase_ref_r),
					    .end_mark_dout(mark_done_d),
					    .end_mark_rout(mark_done_r)
					    );

   RootChase #(.POINTER_BITS(POINTER_BITS),
	       .NODE_BITS(NODE_BITS)) rootChase(.clk(clk),
						  .root_d(chase_ref_d),
						  .root_r(chase_ref_r),
						  .res_d(mark_res_d),
						  .res_r(mark_res_r),
						  .done_out_dout(chase_done_d),
						  .done_out_rout(chase_done_r),
						  .cmd_dout(mark_cmd_d),
						  .cmd_rout(mark_cmd_r),
						  .root_error_dout(root_error_dout),
						  .root_error_rout(root_error_rout)
						  );

   GoFork2 done_fork(.clk(clk),
		     .input_d(sweep_done_d),
		     .input_r(sweep_done_r),
		     .output1_dout(mark_start_d),
		     .output1_rout(mark_start_r),
		     .output2_dout(done_dout),
		     .output2_rout(done_rout)
		     );
   
   SweepCtrl #(.POINTER_BITS(POINTER_BITS),
	       .NODE_BITS(NODE_BITS)) sweepCtrl(.clk(clk),
						  .base_d(sweep_base_d),
						  .base_r(sweep_base_r),
						  .bound_d(sweep_bound_d),
						  .bound_r(sweep_bound_r),
						  .start_d(mark_done_d),
						  .start_r(mark_done_r),
						  .res_d(sweep_res_d),
						  .res_r(sweep_res_r),
						  .cmd_dout(sweep_cmd_d),
						  .cmd_rout(sweep_cmd_r),
						  .end_sweep_dout(sweep_done_d),
						  .end_sweep_rout(sweep_done_r),
						  .freed_dout(freed_d),
						  .freed_rout(freed_r),
						  .sweep_error_dout(sweep_error_dout),
						  .sweep_error_rout(sweep_error_rout)
						  );

   ListCtrl #(.POINTER_BITS(POINTER_BITS),
	      .NODE_BITS(NODE_BITS)) listCtrl(.clk(clk),
					    .freed_d(freed_d),
					    .freed_r(freed_r),
					    .removed_d(list_res_d),
					    .removed_r(list_res_r),
					    .alloc_d(alloc_d),
					    .alloc_r(alloc_r),
					    .gc_d(force_gc_d),
					    .gc_r(force_gc_r),
					    .base_d(list_base_d),
					    .base_r(list_base_r),
					    .bound_d(list_bound_d),
					    .bound_r(list_bound_r),
					    .threshold_d(threshold_d),
					    .threshold_r(threshold_r),
					    .do_gc_dout(start_gc_dout),
					    .do_gc_rout(start_gc_rout),
					    .cmd_dout(list_cmd_d),
					    .cmd_rout(list_cmd_r)
					    );

   WordFork2 #(.POINTER_BITS(POINTER_BITS),
	       .NODE_BITS(NODE_BITS)) base_fork(.clk(clk),
					      .input_d(base_d),
					      .input_r(base_r),
					      .output1_dout(sweep_base_d),
					      .output1_rout(sweep_base_r),
					      .output2_dout(list_base_d),
					      .output2_rout(list_base_r)
					      );

   WordFork2 #(.POINTER_BITS(POINTER_BITS),
	       .NODE_BITS(NODE_BITS)) bound_fork(.clk(clk),
					       .input_d(bound_d),
					       .input_r(bound_r),
					       .output1_dout(sweep_bound_d),
					       .output1_rout(sweep_bound_r),
					       .output2_dout(list_bound_d),
					       .output2_rout(list_bound_r)
					       );
   
   GCMerge3 #(.POINTER_BITS(POINTER_BITS),
	      .NODE_BITS(NODE_BITS)) gc_cmd_merge(.clk(clk),
						    .cmd0_d(sweep_cmd_d),
						    .cmd0_r(sweep_cmd_r),
						    .cmd1_d(list_cmd_d),
						    .cmd1_r(list_cmd_r),
						    .cmd2_d(mark_cmd_d),
						    .cmd2_r(mark_cmd_r),
						    .res_in_d(gc_res_d),
						    .res_in_r(gc_res_r),
						    .res0_dout(sweep_res_d),
						    .res0_rout(sweep_res_r),
						    .res1_dout(list_res_d),
						    .res1_rout(list_res_r),
						    .res2_dout(mark_res_d),
						    .res2_rout(mark_res_r),
						    .cmd_out_dout(gc_cmd_dout),
						    .cmd_out_rout(gc_cmd_rout)
						    );
   
endmodule
