//`include "Types.sv"

module GCMerge3(
  input logic clk,
  input GC_Cmd_t cmd0_d,
  output logic cmd0_r,
  input GC_Cmd_t cmd1_d,
  output logic cmd1_r,
  input GC_Cmd_t cmd2_d,
  output logic cmd2_r,
  input GC_Res_t res_in_d,
  output logic res_in_r,
  output GC_Res_t res0_dout,
  input logic res0_rout,
  output GC_Res_t res1_dout,
  input logic res1_rout,
  output GC_Res_t res2_dout,
  input logic res2_rout,
  output GC_Cmd_t cmd_out_dout,
  input logic cmd_out_rout
  );
  /* --define=INPUTS=((cmd0, 18, 262144, GC_Cmd), (cmd1, 18, 262144, GC_Cmd), (cmd2, 18, 262144, GC_Cmd), (res_in, 19, 524288, GC_Res)) */
  /* --define=TAPS=() */
  /* --define=OUTPUTS=((res0, 19, 524288, GC_Res), (res1, 19, 524288, GC_Res), (res2, 19, 524288, GC_Res), (cmd_out, 18, 262144, GC_Cmd)) */
  /* TYPE_START
TYPE_END */
  /*  */
  /*  */

   parameter POINTER_BITS = 17;
   parameter NODE_BITS = 34;

   parameter GC_CMD_MSB = POINTER_BITS+1; //18;
   parameter GC_RES_MSB = POINTER_BITS+2; //19;
   
  GC_Cmd_t i0_d;
  logic i0_r;
  GC_Cmd_t i1_d;
  logic i1_r;
  GC_Cmd_t i2_d;
  logic i2_r;
  GC_Cmd_t ii0_d;
  logic ii0_r;
  GC_Cmd_t ii1_d;
  logic ii1_r;
  GC_Cmd_t ii2_d;
  logic ii2_r;
  GC_Res_t i3_d;
  logic i3_r;
  GC_Res_t ii3_d;
  logic ii3_r;
  Sel3_t s_d;
  logic s_r;
  GC_Cmd_t ccmd_out_d;
  logic ccmd_out_r;
  GC_Cmd_t cmd_out_d;
  logic cmd_out_r;
  Sel3_t ss_d;
  logic ss_r;
  Sel3_t sss_d;
  logic sss_r;
  Sel3_t ssss_d;
  logic ssss_r;
  Sel3_t sssss_d;
  logic sssss_r;
  GC_Res_t rres0_d;
  logic rres0_r;
  GC_Res_t rres1_d;
  logic rres1_r;
  GC_Res_t rres2_d;
  logic rres2_r;
  GC_Res_t res0_d;
  logic res0_r;
  GC_Res_t res1_d;
  logic res1_r;
  GC_Res_t res2_d;
  logic res2_r;
  
  /* source (Ty GC_Cmd) : > (cmd0,GC_Cmd) */
  
  /* source (Ty GC_Cmd) : > (cmd1,GC_Cmd) */
  
  /* source (Ty GC_Cmd) : > (cmd2,GC_Cmd) */
  
  /* source (Ty GC_Res) : > (res_in,GC_Res) */
  
  /* buf (Ty GC_Cmd) : (cmd0,GC_Cmd) > (i0,GC_Cmd) */
  GC_Cmd_t cmd0_bufchan_d;
  logic cmd0_bufchan_r;
  GC_Cmd_t cmd0_buf;
  initial cmd0_buf = {{GC_CMD_MSB{1'bx}}, 1'd0};
  assign cmd0_r = (! cmd0_buf[0]);
  assign cmd0_bufchan_d = (cmd0_buf[0] ? cmd0_buf :
                           cmd0_d);
  always_ff @(posedge clk)
    if ((cmd0_bufchan_r && cmd0_buf[0])) cmd0_buf <= {{GC_CMD_MSB{1'bx}}, 1'd0};
    else if (((! cmd0_bufchan_r) && (! cmd0_buf[0])))
      cmd0_buf <= cmd0_d;
  initial i0_d = {{GC_CMD_MSB{1'bx}}, 1'd0};
  assign cmd0_bufchan_r = ((! i0_d[0]) || i0_r);
  always_ff @(posedge clk)
    if (cmd0_bufchan_r) i0_d <= cmd0_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((i0_d[0] && (! i0_r))) $display("%5t blocked: i0", $time);
  `endif
  
  /* buf (Ty GC_Cmd) : (cmd1,GC_Cmd) > (i1,GC_Cmd) */
  GC_Cmd_t cmd1_bufchan_d;
  logic cmd1_bufchan_r;
  GC_Cmd_t cmd1_buf;
  initial cmd1_buf = {{GC_CMD_MSB{1'bx}}, 1'd0};
  assign cmd1_r = (! cmd1_buf[0]);
  assign cmd1_bufchan_d = (cmd1_buf[0] ? cmd1_buf :
                           cmd1_d);
  always_ff @(posedge clk)
    if ((cmd1_bufchan_r && cmd1_buf[0])) cmd1_buf <= {{GC_CMD_MSB{1'bx}}, 1'd0};
    else if (((! cmd1_bufchan_r) && (! cmd1_buf[0])))
      cmd1_buf <= cmd1_d;
  initial i1_d = {{GC_CMD_MSB{1'bx}}, 1'd0};
  assign cmd1_bufchan_r = ((! i1_d[0]) || i1_r);
  always_ff @(posedge clk)
    if (cmd1_bufchan_r) i1_d <= cmd1_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((i1_d[0] && (! i1_r))) $display("%5t blocked: i1", $time);
  `endif
  
  /* buf (Ty GC_Cmd) : (cmd2,GC_Cmd) > (i2,GC_Cmd) */
  GC_Cmd_t cmd2_bufchan_d;
  logic cmd2_bufchan_r;
  GC_Cmd_t cmd2_buf;
  initial cmd2_buf = {{GC_CMD_MSB{1'bx}}, 1'd0};
  assign cmd2_r = (! cmd2_buf[0]);
  assign cmd2_bufchan_d = (cmd2_buf[0] ? cmd2_buf :
                           cmd2_d);
  always_ff @(posedge clk)
    if ((cmd2_bufchan_r && cmd2_buf[0])) cmd2_buf <= {{GC_CMD_MSB{1'bx}}, 1'd0};
    else if (((! cmd2_bufchan_r) && (! cmd2_buf[0])))
      cmd2_buf <= cmd2_d;
  initial i2_d = {{GC_CMD_MSB{1'bx}}, 1'd0};
  assign cmd2_bufchan_r = ((! i2_d[0]) || i2_r);
  always_ff @(posedge clk)
    if (cmd2_bufchan_r) i2_d <= cmd2_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((i2_d[0] && (! i2_r))) $display("%5t blocked: i2", $time);
  `endif
  
  /* buf (Ty GC_Cmd) : (i0,GC_Cmd) > (ii0,GC_Cmd) */
  GC_Cmd_t i0_bufchan_d;
  logic i0_bufchan_r;
  GC_Cmd_t i0_buf;
  initial i0_buf = {{GC_CMD_MSB{1'bx}}, 1'd0};
  assign i0_r = (! i0_buf[0]);
  assign i0_bufchan_d = (i0_buf[0] ? i0_buf :
                         i0_d);
  always_ff @(posedge clk)
    if ((i0_bufchan_r && i0_buf[0])) i0_buf <= {{GC_CMD_MSB{1'bx}}, 1'd0};
    else if (((! i0_bufchan_r) && (! i0_buf[0]))) i0_buf <= i0_d;
  initial ii0_d = {{GC_CMD_MSB{1'bx}}, 1'd0};
  assign i0_bufchan_r = ((! ii0_d[0]) || ii0_r);
  always_ff @(posedge clk)
    if (i0_bufchan_r) ii0_d <= i0_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((ii0_d[0] && (! ii0_r))) $display("%5t blocked: ii0", $time);
  `endif
  
  /* buf (Ty GC_Cmd) : (i1,GC_Cmd) > (ii1,GC_Cmd) */
  GC_Cmd_t i1_bufchan_d;
  logic i1_bufchan_r;
  GC_Cmd_t i1_buf;
  initial i1_buf = {{GC_CMD_MSB{1'bx}}, 1'd0};
  assign i1_r = (! i1_buf[0]);
  assign i1_bufchan_d = (i1_buf[0] ? i1_buf :
                         i1_d);
  always_ff @(posedge clk)
    if ((i1_bufchan_r && i1_buf[0])) i1_buf <= {{GC_CMD_MSB{1'bx}}, 1'd0};
    else if (((! i1_bufchan_r) && (! i1_buf[0]))) i1_buf <= i1_d;
  initial ii1_d = {{GC_CMD_MSB{1'bx}}, 1'd0};
  assign i1_bufchan_r = ((! ii1_d[0]) || ii1_r);
  always_ff @(posedge clk)
    if (i1_bufchan_r) ii1_d <= i1_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((ii1_d[0] && (! ii1_r))) $display("%5t blocked: ii1", $time);
  `endif
  
  /* buf (Ty GC_Cmd) : (i2,GC_Cmd) > (ii2,GC_Cmd) */
  GC_Cmd_t i2_bufchan_d;
  logic i2_bufchan_r;
  GC_Cmd_t i2_buf;
  initial i2_buf = {{GC_CMD_MSB{1'bx}}, 1'd0};
  assign i2_r = (! i2_buf[0]);
  assign i2_bufchan_d = (i2_buf[0] ? i2_buf :
                         i2_d);
  always_ff @(posedge clk)
    if ((i2_bufchan_r && i2_buf[0])) i2_buf <= {{GC_CMD_MSB{1'bx}}, 1'd0};
    else if (((! i2_bufchan_r) && (! i2_buf[0]))) i2_buf <= i2_d;
  initial ii2_d = {{GC_CMD_MSB{1'bx}}, 1'd0};
  assign i2_bufchan_r = ((! ii2_d[0]) || ii2_r);
  always_ff @(posedge clk)
    if (i2_bufchan_r) ii2_d <= i2_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((ii2_d[0] && (! ii2_r))) $display("%5t blocked: ii2", $time);
  `endif
  
  /* buf (Ty GC_Res) : (res_in,GC_Res) > (i3,GC_Res) */
  GC_Res_t res_in_bufchan_d;
  logic res_in_bufchan_r;
  GC_Res_t res_in_buf;
  initial res_in_buf = {{GC_RES_MSB{1'bx}}, 1'd0};
  assign res_in_r = (! res_in_buf[0]);
  assign res_in_bufchan_d = (res_in_buf[0] ? res_in_buf :
                             res_in_d);
  always_ff @(posedge clk)
    if ((res_in_bufchan_r && res_in_buf[0]))
      res_in_buf <= {{GC_RES_MSB{1'bx}}, 1'd0};
    else if (((! res_in_bufchan_r) && (! res_in_buf[0])))
      res_in_buf <= res_in_d;
  initial i3_d = {{GC_RES_MSB{1'bx}}, 1'd0};
  assign res_in_bufchan_r = ((! i3_d[0]) || i3_r);
  always_ff @(posedge clk)
    if (res_in_bufchan_r) i3_d <= res_in_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((i3_d[0] && (! i3_r))) $display("%5t blocked: i3", $time);
  `endif
  
  /* buf (Ty GC_Res) : (i3,GC_Res) > (ii3,GC_Res) */
  GC_Res_t i3_bufchan_d;
  logic i3_bufchan_r;
  GC_Res_t i3_buf;
  initial i3_buf = {{GC_RES_MSB{1'bx}}, 1'd0};
  assign i3_r = (! i3_buf[0]);
  assign i3_bufchan_d = (i3_buf[0] ? i3_buf :
                         i3_d);
  always_ff @(posedge clk)
    if ((i3_bufchan_r && i3_buf[0])) i3_buf <= {{GC_RES_MSB{1'bx}}, 1'd0};
    else if (((! i3_bufchan_r) && (! i3_buf[0]))) i3_buf <= i3_d;
  initial ii3_d = {{GC_RES_MSB{1'bx}}, 1'd0};
  assign i3_bufchan_r = ((! ii3_d[0]) || ii3_r);
  always_ff @(posedge clk)
    if (i3_bufchan_r) ii3_d <= i3_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((ii3_d[0] && (! ii3_r))) $display("%5t blocked: ii3", $time);
  `endif
  
  /* mergectrl (Ty Sel3,Ty GC_Cmd) : [(ii0,GC_Cmd),
                                 (ii1,GC_Cmd),
                                 (ii2,GC_Cmd)] > (s,Sel3) (ccmd_out,GC_Cmd) */
  logic [2:0] ii0_select_d;
  assign ii0_select_d = ((| ii0_select_q) ? ii0_select_q :
                         (ii0_d[0] ? 3'd1 :
                          (ii1_d[0] ? 3'd2 :
                           (ii2_d[0] ? 3'd4 :
                            3'd0))));
  logic [2:0] ii0_select_q;
  initial ii0_select_q = 3'd0;
  always_ff @(posedge clk)
    ii0_select_q <= (ii0_done ? 3'd0 :
                     ii0_select_d);
  logic [1:0] ii0_emit_q;
  initial ii0_emit_q = 2'd0;
  always_ff @(posedge clk)
    ii0_emit_q <= (ii0_done ? 2'd0 :
                   ii0_emit_d);
  logic [1:0] ii0_emit_d;
  assign ii0_emit_d = (ii0_emit_q | ({s_d[0], ccmd_out_d[0]} & {s_r,
                                                                ccmd_out_r}));
  logic ii0_done;
  assign ii0_done = (& ii0_emit_d);
  assign {ii2_r, ii1_r, ii0_r} = (ii0_done ? ii0_select_d :
                                  3'd0);
  assign ccmd_out_d = ((ii0_select_d[0] && (! ii0_emit_q[0])) ? ii0_d :
                       ((ii0_select_d[1] && (! ii0_emit_q[0])) ? ii1_d :
                        ((ii0_select_d[2] && (! ii0_emit_q[0])) ? ii2_d :
                         {{GC_CMD_MSB{1'bx}}, 1'd0})));
  assign s_d = ((ii0_select_d[0] && (! ii0_emit_q[1])) ? I30_dc(1'd1) :
                ((ii0_select_d[1] && (! ii0_emit_q[1])) ? I31_dc(1'd1) :
                 ((ii0_select_d[2] && (! ii0_emit_q[1])) ? I32_dc(1'd1) :
                  {2'bx, 1'd0})));
  
  /* buf (Ty GC_Cmd) : (ccmd_out,GC_Cmd) > (cmd_out,GC_Cmd) */
  GC_Cmd_t ccmd_out_bufchan_d;
  logic ccmd_out_bufchan_r;
  GC_Cmd_t ccmd_out_buf;
  initial ccmd_out_buf = {{GC_CMD_MSB{1'bx}}, 1'd0};
  assign ccmd_out_r = (! ccmd_out_buf[0]);
  assign ccmd_out_bufchan_d = (ccmd_out_buf[0] ? ccmd_out_buf :
                               ccmd_out_d);
  always_ff @(posedge clk)
    if ((ccmd_out_bufchan_r && ccmd_out_buf[0]))
      ccmd_out_buf <= {{GC_CMD_MSB{1'bx}}, 1'd0};
    else if (((! ccmd_out_bufchan_r) && (! ccmd_out_buf[0])))
      ccmd_out_buf <= ccmd_out_d;
  initial cmd_out_d = {{GC_CMD_MSB{1'bx}}, 1'd0};
  assign ccmd_out_bufchan_r = ((! cmd_out_d[0]) || cmd_out_r);
  always_ff @(posedge clk)
    if (ccmd_out_bufchan_r) cmd_out_d <= ccmd_out_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((cmd_out_d[0] && (! cmd_out_r)))
      $display("%5t blocked: cmd_out", $time);
  `endif
  
  /* buf (Ty Sel3) : (s,Sel3) > (ss,Sel3) */
  Sel3_t s_bufchan_d;
  logic s_bufchan_r;
  Sel3_t s_buf;
  initial s_buf = {2'bx, 1'd0};
  assign s_r = (! s_buf[0]);
  assign s_bufchan_d = (s_buf[0] ? s_buf :
                        s_d);
  always_ff @(posedge clk)
    if ((s_bufchan_r && s_buf[0])) s_buf <= {2'bx, 1'd0};
    else if (((! s_bufchan_r) && (! s_buf[0]))) s_buf <= s_d;
  initial ss_d = {2'bx, 1'd0};
  assign s_bufchan_r = ((! ss_d[0]) || ss_r);
  always_ff @(posedge clk)
    if (s_bufchan_r) ss_d <= s_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((ss_d[0] && (! ss_r))) $display("%5t blocked: ss", $time);
  `endif
  
  /* buf (Ty Sel3) : (ss,Sel3) > (sss,Sel3) */
  Sel3_t ss_bufchan_d;
  logic ss_bufchan_r;
  Sel3_t ss_buf;
  initial ss_buf = {2'bx, 1'd0};
  assign ss_r = (! ss_buf[0]);
  assign ss_bufchan_d = (ss_buf[0] ? ss_buf :
                         ss_d);
  always_ff @(posedge clk)
    if ((ss_bufchan_r && ss_buf[0])) ss_buf <= {2'bx, 1'd0};
    else if (((! ss_bufchan_r) && (! ss_buf[0]))) ss_buf <= ss_d;
  initial sss_d = {2'bx, 1'd0};
  assign ss_bufchan_r = ((! sss_d[0]) || sss_r);
  always_ff @(posedge clk)
    if (ss_bufchan_r) sss_d <= ss_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((sss_d[0] && (! sss_r))) $display("%5t blocked: sss", $time);
  `endif
  
  /* buf (Ty Sel3) : (sss,Sel3) > (ssss,Sel3) */
  Sel3_t sss_bufchan_d;
  logic sss_bufchan_r;
  Sel3_t sss_buf;
  initial sss_buf = {2'bx, 1'd0};
  assign sss_r = (! sss_buf[0]);
  assign sss_bufchan_d = (sss_buf[0] ? sss_buf :
                          sss_d);
  always_ff @(posedge clk)
    if ((sss_bufchan_r && sss_buf[0])) sss_buf <= {2'bx, 1'd0};
    else if (((! sss_bufchan_r) && (! sss_buf[0]))) sss_buf <= sss_d;
  initial ssss_d = {2'bx, 1'd0};
  assign sss_bufchan_r = ((! ssss_d[0]) || ssss_r);
  always_ff @(posedge clk)
    if (sss_bufchan_r) ssss_d <= sss_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((ssss_d[0] && (! ssss_r)))
      $display("%5t blocked: ssss", $time);
  `endif
  
  /* buf (Ty Sel3) : (ssss,Sel3) > (sssss,Sel3) */
  Sel3_t ssss_bufchan_d;
  logic ssss_bufchan_r;
  Sel3_t ssss_buf;
  initial ssss_buf = {2'bx, 1'd0};
  assign ssss_r = (! ssss_buf[0]);
  assign ssss_bufchan_d = (ssss_buf[0] ? ssss_buf :
                           ssss_d);
  always_ff @(posedge clk)
    if ((ssss_bufchan_r && ssss_buf[0])) ssss_buf <= {2'bx, 1'd0};
    else if (((! ssss_bufchan_r) && (! ssss_buf[0])))
      ssss_buf <= ssss_d;
  initial sssss_d = {2'bx, 1'd0};
  assign ssss_bufchan_r = ((! sssss_d[0]) || sssss_r);
  always_ff @(posedge clk)
    if (ssss_bufchan_r) sssss_d <= ssss_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((sssss_d[0] && (! sssss_r)))
      $display("%5t blocked: sssss", $time);
  `endif
  
  /* demux (Ty Sel3,
       Ty GC_Res) : (sssss,Sel3) (ii3,GC_Res) > [(rres0,GC_Res),
                                                 (rres1,GC_Res),
                                                 (rres2,GC_Res)] */
  logic [2:0] ii3_onehotd;
  always_comb
    if ((sssss_d[0] && ii3_d[0]))
      unique case (sssss_d[2:1])
        2'd0: ii3_onehotd = 3'd1;
        2'd1: ii3_onehotd = 3'd2;
        2'd2: ii3_onehotd = 3'd4;
        default: ii3_onehotd = 3'bx;
      endcase
    else ii3_onehotd = 3'd0;
  assign rres0_d = {ii3_d[GC_RES_MSB:1], ii3_onehotd[0]};
  assign rres1_d = {ii3_d[GC_RES_MSB:1], ii3_onehotd[1]};
  assign rres2_d = {ii3_d[GC_RES_MSB:1], ii3_onehotd[2]};
  assign ii3_r = (| (ii3_onehotd & {rres2_r, rres1_r, rres0_r}));
  assign sssss_r = ii3_r;
  
  /* buf (Ty GC_Res) : (rres0,GC_Res) > (res0,GC_Res) */
  GC_Res_t rres0_bufchan_d;
  logic rres0_bufchan_r;
  GC_Res_t rres0_buf;
  initial rres0_buf = {{GC_RES_MSB{1'bx}}, 1'd0};
  assign rres0_r = (! rres0_buf[0]);
  assign rres0_bufchan_d = (rres0_buf[0] ? rres0_buf :
                            rres0_d);
  always_ff @(posedge clk)
    if ((rres0_bufchan_r && rres0_buf[0])) rres0_buf <= {{GC_RES_MSB{1'bx}}, 1'd0};
    else if (((! rres0_bufchan_r) && (! rres0_buf[0])))
      rres0_buf <= rres0_d;
  initial res0_d = {{GC_RES_MSB{1'bx}}, 1'd0};
  assign rres0_bufchan_r = ((! res0_d[0]) || res0_r);
  always_ff @(posedge clk)
    if (rres0_bufchan_r) res0_d <= rres0_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((res0_d[0] && (! res0_r)))
      $display("%5t blocked: res0", $time);
  `endif
  
  /* buf (Ty GC_Res) : (rres1,GC_Res) > (res1,GC_Res) */
  GC_Res_t rres1_bufchan_d;
  logic rres1_bufchan_r;
  GC_Res_t rres1_buf;
  initial rres1_buf = {{GC_RES_MSB{1'bx}}, 1'd0};
  assign rres1_r = (! rres1_buf[0]);
  assign rres1_bufchan_d = (rres1_buf[0] ? rres1_buf :
                            rres1_d);
  always_ff @(posedge clk)
    if ((rres1_bufchan_r && rres1_buf[0])) rres1_buf <= {{GC_RES_MSB{1'bx}}, 1'd0};
    else if (((! rres1_bufchan_r) && (! rres1_buf[0])))
      rres1_buf <= rres1_d;
  initial res1_d = {{GC_RES_MSB{1'bx}}, 1'd0};
  assign rres1_bufchan_r = ((! res1_d[0]) || res1_r);
  always_ff @(posedge clk)
    if (rres1_bufchan_r) res1_d <= rres1_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((res1_d[0] && (! res1_r)))
      $display("%5t blocked: res1", $time);
  `endif
  
  /* buf (Ty GC_Res) : (rres2,GC_Res) > (res2,GC_Res) */
  GC_Res_t rres2_bufchan_d;
  logic rres2_bufchan_r;
  GC_Res_t rres2_buf;
  initial rres2_buf = {{GC_RES_MSB{1'bx}}, 1'd0};
  assign rres2_r = (! rres2_buf[0]);
  assign rres2_bufchan_d = (rres2_buf[0] ? rres2_buf :
                            rres2_d);
  always_ff @(posedge clk)
    if ((rres2_bufchan_r && rres2_buf[0])) rres2_buf <= {{GC_RES_MSB{1'bx}}, 1'd0};
    else if (((! rres2_bufchan_r) && (! rres2_buf[0])))
      rres2_buf <= rres2_d;
  initial res2_d = {{GC_RES_MSB{1'bx}}, 1'd0};
  assign rres2_bufchan_r = ((! res2_d[0]) || res2_r);
  always_ff @(posedge clk)
    if (rres2_bufchan_r) res2_d <= rres2_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((res2_d[0] && (! res2_r)))
      $display("%5t blocked: res2", $time);
  `endif
  
  /* sink (Ty GC_Res) : (res0,GC_Res) > */
  assign {res0_r, res0_dout} = {res0_rout, res0_d};
  
  /* sink (Ty GC_Res) : (res1,GC_Res) > */
  assign {res1_r, res1_dout} = {res1_rout, res1_d};
  
  /* sink (Ty GC_Res) : (res2,GC_Res) > */
  assign {res2_r, res2_dout} = {res2_rout, res2_d};
  
  /* sink (Ty GC_Cmd) : (cmd_out,GC_Cmd) > */
  assign {cmd_out_r, cmd_out_dout} = {cmd_out_rout, cmd_out_d};
  
  /* Lack-of-progress detector */
  `ifdef CHECK_PROGRESS
  logic [15:0] bufferedChannelValids;
  logic [15:0] bufferedChannelReadys;
  logic [15:0] last1BufferedChannelValids;
  logic [15:0] last1BufferedChannelReadys;
  logic [15:0] last2BufferedChannelValids;
  logic [15:0] last2BufferedChannelReadys;
  initial last1BufferedChannelValids = 16'd0;
  initial last1BufferedChannelReadys = 16'd0;
  initial last2BufferedChannelValids = 16'd1;
  initial last2BufferedChannelReadys = 16'd1;
  assign bufferedChannelValids = {i0_d[0],
                                  i1_d[0],
                                  i2_d[0],
                                  ii0_d[0],
                                  ii1_d[0],
                                  ii2_d[0],
                                  i3_d[0],
                                  ii3_d[0],
                                  cmd_out_d[0],
                                  ss_d[0],
                                  sss_d[0],
                                  ssss_d[0],
                                  sssss_d[0],
                                  res0_d[0],
                                  res1_d[0],
                                  res2_d[0]};
  assign bufferedChannelReadys = {i0_r,
                                  i1_r,
                                  i2_r,
                                  ii0_r,
                                  ii1_r,
                                  ii2_r,
                                  i3_r,
                                  ii3_r,
                                  cmd_out_r,
                                  ss_r,
                                  sss_r,
                                  ssss_r,
                                  sssss_r,
                                  res0_r,
                                  res1_r,
                                  res2_r};
  always_ff @(posedge clk)
    begin
      last1BufferedChannelValids <= bufferedChannelValids;
      last1BufferedChannelReadys <= bufferedChannelReadys;
      last2BufferedChannelValids <= last1BufferedChannelValids;
      last2BufferedChannelReadys <= last1BufferedChannelReadys;
      if (((((last2BufferedChannelValids == last1BufferedChannelValids) && (last1BufferedChannelValids == bufferedChannelValids)) && (last2BufferedChannelReadys == last1BufferedChannelReadys)) && (last1BufferedChannelReadys == bufferedChannelReadys)))
        begin
          $display("%6t no progress", $time);
          $display(" valids %b", last2BufferedChannelValids);
          $display(" readys %b", last2BufferedChannelReadys);
          $display(" valids %b", last1BufferedChannelValids);
          $display(" readys %b", last1BufferedChannelReadys);
          $display(" valids %b", bufferedChannelValids);
          $display(" readys %b", bufferedChannelReadys);
          if ((i0_d[0] && (! i0_r))) $display(" blocked i0");
          if ((i1_d[0] && (! i1_r))) $display(" blocked i1");
          if ((i2_d[0] && (! i2_r))) $display(" blocked i2");
          if ((ii0_d[0] && (! ii0_r))) $display(" blocked ii0");
          if ((ii1_d[0] && (! ii1_r))) $display(" blocked ii1");
          if ((ii2_d[0] && (! ii2_r))) $display(" blocked ii2");
          if ((i3_d[0] && (! i3_r))) $display(" blocked i3");
          if ((ii3_d[0] && (! ii3_r))) $display(" blocked ii3");
          if ((cmd_out_d[0] && (! cmd_out_r))) $display(" blocked cmd_out");
          if ((ss_d[0] && (! ss_r))) $display(" blocked ss");
          if ((sss_d[0] && (! sss_r))) $display(" blocked sss");
          if ((ssss_d[0] && (! ssss_r))) $display(" blocked ssss");
          if ((sssss_d[0] && (! sssss_r))) $display(" blocked sssss");
          if ((res0_d[0] && (! res0_r))) $display(" blocked res0");
          if ((res1_d[0] && (! res1_r))) $display(" blocked res1");
          if ((res2_d[0] && (! res2_r))) $display(" blocked res2");
          $finish();
        end
    end
  `endif
  /* Wake Node Reporting */
  `ifdef WAKE_REPORT
  /* wake i0:buf */
  /* wake i1:buf */
  /* wake i2:buf */
  /* wake ii0:buf */
  /* wake ii1:buf */
  /* wake ii2:buf */
  /* wake i3:buf */
  /* wake ii3:buf */
  /* wake cmd_out:buf */
  /* wake ss:buf */
  /* wake sss:buf */
  /* wake ssss:buf */
  /* wake sssss:buf */
  /* wake res0:buf */
  /* wake res1:buf */
  /* wake res2:buf */
  always_ff @(posedge clk)
    $display("wake %b", {(i0_d[0] || (cmd0_d[0] || cmd0_bufchan_d[0])),
                         (i1_d[0] || (cmd1_d[0] || cmd1_bufchan_d[0])),
                         (i2_d[0] || (cmd2_d[0] || cmd2_bufchan_d[0])),
                         (ii0_d[0] || (i0_d[0] || i0_bufchan_d[0])),
                         (ii1_d[0] || (i1_d[0] || i1_bufchan_d[0])),
                         (ii2_d[0] || (i2_d[0] || i2_bufchan_d[0])),
                         (i3_d[0] || (res_in_d[0] || res_in_bufchan_d[0])),
                         (ii3_d[0] || (i3_d[0] || i3_bufchan_d[0])),
                         (cmd_out_d[0] || (ccmd_out_d[0] || ccmd_out_bufchan_d[0])),
                         (ss_d[0] || (s_d[0] || s_bufchan_d[0])),
                         (sss_d[0] || (ss_d[0] || ss_bufchan_d[0])),
                         (ssss_d[0] || (sss_d[0] || sss_bufchan_d[0])),
                         (sssss_d[0] || (ssss_d[0] || ssss_bufchan_d[0])),
                         (res0_d[0] || (rres0_d[0] || rres0_bufchan_d[0])),
                         (res1_d[0] || (rres1_d[0] || rres1_bufchan_d[0])),
                         (res2_d[0] || (rres2_d[0] || rres2_bufchan_d[0]))});
  `endif
endmodule
