//`include "Types.sv"

module Free(
  input logic clk,
  input \Word#_t  init_d,
  output logic init_r,
  input Pointer_t input_d,
  output logic input_r,
  input Res_t res_in_d,
  output logic res_in_r,
  output Cmd_t cmd_out_dout,
  input logic cmd_out_rout,
  output Go_t free_ack_dout,
  input logic free_ack_rout
  );
  /* --define=INPUTS=((init, 16, 65536, Word__023), (input, 16, 65536, Pointer), (res_in, 34, 17179869184, Res)) */
  /* --define=TAPS=() */
  /* --define=OUTPUTS=((cmd_out, 50, 1125899906842624, Cmd), (free_ack, 0, 1, Go)) */
  /* TYPE_START
TYPE_END */
  /*  */
  /*  */

   parameter POINTER_BITS = 17;
   parameter NODE_BITS = 34;

   parameter POINTER_MSB = POINTER_BITS-1; //16;
   parameter WORD_MSB = POINTER_BITS-1; //16;
   parameter RES_MSB = NODE_BITS; //34;
   parameter CMD_MSB = NODE_BITS+POINTER_BITS-1; //50;
  
  Pointer_t inbuf_d;
  logic inbuf_r;
  Pointer_t ref0_d;
  logic ref0_r;
  Pointer_t ref1_d;
  logic ref1_r;
  Pointer_t ref2_d;
  logic ref2_r;
  Pointer_t ref3_d;
  logic ref3_r;
  \Word#_t  addr0_d;
  logic addr0_r;
  \Word#_t  end_addr_d;
  logic end_addr_r;
  \Word#_t  end_tok_d;
  logic end_tok_r;
  \Word#_t  end_min_d;
  logic end_min_r;
  Go_t minus_1_go_d;
  logic minus_1_go_r;
  \Word#_t  minus_1_d;
  logic minus_1_r;
  \Word#_t  end_addr_ex_d;
  logic end_addr_ex_r;
  Go_t end_go_d;
  logic end_go_r;
  Tog_t choose_init_d;
  logic choose_init_r;
  Tog_t choose_d;
  logic choose_r;
  \Word#_t  addr_out_d;
  logic addr_out_r;
  \Word#_t  use_addr_d;
  logic use_addr_r;
  \Word#_t  loop_addr_d;
  logic loop_addr_r;
  \Word#_t  i_addr0_d;
  logic i_addr0_r;
  \Word#_t  addr_buf_d;
  logic addr_buf_r;
  Go_t addr_go_d;
  logic addr_go_r;
  Tog_t choose_addr_d;
  logic choose_addr_r;
  \Word#_t  zero_buf0_d;
  logic zero_buf0_r;
  \Word#_t  zero_buf0_in_d;
  logic zero_buf0_in_r;
  \Word#_t  zero_buf0_out_d;
  logic zero_buf0_out_r;
  \Word#_t  zero_buf0_rdy_d;
  logic zero_buf0_rdy_r;
  Node_t node0_d;
  logic node0_r;
  Cmd_t cmd0_d;
  logic cmd0_r;
  \Word#_t  addr1_d;
  logic addr1_r;
  Go_t nul_node_d;
  logic nul_node_r;
  Node_t node1_d;
  logic node1_r;
  Cmd_t cmd1_d;
  logic cmd1_r;
  Cmd_t cmd_out_d;
  logic cmd_out_r;
  S_t sel_d;
  logic sel_r;
  S_t sel_loop_d;
  logic sel_loop_r;
  S_t sel_out_d;
  logic sel_out_r;
  S_t sel_new_r_d;
  logic sel_new_r_r;
  S_t sel_new_d;
  logic sel_new_r;
  S_t sel_zero_d;
  logic sel_zero_r;
  S_t sel_zero_loop_d;
  logic sel_zero_loop_r;
  S_t sel_one_d;
  logic sel_one_r;
  S_t sel_one_loop_d;
  logic sel_one_loop_r;
  S_t sel_zero_out_d;
  logic sel_zero_out_r;
  S_t sel_zero_r_d;
  logic sel_zero_r_r;
  S_t sel_one_out_d;
  logic sel_one_out_r;
  S_t sel_one_r_d;
  logic sel_one_r_r;
  S_t rsel_d;
  logic rsel_r;
  S_t rsel_loop_d;
  logic rsel_loop_r;
  S_t rsel_out_d;
  logic rsel_out_r;
  S_t rsel_new_r_d;
  logic rsel_new_r_r;
  S_t rsel_new_d;
  logic rsel_new_r;
  S_t rsel_zero_d;
  logic rsel_zero_r;
  S_t rsel_zero_loop_d;
  logic rsel_zero_loop_r;
  S_t rsel_one_d;
  logic rsel_one_r;
  S_t rsel_one_loop_d;
  logic rsel_one_loop_r;
  S_t rsel_zero_out_d;
  logic rsel_zero_out_r;
  S_t rsel_zero_r_d;
  logic rsel_zero_r_r;
  S_t rsel_one_out_d;
  logic rsel_one_out_r;
  S_t rsel_one_r_d;
  logic rsel_one_r_r;
  Res_t _0_d;
  logic _0_r;
  assign _0_r = 1'd1;
  Res_t ack_d;
  logic ack_r;
  Go_t free_ack_d;
  logic free_ack_r;
  
  /* source (Ty Word#) : > (init,Word#) */
  
  /* source (Ty Pointer) : > (input,Pointer) */
  
  /* source (Ty Res) : > (res_in,Res) */
  
  /* buf (Ty Pointer) : (input,Pointer) > (inbuf,Pointer) */
  Pointer_t input_bufchan_d;
  logic input_bufchan_r;
  Pointer_t input_buf;
  initial input_buf = {{POINTER_MSB{1'bx}}, 1'd0};
  assign input_r = (! input_buf[0]);
  assign input_bufchan_d = (input_buf[0] ? input_buf :
                            input_d);
  always_ff @(posedge clk)
    if ((input_bufchan_r && input_buf[0])) input_buf <= {{POINTER_MSB{1'bx}}, 1'd0};
    else if (((! input_bufchan_r) && (! input_buf[0])))
      input_buf <= input_d;
  initial inbuf_d = {{POINTER_MSB{1'bx}}, 1'd0};
  assign input_bufchan_r = ((! inbuf_d[0]) || inbuf_r);
  always_ff @(posedge clk)
    if (input_bufchan_r) inbuf_d <= input_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((inbuf_d[0] && (! inbuf_r)))
      $display("%5t blocked: inbuf", $time);
  `endif
  
  /* fork (Ty Pointer) : (inbuf,Pointer) > [(ref0,Pointer),
                                       (ref1,Pointer),
                                       (ref2,Pointer),
                                       (ref3,Pointer)] */
  logic [3:0] inbuf_emitted;
  initial inbuf_emitted = 4'd0;
  logic [3:0] inbuf_done;
  assign ref0_d = {inbuf_d[POINTER_MSB:1],
                   (inbuf_d[0] && (! inbuf_emitted[0]))};
  assign ref1_d = {inbuf_d[POINTER_MSB:1],
                   (inbuf_d[0] && (! inbuf_emitted[1]))};
  assign ref2_d = {inbuf_d[POINTER_MSB:1],
                   (inbuf_d[0] && (! inbuf_emitted[2]))};
  assign ref3_d = {inbuf_d[POINTER_MSB:1],
                   (inbuf_d[0] && (! inbuf_emitted[3]))};
  assign inbuf_done = (inbuf_emitted | ({ref3_d[0],
                                         ref2_d[0],
                                         ref1_d[0],
                                         ref0_d[0]} & {ref3_r, ref2_r, ref1_r, ref0_r}));
  assign inbuf_r = (& inbuf_done);
  always_ff @(posedge clk)
    inbuf_emitted <= (inbuf_r ? 4'd0 :
                      inbuf_done);
  
  /* destruct (Ty Pointer,Dcon P) : (ref0,Pointer) > [(addr0,Word#)] */
  assign addr0_d = {ref0_d[POINTER_MSB:1], ref0_d[0]};
  assign ref0_r = addr0_r;
  
  /* fork (Ty Word#) : (init,Word#) > [(end_addr,Word#),
                                      (end_tok,Word#),
                                      (end_min,Word#)] */
  logic [2:0] init_emitted;
  initial init_emitted = 3'd0;
  logic [2:0] init_done;
  assign end_addr_d = {init_d[WORD_MSB:1],
                       (init_d[0] && (! init_emitted[0]))};
  assign end_tok_d = {init_d[WORD_MSB:1],
                      (init_d[0] && (! init_emitted[1]))};
  assign end_min_d = {init_d[WORD_MSB:1],
                      (init_d[0] && (! init_emitted[2]))};
  assign init_done = (init_emitted | ({end_min_d[0],
                                       end_tok_d[0],
                                       end_addr_d[0]} & {end_min_r, end_tok_r, end_addr_r}));
  assign init_r = (& init_done);
  always_ff @(posedge clk)
    init_emitted <= (init_r ? 3'd0 :
                     init_done);
  
  /* togo (Ty Word#) : (end_min,Word#) > (minus_1_go,Go) */
  assign minus_1_go_d = end_min_d[0];
  assign end_min_r = minus_1_go_r;
  
  /* const (Ty Word#,Lit 1) : (minus_1_go,Go) > (minus_1,Word#) */
  assign minus_1_d = {{WORD_MSB-1{1'd0}}, 1'd1, minus_1_go_d[0]};
  assign minus_1_go_r = minus_1_r;
  
  /* op_sub (Ty Word#) : (end_addr,Word#) (minus_1,Word#) > (end_addr_ex,Word#) */
  assign end_addr_ex_d = {(end_addr_d[WORD_MSB:1] - minus_1_d[WORD_MSB:1]),
                          (end_addr_d[0] && minus_1_d[0])};
  assign {end_addr_r,
          minus_1_r} = {2 {(end_addr_ex_r && end_addr_ex_d[0])}};
  
  /* togo (Ty Word#) : (end_tok,Word#) > (end_go,Go) */
  assign end_go_d = end_tok_d[0];
  assign end_tok_r = end_go_r;
  
  /* dcon (Ty Tog,Dcon Zero) : [(end_go,Go)] > (choose_init,Tog) */
  assign choose_init_d = Zero_dc((& {end_go_d[0]}), end_go_d);
  assign {end_go_r} = {1 {(choose_init_r && choose_init_d[0])}};
  
  /* merge (Ty Tog) : [(choose_addr,Tog),
                  (choose_init,Tog)] > (choose,Tog) */
  logic [1:0] choose_selected;
  logic [1:0] choose_select;
  initial choose_select = 2'd0;
  always_comb
    begin
      choose_selected = 2'd0;
      if ((| choose_select)) choose_selected = choose_select;
      else
        if (choose_addr_d[0]) choose_selected[0] = 1'd1;
        else if (choose_init_d[0]) choose_selected[1] = 1'd1;
    end
  always_ff @(posedge clk)
    choose_select <= (choose_r ? 2'd0 :
                      choose_selected);
  always_comb
    if (choose_selected[0]) choose_d = choose_addr_d;
    else if (choose_selected[1]) choose_d = choose_init_d;
    else choose_d = {1'bx, 1'd0};
  assign {choose_init_r,
          choose_addr_r} = (choose_r ? choose_selected :
                            2'd0);
  
  /* mux (Ty Tog,Ty Word#) : (choose,Tog) [(end_addr_ex,Word#),
                                        (addr0,Word#)] > (addr_out,Word#) */
  logic [WORD_MSB:0] addr_out_mux;
  logic [1:0] addr_out_onehot;
  always_comb
    unique case (choose_d[1:1])
      1'd0: {addr_out_onehot, addr_out_mux} = {2'd1, end_addr_ex_d};
      1'd1: {addr_out_onehot, addr_out_mux} = {2'd2, addr0_d};
      default: {addr_out_onehot, addr_out_mux} = {2'bx, {{WORD_MSB{1'bx}}, 1'd0}};
    endcase
  assign addr_out_d = {addr_out_mux[WORD_MSB:1],
                       (addr_out_mux[0] && choose_d[0])};
  assign choose_r = (addr_out_d[0] && addr_out_r);
  assign {addr0_r, end_addr_ex_r} = (choose_r ? addr_out_onehot :
                                     2'd0);
  
  /* fork (Ty Word#) : (addr_out,Word#) > [(use_addr,Word#),
                                          (loop_addr,Word#)] */
  logic [1:0] addr_out_emitted;
  initial addr_out_emitted = 2'd0;
  logic [1:0] addr_out_done;
  assign use_addr_d = {addr_out_d[WORD_MSB:1],
                       (addr_out_d[0] && (! addr_out_emitted[0]))};
  assign loop_addr_d = {addr_out_d[WORD_MSB:1],
                        (addr_out_d[0] && (! addr_out_emitted[1]))};
  assign addr_out_done = (addr_out_emitted | ({loop_addr_d[0],
                                               use_addr_d[0]} & {loop_addr_r, use_addr_r}));
  assign addr_out_r = (& addr_out_done);
  always_ff @(posedge clk)
    addr_out_emitted <= (addr_out_r ? 2'd0 :
                         addr_out_done);
  
  /* buf (Ty Word#) : (use_addr,Word#) > (i_addr0,Word#) */
  \Word#_t  use_addr_bufchan_d;
  logic use_addr_bufchan_r;
  \Word#_t  use_addr_buf;
  initial use_addr_buf = {{WORD_MSB{1'bx}}, 1'd0};
  assign use_addr_r = (! use_addr_buf[0]);
  assign use_addr_bufchan_d = (use_addr_buf[0] ? use_addr_buf :
                               use_addr_d);
  always_ff @(posedge clk)
    if ((use_addr_bufchan_r && use_addr_buf[0]))
      use_addr_buf <= {{WORD_MSB{1'bx}}, 1'd0};
    else if (((! use_addr_bufchan_r) && (! use_addr_buf[0])))
      use_addr_buf <= use_addr_d;
  initial i_addr0_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign use_addr_bufchan_r = ((! i_addr0_d[0]) || i_addr0_r);
  always_ff @(posedge clk)
    if (use_addr_bufchan_r) i_addr0_d <= use_addr_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((i_addr0_d[0] && (! i_addr0_r)))
      $display("%5t blocked: i_addr0", $time);
  `endif
  
  /* buf (Ty Word#) : (loop_addr,Word#) > (addr_buf,Word#) */
  \Word#_t  loop_addr_bufchan_d;
  logic loop_addr_bufchan_r;
  \Word#_t  loop_addr_buf;
  initial loop_addr_buf = {{WORD_MSB{1'bx}}, 1'd0};
  assign loop_addr_r = (! loop_addr_buf[0]);
  assign loop_addr_bufchan_d = (loop_addr_buf[0] ? loop_addr_buf :
                                loop_addr_d);
  always_ff @(posedge clk)
    if ((loop_addr_bufchan_r && loop_addr_buf[0]))
      loop_addr_buf <= {{WORD_MSB{1'bx}}, 1'd0};
    else if (((! loop_addr_bufchan_r) && (! loop_addr_buf[0])))
      loop_addr_buf <= loop_addr_d;
  initial addr_buf_d = {{WORD_MSB{1'bx}}, 1'd0};
  assign loop_addr_bufchan_r = ((! addr_buf_d[0]) || addr_buf_r);
  always_ff @(posedge clk)
    if (loop_addr_bufchan_r) addr_buf_d <= loop_addr_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((addr_buf_d[0] && (! addr_buf_r)))
      $display("%5t blocked: addr_buf", $time);
  `endif
  
  /* togo (Ty Word#) : (addr_buf,Word#) > (addr_go,Go) */
  assign addr_go_d = addr_buf_d[0];
  assign addr_buf_r = addr_go_r;
  
  /* dcon (Ty Tog,Dcon One) : [(addr_go,Go)] > (choose_addr,Tog) */
  assign choose_addr_d = One_dc((& {addr_go_d[0]}), addr_go_d);
  assign {addr_go_r} = {1 {(choose_addr_r && choose_addr_d[0])}};
  
  /* initibuf (Ty Word#,
          Lit 0) : (zero_buf0_rdy,Word#) > (zero_buf0,Word#) */
  initial zero_buf0_d = {{WORD_MSB{1'd0}}, 1'd1};
  assign zero_buf0_rdy_r = ((! zero_buf0_d[0]) || zero_buf0_r);
  always_ff @(posedge clk)
    if (zero_buf0_rdy_r) zero_buf0_d <= zero_buf0_rdy_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((zero_buf0_d[0] && (! zero_buf0_r)))
      $display("%5t blocked: zero_buf0", $time);
  `endif
  
  /* fork (Ty Word#) : (zero_buf0,Word#) > [(zero_buf0_in,Word#),
                                           (zero_buf0_out,Word#)] */
  logic [1:0] zero_buf0_emitted;
  initial zero_buf0_emitted = 2'd0;
  logic [1:0] zero_buf0_done;
  assign zero_buf0_in_d = {zero_buf0_d[WORD_MSB:1],
                           (zero_buf0_d[0] && (! zero_buf0_emitted[0]))};
  assign zero_buf0_out_d = {zero_buf0_d[WORD_MSB:1],
                            (zero_buf0_d[0] && (! zero_buf0_emitted[1]))};
  assign zero_buf0_done = (zero_buf0_emitted | ({zero_buf0_out_d[0],
                                                 zero_buf0_in_d[0]} & {zero_buf0_out_r,
                                                                       zero_buf0_in_r}));
  assign zero_buf0_r = (& zero_buf0_done);
  always_ff @(posedge clk)
    zero_buf0_emitted <= (zero_buf0_r ? 2'd0 :
                          zero_buf0_done);
  
  /* rbuf (Ty Word#) : (zero_buf0_in,Word#) > (zero_buf0_rdy,Word#) */
  \Word#_t  zero_buf0_in_buf;
  initial zero_buf0_in_buf = {{WORD_MSB{1'bx}}, 1'd0};
  assign zero_buf0_in_r = (! zero_buf0_in_buf[0]);
  assign zero_buf0_rdy_d = (zero_buf0_in_buf[0] ? zero_buf0_in_buf :
                            zero_buf0_in_d);
  always_ff @(posedge clk)
    if ((zero_buf0_rdy_r && zero_buf0_in_buf[0]))
      zero_buf0_in_buf <= {{WORD_MSB{1'bx}}, 1'd0};
    else if (((! zero_buf0_rdy_r) && (! zero_buf0_in_buf[0])))
      zero_buf0_in_buf <= zero_buf0_in_d;
  
  /* dcon (Ty Node,Dcon Nd) : [(zero_buf0_out,Word#),
                          (ref1,Pointer)] > (node0,Node) */
  assign node0_d = Nd_dc((& {zero_buf0_out_d[0],
                             ref1_d[0]}), zero_buf0_out_d, ref1_d);
  assign {zero_buf0_out_r, ref1_r} = {2 {(node0_r && node0_d[0])}};
  
  /* dcon (Ty Cmd,Dcon Write) : [(i_addr0,Word#),
                            (node0,Node)] > (cmd0,Cmd) */
  assign cmd0_d = Write_dc((& {i_addr0_d[0],
                               node0_d[0]}), i_addr0_d, node0_d);
  assign {i_addr0_r, node0_r} = {2 {(cmd0_r && cmd0_d[0])}};
  
  /* destruct (Ty Pointer,Dcon P) : (ref2,Pointer) > [(addr1,Word#)] */
  assign addr1_d = {ref2_d[POINTER_MSB:1], ref2_d[0]};
  assign ref2_r = addr1_r;
  
  /* togo (Ty Pointer) : (ref3,Pointer) > (nul_node,Go) */
  assign nul_node_d = ref3_d[0];
  assign ref3_r = nul_node_r;
  
  /* dcon (Ty Node,Dcon Nul) : [(nul_node,Go)] > (node1,Node) */
  assign node1_d = Nul_dc((& {nul_node_d[0]}), nul_node_d);
  assign {nul_node_r} = {1 {(node1_r && node1_d[0])}};
  
  /* dcon (Ty Cmd,Dcon Write) : [(addr1,Word#),
                            (node1,Node)] > (cmd1,Cmd) */
  assign cmd1_d = Write_dc((& {addr1_d[0],
                               node1_d[0]}), addr1_d, node1_d);
  assign {addr1_r, node1_r} = {2 {(cmd1_r && cmd1_d[0])}};
  
  /* mux (Ty S,Ty Cmd) : (sel,S) [(cmd0,Cmd),(cmd1,Cmd)] > (cmd_out,Cmd) */
  logic [CMD_MSB:0] cmd_out_mux;
  logic [1:0] cmd_out_onehot;
  always_comb
    unique case (sel_d[1:1])
      1'd0: {cmd_out_onehot, cmd_out_mux} = {2'd1, cmd0_d};
      1'd1: {cmd_out_onehot, cmd_out_mux} = {2'd2, cmd1_d};
      default: {cmd_out_onehot, cmd_out_mux} = {2'bx, {{CMD_MSB{1'bx}}, 1'd0}};
    endcase
  assign cmd_out_d = {cmd_out_mux[CMD_MSB:1],
                      (cmd_out_mux[0] && sel_d[0])};
  assign sel_r = (cmd_out_d[0] && cmd_out_r);
  assign {cmd1_r, cmd0_r} = (sel_r ? cmd_out_onehot :
                             2'd0);
  
  /* fork (Ty S) : (sel_out,S) > [(sel,S),(sel_loop,S)] */
  logic [1:0] sel_out_emitted;
  initial sel_out_emitted = 2'd0;
  logic [1:0] sel_out_done;
  assign sel_d = {sel_out_d[1:1],
                  (sel_out_d[0] && (! sel_out_emitted[0]))};
  assign sel_loop_d = {sel_out_d[1:1],
                       (sel_out_d[0] && (! sel_out_emitted[1]))};
  assign sel_out_done = (sel_out_emitted | ({sel_loop_d[0],
                                             sel_d[0]} & {sel_loop_r, sel_r}));
  assign sel_out_r = (& sel_out_done);
  always_ff @(posedge clk)
    sel_out_emitted <= (sel_out_r ? 2'd0 :
                        sel_out_done);
  
  /* initbuf (Ty S,Dcon Z) : (sel_new_r,S) > (sel_out,S) */
  initial sel_out_d = Z_dc(1'd1);
  assign sel_new_r_r = ((! sel_out_d[0]) || sel_out_r);
  always_ff @(posedge clk)
    if (sel_new_r_r) sel_out_d <= sel_new_r_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((sel_out_d[0] && (! sel_out_r)))
      $display("%5t blocked: sel_out", $time);
  `endif
  
  /* rbuf (Ty S) : (sel_new,S) > (sel_new_r,S) */
  S_t sel_new_buf;
  initial sel_new_buf = {1'bx, 1'd0};
  assign sel_new_r = (! sel_new_buf[0]);
  assign sel_new_r_d = (sel_new_buf[0] ? sel_new_buf :
                        sel_new_d);
  always_ff @(posedge clk)
    if ((sel_new_r_r && sel_new_buf[0])) sel_new_buf <= {1'bx, 1'd0};
    else if (((! sel_new_r_r) && (! sel_new_buf[0])))
      sel_new_buf <= sel_new_d;
  
  /* mux (Ty S,Ty S) : (sel_loop,S) [(sel_one,S),
                                (sel_zero,S)] > (sel_new,S) */
  logic [1:0] sel_new_mux;
  logic [1:0] sel_new_onehot;
  always_comb
    unique case (sel_loop_d[1:1])
      1'd0: {sel_new_onehot, sel_new_mux} = {2'd1, sel_one_d};
      1'd1: {sel_new_onehot, sel_new_mux} = {2'd2, sel_zero_d};
      default: {sel_new_onehot, sel_new_mux} = {2'bx, {1'bx, 1'd0}};
    endcase
  assign sel_new_d = {sel_new_mux[1:1],
                      (sel_new_mux[0] && sel_loop_d[0])};
  assign sel_loop_r = (sel_new_d[0] && sel_new_r);
  assign {sel_zero_r, sel_one_r} = (sel_loop_r ? sel_new_onehot :
                                    2'd0);
  
  /* fork (Ty S) : (sel_zero_out,S) > [(sel_zero,S),(sel_zero_loop,S)] */
  logic [1:0] sel_zero_out_emitted;
  initial sel_zero_out_emitted = 2'd0;
  logic [1:0] sel_zero_out_done;
  assign sel_zero_d = {sel_zero_out_d[1:1],
                       (sel_zero_out_d[0] && (! sel_zero_out_emitted[0]))};
  assign sel_zero_loop_d = {sel_zero_out_d[1:1],
                            (sel_zero_out_d[0] && (! sel_zero_out_emitted[1]))};
  assign sel_zero_out_done = (sel_zero_out_emitted | ({sel_zero_loop_d[0],
                                                       sel_zero_d[0]} & {sel_zero_loop_r,
                                                                         sel_zero_r}));
  assign sel_zero_out_r = (& sel_zero_out_done);
  always_ff @(posedge clk)
    sel_zero_out_emitted <= (sel_zero_out_r ? 2'd0 :
                             sel_zero_out_done);
  
  /* fork (Ty S) : (sel_one_out,S) > [(sel_one,S),(sel_one_loop,S)] */
  logic [1:0] sel_one_out_emitted;
  initial sel_one_out_emitted = 2'd0;
  logic [1:0] sel_one_out_done;
  assign sel_one_d = {sel_one_out_d[1:1],
                      (sel_one_out_d[0] && (! sel_one_out_emitted[0]))};
  assign sel_one_loop_d = {sel_one_out_d[1:1],
                           (sel_one_out_d[0] && (! sel_one_out_emitted[1]))};
  assign sel_one_out_done = (sel_one_out_emitted | ({sel_one_loop_d[0],
                                                     sel_one_d[0]} & {sel_one_loop_r, sel_one_r}));
  assign sel_one_out_r = (& sel_one_out_done);
  always_ff @(posedge clk)
    sel_one_out_emitted <= (sel_one_out_r ? 2'd0 :
                            sel_one_out_done);
  
  /* initbuf (Ty S,Dcon Z) : (sel_zero_r,S) > (sel_zero_out,S) */
  initial sel_zero_out_d = Z_dc(1'd1);
  assign sel_zero_r_r = ((! sel_zero_out_d[0]) || sel_zero_out_r);
  always_ff @(posedge clk)
    if (sel_zero_r_r) sel_zero_out_d <= sel_zero_r_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((sel_zero_out_d[0] && (! sel_zero_out_r)))
      $display("%5t blocked: sel_zero_out", $time);
  `endif
  
  /* rbuf (Ty S) : (sel_zero_loop,S) > (sel_zero_r,S) */
  S_t sel_zero_loop_buf;
  initial sel_zero_loop_buf = {1'bx, 1'd0};
  assign sel_zero_loop_r = (! sel_zero_loop_buf[0]);
  assign sel_zero_r_d = (sel_zero_loop_buf[0] ? sel_zero_loop_buf :
                         sel_zero_loop_d);
  always_ff @(posedge clk)
    if ((sel_zero_r_r && sel_zero_loop_buf[0]))
      sel_zero_loop_buf <= {1'bx, 1'd0};
    else if (((! sel_zero_r_r) && (! sel_zero_loop_buf[0])))
      sel_zero_loop_buf <= sel_zero_loop_d;
  
  /* initbuf (Ty S,Dcon O) : (sel_one_r,S) > (sel_one_out,S) */
  initial sel_one_out_d = O_dc(1'd1);
  assign sel_one_r_r = ((! sel_one_out_d[0]) || sel_one_out_r);
  always_ff @(posedge clk)
    if (sel_one_r_r) sel_one_out_d <= sel_one_r_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((sel_one_out_d[0] && (! sel_one_out_r)))
      $display("%5t blocked: sel_one_out", $time);
  `endif
  
  /* rbuf (Ty S) : (sel_one_loop,S) > (sel_one_r,S) */
  S_t sel_one_loop_buf;
  initial sel_one_loop_buf = {1'bx, 1'd0};
  assign sel_one_loop_r = (! sel_one_loop_buf[0]);
  assign sel_one_r_d = (sel_one_loop_buf[0] ? sel_one_loop_buf :
                        sel_one_loop_d);
  always_ff @(posedge clk)
    if ((sel_one_r_r && sel_one_loop_buf[0]))
      sel_one_loop_buf <= {1'bx, 1'd0};
    else if (((! sel_one_r_r) && (! sel_one_loop_buf[0])))
      sel_one_loop_buf <= sel_one_loop_d;
  
  /* fork (Ty S) : (rsel_out,S) > [(rsel,S),(rsel_loop,S)] */
  logic [1:0] rsel_out_emitted;
  initial rsel_out_emitted = 2'd0;
  logic [1:0] rsel_out_done;
  assign rsel_d = {rsel_out_d[1:1],
                   (rsel_out_d[0] && (! rsel_out_emitted[0]))};
  assign rsel_loop_d = {rsel_out_d[1:1],
                        (rsel_out_d[0] && (! rsel_out_emitted[1]))};
  assign rsel_out_done = (rsel_out_emitted | ({rsel_loop_d[0],
                                               rsel_d[0]} & {rsel_loop_r, rsel_r}));
  assign rsel_out_r = (& rsel_out_done);
  always_ff @(posedge clk)
    rsel_out_emitted <= (rsel_out_r ? 2'd0 :
                         rsel_out_done);
  
  /* initbuf (Ty S,Dcon Z) : (rsel_new_r,S) > (rsel_out,S) */
  initial rsel_out_d = Z_dc(1'd1);
  assign rsel_new_r_r = ((! rsel_out_d[0]) || rsel_out_r);
  always_ff @(posedge clk)
    if (rsel_new_r_r) rsel_out_d <= rsel_new_r_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((rsel_out_d[0] && (! rsel_out_r)))
      $display("%5t blocked: rsel_out", $time);
  `endif
  
  /* rbuf (Ty S) : (rsel_new,S) > (rsel_new_r,S) */
  S_t rsel_new_buf;
  initial rsel_new_buf = {1'bx, 1'd0};
  assign rsel_new_r = (! rsel_new_buf[0]);
  assign rsel_new_r_d = (rsel_new_buf[0] ? rsel_new_buf :
                         rsel_new_d);
  always_ff @(posedge clk)
    if ((rsel_new_r_r && rsel_new_buf[0]))
      rsel_new_buf <= {1'bx, 1'd0};
    else if (((! rsel_new_r_r) && (! rsel_new_buf[0])))
      rsel_new_buf <= rsel_new_d;
  
  /* mux (Ty S,Ty S) : (rsel_loop,S) [(rsel_one,S),
                                 (rsel_zero,S)] > (rsel_new,S) */
  logic [1:0] rsel_new_mux;
  logic [1:0] rsel_new_onehot;
  always_comb
    unique case (rsel_loop_d[1:1])
      1'd0: {rsel_new_onehot, rsel_new_mux} = {2'd1, rsel_one_d};
      1'd1: {rsel_new_onehot, rsel_new_mux} = {2'd2, rsel_zero_d};
      default: {rsel_new_onehot, rsel_new_mux} = {2'bx, {1'bx, 1'd0}};
    endcase
  assign rsel_new_d = {rsel_new_mux[1:1],
                       (rsel_new_mux[0] && rsel_loop_d[0])};
  assign rsel_loop_r = (rsel_new_d[0] && rsel_new_r);
  assign {rsel_zero_r, rsel_one_r} = (rsel_loop_r ? rsel_new_onehot :
                                      2'd0);
  
  /* fork (Ty S) : (rsel_zero_out,S) > [(rsel_zero,S),
                                   (rsel_zero_loop,S)] */
  logic [1:0] rsel_zero_out_emitted;
  initial rsel_zero_out_emitted = 2'd0;
  logic [1:0] rsel_zero_out_done;
  assign rsel_zero_d = {rsel_zero_out_d[1:1],
                        (rsel_zero_out_d[0] && (! rsel_zero_out_emitted[0]))};
  assign rsel_zero_loop_d = {rsel_zero_out_d[1:1],
                             (rsel_zero_out_d[0] && (! rsel_zero_out_emitted[1]))};
  assign rsel_zero_out_done = (rsel_zero_out_emitted | ({rsel_zero_loop_d[0],
                                                         rsel_zero_d[0]} & {rsel_zero_loop_r,
                                                                            rsel_zero_r}));
  assign rsel_zero_out_r = (& rsel_zero_out_done);
  always_ff @(posedge clk)
    rsel_zero_out_emitted <= (rsel_zero_out_r ? 2'd0 :
                              rsel_zero_out_done);
  
  /* fork (Ty S) : (rsel_one_out,S) > [(rsel_one,S),(rsel_one_loop,S)] */
  logic [1:0] rsel_one_out_emitted;
  initial rsel_one_out_emitted = 2'd0;
  logic [1:0] rsel_one_out_done;
  assign rsel_one_d = {rsel_one_out_d[1:1],
                       (rsel_one_out_d[0] && (! rsel_one_out_emitted[0]))};
  assign rsel_one_loop_d = {rsel_one_out_d[1:1],
                            (rsel_one_out_d[0] && (! rsel_one_out_emitted[1]))};
  assign rsel_one_out_done = (rsel_one_out_emitted | ({rsel_one_loop_d[0],
                                                       rsel_one_d[0]} & {rsel_one_loop_r,
                                                                         rsel_one_r}));
  assign rsel_one_out_r = (& rsel_one_out_done);
  always_ff @(posedge clk)
    rsel_one_out_emitted <= (rsel_one_out_r ? 2'd0 :
                             rsel_one_out_done);
  
  /* initbuf (Ty S,Dcon Z) : (rsel_zero_r,S) > (rsel_zero_out,S) */
  initial rsel_zero_out_d = Z_dc(1'd1);
  assign rsel_zero_r_r = ((! rsel_zero_out_d[0]) || rsel_zero_out_r);
  always_ff @(posedge clk)
    if (rsel_zero_r_r) rsel_zero_out_d <= rsel_zero_r_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((rsel_zero_out_d[0] && (! rsel_zero_out_r)))
      $display("%5t blocked: rsel_zero_out", $time);
  `endif
  
  /* rbuf (Ty S) : (rsel_zero_loop,S) > (rsel_zero_r,S) */
  S_t rsel_zero_loop_buf;
  initial rsel_zero_loop_buf = {1'bx, 1'd0};
  assign rsel_zero_loop_r = (! rsel_zero_loop_buf[0]);
  assign rsel_zero_r_d = (rsel_zero_loop_buf[0] ? rsel_zero_loop_buf :
                          rsel_zero_loop_d);
  always_ff @(posedge clk)
    if ((rsel_zero_r_r && rsel_zero_loop_buf[0]))
      rsel_zero_loop_buf <= {1'bx, 1'd0};
    else if (((! rsel_zero_r_r) && (! rsel_zero_loop_buf[0])))
      rsel_zero_loop_buf <= rsel_zero_loop_d;
  
  /* initbuf (Ty S,Dcon O) : (rsel_one_r,S) > (rsel_one_out,S) */
  initial rsel_one_out_d = O_dc(1'd1);
  assign rsel_one_r_r = ((! rsel_one_out_d[0]) || rsel_one_out_r);
  always_ff @(posedge clk)
    if (rsel_one_r_r) rsel_one_out_d <= rsel_one_r_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((rsel_one_out_d[0] && (! rsel_one_out_r)))
      $display("%5t blocked: rsel_one_out", $time);
  `endif
  
  /* rbuf (Ty S) : (rsel_one_loop,S) > (rsel_one_r,S) */
  S_t rsel_one_loop_buf;
  initial rsel_one_loop_buf = {1'bx, 1'd0};
  assign rsel_one_loop_r = (! rsel_one_loop_buf[0]);
  assign rsel_one_r_d = (rsel_one_loop_buf[0] ? rsel_one_loop_buf :
                         rsel_one_loop_d);
  always_ff @(posedge clk)
    if ((rsel_one_r_r && rsel_one_loop_buf[0]))
      rsel_one_loop_buf <= {1'bx, 1'd0};
    else if (((! rsel_one_r_r) && (! rsel_one_loop_buf[0])))
      rsel_one_loop_buf <= rsel_one_loop_d;
  
  /* demux (Ty S,Ty Res) : (rsel,S) (res_in,Res) > [(_0,Res),(ack,Res)] */
  logic [1:0] res_in_onehotd;
  always_comb
    if ((rsel_d[0] && res_in_d[0]))
      unique case (rsel_d[1:1])
        1'd0: res_in_onehotd = 2'd1;
        1'd1: res_in_onehotd = 2'd2;
        default: res_in_onehotd = 2'bx;
      endcase
    else res_in_onehotd = 2'd0;
  assign _0_d = {res_in_d[RES_MSB:1], res_in_onehotd[0]};
  assign ack_d = {res_in_d[RES_MSB:1], res_in_onehotd[1]};
  assign res_in_r = (| (res_in_onehotd & {ack_r, _0_r}));
  assign rsel_r = res_in_r;
  
  /* togo (Ty Res) : (ack,Res) > (free_ack,Go) */
  assign free_ack_d = ack_d[0];
  assign ack_r = free_ack_r;
  
  /* sink (Ty Cmd) : (cmd_out,Cmd) > */
  assign {cmd_out_r, cmd_out_dout} = {cmd_out_rout, cmd_out_d};
  
  /* sink (Ty Go) : (free_ack,Go) > */
  assign {free_ack_r, free_ack_dout} = {free_ack_rout, free_ack_d};
  
  /* Lack-of-progress detector */
  `ifdef CHECK_PROGRESS
  logic [16:0] bufferedChannelValids;
  logic [16:0] bufferedChannelReadys;
  logic [16:0] last1BufferedChannelValids;
  logic [16:0] last1BufferedChannelReadys;
  logic [16:0] last2BufferedChannelValids;
  logic [16:0] last2BufferedChannelReadys;
  initial last1BufferedChannelValids = 17'd0;
  initial last1BufferedChannelReadys = 17'd0;
  initial last2BufferedChannelValids = 17'd1;
  initial last2BufferedChannelReadys = 17'd1;
  assign bufferedChannelValids = {inbuf_d[0],
                                  i_addr0_d[0],
                                  addr_buf_d[0],
                                  zero_buf0_d[0],
                                  zero_buf0_rdy_d[0],
                                  sel_out_d[0],
                                  sel_new_r_d[0],
                                  sel_zero_out_d[0],
                                  sel_zero_r_d[0],
                                  sel_one_out_d[0],
                                  sel_one_r_d[0],
                                  rsel_out_d[0],
                                  rsel_new_r_d[0],
                                  rsel_zero_out_d[0],
                                  rsel_zero_r_d[0],
                                  rsel_one_out_d[0],
                                  rsel_one_r_d[0]};
  assign bufferedChannelReadys = {inbuf_r,
                                  i_addr0_r,
                                  addr_buf_r,
                                  zero_buf0_r,
                                  zero_buf0_rdy_r,
                                  sel_out_r,
                                  sel_new_r_r,
                                  sel_zero_out_r,
                                  sel_zero_r_r,
                                  sel_one_out_r,
                                  sel_one_r_r,
                                  rsel_out_r,
                                  rsel_new_r_r,
                                  rsel_zero_out_r,
                                  rsel_zero_r_r,
                                  rsel_one_out_r,
                                  rsel_one_r_r};
  always_ff @(posedge clk)
    begin
      last1BufferedChannelValids <= bufferedChannelValids;
      last1BufferedChannelReadys <= bufferedChannelReadys;
      last2BufferedChannelValids <= last1BufferedChannelValids;
      last2BufferedChannelReadys <= last1BufferedChannelReadys;
      if (((((last2BufferedChannelValids == last1BufferedChannelValids) && (last1BufferedChannelValids == bufferedChannelValids)) && (last2BufferedChannelReadys == last1BufferedChannelReadys)) && (last1BufferedChannelReadys == bufferedChannelReadys)))
        begin
          $display("%6t no progress", $time);
          $display(" valids %b", last2BufferedChannelValids);
          $display(" readys %b", last2BufferedChannelReadys);
          $display(" valids %b", last1BufferedChannelValids);
          $display(" readys %b", last1BufferedChannelReadys);
          $display(" valids %b", bufferedChannelValids);
          $display(" readys %b", bufferedChannelReadys);
          if ((inbuf_d[0] && (! inbuf_r))) $display(" blocked inbuf");
          if ((i_addr0_d[0] && (! i_addr0_r))) $display(" blocked i_addr0");
          if ((addr_buf_d[0] && (! addr_buf_r)))
            $display(" blocked addr_buf");
          if ((zero_buf0_d[0] && (! zero_buf0_r)))
            $display(" blocked zero_buf0");
          if ((zero_buf0_rdy_d[0] && (! zero_buf0_rdy_r)))
            $display(" blocked zero_buf0_rdy");
          if ((sel_out_d[0] && (! sel_out_r))) $display(" blocked sel_out");
          if ((sel_new_r_d[0] && (! sel_new_r_r)))
            $display(" blocked sel_new_r");
          if ((sel_zero_out_d[0] && (! sel_zero_out_r)))
            $display(" blocked sel_zero_out");
          if ((sel_zero_r_d[0] && (! sel_zero_r_r)))
            $display(" blocked sel_zero_r");
          if ((sel_one_out_d[0] && (! sel_one_out_r)))
            $display(" blocked sel_one_out");
          if ((sel_one_r_d[0] && (! sel_one_r_r)))
            $display(" blocked sel_one_r");
          if ((rsel_out_d[0] && (! rsel_out_r)))
            $display(" blocked rsel_out");
          if ((rsel_new_r_d[0] && (! rsel_new_r_r)))
            $display(" blocked rsel_new_r");
          if ((rsel_zero_out_d[0] && (! rsel_zero_out_r)))
            $display(" blocked rsel_zero_out");
          if ((rsel_zero_r_d[0] && (! rsel_zero_r_r)))
            $display(" blocked rsel_zero_r");
          if ((rsel_one_out_d[0] && (! rsel_one_out_r)))
            $display(" blocked rsel_one_out");
          if ((rsel_one_r_d[0] && (! rsel_one_r_r)))
            $display(" blocked rsel_one_r");
          $finish();
        end
    end
  `endif
  /* Wake Node Reporting */
  `ifdef WAKE_REPORT
  /* wake inbuf:buf */
  /* wake end_addr_ex:sub */
  /* wake addr_out:mux */
  /* wake i_addr0:buf */
  /* wake addr_buf:buf */
  /* wake zero_buf0:initibuf */
  /* wake zero_buf0_rdy:rbuf */
  /* wake cmd_out:mux */
  /* wake sel_out:initbuf */
  /* wake sel_new_r:rbuf */
  /* wake sel_new:mux */
  /* wake sel_zero_out:initbuf */
  /* wake sel_zero_r:rbuf */
  /* wake sel_one_out:initbuf */
  /* wake sel_one_r:rbuf */
  /* wake rsel_out:initbuf */
  /* wake rsel_new_r:rbuf */
  /* wake rsel_new:mux */
  /* wake rsel_zero_out:initbuf */
  /* wake rsel_zero_r:rbuf */
  /* wake rsel_one_out:initbuf */
  /* wake rsel_one_r:rbuf */
  always_ff @(posedge clk)
    $display("wake %b", {(inbuf_d[0] || (input_d[0] || input_bufchan_d[0])),
                         end_addr_ex_d[0],
                         addr_out_d[0],
                         (i_addr0_d[0] || (use_addr_d[0] || use_addr_bufchan_d[0])),
                         (addr_buf_d[0] || (loop_addr_d[0] || loop_addr_bufchan_d[0])),
                         (zero_buf0_d[0] || zero_buf0_rdy_d[0]),
                         (zero_buf0_rdy_d[0] || zero_buf0_in_d[0]),
                         cmd_out_d[0],
                         (sel_out_d[0] || sel_new_r_d[0]),
                         (sel_new_r_d[0] || sel_new_d[0]),
                         sel_new_d[0],
                         (sel_zero_out_d[0] || sel_zero_r_d[0]),
                         (sel_zero_r_d[0] || sel_zero_loop_d[0]),
                         (sel_one_out_d[0] || sel_one_r_d[0]),
                         (sel_one_r_d[0] || sel_one_loop_d[0]),
                         (rsel_out_d[0] || rsel_new_r_d[0]),
                         (rsel_new_r_d[0] || rsel_new_d[0]),
                         rsel_new_d[0],
                         (rsel_zero_out_d[0] || rsel_zero_r_d[0]),
                         (rsel_zero_r_d[0] || rsel_zero_loop_d[0]),
                         (rsel_one_out_d[0] || rsel_one_r_d[0]),
                         (rsel_one_r_d[0] || rsel_one_loop_d[0])});
  `endif
endmodule
