module ErrorMerge3(
  input logic clk,
  input Raise_Err_t in0_d,
  output logic in0_r,
  input Raise_Err_t in1_d,
  output logic in1_r,
  input Raise_Err_t in2_d,
  output logic in2_r,
  output Raise_Err_t out_dout,
  input logic out_rout
  );
  /* --define=INPUTS=((in0, 2, 3, Raise_Err), (in1, 2, 3, Raise_Err), (in2, 2, 3, Raise_Err)) */
  /* --define=TAPS=() */
  /* --define=OUTPUTS=((out, 2, 3, Raise_Err)) */
  /* TYPE_START
TYPE_END */
  /*  */
  /*  */
  Raise_Err_t iin0_d;
  logic iin0_r;
  Raise_Err_t iin1_d;
  logic iin1_r;
  Raise_Err_t iin2_d;
  logic iin2_r;
  Raise_Err_t oout_d;
  logic oout_r;
  Raise_Err_t out_d;
  logic out_r;
  
  /* source (Ty Raise_Err) : > (in0,Raise_Err) */
  
  /* source (Ty Raise_Err) : > (in1,Raise_Err) */
  
  /* source (Ty Raise_Err) : > (in2,Raise_Err) */
  
  /* buf (Ty Raise_Err) : (in0,Raise_Err) > (iin0,Raise_Err) */
  Raise_Err_t in0_bufchan_d;
  logic in0_bufchan_r;
  Raise_Err_t in0_buf;
  initial in0_buf = {2'bx, 1'd0};
  assign in0_r = (! in0_buf[0]);
  assign in0_bufchan_d = (in0_buf[0] ? in0_buf :
                          in0_d);
  always_ff @(posedge clk)
    if ((in0_bufchan_r && in0_buf[0])) in0_buf <= {2'bx, 1'd0};
    else if (((! in0_bufchan_r) && (! in0_buf[0]))) in0_buf <= in0_d;
  initial iin0_d = {2'bx, 1'd0};
  assign in0_bufchan_r = ((! iin0_d[0]) || iin0_r);
  always_ff @(posedge clk)
    if (in0_bufchan_r) iin0_d <= in0_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((iin0_d[0] && (! iin0_r)))
      $display("%5t blocked: iin0", $time);
  `endif
  
  /* buf (Ty Raise_Err) : (in1,Raise_Err) > (iin1,Raise_Err) */
  Raise_Err_t in1_bufchan_d;
  logic in1_bufchan_r;
  Raise_Err_t in1_buf;
  initial in1_buf = {2'bx, 1'd0};
  assign in1_r = (! in1_buf[0]);
  assign in1_bufchan_d = (in1_buf[0] ? in1_buf :
                          in1_d);
  always_ff @(posedge clk)
    if ((in1_bufchan_r && in1_buf[0])) in1_buf <= {2'bx, 1'd0};
    else if (((! in1_bufchan_r) && (! in1_buf[0]))) in1_buf <= in1_d;
  initial iin1_d = {2'bx, 1'd0};
  assign in1_bufchan_r = ((! iin1_d[0]) || iin1_r);
  always_ff @(posedge clk)
    if (in1_bufchan_r) iin1_d <= in1_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((iin1_d[0] && (! iin1_r)))
      $display("%5t blocked: iin1", $time);
  `endif
  
  /* buf (Ty Raise_Err) : (in2,Raise_Err) > (iin2,Raise_Err) */
  Raise_Err_t in2_bufchan_d;
  logic in2_bufchan_r;
  Raise_Err_t in2_buf;
  initial in2_buf = {2'bx, 1'd0};
  assign in2_r = (! in2_buf[0]);
  assign in2_bufchan_d = (in2_buf[0] ? in2_buf :
                          in2_d);
  always_ff @(posedge clk)
    if ((in2_bufchan_r && in2_buf[0])) in2_buf <= {2'bx, 1'd0};
    else if (((! in2_bufchan_r) && (! in2_buf[0]))) in2_buf <= in2_d;
  initial iin2_d = {2'bx, 1'd0};
  assign in2_bufchan_r = ((! iin2_d[0]) || iin2_r);
  always_ff @(posedge clk)
    if (in2_bufchan_r) iin2_d <= in2_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((iin2_d[0] && (! iin2_r)))
      $display("%5t blocked: iin2", $time);
  `endif
  
  /* merge (Ty Raise_Err) : [(iin0,Raise_Err),
                        (iin1,Raise_Err),
                        (iin2,Raise_Err)] > (oout,Raise_Err) */
  logic [2:0] oout_selected;
  logic [2:0] oout_select;
  initial oout_select = 3'd0;
  always_comb
    begin
      oout_selected = 3'd0;
      if ((| oout_select)) oout_selected = oout_select;
      else
        if (iin0_d[0]) oout_selected[0] = 1'd1;
        else if (iin1_d[0]) oout_selected[1] = 1'd1;
        else if (iin2_d[0]) oout_selected[2] = 1'd1;
    end
  always_ff @(posedge clk)
    oout_select <= (oout_r ? 3'd0 :
                    oout_selected);
  always_comb
    if (oout_selected[0]) oout_d = iin0_d;
    else if (oout_selected[1]) oout_d = iin1_d;
    else if (oout_selected[2]) oout_d = iin2_d;
    else oout_d = {2'bx, 1'd0};
  assign {iin2_r, iin1_r, iin0_r} = (oout_r ? oout_selected :
                                     3'd0);
  
  /* buf (Ty Raise_Err) : (oout,Raise_Err) > (out,Raise_Err) */
  Raise_Err_t oout_bufchan_d;
  logic oout_bufchan_r;
  Raise_Err_t oout_buf;
  initial oout_buf = {2'bx, 1'd0};
  assign oout_r = (! oout_buf[0]);
  assign oout_bufchan_d = (oout_buf[0] ? oout_buf :
                           oout_d);
  always_ff @(posedge clk)
    if ((oout_bufchan_r && oout_buf[0])) oout_buf <= {2'bx, 1'd0};
    else if (((! oout_bufchan_r) && (! oout_buf[0])))
      oout_buf <= oout_d;
  initial out_d = {2'bx, 1'd0};
  assign oout_bufchan_r = ((! out_d[0]) || out_r);
  always_ff @(posedge clk)
    if (oout_bufchan_r) out_d <= oout_bufchan_d;
  `ifdef SHOW_BLOCKED_BUFFERS
  always_ff @(posedge clk)
    if ((out_d[0] && (! out_r))) $display("%5t blocked: out", $time);
  `endif
  
  /* sink (Ty Raise_Err) : (out,Raise_Err) > */
  assign {out_r, out_dout} = {out_rout, out_d};
  
  /* Lack-of-progress detector */
  `ifdef CHECK_PROGRESS
  logic [3:0] bufferedChannelValids;
  logic [3:0] bufferedChannelReadys;
  logic [3:0] last1BufferedChannelValids;
  logic [3:0] last1BufferedChannelReadys;
  logic [3:0] last2BufferedChannelValids;
  logic [3:0] last2BufferedChannelReadys;
  initial last1BufferedChannelValids = 4'd0;
  initial last1BufferedChannelReadys = 4'd0;
  initial last2BufferedChannelValids = 4'd1;
  initial last2BufferedChannelReadys = 4'd1;
  assign bufferedChannelValids = {iin0_d[0],
                                  iin1_d[0],
                                  iin2_d[0],
                                  out_d[0]};
  assign bufferedChannelReadys = {iin0_r, iin1_r, iin2_r, out_r};
  always_ff @(posedge clk)
    begin
      last1BufferedChannelValids <= bufferedChannelValids;
      last1BufferedChannelReadys <= bufferedChannelReadys;
      last2BufferedChannelValids <= last1BufferedChannelValids;
      last2BufferedChannelReadys <= last1BufferedChannelReadys;
      if (((((last2BufferedChannelValids == last1BufferedChannelValids) && (last1BufferedChannelValids == bufferedChannelValids)) && (last2BufferedChannelReadys == last1BufferedChannelReadys)) && (last1BufferedChannelReadys == bufferedChannelReadys)))
        begin
          $display("%6t no progress", $time);
          $display(" valids %b", last2BufferedChannelValids);
          $display(" readys %b", last2BufferedChannelReadys);
          $display(" valids %b", last1BufferedChannelValids);
          $display(" readys %b", last1BufferedChannelReadys);
          $display(" valids %b", bufferedChannelValids);
          $display(" readys %b", bufferedChannelReadys);
          if ((iin0_d[0] && (! iin0_r))) $display(" blocked iin0");
          if ((iin1_d[0] && (! iin1_r))) $display(" blocked iin1");
          if ((iin2_d[0] && (! iin2_r))) $display(" blocked iin2");
          if ((out_d[0] && (! out_r))) $display(" blocked out");
          $finish();
        end
    end
  `endif
  /* Wake Node Reporting */
  `ifdef WAKE_REPORT
  /* wake iin0:buf */
  /* wake iin1:buf */
  /* wake iin2:buf */
  /* wake out:buf */
  always_ff @(posedge clk)
    $display("wake %b", {(iin0_d[0] || (in0_d[0] || in0_bufchan_d[0])),
                         (iin1_d[0] || (in1_d[0] || in1_bufchan_d[0])),
                         (iin2_d[0] || (in2_d[0] || in2_bufchan_d[0])),
                         (out_d[0] || (oout_d[0] || oout_bufchan_d[0]))});
  `endif
endmodule
